/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importutil;

import com.tridium.orion.BOrionDatabase;
import com.tridium.orion.BOrionService;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.accessDriver.enums.activity.BLDAPActivityEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.history.BLDAPAuditRecord;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.ldap.importconfig.BLdapImportConfig;
import com.tridiumx.entsec.securityUtil.HistoryManager;
import com.tridiumx.ldapDriver.BLdapAttributeValuePair;
import com.tridiumx.ldapDriver.BLdapNetwork;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.attributes.BLdapAttributesDeviceExt;
import com.tridiumx.ldapDriver.users.BLdapUser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class LdapImportUtils {
    public static final int LDAP_PAGE_SIZE = 500;
    public static final String STATUS_VALUE_DELIMITER = ",";
    public static final String SLASH = "/";
    public static final String QUESTIONMARK = "?";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BUuid getLDAPServerReference(String ldapServerName) {
        BLdapNetwork ldapNetwork = (BLdapNetwork)Sys.getService((Type)BLdapNetwork.TYPE);
        BUuid uuid = BUuid.DEFAULT;
        ldapNetwork.lease();
        OrionSession session = LdapImportUtils.getOrionSession();
        BLdapServer server = (BLdapServer)ldapNetwork.get(ldapServerName);
        if (server != null) {
            try {
                server.lease();
                BOrd ord = server.getSlotPathOrd();
                BSqlQuery query = BSqlQuery.make((OrionType)com.tridiumx.entsec.access.orion.BLdapServer.ORION_TYPE);
                BQuery q = query.where(Predicates.eq((String)"ord", (BSimple)BOrd.make((String)("station:|" + ord.encodeToString()))));
                OrionCursor cursor = session.select(q);
                if (cursor.next()) {
                    com.tridiumx.entsec.access.orion.BLdapServer ldapServer = (com.tridiumx.entsec.access.orion.BLdapServer)((Object)cursor.get());
                    uuid = ldapServer.getLdapServerId();
                }
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        return uuid;
    }

    public static OrionSession getOrionSession() {
        BOrionDatabase[] orionDatabases = BOrionService.getService().getOrionDatabases();
        if (orionDatabases.length > 0) {
            OrionSession orionSession = orionDatabases[0].createSession(null);
            orionSession.setAutoCommit(false);
            return orionSession;
        }
        return null;
    }

    public static BAbsTime parseLdapDate(String ldapDate) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss.S");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            Date date = sdf.parse(ldapDate);
            return BAbsTime.make((long)date.getTime());
        }
        catch (ParseException e) {
            throw new Exception("Error parsing date " + ldapDate);
        }
    }

    public static boolean isLDAPUserStatusActive(BLdapUser user, BLdapImportConfig importConfig) {
        boolean validStatus = true;
        if (importConfig != null) {
            List<String> validStatusList = importConfig.getValidStatusList();
            String statusAttr = importConfig.getStatusAttribute();
            if (statusAttr != null && !"".equals(statusAttr.trim())) {
                BLdapAttributeValuePair attrValPair = (BLdapAttributeValuePair)user.getAttributeList().get(SlotPath.escape((String)statusAttr));
                if (attrValPair == null) {
                    return false;
                }
                validStatus = validStatusList.contains(attrValPair.getAttrValue());
            } else {
                validStatus = false;
            }
        }
        return validStatus;
    }

    public static String validateMandatoryAttributes(HashMap attributesMap, BLdapServer selectedLdapServer) {
        StringBuilder builder = new StringBuilder();
        BLdapAttributesDeviceExt attributeExt = selectedLdapServer.getAttributes();
        String mandatoryAttributes = attributeExt.getMandatoryAttributes();
        String[] attr = mandatoryAttributes.split(";");
        ArrayList<String> mandAttrList = new ArrayList<String>(Arrays.asList(attr));
        for (int i = 0; i < mandAttrList.size(); ++i) {
            if (attributesMap.containsKey(mandAttrList.get(i))) continue;
            if (builder.length() > 0) {
                builder.append(STATUS_VALUE_DELIMITER);
            }
            builder.append(mandAttrList.get(i));
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return "";
    }

    public static String getStackTrace(Exception ex) {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    public static List<String> getMandatoryFieldsForMapping() {
        ArrayList<String> mandatoryFieldsList = new ArrayList<String>();
        BPerson person = new BPerson();
        Property[] props = person.getPropertiesArray();
        Array a = new Array(String.class);
        for (int i = 0; i < props.length; ++i) {
            BFacets facets = props[i].getFacets();
            BObject obj = facets.get("allowNull");
            if (obj == null || !obj.toString().equals("false")) continue;
            mandatoryFieldsList.add(props[i].getName());
        }
        return mandatoryFieldsList;
    }

    public static String getAttributesList(List<String> mandAttrList) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < mandAttrList.size(); ++i) {
            if (builder.length() > 0) {
                builder.append(STATUS_VALUE_DELIMITER);
            }
            builder.append(mandAttrList.get(i));
        }
        if (builder.length() > 0) {
            return builder.toString();
        }
        return "";
    }

    public static void addAuditLogEntry(BOrd slotPathOrd, String auditLogStatus, String auditLogMessage, String owner, BLDAPActivityEnum activity) {
        BLDAPAuditRecord auditRecord = new BLDAPAuditRecord();
        auditRecord.setTimestamp(BAbsTime.now());
        auditRecord.setLdapServerOrd(slotPathOrd);
        auditRecord.setStatus(auditLogStatus);
        auditRecord.setDetails(auditLogMessage);
        auditRecord.setOwner(owner);
        auditRecord.setActivity(activity);
        BAccessControlService accessControlService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        HistoryManager historyManager = accessControlService.getHistoryManager();
        historyManager.append(auditRecord);
    }

    public static String getDBSchemaName(String dbURL) {
        String dbURLTillSchemaName = dbURL.substring(0, dbURL.lastIndexOf(QUESTIONMARK));
        String dbSchemaName = dbURLTillSchemaName.substring(dbURLTillSchemaName.lastIndexOf(SLASH) + 1);
        return dbSchemaName;
    }

    public static enum ImportProcessStatus {
        SUCCESS,
        ERROR,
        WARNING;

    }
}

