/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importutil;

import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.LdapImportUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public final class FilteredLdapMappingDetailsCache {
    private static final Map<String, FilteredLdapMappingDetailsCache> cache = new LinkedHashMap<String, FilteredLdapMappingDetailsCache>();
    private final Map<Type, List<String>> colDetailsByType = new HashMap<Type, List<String>>();
    private BUuid ldapServerReference = BUuid.NULL;
    private String ldapServerName;

    private FilteredLdapMappingDetailsCache(String ldapServerName) {
        this.ldapServerName = ldapServerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final FilteredLdapMappingDetailsCache getInstance(String ldapServerName) {
        if (cache.get(ldapServerName) != null) return cache.get(ldapServerName);
        Class<FilteredLdapMappingDetailsCache> clazz = FilteredLdapMappingDetailsCache.class;
        synchronized (FilteredLdapMappingDetailsCache.class) {
            if (cache.get(ldapServerName) != null) return cache.get(ldapServerName);
            cache.put(ldapServerName, new FilteredLdapMappingDetailsCache(ldapServerName));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return cache.get(ldapServerName);
        }
    }

    public final List<String> getMappedColumnsForType(Map<String, ColumnDetails> mappingDetails, Type type) {
        if (!this.colDetailsByType.containsKey(type)) {
            this.colDetailsByType.put(type, ColumnDetails.filterMappedColumnsByOrionType(mappingDetails, type));
        }
        return this.colDetailsByType.get(type);
    }

    public static final void resetMappingDetailsCache() {
        cache.clear();
    }

    public synchronized BUuid getLdapServerReference() {
        if (this.ldapServerReference.isNull() && this.ldapServerName != null) {
            BUuid uuid;
            this.ldapServerReference = uuid = LdapImportUtils.getLDAPServerReference(this.ldapServerName);
        }
        return this.ldapServerReference;
    }
}

