/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importutil;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class ColumnDetails {
    private String columnName;
    private String tableName;
    private String refColumnName;

    public ColumnDetails(String columnName, String tableName) {
        this.columnName = columnName;
        this.tableName = tableName;
    }

    public ColumnDetails(String columnName, String tableName, String refColumnName) {
        this(columnName, tableName);
        this.refColumnName = refColumnName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    protected void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getRefColumnName() {
        return this.refColumnName;
    }

    public void setRefColumnName(String refColumnName) {
        this.refColumnName = refColumnName;
    }

    public boolean equals(Object obj) {
        ColumnDetails details = (ColumnDetails)obj;
        if (this.tableName != null && this.columnName != null) {
            return this.tableName.equals(details.getTableName()) && this.columnName.equals(details.getColumnName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.tableName != null && this.columnName != null) {
            return this.tableName.hashCode() + this.columnName.hashCode();
        }
        return super.hashCode();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        buffer.append(this.columnName);
        buffer.append(",");
        buffer.append(this.tableName);
        buffer.append(")");
        return buffer.toString();
    }

    public static List<String> filterMappedColumnsByOrionType(Map<String, ColumnDetails> mappingDetails, Type type) {
        Set<String> mappings = mappingDetails.keySet();
        Iterator<String> atts = mappings.iterator();
        ArrayList<String> cols = new ArrayList<String>();
        while (atts.hasNext()) {
            String attrName = atts.next();
            ColumnDetails details = mappingDetails.get(attrName);
            BTypeSpec spec = BTypeSpec.make((String)"entsec", (String)details.getTableName());
            if (!type.getTypeSpec().equals((Object)spec)) continue;
            cols.add(details.getColumnName());
        }
        return cols;
    }
}

