/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridiumx.entsec.ldap.importconfig.BLdapImportConfig;
import com.tridiumx.entsec.ldap.importsteps.LdapImportStep;
import com.tridiumx.entsec.ldap.importutil.FilteredLdapMappingDetailsCache;
import com.tridiumx.entsec.ldap.importvalidate.ILdapImportEntryValidator;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.callbacks.LdapChangeRegistrationCallback;
import com.tridiumx.ldapDriver.users.BLdapUsersDeviceExt;
import java.util.logging.Level;
import javax.baja.sys.BAbsTime;
import javax.naming.NamingException;

public class LdapImportStartSubscriptionAndCleanupStep
extends LdapImportStep {
    public LdapImportStartSubscriptionAndCleanupStep(BLdapServer server) {
        super(server);
    }

    @Override
    public boolean execute() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering the step LdapImportStartSubscriptionAndCleanupStep");
        }
        boolean success = true;
        BLdapUsersDeviceExt ext = this.server.getUsers();
        ext.setLastUpdateTime(BAbsTime.now());
        BLdapImportConfig mixin = (BLdapImportConfig)this.server.getMixIn(BLdapImportConfig.TYPE);
        if (mixin != null) {
            if (BAbsTime.NULL.equals((Object)mixin.getLastImportTime())) {
                try {
                    LdapChangeRegistrationCallback registrationCallback = this.server.getRegistrationCallback();
                    if (registrationCallback == null) {
                        registrationCallback = new LdapChangeRegistrationCallback(this.server);
                    }
                    registrationCallback.invoke();
                }
                catch (NamingException e) {
                    this.log.fine("Error cleaning and re-registering the the previous registration callback " + e.getMessage());
                    success = false;
                }
            }
            mixin.setLastImportTime(BAbsTime.now());
        }
        FilteredLdapMappingDetailsCache.resetMappingDetailsCache();
        success = true;
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Executed the step LdapImportStartSubscriptionAndCleanupStep");
        }
        return success;
    }

    @Override
    public Object getStepData() {
        return this.server;
    }

    @Override
    public ILdapImportEntryValidator[] getApplicableValidators() {
        return new ILdapImportEntryValidator[0];
    }
}

