/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridiumx.entsec.ldap.importconfig.BLdapImportConfig;
import com.tridiumx.entsec.ldap.importsteps.LdapImportStep;
import com.tridiumx.entsec.ldap.importvalidate.ILdapImportEntryValidator;
import com.tridiumx.ldapDriver.BLdapServer;
import com.tridiumx.ldapDriver.users.BLdapUser;
import com.tridiumx.ldapDriver.users.BLdapUsersDeviceExt;
import com.tridiumx.ldapDriver.users.LdapUserListQueryResponse;
import java.util.logging.Level;
import javax.naming.ldap.Control;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;

public class LdapImportPrepareStep
extends LdapImportStep {
    protected ImportData importData = null;
    private byte[] cookie = null;

    public LdapImportPrepareStep(BLdapServer server) {
        super(server);
    }

    @Override
    public boolean execute() throws Exception {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering the step LdapImportPrepareStep");
        }
        boolean success = true;
        BLdapUsersDeviceExt ext = this.server.getUsers();
        this.importData = new ImportData();
        BLdapImportConfig mixin = (BLdapImportConfig)this.server.getMixIn(BLdapImportConfig.TYPE);
        if (mixin != null) {
            LdapUserListQueryResponse response = null;
            try {
                response = ext.getUserList(new Control[]{new PagedResultsControl(500, this.cookie, false)});
                Control[] controls = response.getResponseControls();
                if (controls != null) {
                    for (int i = 0; i < controls.length; ++i) {
                        if (!(controls[i] instanceof PagedResultsResponseControl)) continue;
                        PagedResultsResponseControl prrc = (PagedResultsResponseControl)controls[i];
                        this.cookie = prrc.getCookie();
                    }
                }
                this.importData.setHasMore(this.cookie != null);
            }
            catch (Exception e) {
                this.log.fine("Error preparing data for LDAP import " + e.getMessage());
                e.printStackTrace();
                success = false;
                throw e;
            }
            this.importData.setUserList(response.getUserList());
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Completed execution of the LdapImportPrepareStep");
        }
        return success;
    }

    @Override
    public Object getStepData() {
        return this.importData;
    }

    @Override
    public ILdapImportEntryValidator[] getApplicableValidators() {
        return new ILdapImportEntryValidator[0];
    }

    public class ImportData {
        private BLdapUser[] userList;
        private boolean hasMore = false;

        public BLdapUser[] getUserList() {
            return this.userList;
        }

        public void setUserList(BLdapUser[] userList) {
            this.userList = userList;
        }

        public boolean hasMore() {
            return this.hasMore;
        }

        public void setHasMore(boolean hasMore) {
            this.hasMore = hasMore;
        }
    }
}

