/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BOrionObject;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeDatabaseEntry;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.RecordStatus;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.ldapDriver.BLdapServer;
import java.util.Map;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Property;

public class LdapImportMakeTenantEntry
extends LdapImportMakeDatabaseEntry {
    public LdapImportMakeTenantEntry(BLdapServer server, Map<String, ColumnDetails> mappingDetails, OrionSession session) {
        super(server, mappingDetails, session);
    }

    @Override
    public OrionType getDataBaseEntryType() {
        return BTenant.ORION_TYPE;
    }

    @Override
    public Property[] getMandatoryProperties() {
        return new Property[]{BTenant.tenantName};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordStatus recordExists(BOrionObject obj) {
        boolean recordExists = false;
        BTenant tenant = null;
        BTenant ref = (BTenant)obj;
        try (OrionCursor c = null;){
            BSqlQuery query = BSqlQuery.make((OrionType)BTenant.ORION_TYPE);
            if (!ref.getTenantName().equals("")) {
                BExpression exp = Predicates.eq((String)"tenantName", (BSimple)BString.make((String)ref.getTenantName()));
                query = query.where(exp);
                c = this.session.select((BQuery)query);
            }
            if (c.next()) {
                recordExists = true;
                tenant = (BTenant)((Object)c.get());
                tenant.setLastModified(BAbsTime.now());
            }
        }
        return new RecordStatus(recordExists && tenant != null ? tenant : obj, recordExists);
    }
}

