/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.access.orion.BInfoTemplate;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonInfo;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeDatabaseEntry;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.RecordStatus;
import com.tridiumx.ldapDriver.BLdapServer;
import java.util.Map;
import java.util.logging.Level;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;

public class LdapImportMakePersonInfoEntry
extends LdapImportMakeDatabaseEntry {
    private BRef personRef = BRef.NULL;

    public LdapImportMakePersonInfoEntry(BLdapServer server, Map<String, ColumnDetails> mappingDetails, OrionSession session) {
        super(server, mappingDetails, session);
    }

    @Override
    public boolean execute() {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Entering the step LdapImportMakePersonInfoEntry");
        }
        boolean success = false;
        BPersonInfo info = (BPersonInfo)this.getStepData();
        boolean populated = this.populateOrionObject(this.getLdapEntSecMappingDetails());
        if (populated && this.steps != null && this.steps.length == 1) {
            BInfoTemplate[] infoTemplates = BInfoTemplate.getOrderedInfoTemplates(this.session);
            boolean hasAtleastOneValue = false;
            for (int i = 0; i < infoTemplates.length; ++i) {
                BInfoTemplate infoTemplate = infoTemplates[i];
                String templateName = "info" + i;
                BValue templateValue = info.get(templateName);
                if (templateValue == null) continue;
                info.set(templateName, (BValue)BString.DEFAULT);
                String value = templateValue.toString();
                if ("".equals(value.trim())) continue;
                info.setValue(infoTemplate, value);
                hasAtleastOneValue = true;
            }
            if (hasAtleastOneValue) {
                try {
                    BPerson person = (BPerson)this.steps[0].getStepData();
                    this.personRef = BRef.make((BTypeSpec)BPerson.ORION_TYPE.getTypeSpec(), (BSimple)person.getPersonId());
                    info.setPerson(this.personRef);
                    if (info.isDefault(this.session)) {
                        if (this.session.exists((BIOrionObject)info)) {
                            this.session.delete((BIOrionObject)info);
                        }
                    } else {
                        RecordStatus recStatus = this.recordExists(info);
                        if (recStatus.isExists()) {
                            this.session.update((BIOrionObject)recStatus.get());
                        } else {
                            this.session.insert((BIOrionObject)recStatus.get());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            success = true;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Completed the step LdapImportMakePersonInfoEntry");
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RecordStatus recordExists(BOrionObject obj) {
        boolean recordExists = false;
        BPersonInfo info = null;
        if (this.steps.length == 1) {
            try (OrionCursor c = null;){
                BSqlQuery query = BSqlQuery.make((OrionType)BPersonInfo.ORION_TYPE);
                BExpression exp = Predicates.eq((String)"person", (BSimple)this.personRef);
                query = query.where(exp);
                c = this.session.select((BQuery)query);
                if (c.next()) {
                    recordExists = true;
                    info = (BPersonInfo)c.get();
                    info.setLastModified(BAbsTime.now());
                }
            }
        }
        return new RecordStatus(recordExists && info != null ? info : obj, recordExists);
    }

    @Override
    public OrionType getDataBaseEntryType() {
        return BPersonInfo.ORION_TYPE;
    }

    @Override
    public Property[] getMandatoryProperties() {
        return new Property[0];
    }
}

