/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importsteps;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.BatchStatement;
import com.tridiumx.entsec.access.orion.BPersonLdapServerJoin;
import com.tridiumx.entsec.ldap.importsteps.LdapImportMakeDatabaseEntry;
import com.tridiumx.entsec.ldap.importutil.ColumnDetails;
import com.tridiumx.entsec.ldap.importutil.FilteredLdapMappingDetailsCache;
import com.tridiumx.ldapDriver.BLdapServer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BSimple;
import javax.baja.sys.Property;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class LdapImportDeletePersonJoinEntries
extends LdapImportMakeDatabaseEntry {
    private List<BUuid> personUuidList = new ArrayList<BUuid>();

    public LdapImportDeletePersonJoinEntries(BLdapServer server, Map<String, ColumnDetails> mappingDetails, OrionSession session) {
        super(server, mappingDetails, session);
    }

    @Override
    public OrionType getDataBaseEntryType() {
        return BPersonLdapServerJoin.ORION_TYPE;
    }

    @Override
    public Property[] getMandatoryProperties() {
        return new Property[0];
    }

    @Override
    public boolean execute() {
        this.log.fine("Deleting all the person join entries asscoiated with LDAP server : " + this.server.getDisplayName(null));
        BatchStatement delStmt = this.session.batchDelete(this.getDataBaseEntryType());
        BSqlQuery query = BSqlQuery.make((OrionType)this.getDataBaseEntryType());
        BUuid serverId = FilteredLdapMappingDetailsCache.getInstance(this.server.getName()).getLdapServerReference();
        BExpression serverFilter = Predicates.eq((String)"ldapServer", (BSimple)BRef.make((BTypeSpec)com.tridiumx.entsec.access.orion.BLdapServer.TYPE.getTypeSpec(), (BSimple)serverId));
        query = (BSqlQuery)query.where(serverFilter);
        OrionCursor cur = this.session.select((BQuery)query);
        while (cur.next()) {
            BPersonLdapServerJoin entry = (BPersonLdapServerJoin)((Object)cur.get());
            BRef personRef = entry.getPerson();
            this.personUuidList.add((BUuid)personRef.getId());
            delStmt.add((BIOrionObject)entry);
        }
        try {
            delStmt.execute();
        }
        catch (Exception ex) {
            this.makeAuditLogErrorEntry("Error while deleting the entries in Person Server Mapping table", ex);
            return false;
        }
        this.log.fine("Person Server Join entries deleted");
        return true;
    }

    @Override
    public Object getStepData() {
        return this.personUuidList;
    }
}

