/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.ldap.importconfig;

import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BLdapServer;
import com.tridiumx.entsec.ldap.importconfig.CreatePersonCleanupProcedure;
import com.tridiumx.entsec.ldap.importutil.LdapImportUtils;
import com.tridiumx.entsec.orionTools.BAppTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.rdb.RdbmsContext;

class CreatePersonCleanupProcedureForMySQL
extends CreatePersonCleanupProcedure {
    private static Logger LOG = Logger.getLogger("entsec:CreatePersonCleanupProcedureForMySQL");

    CreatePersonCleanupProcedureForMySQL() {
    }

    @Override
    public String getDdl(RdbmsContext context) {
        StringBuilder sql = new StringBuilder();
        sql.append(" CREATE PROCEDURE                                                           ");
        sql.append("removePersonsDeletedFromLdapServer");
        sql.append("  (                                                                         ");
        sql.append("     IN ldapServerOrdString VARCHAR(255),                                   ");
        sql.append("     OUT noOfDeletedPersons INT                                             ");
        sql.append("  )                                                                         ");
        sql.append(" BEGIN                                                                      ");
        sql.append("    DECLARE done INT;                                                       ");
        sql.append("    DECLARE dnToBeDelete VARCHAR(255);                                      ");
        sql.append("    DECLARE dnRefToDelete VARCHAR(255);                                     ");
        sql.append("    DECLARE personToDelete BINARY(16);                                      ");
        sql.append("    DECLARE ldapServerOrdWithPrefix VARCHAR(255);                           ");
        sql.append("    DECLARE ldapServerIdFromOrd BINARY(16);                                 ");
        sql.append("    DECLARE ldapServerIdFromQuery BINARY(16);                               ");
        sql.append("    DECLARE person_cursor CURSOR FOR                                        ");
        sql.append(this.getToBeDeletedPersonsCursorQuery());
        sql.append("    DECLARE EXIT HANDLER FOR NOT FOUND SET done = 0;                        ");
        sql.append("    SET ldapServerOrdWithPrefix = CONCAT('%', ldapServerOrdString);         ");
        sql.append("    select ldapServerId into ldapServerIdFromOrd                            ");
        sql.append("      from ").append(BAppTable.getTableName(BLdapServer.ORION_TYPE));
        sql.append("     where ord like ldapServerOrdWithPrefix;                                ");
        sql.append("    SET noOfDeletedPersons = 0;                                             ");
        sql.append("    OPEN person_cursor;                                                     ");
        sql.append("        FETCH person_cursor INTO    personToDelete,                         ");
        sql.append("                                    ldapServerIdFromQuery,                  ");
        sql.append("                                    dnToBeDelete,                           ");
        sql.append("                                    dnRefToDelete;                          ");
        sql.append("    read_loop: LOOP                                                         ");
        sql.append("        IF (ldapServerIdFromQuery = ldapServerIdFromOrd) THEN               ");
        sql.append(this.deletePerson("personToDelete"));
        sql.append("            SET noOfDeletedPersons = (noOfDeletedPersons + 1);              ");
        sql.append("            FETCH person_cursor INTO    personToDelete,                     ");
        sql.append("                                        ldapServerIdFromQuery,              ");
        sql.append("                                        dnToBeDelete,                       ");
        sql.append("                                        dnRefToDelete;                      ");
        sql.append("        END IF;                                                             ");
        sql.append("    END LOOP;                                                               ");
        sql.append("    CLOSE person_cursor;                                                    ");
        sql.append("    select noOfDeletedPersons;                                              ");
        sql.append("    COMMIT;                                                                 ");
        sql.append(" END                                                                        ");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isProcedureCreationRequired(OrionSession session) throws SQLException {
        StringBuilder query = new StringBuilder();
        query.append("  SELECT COUNT(1)                     ");
        query.append("    FROM INFORMATION_SCHEMA.ROUTINES  ");
        query.append("   WHERE ROUTINE_TYPE = 'PROCEDURE'   ");
        query.append("     AND ROUTINE_SCHEMA = ?           ");
        query.append("     AND ROUTINE_NAME = ?             ");
        Connection connection = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            connection = this.getConnection(session);
            DatabaseMetaData metaData = connection.getMetaData();
            String dbURL = metaData.getURL();
            statement = connection.prepareStatement(query.toString());
            int paramIndex = 0;
            String dbSchemaName = LdapImportUtils.getDBSchemaName(dbURL);
            LOG.log(Level.FINE, "dbSchemaName: {0}", dbSchemaName);
            statement.setString(++paramIndex, dbSchemaName);
            statement.setString(++paramIndex, "removePersonsDeletedFromLdapServer");
            rs = statement.executeQuery();
            if (rs.next() && rs.getInt(1) > 0) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.closeConnection(connection);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

