/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.ui;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import com.tridiumx.entsec.intrusion.fox.BIntrusionGroupExt;
import com.tridiumx.entsec.intrusion.nd.BNiagaraIntrusionLearnResult;
import com.tridiumx.entsec.intrusion.orion.BMappedIntrusionZoneExt;
import com.tridiumx.entsec.intrusion.ui.BIntrusionSyncManager;
import com.tridiumx.entsec.intrusion.ui.BNiagaraIntrusionSyncManager;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BISession;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;

public class IntrusionSyncController
extends MgrController {
    public final MgrController.MgrCommand syncCommand;
    public final MgrController.MgrCommand pushCommand;

    public IntrusionSyncController(BIntrusionSyncManager mgr) {
        super((BAbstractManager)mgr);
        this.syncCommand = new SyncCommand((BWidget)mgr);
        this.syncCommand.setFlags(15);
        this.pushCommand = new PushCommand((BWidget)mgr);
        this.pushCommand.setFlags(15);
    }

    public MgrEdit makeEdit(String label) {
        return new IntrusionMgrEdit(this.getManager(), label);
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return IntrusionSyncController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.syncCommand, this.pushCommand});
    }

    public void updateCommands() {
        super.updateCommands();
        BMgrTable table = this.getManager().getModel().getTable();
        this.syncCommand.setEnabled(table != null && !table.getSelection().isEmpty());
        this.pushCommand.setEnabled(table != null && !table.getSelection().isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandArtifact doMatch(Object discovery, BComponent database, Context cx) throws Exception {
        database.lease();
        BNiagaraIntrusionLearnResult learn = (BNiagaraIntrusionLearnResult)((Object)discovery);
        BNiagaraIntrusionSyncManager manager = (BNiagaraIntrusionSyncManager)this.getManager();
        BIntrusionZone intrusionZone = (BIntrusionZone)database;
        BIntrusionZone remoteZone = new BIntrusionZone();
        BISession session = this.getManager().getCurrentValueSession();
        BFoxSession foxSession = (BFoxSession)session;
        BIntrusionService intrusionService = (BIntrusionService)foxSession.getService(BIntrusionService.TYPE);
        intrusionService.lease();
        BAlarmService alarmService = (BAlarmService)foxSession.getService(BAlarmService.TYPE);
        alarmService.lease(4);
        OrionSession orionSession = null;
        try {
            orionSession = intrusionService.createSession(null);
            BMappedIntrusionZoneExt.handlePush(remoteZone, learn.getUuid(), intrusionZone.getName(), intrusionZone, manager.getStationName(), alarmService, orionSession);
        }
        finally {
            if (orionSession != null) {
                orionSession.close();
                orionSession = null;
            }
        }
        BIntrusionGroupExt ext = BIntrusionGroupExt.addExt(intrusionZone, manager.getStationName());
        intrusionZone.sync();
        return null;
    }

    class PushCommand
    extends MgrController.MgrCommand {
        public PushCommand(BWidget owner) {
            super(owner, Lexicon.make(BIntrusionZone.class), "command.push");
        }

        public CommandArtifact doInvoke() throws Exception {
            BNiagaraIntrusionSyncManager manager = (BNiagaraIntrusionSyncManager)IntrusionSyncController.this.getManager();
            String stationName = manager.getDeviceExt().getDevice().getName();
            BComponent[] sel = IntrusionSyncController.this.getManager().getModel().getTable().getSelectedComponents();
            for (int i = 0; i < sel.length; ++i) {
                BIntrusionZone intrusionZone = (BIntrusionZone)sel[i];
                if (BIntrusionGroupExt.getExt(intrusionZone, stationName) == null) {
                    BIntrusionGroupExt.addExt(intrusionZone, stationName);
                }
                BIntrusionGroupExt ext = BIntrusionGroupExt.getExt(intrusionZone, stationName);
                ext.push();
                IntrusionSyncController.this.doDiscover(manager.getCurrentContext());
            }
            return null;
        }
    }

    class SyncCommand
    extends MgrController.MgrCommand {
        public SyncCommand(BWidget owner) {
            super(owner, Lexicon.make(BIntrusionZone.class), "command.sync");
        }

        public CommandArtifact doInvoke() {
            BNiagaraIntrusionSyncManager manager = (BNiagaraIntrusionSyncManager)IntrusionSyncController.this.getManager();
            String stationName = manager.getDeviceExt().getDevice().getName();
            BComponent[] sel = IntrusionSyncController.this.getManager().getModel().getTable().getSelectedComponents();
            for (int i = 0; i < sel.length; ++i) {
                BIntrusionZone iz = (BIntrusionZone)sel[i];
                iz.sync();
            }
            return null;
        }
    }

    class IntrusionMgrEdit
    extends MgrEdit {
        public IntrusionMgrEdit(BAbstractManager manager, String title) {
            super(manager, title);
        }

        public BComponent getAddContainer() {
            BISession session = this.getManager().getCurrentValueSession();
            BFoxSession foxSession = (BFoxSession)session;
            BAlarmService alarmService = (BAlarmService)foxSession.getService(BAlarmService.TYPE);
            return alarmService;
        }
    }
}

