/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.ui;

import com.tridium.workbench.bql.filter.ColumnNameTableModel;
import com.tridium.workbench.util.CollectionTableModel;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Tables;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.InvokeActionCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

public class BIntrusionZoneSummary
extends BWbComponentView {
    public static final Action updateCommands = BIntrusionZoneSummary.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BIntrusionZoneSummary.class);
    private static final String[] ATTRS = new String[]{"displayName", "zoneStatus", "timeDelay", "warningTime", "countDown", "priority", "timeOfLastAlarm", "ackRequired", "remoteStations", "toPathString"};
    private static final int[] DISPLAY = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static Lexicon lex = Lexicon.make(BIntrusionZoneSummary.class);
    private BTable table = new BTable();
    private BITable itable;
    private CollectionTableModel collectionModel;
    private IntHashMap nameMap;

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIntrusionZoneSummary() {
        this.table.setController((TableController)new Controller());
        this.setContent((BWidget)BTitlePane.makePane((String)TYPE.getDisplayName(null), (BTable)this.table, (String)lex.getText("alarm.alarmClasses")));
        this.add("selectionLink", (BValue)new BLink((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommands));
        this.nameMap = new IntHashMap();
        this.nameMap.put(0, (Object)"alarmClass.name");
        this.nameMap.put(1, (Object)"intrusionZone.zoneStatus");
        this.nameMap.put(2, (Object)"intrusionZone.timeDelay");
        this.nameMap.put(3, (Object)"intrusionZone.warningTime");
        this.nameMap.put(4, (Object)"intrusionZone.countDown");
        this.nameMap.put(5, (Object)"alarmClass.priority");
        this.nameMap.put(6, (Object)"alarmClass.timeOfLastAlarm");
        this.nameMap.put(7, (Object)"alarmClass.ackRequired");
        this.nameMap.put(8, (Object)"intrusionZone.remoteStations");
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.updateTable();
        this.table.fireTableModified(null);
    }

    private void updateTable() {
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd bqlOrd = BOrd.make((BOrd)authority, (String)this.query()).normalize();
        this.itable = (BITable)bqlOrd.resolve().get();
        boolean prevSorted = false;
        int sortCol = -1;
        boolean sortAsc = true;
        if (this.table.getModel() instanceof AlarmClassSummaryTableModel) {
            prevSorted = true;
            sortCol = ((AlarmClassSummaryTableModel)this.table.getModel()).sortCol;
            sortAsc = ((AlarmClassSummaryTableModel)this.table.getModel()).sortAsc;
        }
        this.collectionModel = new CollectionTableModel(this.itable, this.getCurrentContext());
        ColumnNameTableModel renameModel = new ColumnNameTableModel((TableModel)this.collectionModel, this.nameMap, lex);
        AlarmClassSummaryTableModel hideModel = new AlarmClassSummaryTableModel((TableModel)renameModel, DISPLAY);
        if (prevSorted && sortCol != -1) {
            hideModel.sortByColumn(sortCol, sortAsc);
        }
        this.table.setModel((TableModel)hideModel);
        this.table.relayout();
    }

    private String query() {
        StringBuffer s = new StringBuffer(128);
        s.append("station:|slot:/|bql:select ");
        for (int i = 0; i < ATTRS.length; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(ATTRS[i]);
        }
        s.append(" from entsec:IntrusionZone");
        return s.toString();
    }

    public void doUpdateCommands() {
    }

    public class AlarmClassSummaryTableModel
    extends DynamicTableModel {
        public int sortCol;
        public boolean sortAsc;

        public AlarmClassSummaryTableModel(TableModel root, int[] showColumns) {
            super(root, showColumns);
            this.sortCol = -1;
            this.sortAsc = true;
        }

        public AlarmClassSummaryTableModel(TableModel root) {
            super(root);
            this.sortCol = -1;
            this.sortAsc = true;
        }

        public void sortByColumn(int col, boolean ascending) {
            this.sortCol = col;
            this.sortAsc = ascending;
            super.sortByColumn(col, ascending);
        }

        public Object getValueAt(int row, int col) {
            Object obj = super.getValueAt(row, col);
            if (obj instanceof String) {
                obj = SlotPath.unescape((String)((String)obj));
            }
            return obj;
        }
    }

    public class GotoPoint
    extends Goto {
        public GotoPoint(int row, BITable itable) {
            super("alarmClass.goto.alarmClass", row, itable);
        }

        @Override
        public BOrd getTargetOrd() {
            BIRandomAccessTable tableRow = Tables.slurp((BITable)this.itable);
            return BOrd.make((String)("slot:" + tableRow.get(this.row).cell(BIntrusionZoneSummary.this.itable.getColumns().get("toPathString")).toString()));
        }
    }

    public abstract class Goto
    extends Command {
        int row;
        BITable itable;

        public Goto(String key, int row, BITable itable) {
            super((BWidget)BIntrusionZoneSummary.this, Sys.getModuleForClass(BIntrusionZoneSummary.class), key);
            this.row = row;
            this.itable = itable;
        }

        public abstract BOrd getTargetOrd();

        public CommandArtifact doInvoke() {
            BOrd targetOrd = this.getTargetOrd();
            if (targetOrd == null) {
                return null;
            }
            BOrd authority = ((BWbShell)BIntrusionZoneSummary.this.getShell()).getActiveOrd();
            BOrd hyperlinkOrd = BOrd.make((BOrd)authority, (BOrd)targetOrd).normalize();
            ((BWbShell)this.getShell()).hyperlink(hyperlinkOrd);
            return null;
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            ColumnList columns = BIntrusionZoneSummary.this.itable.getColumns();
            if (column != 1) {
                BOrd targetOrd = null;
                BIRandomAccessTable tableRow = Tables.slurp((BITable)BIntrusionZoneSummary.this.itable);
                String path = tableRow.get(row).cell(columns.get("toPathString")).toString();
                BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
                targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
                if (targetOrd != null) {
                    ((BWbShell)this.getShell()).hyperlink(targetOrd);
                }
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            ColumnList columns = BIntrusionZoneSummary.this.itable.getColumns();
            BIRandomAccessTable tableRow = Tables.slurp((BITable)BIntrusionZoneSummary.this.itable);
            String path = tableRow.get(row).cell(columns.get("toPathString")).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            BComponent target = (BComponent)targetOrd.get();
            BMenu menu = new BMenu();
            Action[] actions = target.getActionsArray();
            for (int i = 0; i < actions.length; ++i) {
                if (Flags.isHidden((BComplex)target, (Slot)actions[i])) continue;
                menu.add(null, (Command)new InvokeActionCommand((BWidget)this.getShell(), target, actions[i]));
            }
            menu.add(null, (Command)new GotoPoint(row, BIntrusionZoneSummary.this.itable));
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }
    }
}

