/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.ui;

import com.tridium.alarm.ui.BAlarmClassFE;
import com.tridium.alarm.ui.BInstructionsFE;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.bql.filter.ColumnNameTableModel;
import com.tridium.workbench.job.BJobBar;
import com.tridium.workbench.util.CollectionTableModel;
import com.tridiumx.entsec.securityUtil.BSetPropertyJob;
import javax.baja.alarm.BAlarmInstructions;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.BAlarmState;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.collection.Tables;
import javax.baja.data.BIDataTable;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.IntHashMap;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.WrapperTableModel;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.view.BWbComponentView;

public class BIntrusionExtManager
extends BWbComponentView {
    public static final Action updateCommands = BIntrusionExtManager.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BIntrusionExtManager.class);
    private static final String[] ATTRS = new String[]{"parent.toPathString", "toPathString", "name", "alarmClass", "alarmState", "entry", "alwaysArmed", "alarmState.ordinal", "alarmInstructions", "status"};
    private static final int[] DISPLAY = new int[]{0, 2, 3, 4, 5, 6, 8};
    private static Lexicon lex = Lexicon.make(BIntrusionExtManager.class);
    private BTable table;
    private BITable itable;
    private CollectionTableModel collectionModel;
    private ToggleCommand enableToEntryPoint;
    private ToggleCommand enableToAlwaysArmed;
    private Command editAlarmClass;
    private Command editInstructions;
    private IntHashMap nameMap;
    private BBorderPane topPane;
    private BJobBar jobBar;
    private BJob job;
    private boolean jobComplete;
    private BObject base;

    public void updateCommands() {
        this.invoke(updateCommands, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIntrusionExtManager(BObject base) {
        this();
        this.base = base;
    }

    public BIntrusionExtManager() {
        BEdgePane content = new BEdgePane();
        this.jobBar = new BJobBar();
        this.attach((BWbComponentView.Attachable)this.jobBar);
        BBorderPane jobPane = new BBorderPane((BWidget)this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        jobPane.setFill(Theme.widget().getWindowBackground());
        jobPane = new BBorderPane((BWidget)jobPane, BBorder.inset, BInsets.DEFAULT);
        this.topPane = new BBorderPane((BWidget)jobPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0));
        content.setTop((BWidget)this.topPane);
        this.topPane.setVisible(false);
        this.table = new BTable();
        this.table.setController((TableController)new Controller());
        this.table.setCellRenderer((TableCellRenderer)new CellRenderer());
        content.setCenter((BWidget)BTitlePane.makePane((String)lex.getText("alarm.alarmSourceExts"), (BTable)this.table, (String)lex.getText("alarm.exts")));
        this.setContent((BWidget)content);
        this.enableToEntryPoint = new EntryPoint();
        this.enableToAlwaysArmed = new EnableToAlwaysArmed();
        this.editAlarmClass = new EditAlarmClass();
        this.editInstructions = new EditInstructions();
        this.add("selectionLink", (BValue)new BLink((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)updateCommands));
        this.nameMap = new IntHashMap();
        this.nameMap.put(0, (Object)"alarm.point");
        this.nameMap.put(2, (Object)"alarm.extension");
        this.nameMap.put(3, (Object)"alarm.alarmClass");
        this.nameMap.put(4, (Object)"alarm.alarmState");
        this.nameMap.put(5, (Object)"intrusion.enableToEntryPoint.label");
        this.nameMap.put(6, (Object)"intrusion.toAlwaysArmed.label");
        this.nameMap.put(8, (Object)"alarm.instructions");
    }

    protected void doLoadValue(BObject value, Context context) throws Exception {
        this.updateTable();
        this.table.fireTableModified(null);
    }

    private void updateTable() {
        if (this.base == null) {
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd bqlOrd = BOrd.make((BOrd)authority, (String)this.query()).normalize();
            this.itable = (BITable)bqlOrd.resolve().get();
        } else {
            BOrd bqlOrd = BOrd.make((String)this.query()).normalize();
            this.itable = (BITable)bqlOrd.resolve(this.base).get();
        }
        boolean prevSorted = false;
        int sortCol = -1;
        boolean sortAsc = true;
        if (this.table.getModel() instanceof AlarmExtTableModel) {
            prevSorted = true;
            sortCol = ((AlarmExtTableModel)this.table.getModel()).sortCol;
            sortAsc = ((AlarmExtTableModel)this.table.getModel()).sortAsc;
        }
        this.collectionModel = new CollectionTableModel(this.itable, this.getCurrentContext());
        ColumnNameTableModel renameModel = new ColumnNameTableModel((TableModel)this.collectionModel, this.nameMap, lex);
        AlarmExtTableModel hideModel = new AlarmExtTableModel((TableModel)renameModel, DISPLAY);
        hideModel.setColumnShowable(1, false);
        hideModel.setColumnShowable(7, false);
        if (prevSorted && sortCol != -1) {
            hideModel.sortByColumn(sortCol, sortAsc);
        }
        this.table.setModel((TableModel)hideModel);
        this.table.relayout();
    }

    private String query() {
        StringBuffer s = new StringBuffer(128);
        s.append("station:|slot:/|bql:select ");
        for (int i = 0; i < ATTRS.length; ++i) {
            if (i != 0) {
                s.append(", ");
            }
            s.append(ATTRS[i]);
        }
        s.append(" from alarm:AlarmSourceExt");
        return s.toString();
    }

    public void doUpdateCommands() {
    }

    public BOrd[] getSelectedOrds() {
        int[] selectedRows = this.table.getSelection().getRows();
        int rowCount = selectedRows.length;
        BOrd[] ords = new BOrd[rowCount];
        TableCursor c = this.itable.cursor();
        int i = 0;
        while (c.next()) {
            String path = c.cell(this.itable.getColumns().get("toPathString")).toString();
            ords[i] = BOrd.make((String)("station:|slot:" + path)).normalize();
            ++i;
        }
        return ords;
    }

    public BAlarmSourceExt getExtensionForRow(int rowIndex) {
        String path = this.collectionModel.getValueAt(rowIndex, 1).toString();
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
        return (BAlarmSourceExt)targetOrd.resolve().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String p, BValue value) {
        BWidgetShell shell;
        BOrd[] selections = this.getSelectedOrds();
        if (selections.length == 0) {
            return;
        }
        BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
        BOrd jobServiceOrd = BOrd.make((BOrd)authority, (String)"service:baja:JobService");
        BJobService jobService = (BJobService)jobServiceOrd.resolve().get();
        jobService.lease();
        BSetPropertyJob[] jobs = (BSetPropertyJob[])jobService.getChildren(BSetPropertyJob.class);
        if (jobs != null) {
            for (int i = 0; i < jobs.length; ++i) {
                if (jobs[i] == null) continue;
                jobs[i].lease();
                if (!jobs[i].isAlive()) continue;
                BDialog.error((BWidget)this, (String)lex.getText("alarmExtManager.commandFail"), (Object)lex.getText("alarmExtManager.statusJobExists"));
                return;
            }
        }
        if (!this.topPane.isVisible()) {
            this.topPane.setVisible(true);
            this.topPane.getParentWidget().relayout();
        }
        if ((shell = this.getShell()) != null) {
            shell.enterBusy();
        }
        try {
            BOrd serviceOrd = BOrd.make((BOrd)authority, (String)"service:alarm:AlarmService");
            BAlarmService service = (BAlarmService)serviceOrd.resolve().get();
            BVector extOrds = new BVector();
            for (int j = 0; j < selections.length; ++j) {
                extOrds.add("o" + j, (BValue)selections[j]);
            }
            BSetPropertyJob job = new BSetPropertyJob(this.getCurrentValue(), extOrds, p, value);
            job.submit(this.getCurrentContext());
            this.setJob(job);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (shell != null) {
                shell.exitBusy();
            }
        }
    }

    private BJob getJob() {
        return this.job;
    }

    private void setJob(BJob job) {
        this.job = job;
        this.jobComplete = false;
        this.registerForComponentEvents((BComponent)job);
        this.jobBar.load(job);
        if (job != null && job.getJobState().isComplete() && !this.jobComplete) {
            this.jobComplete = true;
            this.jobComplete(job);
        }
    }

    private void setJob(BOrd jobOrd, BComponent base) throws Exception {
        base.getComponentSpace().sync();
        BJob job = (BJob)jobOrd.get((BObject)base);
        this.setJob(job);
    }

    private void jobComplete(BJob job) {
        this.updateTable();
    }

    public class AlarmExtTableModel
    extends DynamicTableModel {
        public int sortCol;
        public boolean sortAsc;

        public AlarmExtTableModel(TableModel root, int[] showColumns) {
            super(root, showColumns);
            this.sortCol = -1;
            this.sortAsc = true;
        }

        public AlarmExtTableModel(TableModel root) {
            super(root);
            this.sortCol = -1;
            this.sortAsc = true;
        }

        public void sortByColumn(int col, boolean ascending) {
            this.sortCol = col;
            this.sortAsc = ascending;
            super.sortByColumn(col, ascending);
        }

        public Object getValueAt(int row, int col) {
            Object obj = super.getValueAt(row, col);
            if (obj instanceof String) {
                obj = SlotPath.unescape((String)((String)obj));
            }
            return obj;
        }
    }

    public class GotoPoint
    extends Goto {
        public GotoPoint(int row, BITable itable) {
            super("alarmClass.goto.alarmClass", row, itable);
        }

        @Override
        public BOrd getTargetOrd() {
            return BOrd.make((String)("slot:" + BIntrusionExtManager.this.collectionModel.getValueAt(this.row, 0)));
        }
    }

    public abstract class Goto
    extends Command {
        int row;
        BITable itable;

        public Goto(String key, int row, BITable itable) {
            super((BWidget)BIntrusionExtManager.this, Sys.getModuleForClass(BIntrusionExtManager.class), key);
            this.row = row;
            this.itable = itable;
        }

        public abstract BOrd getTargetOrd();

        public CommandArtifact doInvoke() {
            BOrd targetOrd = this.getTargetOrd();
            if (targetOrd == null) {
                return null;
            }
            BOrd authority = ((BWbShell)BIntrusionExtManager.this.getShell()).getActiveOrd();
            BOrd hyperlinkOrd = BOrd.make((BOrd)authority, (BOrd)targetOrd).normalize();
            ((BWbShell)this.getShell()).hyperlink(hyperlinkOrd);
            return null;
        }
    }

    private class CellRenderer
    extends TableCellRenderer {
        BIDataTable lastTable = null;
        int stateOrdCol = -1;

        private CellRenderer() {
        }

        protected void paintCellBackground(Graphics g, TableCellRenderer.Cell cell) {
            if (cell.selected) {
                super.paintCellBackground(g, cell);
                return;
            }
            try {
                ColumnList columns = BIntrusionExtManager.this.itable.getColumns();
                if (BIntrusionExtManager.this.itable != this.lastTable || this.stateOrdCol == -1) {
                    this.stateOrdCol = columns.indexOf("alarmState.ordinal");
                }
                BColor bg = null;
                BColor fg = null;
                TableModel tModel = BIntrusionExtManager.this.table.getModel();
                if (!(tModel instanceof WrapperTableModel)) {
                    super.paintCellBackground(g, cell);
                    return;
                }
                int stateOrd = Integer.parseInt(((WrapperTableModel)tModel).getRootModel().getValueAt(cell.row, this.stateOrdCol).toString());
                if (stateOrd != BAlarmState.normal.getOrdinal()) {
                    if (stateOrd == BAlarmState.fault.getOrdinal()) {
                        bg = (BColor)BStatus.faultBg;
                        fg = (BColor)BStatus.faultFg;
                    } else {
                        bg = (BColor)BStatus.alarmBg;
                        fg = (BColor)BStatus.alarmFg;
                    }
                }
                if (bg != null) {
                    g.setBrush(bg);
                    g.fillRect(0.0, 0.0, cell.width, cell.height);
                    g.setBrush(fg);
                } else {
                    g.setBrush(Theme.table().getTextBrush());
                }
                g.setFont(Theme.table().getCellFont());
            }
            catch (ClassCastException e) {
                super.paintCellBackground(g, cell);
            }
            catch (NullPointerException e) {
                super.paintCellBackground(g, cell);
            }
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            ColumnList columns = BIntrusionExtManager.this.itable.getColumns();
            BOrd targetOrd = null;
            String path = BIntrusionExtManager.this.collectionModel.getValueAt(row, 1).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            if (targetOrd != null) {
                ((BWbShell)this.getShell()).hyperlink(targetOrd);
            }
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            ColumnList columns = BIntrusionExtManager.this.itable.getColumns();
            BIRandomAccessTable tableRow = Tables.slurp((BITable)BIntrusionExtManager.this.itable);
            String path = BIntrusionExtManager.this.collectionModel.getValueAt(row, 1).toString();
            BOrd authority = ((BWbShell)this.getShell()).getActiveOrd();
            BOrd targetOrd = BOrd.make((BOrd)authority, (String)("slot:" + path)).normalize();
            BComponent target = (BComponent)targetOrd.get();
            BMenu menu = new BMenu();
            menu.add(null, (BValue)new BSubMenuItem((BIMenu)NavMenuUtil.makeViewsMenu((BWidget)this.getTable(), (BObject)target)));
            menu.add(null, (BValue)new BSubMenuItem((BIMenu)NavMenuUtil.makeActionsMenu((BWidget)this.getTable(), (BComponent)target)));
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)new GotoPoint(row, BIntrusionExtManager.this.itable));
            menu.add(null, (BValue)new BSeparator());
            if (BIntrusionExtManager.this.table.getModel().getSelection().getRows().length == 1) {
                String entry = tableRow.get(row).cell(columns.get("entry")).toString();
                String always = tableRow.get(row).cell(columns.get("alwaysArmed")).toString();
                if (entry.length() > 0) {
                    BIntrusionExtManager.this.enableToEntryPoint.setSelected(BBoolean.make((String)entry).getBoolean());
                }
                if (always.length() > 0) {
                    BIntrusionExtManager.this.enableToAlwaysArmed.setSelected(BBoolean.make((String)always).getBoolean());
                }
            }
            menu.add("toOffnormal", (Command)BIntrusionExtManager.this.enableToEntryPoint);
            menu.add("toFault", (Command)BIntrusionExtManager.this.enableToAlwaysArmed);
            menu.add("editAlarmClass", BIntrusionExtManager.this.editAlarmClass);
            menu.add("editInstructions", BIntrusionExtManager.this.editInstructions);
            menu.open((BWidget)this.getTable(), event.getX(), event.getY());
        }
    }

    public class EditInstructions
    extends Command {
        public EditInstructions() {
            super((BWidget)BIntrusionExtManager.this, Sys.getModuleForClass(BIntrusionExtManager.class), "intrusion.editInstructions");
        }

        public CommandArtifact doInvoke() {
            int[] selectedRows = BIntrusionExtManager.this.table.getSelection().getRows();
            BAlarmInstructions inst = BAlarmInstructions.NULL;
            if (selectedRows.length == 1) {
                BAlarmSourceExt extension = BIntrusionExtManager.this.getExtensionForRow(selectedRows[0]);
                extension.lease();
                inst = extension.getAlarmInstructions();
            }
            BInstructionsFE iFE = new BInstructionsFE();
            BIntrusionExtManager.this.add("temp", (BValue)iFE);
            iFE.loadValue((BObject)inst, null);
            BIntrusionExtManager.this.remove("temp");
            int retVal = BDialog.open((BWidget)BIntrusionExtManager.this, (String)lex.get("alarm.editAlarmClass.label"), (Object)iFE, (int)3, (BImage)null);
            if (retVal == 1) {
                try {
                    inst = (BAlarmInstructions)iFE.saveValue((BObject)inst, null);
                    for (int i = 0; i < selectedRows.length; ++i) {
                        BAlarmSourceExt extension = BIntrusionExtManager.this.getExtensionForRow(selectedRows[i]);
                        extension.lease();
                        extension.setAlarmInstructions(inst);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BIntrusionExtManager.this.updateTable();
            }
            return null;
        }
    }

    public class EditAlarmClass
    extends Command {
        public EditAlarmClass() {
            super((BWidget)BIntrusionExtManager.this, Sys.getModuleForClass(BIntrusionExtManager.class), "intrusion.editAlarmClass");
        }

        public CommandArtifact doInvoke() {
            int[] selectedRows = BIntrusionExtManager.this.table.getSelection().getRows();
            String acName = "";
            if (selectedRows.length == 1) {
                BAlarmSourceExt extension = BIntrusionExtManager.this.getExtensionForRow(selectedRows[0]);
                extension.lease();
                acName = extension.getAlarmClass();
            }
            BAlarmClassFE acFE = new BAlarmClassFE();
            BIntrusionExtManager.this.add("temp", (BValue)acFE);
            acFE.loadValue((BObject)BString.make((String)acName), null);
            BIntrusionExtManager.this.remove("temp");
            int retVal = BDialog.open((BWidget)BIntrusionExtManager.this, (String)lex.get("alarm.editAlarmClass.label"), (Object)acFE, (int)3, (BImage)null);
            if (retVal == 1) {
                try {
                    acName = acFE.saveValue((BObject)BString.make((String)acName), null).toString();
                    for (int i = 0; i < selectedRows.length; ++i) {
                        BAlarmSourceExt extension = BIntrusionExtManager.this.getExtensionForRow(selectedRows[i]);
                        extension.lease();
                        extension.setAlarmClass(acName);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                BIntrusionExtManager.this.updateTable();
            }
            return null;
        }
    }

    public class EnableToAlwaysArmed
    extends ToggleCommand {
        public EnableToAlwaysArmed() {
            super((BWidget)BIntrusionExtManager.this, Sys.getModuleForClass(BIntrusionExtManager.class), "intrusion.toAlwaysArmed");
        }

        public CommandArtifact doInvoke() {
            if (this.isSelected()) {
                BIntrusionExtManager.this.setProperty("alwaysArmed", (BValue)BBoolean.TRUE);
            } else {
                BIntrusionExtManager.this.setProperty("alwaysArmed", (BValue)BBoolean.FALSE);
            }
            return null;
        }
    }

    public class EntryPoint
    extends ToggleCommand {
        public EntryPoint() {
            super((BWidget)BIntrusionExtManager.this, Sys.getModuleForClass(BIntrusionExtManager.class), "intrusion.enableToEntryPoint");
        }

        public CommandArtifact doInvoke() {
            if (this.isSelected()) {
                BIntrusionExtManager.this.setProperty("entry", (BValue)BBoolean.TRUE);
            } else {
                BIntrusionExtManager.this.setProperty("entry", (BValue)BBoolean.FALSE);
            }
            return null;
        }
    }
}

