/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.replicate;

import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BatchStatement;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPin;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPinJoin;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneGroup;
import com.tridiumx.entsec.intrusion.orion.BIntrusionZoneRec;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.replicate.BDeletion;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.orionTools.replicate.Replicator;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class IntrusionReplicator
extends Replicator {
    private static final OrionType TYPE_Z = BIntrusionZoneRec.ORION_TYPE;
    private static final OrionType TYPE_G = BIntrusionZoneGroup.ORION_TYPE;
    private static final OrionType TYPE_P = BIntrusionPin.ORION_TYPE;
    private static final OrionType TYPE_PZ = BIntrusionPinJoin.ORION_TYPE;
    private static final OrionType TYPE_S = BScheduleRec.ORION_TYPE;
    private static final OrionType TYPE_T = BTenant.ORION_TYPE;
    private static final String Z = BAppTable.getTableName(TYPE_Z);
    private static final String G = BAppTable.getTableName(TYPE_G);
    private static final String P = BAppTable.getTableName(TYPE_P);
    private static final String PZ = BAppTable.getTableName(TYPE_PZ);
    private static final String S = BAppTable.getTableName(TYPE_S);
    private static final String T = BAppTable.getTableName(TYPE_T);
    private static final String LAST_MODIFIED = BReplicableObject.lastModified.getName();
    private static final String G_STATION_NAME = "g." + BIntrusionZoneGroup.stationName.getName();
    private static final String G_INTRUSIONZONE = "g." + BIntrusionZoneGroup.intrusionZone.getName();
    private static final String Z_UUID = "z." + BIntrusionZoneRec.uuid.getName();
    private static final String PZ_INTRUSION_ZONE = "pz." + BIntrusionPinJoin.intrusionZone.getName();
    private static final String PZ_INTRUSION_PIN = "pz." + BIntrusionPinJoin.intrusionPin.getName();
    private static final String P_INTRUSION_PIN_ID = "p." + BIntrusionPin.intrusionPinId.getName();
    private static final String S_UUID = "s." + BScheduleRec.uuid.getName();
    private static final String P_SCHED = "p." + BIntrusionPin.schedule.getName();
    private static final String T_UUID = "t." + BTenant.tenantId.getName();
    private static final String P_TENANT = "p." + BIntrusionPin.tenant.getName();
    private static final String SQL_Z = "select * from " + Z + " where " + LAST_MODIFIED + " between ? and ?";
    private static final String SQL_G = "select * from " + G + " where " + LAST_MODIFIED + " between ? and ?";
    private static final String SQL_PZ = "select distinct pz.* from " + PZ + " pz inner join " + Z + " z on " + PZ_INTRUSION_ZONE + " = " + Z_UUID + " inner join " + G + " g on " + G_INTRUSIONZONE + " = " + Z_UUID + " where (pz." + LAST_MODIFIED + " between ? and ?) and " + G_STATION_NAME + " = ?";
    private static final String SQL_P = "select distinct p.* from " + P + " p inner join " + PZ + " pz on " + P_INTRUSION_PIN_ID + " = " + PZ_INTRUSION_PIN + " inner join " + Z + " z  on " + PZ_INTRUSION_ZONE + " = " + Z_UUID + " inner join " + G + " g  on " + G_INTRUSIONZONE + " = " + Z_UUID + " where (pz." + LAST_MODIFIED + " between ? and ? or  p." + LAST_MODIFIED + " between ? and ?) and " + G_STATION_NAME + " = ?";
    private static final String SQL_S = "select distinct s.* from " + S + " s inner join " + P + " p  on " + S_UUID + " = " + P_SCHED + " inner join " + PZ + " pz on " + P_INTRUSION_PIN_ID + " = " + PZ_INTRUSION_PIN + " inner join " + Z + " z  on " + PZ_INTRUSION_ZONE + " = " + Z_UUID + " inner join " + G + " g  on " + G_INTRUSIONZONE + " = " + Z_UUID + " where (s." + LAST_MODIFIED + " between ? and ? or  pz." + LAST_MODIFIED + " between ? and ? or  p." + LAST_MODIFIED + " between ? and ?) and " + G_STATION_NAME + " = ?";
    private static final String SQL_T = "select distinct t.* from " + T + " t inner join " + P + " p  on " + T_UUID + " = " + P_TENANT + " inner join " + PZ + " pz on " + P_INTRUSION_PIN_ID + " = " + PZ_INTRUSION_PIN + " inner join " + Z + " z  on " + PZ_INTRUSION_ZONE + " = " + Z_UUID + " inner join " + G + " g  on " + G_INTRUSIONZONE + " = " + Z_UUID + " where (t." + LAST_MODIFIED + " between ? and ? or  pz." + LAST_MODIFIED + " between ? and ? or  p." + LAST_MODIFIED + " between ? and ?) and " + G_STATION_NAME + " = ?";
    private static OrionType[] CLEAN_TYPES = new OrionType[]{TYPE_Z, TYPE_G, TYPE_P, TYPE_PZ, TYPE_S, TYPE_T};
    private static final BOrd APP_ORD = BOrd.make((String)"service:entsec:IntrusionService");

    public int compareTo(Object o) {
        return 1;
    }

    @Override
    protected BAbstractOrionApp getSupervisorOrionApp() {
        return (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
    }

    @Override
    protected BOrd getJaceOrionAppOrd() {
        return APP_ORD;
    }

    public OrionSession openSupervisorSession(String name) {
        return IntrusionReplicator.makeOrionSession(this.getSupervisorOrionApp(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReplicate(OrionSession jaceSession, BAbsTime timestamp, String stationName, boolean replicateFromJace, BSafeSimpleJob job, BFacets facets) throws Exception {
        OrionSession superSession = null;
        try {
            superSession = this.openSupervisorSession(stationName);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            if (replicateFromJace) {
                this.pullDeleteIntrusionZones(jaceSession, timestamp, stationName, superSession);
                this.pullDelete(jaceSession, timestamp, TYPE_G, superSession);
                this.pullPersist(jaceSession, timestamp, TYPE_Z, SQL_Z, superSession);
                this.pullPersist(jaceSession, timestamp, TYPE_G, SQL_G, superSession);
            }
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushDelete(jaceSession, timestamp, TYPE_S, superSession);
            this.pushPersistPerJace(jaceSession, timestamp, 3, stationName, TYPE_S, SQL_S, true, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushDelete(jaceSession, timestamp, TYPE_T, superSession);
            this.pushPersistPerJace(jaceSession, timestamp, 3, stationName, TYPE_T, SQL_T, false, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_PZ, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_P, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushPersistPerJace(jaceSession, timestamp, 2, stationName, TYPE_P, SQL_P, false, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushPersistPerJace(jaceSession, timestamp, 1, stationName, TYPE_PZ, SQL_PZ, false, superSession);
        }
        finally {
            if (superSession != null) {
                superSession.close();
                superSession = null;
            }
        }
    }

    @Override
    protected void doCleanSupervisorDeletionTable(BAbsTime timestamp) throws Exception {
        IntrusionReplicator.cleanDeletionTable(this.getSupervisorSession(), timestamp);
    }

    @Override
    protected void doCleanJaceDeletionTable(OrionSession jaceSession, BAbsTime timestamp) throws Exception {
        IntrusionReplicator.cleanDeletionTable(jaceSession, timestamp);
    }

    protected final void pullDeleteIntrusionZones(OrionSession jaceSession, BAbsTime timestamp, String stationName, OrionSession superSession) throws Exception {
        OrionType type = BIntrusionZoneRec.ORION_TYPE;
        OrionType groupType = BIntrusionZoneGroup.ORION_TYPE;
        this.logTrace("pullDelete begin " + type + " being processed as " + groupType);
        OrionCursor jaceCursor = jaceSession.select(BDeletion.ORION_TYPE, SQL_D, new BSimple[]{type.getTypeSpec(), timestamp});
        BatchStatement supDelete = superSession.batchDelete(groupType);
        supDelete.setChunkSize(CHUNK_SIZE);
        while (jaceCursor.next()) {
            BDeletion del = (BDeletion)((Object)jaceCursor.get());
            BIntrusionZoneRec zoneRec = (BIntrusionZoneRec)IntrusionReplicator.createRecordFromDeletion(del, type);
            BIntrusionZoneGroup groupRec = new BIntrusionZoneGroup();
            groupRec.setIntrusionZone(BRef.make((BIOrionObject)zoneRec));
            groupRec.setStationName(stationName);
            supDelete.add((BIOrionObject)groupRec);
            if (supDelete.size() <= EXECUTE_SIZE) continue;
            supDelete.execute();
        }
        this.logTrace("pullDelete execute " + supDelete.size());
        supDelete.execute();
        this.logTrace("pullDelete end");
    }
}

