/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion.fox;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BRemoteIntrusionResult;
import com.tridiumx.entsec.intrusion.BRemoteIntrusionSync;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.entsec.intrusion.fox.BIRemoteIntrusion;
import com.tridiumx.entsec.intrusion.fox.BIntrusionChannel;
import com.tridiumx.entsec.intrusion.nd.BNiagaraIntrusionLearnJob;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUnrestrictedFolder;

public class BNiagaraIntrusionDeviceExt
extends BDeviceExt
implements BINiagaraDeviceExt,
BIMixIn,
BFoxClientConnection.Interest,
BIRemoteIntrusion {
    public static final Property enabled = BNiagaraIntrusionDeviceExt.newProperty((int)0, (boolean)true, null);
    public static final Property status = BNiagaraIntrusionDeviceExt.newProperty((int)3, (BValue)BStatus.ok, null);
    public static final Property faultCause = BNiagaraIntrusionDeviceExt.newProperty((int)3, (String)"", null);
    public static final Action ping = BNiagaraIntrusionDeviceExt.newAction((int)16, null);
    public static final Action submitDiscoveryJob = BNiagaraIntrusionDeviceExt.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BNiagaraIntrusionDeviceExt.class);
    private static final BIcon icon = BIcon.make((String)"module://entsec/rc/intrusion/intrusionZone.png");
    private static final Logger log = Logger.getLogger(BIntrusionService.TYPE.getModule().getModuleName());

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public void ping() {
        this.invoke(ping, null, null);
    }

    public BOrd submitDiscoveryJob() {
        return (BOrd)this.invoke(submitDiscoveryJob, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void updateStatus() {
        BDevice device = this.getDevice();
        if (device == null) {
            return;
        }
        int bits = 0;
        BStatus deviceStatus = device.getStatus();
        if (deviceStatus.isDisabled() || !this.getEnabled()) {
            bits |= 1;
        }
        if (this.getFaultCause().length() != 0) {
            bits |= 2;
        }
        this.setStatus(BStatus.make((int)bits));
    }

    public void setFault(String cause) {
        this.setFaultCause(cause);
        this.updateStatus();
    }

    public void clearFault() {
        this.setFaultCause("");
        this.updateStatus();
    }

    public String getDisplayNameInParent(Context cx) {
        return "Intrusion";
    }

    public void started() {
        this.updateStatus();
    }

    public void stopped() {
    }

    public void changed(Property prop, Context cx) {
        if (prop.equals(enabled)) {
            this.updateStatus();
        }
    }

    public final BFoxClientConnection getClientConnection() {
        return ((BNiagaraStation)this.getParent()).getClientConnection();
    }

    public synchronized BIntrusionChannel getChannel() {
        BIntrusionChannel channel = (BIntrusionChannel)this.getClientConnection().getChannels().get("intrusion", BIntrusionChannel.TYPE);
        return channel;
    }

    public void serverOpened() {
    }

    public void serverClosed() {
    }

    public void clientOpened() {
    }

    public void clientClosed() {
    }

    void closeConnection(BFoxClientConnection.Interest i) throws Exception {
        BIntrusionChannel channel = this.getChannel();
        BFoxClientConnection conn = channel.getClientConnection();
        conn.disengage(i);
    }

    BFoxClientConnection openConnection(BFoxClientConnection.Interest i) throws Exception {
        BIntrusionChannel channel = this.getChannel();
        BFoxClientConnection conn = channel.getClientConnection();
        conn.engageNoRetry(i);
        return conn;
    }

    public void doPing() {
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            BIntrusionChannel channel = this.getChannel();
            channel.ping();
            this.clearFault();
        }
        catch (Exception ex) {
            this.setFault("Intrusion ping failed.");
        }
        finally {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
    }

    public BITable discover() {
        try {
            this.openConnection(this);
            BITable bITable = this.getChannel().learn();
            return bITable;
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new BajaRuntimeException((Throwable)x);
        }
        finally {
            try {
                this.closeConnection(this);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    public BOrd doSubmitDiscoveryJob(Context cx) {
        return new BNiagaraIntrusionLearnJob(this).submit(cx);
    }

    public void setFault(String cause, BRemoteIntrusionResult result) {
        this.setFault(cause);
        String details = result.getRecord().getDetails();
        if (details.length() > 0) {
            details = details + ";";
        }
        result.getRecord().setDetails(details + IntrusionUtil.text("stationConnectionFailure", new Object[]{this.getDevice().getName()}));
    }

    public void setFault(String cause, BRemoteIntrusionSync sync) {
        this.setFault(cause);
        String details = sync.getRecord().getDetails();
        if (details.length() > 0) {
            details = details + ";";
        }
        sync.getRecord().setDetails(details + IntrusionUtil.text("stationConnectionFailure", new Object[]{this.getDevice().getName()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BRemoteIntrusionSync sync(BRemoteIntrusionSync result) {
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            result = this.getChannel().sync(result);
            this.clearFault();
        }
        catch (Exception ex) {
            this.setFault("Intrusion sync failed.", result);
        }
        finally {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BRemoteIntrusionResult armingSequence(BRemoteIntrusionResult result) {
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            result = this.getChannel().armingSequence(result);
            this.clearFault();
        }
        catch (Exception ex) {
            this.setFault("Intrusion arming sequence failed.", result);
        }
        finally {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BRemoteIntrusionResult armingTest(BRemoteIntrusionResult result) {
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            result = this.getChannel().armingTest(result);
            this.clearFault();
        }
        catch (Exception ex) {
            this.setFault("Intrusion Arming Test failed.", result);
        }
        finally {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BRemoteIntrusionResult disarm(BRemoteIntrusionResult result) {
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            result = this.getChannel().disarm(result);
            this.clearFault();
        }
        catch (Exception ex) {
            this.setFault("Intrusion disarm failed.", result);
        }
        finally {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BRemoteIntrusionResult forceArm(BRemoteIntrusionResult result) {
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            result = this.getChannel().forceArm(result);
            this.clearFault();
        }
        catch (Exception ex) {
            this.setFault("Intrusion force Arm failed.", result);
        }
        finally {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BRemoteIntrusionResult allowingTimeForDisarm(BRemoteIntrusionResult result) {
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            result = this.getChannel().allowingTimeForDisarm(result);
            this.clearFault();
        }
        catch (Exception ex) {
            this.setFault("Allowing Time For Disarm failed.", result);
        }
        finally {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BRemoteIntrusionSync remoteSync(BRemoteIntrusionSync sync) {
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            sync = this.getChannel().sync(sync);
            this.clearFault();
        }
        catch (Exception ex) {
            this.setFault("Intrusion remote Sync failed.", sync);
        }
        finally {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
        return sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(BUnrestrictedFolder zones) {
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            this.getChannel().push(zones);
            this.clearFault();
        }
        catch (Exception ex) {
            this.setFault("Push failed.");
        }
        finally {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

