/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion;

import com.tridiumx.accessDriver.BAccessAlarmSourceExt;
import com.tridiumx.accessDriver.BOffAlarmClass;
import com.tridiumx.accessDriver.enums.BSecurityAlgorithmEnum;
import com.tridiumx.entsec.intrusion.BIntrusionZone;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public abstract class IntrusionUtil {
    public static Lexicon lex = Lexicon.make(IntrusionUtil.class);
    public static final String DEFAULT = "defaultIntrusionZone";
    public static final String handlePrefix = "station:|h:";

    public static void matchEnabled(BAlarmSourceExt ext, String alarmClassName) {
        BAlarmService service = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        BAlarmClass alarmClass = service.lookupAlarmClass(alarmClassName);
        if (alarmClass instanceof BIntrusionZone) {
            IntrusionUtil.matchZoneEnabled(ext, ((BIntrusionZone)alarmClass).getZoneEnabled().getBoolean());
        }
    }

    public static void matchZoneEnabled(BAlarmSourceExt ext, boolean zoneEnabled) {
        if (ext.getMetaData().getb("alwaysArmed", false)) {
            if (ext.getAlarmInhibit().getValue()) {
                ext.setAlarmInhibit(new BStatusBoolean(false));
            }
            return;
        }
        if (zoneEnabled && ext.getAlarmInhibit().getValue()) {
            ext.setAlarmInhibit(new BStatusBoolean(false));
        } else if (!zoneEnabled && !ext.getAlarmInhibit().getValue()) {
            ext.setAlarmInhibit(new BStatusBoolean(true));
        }
    }

    public static void createDefaultIntrusionZone() {
        BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
        if (alarmService.get(DEFAULT) == null) {
            alarmService.add(DEFAULT, (BValue)new BIntrusionZone());
        }
    }

    public static String text(String text) {
        return lex.getText(text);
    }

    public static String text(String text, Object[] params) {
        return lex.getText(text, params);
    }

    public static String getAlarmDescription(BAlarmSourceExt ext) {
        String text = TextUtil.toFriendly((String)ext.getParent().getName());
        String offNormalText = ext.getToOffnormalText().format((Object)ext);
        String faultText = ext.getToFaultText().format((Object)ext);
        if (offNormalText.length() > 0) {
            text = text + "." + offNormalText;
        } else if (faultText.length() > 0) {
            text = text + "." + faultText;
        }
        return text;
    }

    public static BComponent getComponent(String handle) {
        if (handle == null) {
            return null;
        }
        String ordString = handlePrefix + handle;
        try {
            BObject object = BOrd.make((String)ordString).get();
            if (object.isComponent()) {
                return (BComponent)object;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void deleteAlarmClass(String oldName) {
        BString defaultAlarmClass = BString.make((String)BAlarmService.defaultAlarmClass.getName());
        BString offAlarmClass = BString.make((String)BOffAlarmClass.getAlarmClassName());
        BAlarmSourceExt[] alarmExtUsage = IntrusionUtil.getAlarmSourceExtUsage(oldName);
        for (int i = 0; i < alarmExtUsage.length; ++i) {
            if (alarmExtUsage[i] instanceof BAccessAlarmSourceExt && ((BAccessAlarmSourceExt)alarmExtUsage[i]).getSecurityAlgorithm() == BSecurityAlgorithmEnum.intrusionTimeout) {
                alarmExtUsage[i].set("alarmClass", (BValue)offAlarmClass);
                continue;
            }
            alarmExtUsage[i].set("alarmClass", (BValue)defaultAlarmClass);
        }
        BAlarmSourceInfo[] alarmInfo = IntrusionUtil.getAlarmSourceInfoUsage(oldName);
        for (int i = 0; i < alarmInfo.length; ++i) {
            alarmInfo[i].set("alarmClass", (BValue)defaultAlarmClass);
        }
    }

    public static void renameAlarmClass(String oldName, String newName) {
        BAlarmSourceExt[] alarmExtUsage = IntrusionUtil.getAlarmSourceExtUsage(oldName);
        for (int i = 0; i < alarmExtUsage.length; ++i) {
            alarmExtUsage[i].set("alarmClass", (BValue)BString.make((String)newName));
        }
        BAlarmSourceInfo[] alarmInfo = IntrusionUtil.getAlarmSourceInfoUsage(oldName);
        for (int i = 0; i < alarmInfo.length; ++i) {
            alarmInfo[i].set("alarmClass", (BValue)BString.make((String)newName));
        }
    }

    public static BAlarmSourceExt[] getAlarmSourceExtUsage(String alarmClassName) {
        String station = "station:|slot:/";
        String bql = "|bql:select * from alarm:AlarmSourceExt where alarmClass='" + SlotPath.escape((String)alarmClassName) + "'";
        BOrd bqlOrd = BOrd.make((String)(station + bql)).normalize();
        BITable points = (BITable)bqlOrd.resolve().get();
        TableCursor c = points.cursor();
        Array arr = new Array(BAlarmSourceExt.class);
        while (c.next()) {
            arr.add(c.get());
        }
        return (BAlarmSourceExt[])arr.trim();
    }

    public static BAlarmSourceInfo[] getAlarmSourceInfoUsage(String alarmClassName) {
        String station = "station:|slot:/";
        String bql = "|bql:select * from alarm:AlarmSourceInfo where alarmClass='" + SlotPath.escape((String)alarmClassName) + "'";
        BOrd bqlOrd = BOrd.make((String)(station + bql)).normalize();
        TableCursor points = ((BITable)bqlOrd.resolve().get()).cursor();
        Array arr = new Array(BAlarmSourceInfo.class);
        while (points.next()) {
            arr.add(points.get());
        }
        return (BAlarmSourceInfo[])arr.trim();
    }
}

