/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.kitControl.BAlarmCountToRelay;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.OrionSession;
import com.tridiumx.accessDriver.BAuthorization;
import com.tridiumx.accessDriver.BIAlarmSourceController;
import com.tridiumx.accessDriver.BIIntrusionStatusInterest;
import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import com.tridiumx.entsec.intrusion.BIntrusionRecord;
import com.tridiumx.entsec.intrusion.BIntrusionService;
import com.tridiumx.entsec.intrusion.BRemoteIntrusionResult;
import com.tridiumx.entsec.intrusion.BRemoteIntrusionSync;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.entsec.intrusion.fox.BIntrusionGroupExt;
import com.tridiumx.entsec.intrusion.orion.BMappedIntrusionZoneExt;
import com.tridiumx.entsec.orionTools.MergeSupport;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.alarm.AlarmDbConnection;
import javax.baja.alarm.BAckState;
import javax.baja.alarm.BAlarmClass;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmService;
import javax.baja.alarm.BSourceState;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.alarm.ext.fault.BStatusFaultAlgorithm;
import javax.baja.alarm.ext.offnormal.BBooleanChangeOfStateAlgorithm;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BIPointFolder;
import javax.baja.driver.point.BProxyExt;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

public class BIntrusionZone
extends BAlarmClass
implements BIAlarmSourceController {
    public static final Property zoneEnabled = BIntrusionZone.newProperty((int)1, (BValue)new BStatusBoolean(), null);
    public static final Property zoneSchedule = BIntrusionZone.newProperty((int)0, (BValue)new BStatusBoolean(false, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartScheduleLinkFE"));
    public static final Property zoneInput = BIntrusionZone.newProperty((int)0, (BValue)new BStatusBoolean(false, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:PointLinkChooserFE"));
    public static final Property zoneStatus = BIntrusionZone.newProperty((int)9, (BValue)BIntrusionStatusEnum.disarmed, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:ToStringFE"));
    public static final Property armingTestStatus = BIntrusionZone.newProperty((int)2049, (BValue)new BStatusBoolean(true), (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)IntrusionUtil.text("success")), (BFacets)BFacets.make((String)"falseText", (String)IntrusionUtil.text("failure"))));
    public static final Property timeDelay = BIntrusionZone.newProperty((int)8, (BValue)BRelTime.makeSeconds((int)20), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT));
    public static final Property warningTime = BIntrusionZone.newProperty((int)8, (BValue)BRelTime.makeSeconds((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.DEFAULT));
    public static final Property countDown = BIntrusionZone.newProperty((int)2049, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:ToStringFE"), (BFacets)BFacets.make((String)"showMilliseconds", (boolean)false)));
    public static final Property lastActivity = BIntrusionZone.newProperty((int)2049, (BValue)BAbsTime.DEFAULT, null);
    public static final Property remoteStations = BIntrusionZone.newProperty((int)2053, (String)"", null);
    public static final Action armZone = BIntrusionZone.newAction((int)16, null);
    public static final Action forceArmZone = BIntrusionZone.newAction((int)16, null);
    public static final Action forceArmZoneWithTimeDelay = BIntrusionZone.newAction((int)16, null);
    public static final Action disarmZone = BIntrusionZone.newAction((int)16, null);
    public static final Action armingTest = BIntrusionZone.newAction((int)16, null);
    public static final Action toggleZoneEnabled = BIntrusionZone.newAction((int)16, (BValue)new BAuthorization(), null);
    public static final Action arm = BIntrusionZone.newAction((int)4, (BValue)new BIntrusionRecord(), null);
    public static final Action disarm = BIntrusionZone.newAction((int)4, (BValue)new BIntrusionRecord(), null);
    public static final Action delayRouteAlarm = BIntrusionZone.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Action allowingTimeForDisarm = BIntrusionZone.newAction((int)20, (BValue)new BAlarmRecord(), null);
    public static final Action updateCountDown = BIntrusionZone.newAction((int)4, null);
    public static final Action rearm = BIntrusionZone.newAction((int)4, (BValue)new BIntrusionRecord(), null);
    public static final Action sync = BIntrusionZone.newAction((int)20, null);
    public static final Action zoneRenamed = BIntrusionZone.newAction((int)20, (BValue)BString.DEFAULT, null);
    public static final Action changeUuid = BIntrusionZone.newAction((int)20, (BValue)BUuid.DEFAULT, null);
    public static final Action renameZone = BIntrusionZone.newAction((int)20, (BValue)BString.DEFAULT, null);
    public static final Action extRemoved = BIntrusionZone.newAction((int)20, (BValue)new BIntrusionGroupExt(), null);
    public static final Topic zoneDisarmed = BIntrusionZone.newTopic((int)0, null);
    public static final Topic zoneStatusChange = BIntrusionZone.newTopic((int)0, null);
    public static final Topic displayUpdate = BIntrusionZone.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BIntrusionZone.class);
    public static final BIcon ICON = BIcon.make((String)"module://entsec/rc/intrusion/intrusionZone.png");
    private boolean activeInput = false;
    private Clock.Ticket armTicket;
    private HashMap tickets = new HashMap();
    private HashMap sources = new HashMap();
    private Clock.Ticket countDownTicket;
    private BAbsTime countDownFinish = BAbsTime.now();
    public static final Logger log = Logger.getLogger(TYPE.getModule().getModuleName());
    public static final Lexicon lex = Lexicon.make(BIntrusionZone.class);
    public static final char SEPARATOR = '\n';
    public static final String ROWS = "rows";
    public static final String ALWAYS_ARMED = "alwaysArmed";
    public static final String ENTRY = "entry";
    public static final String FORCE_ARM_TEXT = IntrusionUtil.text("forceArm");
    public static final String NOTHING_TO_ARM_TEXT = IntrusionUtil.text("nothingToArm");

    public BStatusBoolean getZoneEnabled() {
        return (BStatusBoolean)this.get(zoneEnabled);
    }

    public void setZoneEnabled(BStatusBoolean v) {
        this.set(zoneEnabled, (BValue)v, null);
    }

    public BStatusBoolean getZoneSchedule() {
        return (BStatusBoolean)this.get(zoneSchedule);
    }

    public void setZoneSchedule(BStatusBoolean v) {
        this.set(zoneSchedule, (BValue)v, null);
    }

    public BStatusBoolean getZoneInput() {
        return (BStatusBoolean)this.get(zoneInput);
    }

    public void setZoneInput(BStatusBoolean v) {
        this.set(zoneInput, (BValue)v, null);
    }

    public BIntrusionStatusEnum getZoneStatus() {
        return (BIntrusionStatusEnum)this.get(zoneStatus);
    }

    public void setZoneStatus(BIntrusionStatusEnum v) {
        this.set(zoneStatus, (BValue)v, null);
    }

    public BStatusBoolean getArmingTestStatus() {
        return (BStatusBoolean)this.get(armingTestStatus);
    }

    public void setArmingTestStatus(BStatusBoolean v) {
        this.set(armingTestStatus, (BValue)v, null);
    }

    public BRelTime getTimeDelay() {
        return (BRelTime)this.get(timeDelay);
    }

    public void setTimeDelay(BRelTime v) {
        this.set(timeDelay, (BValue)v, null);
    }

    public BRelTime getWarningTime() {
        return (BRelTime)this.get(warningTime);
    }

    public void setWarningTime(BRelTime v) {
        this.set(warningTime, (BValue)v, null);
    }

    public BRelTime getCountDown() {
        return (BRelTime)this.get(countDown);
    }

    public void setCountDown(BRelTime v) {
        this.set(countDown, (BValue)v, null);
    }

    public BAbsTime getLastActivity() {
        return (BAbsTime)this.get(lastActivity);
    }

    public void setLastActivity(BAbsTime v) {
        this.set(lastActivity, (BValue)v, null);
    }

    public String getRemoteStations() {
        return this.getString(remoteStations);
    }

    public void setRemoteStations(String v) {
        this.setString(remoteStations, v, null);
    }

    public BString armZone() {
        return (BString)this.invoke(armZone, null, null);
    }

    public BString forceArmZone() {
        return (BString)this.invoke(forceArmZone, null, null);
    }

    public BString forceArmZoneWithTimeDelay() {
        return (BString)this.invoke(forceArmZoneWithTimeDelay, null, null);
    }

    public BString disarmZone() {
        return (BString)this.invoke(disarmZone, null, null);
    }

    public BString armingTest() {
        return (BString)this.invoke(armingTest, null, null);
    }

    public void toggleZoneEnabled(BAuthorization event) {
        this.invoke(toggleZoneEnabled, (BValue)event, null);
    }

    public void arm(BIntrusionRecord event) {
        this.invoke(arm, (BValue)event, null);
    }

    public void disarm(BIntrusionRecord event) {
        this.invoke(disarm, (BValue)event, null);
    }

    public void delayRouteAlarm(BAlarmRecord event) {
        this.invoke(delayRouteAlarm, (BValue)event, null);
    }

    public void allowingTimeForDisarm(BAlarmRecord event) {
        this.invoke(allowingTimeForDisarm, (BValue)event, null);
    }

    public void updateCountDown() {
        this.invoke(updateCountDown, null, null);
    }

    public void rearm(BIntrusionRecord event) {
        this.invoke(rearm, (BValue)event, null);
    }

    public void sync() {
        this.invoke(sync, null, null);
    }

    public void zoneRenamed(BString event) {
        this.invoke(zoneRenamed, (BValue)event, null);
    }

    public void changeUuid(BUuid event) {
        this.invoke(changeUuid, (BValue)event, null);
    }

    public void renameZone(BString event) {
        this.invoke(renameZone, (BValue)event, null);
    }

    public void extRemoved(BIntrusionGroupExt event) {
        this.invoke(extRemoved, (BValue)event, null);
    }

    public void fireZoneDisarmed(BValue event) {
        this.fire(zoneDisarmed, event, null);
    }

    public void fireZoneStatusChange(BIntrusionStatusEnum event) {
        this.fire(zoneStatusChange, (BValue)event, null);
    }

    public void fireDisplayUpdate(BIntrusionRecord event) {
        this.fire(displayUpdate, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BIntrusionService getIntrusionService() {
        BIntrusionService service = (BIntrusionService)Sys.getService((Type)BIntrusionService.TYPE);
        service.getLicenseFeature().check();
        return service;
    }

    public final void started() {
        super.started();
        this.matchEnterpriseLevelProperties();
        this.killCountDown();
        if (Sys.atSteadyState()) {
            this.sync();
        }
    }

    public void atSteadyState() {
        this.sync();
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action.equals(routeAlarm)) {
            return super.post(action, arg, cx);
        }
        BIntrusionService service = this.getIntrusionService();
        service.getIntrusionWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning() || cx == Context.decoding) {
            return;
        }
        super.changed(p, cx);
        if (!Sys.isStationStarted() && (p.equals(zoneSchedule) || p.equals(zoneInput))) {
            log.warning("station is not started");
            return;
        }
        if (p.equals(zoneEnabled)) {
            this.matchEnterpriseLevelProperties();
            this.setLastActivity(BAbsTime.now());
        } else if (p.equals(zoneStatus)) {
            this.statusOutput();
            this.fireZoneStatusChange(this.getZoneStatus());
            if (this.getZoneStatus() == BIntrusionStatusEnum.disarmed) {
                this.fireZoneDisarmed(null);
            }
        } else if (p.equals(zoneSchedule)) {
            if (this.getZoneSchedule().getStatus().isValid()) {
                BIntrusionRecord record = this.getIntrusionRecord(p);
                if (this.getZoneSchedule().getValue()) {
                    this.forceArmWithDelay(record);
                } else {
                    this.disarm(record);
                }
            }
        } else if (p.equals(zoneInput)) {
            boolean newActiveInput;
            if (this.getZoneInput().getStatus().isValid() && (newActiveInput = this.getZoneInput().getValue()) != this.activeInput) {
                this.activeInput = newActiveInput;
                if (this.activeInput) {
                    BIntrusionRecord record = this.getIntrusionRecord(p);
                    this.toggle(record);
                }
            }
        } else if (p.equals(warningTime) || p.equals(timeDelay)) {
            this.setLastActivity(BAbsTime.now());
            this.sync();
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (oldValue instanceof BIntrusionGroupExt) {
            this.extRemoved((BIntrusionGroupExt)oldValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExtRemoved(BIntrusionGroupExt ext) {
        String interest = "IntrusionZone.ExtRemoved." + BUuid.make().toString();
        BFoxSession foxSession = null;
        try {
            foxSession = RemoteUtil.getFoxSession((BNiagaraStation)ext.getStation());
            foxSession.engageNoRetry(interest);
            BIntrusionZone remoteIntrusionZone = (BIntrusionZone)RemoteUtil.getRemoteComponent(foxSession, this.getSlotPath().toString());
            if (remoteIntrusionZone != null) {
                remoteIntrusionZone.lease(2);
                BIntrusionGroupExt[] remoteExts = (BIntrusionGroupExt[])remoteIntrusionZone.getChildren(BIntrusionGroupExt.class);
                for (int i = 0; i < remoteExts.length; ++i) {
                    if (!remoteExts[i].getRemoteStation().equals(Sys.getStation().getStationName())) continue;
                    remoteIntrusionZone.remove(remoteExts[i].getName());
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (foxSession != null) {
                foxSession.disengage(interest);
            }
        }
    }

    public void purge() {
        BRemoteIntrusionSync sync = new BRemoteIntrusionSync();
        sync.setCommand("purge");
        BMappedIntrusionZoneExt ext = (BMappedIntrusionZoneExt)this.getMixIn(BMappedIntrusionZoneExt.TYPE);
        sync.setUuid(ext.getUuid());
        log.fine("purging: " + ext.getUuid());
        BRemoteIntrusionSync result = this.doRemoteSync(sync);
    }

    public void doZoneRenamed(BString oldName) {
        IntrusionUtil.renameAlarmClass(oldName.toString(), this.getName());
        this.setLastActivity(BAbsTime.now());
        this.sync();
    }

    public void doRenameZone(BString newName) {
        log.fine("renaming non grouped zone from supervisor: " + newName);
        if (newName.toString().equals("")) {
            return;
        }
        this.getParent().asComponent().rename(this.getPropertyInParent(), newName.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doChangeUuid(BUuid uuid) {
        BIntrusionService service = this.getIntrusionService();
        OrionSession session = null;
        try {
            session = service.createSession(null);
            MergeSupport.changeUuidForComponent(uuid, (BComponent)this, session);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void doSync(Context cx) {
        String name = this.getDisplayName(null);
        if (name == null) {
            BMappedIntrusionZoneExt ext = (BMappedIntrusionZoneExt)this.getMixIn(BMappedIntrusionZoneExt.TYPE);
            name = ext.getUuid().toString();
        }
        log.fine("sync sequence started: " + name);
        BRemoteIntrusionSync sync = new BRemoteIntrusionSync();
        sync.setWarningTime(this.getWarningTime());
        sync.setTimeDelay(this.getTimeDelay());
        sync.setLastActivity(this.getLastActivity());
        sync.setLastActivityStation(Sys.getStation().getStationName());
        sync.setLastActivityZoneEnabled(this.getZoneEnabled().getValue());
        sync.setCommand("findLastActivity");
        BMappedIntrusionZoneExt ext = (BMappedIntrusionZoneExt)this.getMixIn(BMappedIntrusionZoneExt.TYPE);
        sync.setUuid(ext.getUuid());
        sync.getRecord().initFromContext(cx);
        if (this.isRunning()) {
            sync.getRecord().setIntrusionZone(name);
        }
        BRemoteIntrusionSync result = this.doRemoteSync(sync);
        result.setCommand("syncing");
        result.setTestedStations("");
        log.fine("sync found master: " + name + ": " + result.getLastActivityStation());
        result = this.doRemoteSync(result);
        log.fine("sync complete: " + name + ": " + result.getLastActivityStation());
        String tested = result.getTestedStations();
        this.setRemoteStations(tested.substring(1));
    }

    public BRemoteIntrusionSync doRemoteSync(BRemoteIntrusionSync result) {
        BIntrusionGroupExt[] groups;
        block11: {
            String name;
            block12: {
                boolean masterZoneEnabled;
                block10: {
                    name = this.getDisplayName(null);
                    if (name == null) {
                        BMappedIntrusionZoneExt ext = (BMappedIntrusionZoneExt)this.getMixIn(BMappedIntrusionZoneExt.TYPE);
                        name = ext.getUuid().toString();
                    }
                    log.fine("remote Sync:" + name + ": " + result.getCommand());
                    if (!result.getCommand().equals("findLastActivity")) break block10;
                    if (!this.getLastActivity().isAfter(result.getLastActivity())) break block11;
                    log.fine("remote Sync: most recent activity found: " + name + ": " + this.getLastActivity());
                    result.setWarningTime(this.getWarningTime());
                    result.setTimeDelay(this.getTimeDelay());
                    result.setLastActivity(this.getLastActivity());
                    result.setLastActivityStation(Sys.getStation().getStationName());
                    result.setLastActivityZoneEnabled(this.getZoneEnabled().getValue());
                    if (!this.isRunning()) break block11;
                    result.getRecord().setIntrusionZone(name);
                    break block11;
                }
                if (!result.getCommand().equals("syncing")) break block12;
                if (result.getLastActivityStation().equals(Sys.getStation().getStationName())) break block11;
                log.fine("remote Sync: syncing from master: " + name + ": " + result.getLastActivityStation());
                if (!this.getWarningTime().equals((Object)result.getWarningTime())) {
                    this.setWarningTime(result.getWarningTime());
                }
                if (!this.getTimeDelay().equals((Object)result.getTimeDelay())) {
                    this.setTimeDelay(result.getTimeDelay());
                }
                if (this.isRunning() && !name.equals(result.getRecord().getIntrusionZone())) {
                    this.getParent().asComponent().rename(this.getPropertyInParent(), SlotPath.escape((String)result.getRecord().getIntrusionZone()));
                    log.fine("remote Sync: renaming from master: " + name + " to " + result.getRecord().getIntrusionZone());
                }
                if ((masterZoneEnabled = result.getLastActivityZoneEnabled()) == this.getZoneEnabled().getValue()) break block11;
                BIntrusionRecord record = this.getIntrusionRecord(result);
                if (masterZoneEnabled) {
                    this.arm(record);
                    log.fine("remote Sync: " + name + ": force arming to sync");
                } else {
                    log.fine("remote Sync: " + name + ": disarming to sync");
                    this.disarm(record);
                }
                break block11;
            }
            if (result.getCommand().equals("purge")) {
                log.fine("remote Sync: " + name + ": purging");
                if (this.isRunning()) {
                    this.getParent().asComponent().remove(this.getPropertyInParent());
                }
                groups = this.getValidGroups();
                for (int i = 0; i < groups.length; ++i) {
                    if (result.getTestedStations().indexOf(";" + groups[i].getRemoteStation() + ";") <= -1) continue;
                    this.remove(groups[i].getPropertyInParent());
                }
            }
        }
        result.setTestedStations(result.getTestedStations() + ";" + Sys.getStation().getStationName() + ";");
        groups = this.getValidGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (result.getTestedStations().indexOf(";" + groups[i].getRemoteStation() + ";") != -1) continue;
            result = groups[i].sync(result);
        }
        return result;
    }

    public void doToggleZoneEnabled(BAuthorization info) {
        BIntrusionRecord record = this.getIntrusionRecord(info);
        this.toggle(record);
    }

    public void toggle(BIntrusionRecord record) {
        boolean enabled = this.getZoneEnabled().getValue();
        if (!(enabled || this.getZoneStatus() != BIntrusionStatusEnum.disarmed && this.getZoneStatus() != BIntrusionStatusEnum.unableToArm)) {
            this.doArmZone(record);
        } else {
            this.doDisarmZone(record);
        }
    }

    public BString doArmZone(Context cx) {
        boolean enabled = this.getZoneEnabled().getValue();
        if (!(enabled || this.getZoneStatus() != BIntrusionStatusEnum.disarmed && this.getZoneStatus() != BIntrusionStatusEnum.unableToArm)) {
            BIntrusionRecord record = new BIntrusionRecord();
            record.initFromContext(cx);
            return BString.make((String)this.normalArm(record));
        }
        return BString.DEFAULT;
    }

    public BString doForceArmZoneWithTimeDelay(Context cx) {
        boolean enabled = this.getZoneEnabled().getValue();
        if (!(enabled || this.getZoneStatus() != BIntrusionStatusEnum.disarmed && this.getZoneStatus() != BIntrusionStatusEnum.unableToArm)) {
            BRemoteIntrusionResult result = new BRemoteIntrusionResult();
            result.getRecord().initFromContext(cx);
            result.getRecord().setIntrusionZone(this.getName());
            result.getRecord().setDetails(FORCE_ARM_TEXT);
            result = this.doRemoteArmingSequence(result);
            return BString.make((String)result.getRecord().getDetails());
        }
        return BString.DEFAULT;
    }

    private String normalArm(BIntrusionRecord record) {
        String details = this.doArmingTest(null).toString();
        if (details.length() > 0) {
            BIntrusionService service = this.getIntrusionService();
            this.set(zoneStatus, (BValue)BIntrusionStatusEnum.unableToArm);
            record.setIntrusionZone(this.getName());
            record.setTimestamp(BAbsTime.now());
            record.setStatus(BIntrusionStatusEnum.unableToArm);
            record.setDetails(details);
            this.setTimer(this.getTimeDelay(), disarm, record.newCopy());
            this.recordEvent(record);
            return details;
        }
        BRemoteIntrusionResult result = new BRemoteIntrusionResult();
        result.setRecord(record);
        result = this.doRemoteArmingSequence(result);
        return result.getRecord().getDetails();
    }

    public BRemoteIntrusionResult doRemoteArmingSequence(BRemoteIntrusionResult result) {
        result.setTestedStations(result.getTestedStations() + ";" + Sys.getStation().getStationName() + ";");
        this.forceArmWithDelay(result.getRecord());
        BIntrusionGroupExt[] groups = this.getValidGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (result.getTestedStations().indexOf(";" + groups[i].getRemoteStation() + ";") != -1) continue;
            result = groups[i].armingSequence(result);
        }
        return result;
    }

    private void forceArmWithDelay(BIntrusionRecord record) {
        if (this.getTimeDelay().equals((Object)BRelTime.DEFAULT)) {
            this.arm(record);
        } else {
            BIntrusionService service = this.getIntrusionService();
            record.setIntrusionZone(this.getName());
            record.setTimestamp(BAbsTime.now());
            record.setStatus(BIntrusionStatusEnum.arming);
            this.set(zoneStatus, (BValue)BIntrusionStatusEnum.arming);
            this.armTicket = this.setTimer(this.getTimeDelay(), arm, (BValue)record);
            this.recordEvent(record);
        }
    }

    public BString doForceArmZone(Context cx) {
        BRemoteIntrusionResult result = new BRemoteIntrusionResult();
        result.getRecord().initFromContext(cx);
        result.getRecord().setIntrusionZone(this.getName());
        result.getRecord().setDetails(FORCE_ARM_TEXT);
        result = this.doRemoteForceArm(result);
        return BString.make((String)result.getRecord().getDetails());
    }

    public BRemoteIntrusionResult doRemoteForceArm(BRemoteIntrusionResult result) {
        result.setTestedStations(result.getTestedStations() + ";" + Sys.getStation().getStationName() + ";");
        BIntrusionGroupExt[] groups = this.getValidGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (result.getTestedStations().indexOf(";" + groups[i].getRemoteStation() + ";") != -1) continue;
            result = groups[i].forceArm(result);
        }
        this.doArm(result.getRecord());
        return result;
    }

    public void doArm(BIntrusionRecord record) {
        if (this.armTicket != null) {
            this.armTicket.cancel();
            this.armTicket = null;
        }
        this.killCountDown();
        BIntrusionService service = this.getIntrusionService();
        record.setIntrusionZone(this.getName());
        record.setTimestamp(BAbsTime.now());
        record.setStatus(BIntrusionStatusEnum.armed);
        this.set(zoneStatus, (BValue)BIntrusionStatusEnum.armed);
        this.set(zoneEnabled, (BValue)new BStatusBoolean(true));
        this.recordEvent(record);
    }

    public BString doDisarmZone(Context cx) {
        BRemoteIntrusionResult result = new BRemoteIntrusionResult();
        result.getRecord().initFromContext(cx);
        result.getRecord().setIntrusionZone(this.getName());
        result = this.doRemoteDisarm(result);
        return BString.make((String)result.getRecord().getDetails());
    }

    public BRemoteIntrusionResult doRemoteDisarm(BRemoteIntrusionResult result) {
        result.setTestedStations(result.getTestedStations() + ";" + Sys.getStation().getStationName() + ";");
        BIntrusionGroupExt[] groups = this.getValidGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (result.getTestedStations().indexOf(";" + groups[i].getRemoteStation() + ";") != -1) continue;
            result = groups[i].disarm(result);
        }
        this.doDisarm(result.getRecord());
        return result;
    }

    public void doDisarm(BIntrusionRecord record) {
        if (this.armTicket != null) {
            this.armTicket.cancel();
            this.armTicket = null;
        }
        this.killCountDown();
        BIntrusionService service = this.getIntrusionService();
        record.setIntrusionZone(this.getName());
        record.setTimestamp(BAbsTime.now());
        record.setStatus(BIntrusionStatusEnum.disarmed);
        this.set(zoneStatus, (BValue)BIntrusionStatusEnum.disarmed);
        this.set(zoneEnabled, (BValue)new BStatusBoolean(false));
        this.disableAlarmCountToRelays();
        this.recordEvent(record);
    }

    private void disableAlarmCountToRelays() {
        Array knobArray = new Array(Knob.class);
        knobArray.addAll((Object[])this.getKnobs((Slot)totalAlarmCount));
        knobArray.addAll((Object[])this.getKnobs((Slot)openAlarmCount));
        knobArray.addAll((Object[])this.getKnobs((Slot)inAlarmCount));
        knobArray.addAll((Object[])this.getKnobs((Slot)unackedAlarmCount));
        for (int i = 0; i < knobArray.size(); ++i) {
            Knob knob = (Knob)knobArray.get(i);
            BComponent target = knob.getTargetComponent();
            if (target == null || !target.getType().is(BAlarmCountToRelay.TYPE)) continue;
            BAlarmCountToRelay alarmCountToRelay = (BAlarmCountToRelay)target;
            alarmCountToRelay.relayOutStop();
        }
    }

    public void doAllowingTimeForDisarm(BAlarmRecord alarm) {
        BRemoteIntrusionResult result = new BRemoteIntrusionResult();
        result.setRecord(this.getIntrusionRecord(alarm, BIntrusionStatusEnum.allowingTimeForDisarm));
        result = this.doRemoteAllowingTimeForDisarm(result);
    }

    public BRemoteIntrusionResult doRemoteAllowingTimeForDisarm(BRemoteIntrusionResult result) {
        this.set(zoneStatus, (BValue)BIntrusionStatusEnum.allowingTimeForDisarm);
        this.recordEvent(result.getRecord());
        if (result.getTestedStations().length() > 0) {
            this.armTicket = this.setTimer(this.getTimeDelay(), rearm, (BValue)result.getRecord());
        }
        result.setTestedStations(result.getTestedStations() + ";" + Sys.getStation().getStationName() + ";");
        BIntrusionGroupExt[] groups = this.getValidGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (result.getTestedStations().indexOf(";" + groups[i].getRemoteStation() + ";") != -1) continue;
            result = groups[i].allowingTimeForDisarm(result);
        }
        return result;
    }

    public void doRearm(BIntrusionRecord record) {
        if (this.armTicket != null) {
            this.armTicket.cancel();
            this.armTicket = null;
        }
        this.set(zoneStatus, (BValue)BIntrusionStatusEnum.armed);
        record.setStatus(BIntrusionStatusEnum.armed);
        this.recordEvent(record);
    }

    public void doRouteAlarm(BAlarmRecord alarm) {
        if (this.getTimeDelay() == BRelTime.DEFAULT || alarm.getSource().size() > 1) {
            super.doRouteAlarm(alarm);
            return;
        }
        boolean escalated = false;
        BString escalatedLevel = (BString)alarm.getAlarmData().get("escalated");
        boolean bl = escalated = escalatedLevel != null && escalatedLevel.toString().length() > 0;
        if (alarm.getAckState() == BAckState.acked || alarm.getSourceState() == BSourceState.normal || escalated) {
            try {
                BAlarmService as = this.getAlarmService();
                try (AlarmDbConnection conn = as.getAlarmDb().getDbConnection(null);){
                    if (conn.getRecord(alarm.getUuid()) != null) {
                        super.doRouteAlarm(alarm);
                        return;
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (alarm.getAckState() == BAckState.acked && this.getZoneEnabled().getValue()) {
                this.set(zoneStatus, (BValue)BIntrusionStatusEnum.armed);
            }
        }
        if (alarm.getAckState() == BAckState.unacked) {
            if (alarm.getAlarmData().get(ENTRY) == null) {
                super.doRouteAlarm(alarm);
                return;
            }
            if (this.getZoneEnabled().getValue() && alarm.getSourceState() != BSourceState.normal && this.getZoneStatus() != BIntrusionStatusEnum.allowingTimeForDisarm) {
                this.allowingTimeForDisarm(alarm);
            }
            if (this.tickets.get(this.getHashName(alarm)) == null) {
                Clock.Ticket ticket = this.setTimer(this.getTimeDelay(), delayRouteAlarm, (BValue)alarm);
                this.tickets.put(this.getHashName(alarm), ticket);
                if (alarm.getSourceState() == BSourceState.normal) {
                    this.sources.put(this.getSourceHashName(alarm), ticket);
                }
            }
        }
    }

    public void doDelayRouteAlarm(BAlarmRecord record) {
        this.tickets.remove(this.getHashName(record));
        this.sources.remove(this.getOffnormalSourceHashName(record));
        String normalHashName = this.getNormalSourceHashName(record);
        Clock.Ticket normalTicket = (Clock.Ticket)this.sources.remove(normalHashName);
        if (normalTicket != null && !normalTicket.isExpired()) {
            BAlarmRecord normalRecord = (BAlarmRecord)normalTicket.getActionArgument();
            normalTicket.cancel();
            normalTicket = (Clock.Ticket)this.tickets.remove(this.getHashName(normalRecord));
            if (normalTicket != null) {
                this.killCountDown();
                normalTicket.cancel();
                normalTicket = null;
                record.setSourceState(BSourceState.normal);
            }
        }
        if (this.getZoneEnabled().getBoolean()) {
            this.set(zoneStatus, (BValue)BIntrusionStatusEnum.armed);
            BIntrusionRecord intrusionRecord = this.getIntrusionRecord(record, BIntrusionStatusEnum.armed);
            if (intrusionRecord.getStatus() == BIntrusionStatusEnum.armed) {
                intrusionRecord.setDetails(IntrusionUtil.text("entryTimeExpired"));
            }
            this.recordEvent(intrusionRecord);
            if (record.getSourceState() == BSourceState.normal) {
                record.setSourceState(BSourceState.offnormal);
                super.doRouteAlarm(record);
                record.setSourceState(BSourceState.normal);
            }
            super.doRouteAlarm(record);
        } else if (record.getAlarmData().get(ALWAYS_ARMED) != null) {
            if (record.getSourceState() == BSourceState.normal) {
                record.setSourceState(BSourceState.offnormal);
                super.doRouteAlarm(record);
                record.setSourceState(BSourceState.normal);
            }
            super.doRouteAlarm(record);
        } else {
            BAlarmService alarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
            try {
                alarmService.doAckAlarm(record);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public BIntrusionGroupExt[] getValidGroups() {
        BIntrusionGroupExt[] groups = (BIntrusionGroupExt[])this.getChildren(BIntrusionGroupExt.class);
        Array a = new Array(BIntrusionGroupExt.class);
        for (int i = 0; i < groups.length; ++i) {
            if (groups[i].isValid()) {
                a.add((Object)groups[i]);
                continue;
            }
            this.remove(groups[i].getName());
        }
        return (BIntrusionGroupExt[])a.trim();
    }

    public BString doArmingTest(Context cx) {
        this.getIntrusionService();
        BRemoteIntrusionResult result = new BRemoteIntrusionResult();
        result.getRecord().initFromContext(cx);
        result.getRecord().setIntrusionZone(this.getName());
        result = this.doRemoteArmingTest(result);
        this.getArmingTestStatus().setValue(result.getRecord().getDetails().length() == 0);
        return BString.make((String)result.getRecord().getDetails());
    }

    public BRemoteIntrusionResult doRemoteArmingTest(BRemoteIntrusionResult result) {
        BIntrusionGroupExt[] groups = this.getValidGroups();
        String details = this.doLocalArmingTest().toString();
        if (details.equals(NOTHING_TO_ARM_TEXT) && (groups.length > 0 || !RemoteUtil.isSupervisor() || result.getTestedStations().length() > 0)) {
            details = "";
        }
        result.setTestedStations(result.getTestedStations() + ";" + Sys.getStation().getStationName() + ";");
        result.getRecord().setDetails(result.getRecord().getDetails() + details);
        for (int i = 0; i < groups.length; ++i) {
            if (result.getTestedStations().indexOf(";" + groups[i].getRemoteStation() + ";") != -1) continue;
            result = groups[i].armingTest(result);
        }
        return result;
    }

    public BString doLocalArmingTest() {
        String details = "";
        BAlarmSourceExt[] exts = IntrusionUtil.getAlarmSourceExtUsage(this.getName());
        if (exts.length == 0) {
            return BString.make((String)NOTHING_TO_ARM_TEXT);
        }
        for (int i = 0; i < exts.length; ++i) {
            BStatusFaultAlgorithm algorithm;
            BAlarmSourceExt ext = exts[i];
            if (ext.getMetaData().getb(ENTRY, false)) continue;
            BBooleanPoint bPoint = (BBooleanPoint)ext.getParent();
            boolean problem = false;
            if (ext.getAlarmEnable().isToFault() && ext.getFaultAlgorithm().getType().equals(BStatusFaultAlgorithm.TYPE)) {
                algorithm = (BStatusFaultAlgorithm)ext.getFaultAlgorithm();
                if ((bPoint.getOut().getStatus().getBits() & algorithm.getFaultValues().getBits()) != 0) {
                    problem = true;
                }
            }
            if (ext.getAlarmEnable().isToOffnormal() && ext.getOffnormalAlgorithm().getType().equals(BBooleanChangeOfStateAlgorithm.TYPE) && (algorithm = (BBooleanChangeOfStateAlgorithm)ext.getOffnormalAlgorithm()).getAlarmValue() == bPoint.getOut().getBoolean()) {
                problem = true;
            }
            if (!problem) continue;
            if (details.length() > 0) {
                details = details + "; ";
            }
            details = details + Sys.getStation().getStationName() + ".";
            details = details + ext.getSourceName().format((Object)ext);
            String offnormal = ext.getToOffnormalText().format((Object)ext);
            String fault = ext.getToFaultText().format((Object)ext);
            if (offnormal.length() > 0) {
                details = details + "." + offnormal;
                continue;
            }
            if (fault.length() <= 0) continue;
            details = details + "." + fault;
        }
        return BString.make((String)details);
    }

    private Clock.Ticket setTimer(BRelTime time, Action action, BValue arg) {
        BAbsTime now = BAbsTime.now();
        if (this.countDownFinish.compareTo((Object)now) < 0) {
            this.killCountDown();
            this.setCountDown(time);
            this.countDownFinish = now.add(time);
            this.countDownTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)1), (Action)updateCountDown, null);
        }
        if (action != null) {
            return Clock.schedule((BComponent)this, (BRelTime)time, (Action)action, (BValue)arg);
        }
        return null;
    }

    private void killCountDown() {
        if (this.countDownTicket != null) {
            this.countDownTicket.cancel();
            this.countDownTicket = null;
        }
        this.countDownFinish = BAbsTime.now();
        this.setCountDown(BRelTime.DEFAULT);
    }

    public void doUpdateCountDown() {
        BRelTime time = BAbsTime.now().delta(this.countDownFinish);
        this.setCountDown(time);
        if (time.compareTo((Object)BRelTime.DEFAULT) <= 0) {
            this.killCountDown();
        }
    }

    public BIntrusionRecord getIntrusionRecord(Property property) {
        BIntrusionRecord record = new BIntrusionRecord();
        record.setTimestamp(BAbsTime.now());
        record.setIntrusionZone(this.getName());
        BLink[] links = this.getLinks((Slot)property);
        if (links.length > 0) {
            BComponent component = links[0].getSourceComponent();
            if (component != null && component instanceof BBooleanSchedule) {
                record.setAuthority(IntrusionUtil.text("scheduleAuthorization", new Object[]{component.getDisplayName(null)}));
            } else if (component != null && component instanceof BBooleanPoint) {
                record.setAuthority(IntrusionUtil.text("inputAuthorization", new Object[]{component.getDisplayName(null)}));
                if (((BBooleanPoint)component).getProxyExt() instanceof BProxyExt && ((BBooleanPoint)component).getProxyExt().isRunning()) {
                    record.setLocation(((BProxyExt)((BBooleanPoint)component).getProxyExt()).getDevice().getDisplayName(null));
                }
            }
        }
        return record;
    }

    public BIntrusionRecord getIntrusionRecord(BAuthorization info) {
        BIntrusionRecord record = new BIntrusionRecord();
        BComponent c = IntrusionUtil.getComponent(info.getSourceHandle());
        if (c != null && c instanceof BIPointFolder) {
            BIPointFolder pointFolder = (BIPointFolder)c;
            record.setLocation(pointFolder.getDevice().getDisplayName(null) + "." + c.getDisplayName(null));
        }
        record.setTimestamp(BAbsTime.now());
        record.setIntrusionZone(this.getName());
        record.setAuthority(info.getAuthorization());
        return record;
    }

    public BIntrusionRecord getIntrusionRecord(BRemoteIntrusionSync sync) {
        BIntrusionRecord record = sync.getRecord();
        record.setTimestamp(BAbsTime.now());
        record.setIntrusionZone(this.getName());
        record.setDetails("Synced from: " + sync.getLastActivityStation());
        return record;
    }

    public BIntrusionRecord getIntrusionRecord(BAlarmRecord alarmRecord, BIntrusionStatusEnum status) {
        BAlarmSourceExt ext = (BAlarmSourceExt)alarmRecord.getSource().get(0).get();
        BControlPoint parent = (BControlPoint)ext.getParent();
        String location = ((BProxyExt)parent.getProxyExt()).getDevice().getDisplayName(null);
        location = location + "." + parent.getDisplayName(null);
        BIntrusionRecord record = new BIntrusionRecord();
        record.setTimestamp(BAbsTime.now());
        record.setIntrusionZone(this.getName());
        record.setStatus(status);
        record.setAuthority(IntrusionUtil.text("alarmAuthorization", new Object[]{IntrusionUtil.getAlarmDescription(ext)}));
        record.setLocation(location);
        return record;
    }

    private void recordEvent(BIntrusionRecord record) {
        record = (BIntrusionRecord)record.newCopy();
        BIntrusionService service = this.getIntrusionService();
        record.setIntrusionZone(this.getDisplayName(null));
        service.appendIntrusionHistory(record);
        this.fireDisplayUpdate(record);
    }

    private String getHashName(BAlarmRecord alarm) {
        return alarm.getUuid().toString();
    }

    private String getNormalSourceHashName(BAlarmRecord alarm) {
        return alarm.getSource().toString() + BSourceState.normal.getOrdinal();
    }

    private String getOffnormalSourceHashName(BAlarmRecord alarm) {
        return alarm.getSource().toString() + BSourceState.offnormal.getOrdinal();
    }

    private String getSourceHashName(BAlarmRecord alarm) {
        return alarm.getSource().toString() + alarm.getSourceState().getOrdinal();
    }

    public void statusOutput() {
        BLink[] links = this.getLinks((Slot)toggleZoneEnabled);
        for (int i = 0; i < links.length; ++i) {
            BComponent c = links[i].getSourceComponent();
            if (c == null || !(c instanceof BIIntrusionStatusInterest)) continue;
            BIIntrusionStatusInterest interest = (BIIntrusionStatusInterest)c;
            interest.changeStatus(this.getZoneStatus(), this.getWarningTime(), this.getTimeDelay());
        }
    }

    public void matchEnterpriseLevelProperties() {
        BAlarmSourceExt[] alarmUsage = IntrusionUtil.getAlarmSourceExtUsage(this.getName());
        boolean enabled = this.getZoneEnabled().getValue();
        for (int i = 0; i < alarmUsage.length; ++i) {
            IntrusionUtil.matchZoneEnabled(alarmUsage[i], enabled);
        }
    }

    public BFacets getMetaDataDefaults() {
        return BFacets.make((String)ENTRY, (BIDataValue)BBoolean.make((boolean)false), (String)ALWAYS_ARMED, (BIDataValue)BBoolean.make((boolean)false));
    }

    public void controlAlarmInhibit(BAlarmSourceExt ext) {
        IntrusionUtil.matchZoneEnabled(ext, this.getZoneEnabled().getBoolean());
    }

    public void controlMetaDataChange(BAlarmSourceExt ext) {
        IntrusionUtil.matchZoneEnabled(ext, this.getZoneEnabled().getBoolean());
    }

    public BIcon getIcon() {
        return ICON;
    }
}

