/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.intrusion;

import com.tridiumx.accessDriver.enums.activity.BIntrusionStatusEnum;
import com.tridiumx.entsec.intrusion.IntrusionUtil;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsec.securityUtil.BIOutOfOrderHistoryRecord;
import com.tridiumx.entsec.securityUtil.BISecurityActivity;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.BHistoryRecord;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

public class BIntrusionRecord
extends BHistoryRecord
implements BISecurityActivity,
Context,
BIOutOfOrderHistoryRecord {
    private static final long serialVersionUID = 0L;
    public static final Property intrusionZone = BIntrusionRecord.newProperty((int)0, (String)"", null);
    public static final Property authority = BIntrusionRecord.newProperty((int)0, (String)"", null);
    public static final Property status = BIntrusionRecord.newProperty((int)0, (BValue)BIntrusionStatusEnum.armed, null);
    public static final Property location = BIntrusionRecord.newProperty((int)0, (String)"", null);
    public static final Property details = BIntrusionRecord.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BIntrusionRecord.class);

    public String getIntrusionZone() {
        return this.getString(intrusionZone);
    }

    public void setIntrusionZone(String v) {
        this.setString(intrusionZone, v, null);
    }

    public String getAuthority() {
        return this.getString(authority);
    }

    public void setAuthority(String v) {
        this.setString(authority, v, null);
    }

    public BIntrusionStatusEnum getStatus() {
        return (BIntrusionStatusEnum)this.get(status);
    }

    public void setStatus(BIntrusionStatusEnum v) {
        this.set(status, (BValue)v, null);
    }

    public String getLocation() {
        return this.getString(location);
    }

    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    public String getDetails() {
        return this.getString(details);
    }

    public void setDetails(String v) {
        this.setString(details, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIntrusionRecord() {
    }

    public BIntrusionRecord(String intrusionZone, String authorization, BIntrusionStatusEnum status, String location, String details) {
        this.setTimestamp(BAbsTime.now());
        this.setIntrusionZone(intrusionZone);
        this.setAuthority(authorization);
        this.setStatus(status);
        this.setLocation(location);
        this.setDetails(details);
    }

    public void initFromContext(Context cx) {
        if (cx instanceof BIntrusionRecord) {
            this.copyFrom((BComplex)((BIntrusionRecord)cx));
        } else if (cx != null && cx.getUser() != null) {
            this.setAuthority(IntrusionUtil.text("userAuthorization", new Object[]{cx.getUser()}));
        }
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput in) throws IOException {
        this.setIntrusionZone(in.readUTF());
        this.setAuthority(in.readUTF());
        this.setStatus((BIntrusionStatusEnum)BIntrusionStatusEnum.armed.decodeFromString(in.readUTF()));
        this.setLocation(in.readUTF());
        this.setDetails(in.readUTF());
    }

    protected void doWrite(DataOutput out) throws IOException {
        out.writeUTF(this.getIntrusionZone());
        out.writeUTF(this.getAuthority());
        out.writeUTF(this.getStatus().encodeToString());
        out.writeUTF(this.getLocation());
        out.writeUTF(this.getDetails());
    }

    @Override
    public BActivityRecord convertToActivity(Context cx) {
        StringBuffer desc = new StringBuffer();
        desc.append(this.getIntrusionZone());
        String detail = this.getDetails();
        if (detail.length() > 0) {
            desc.append(": ").append(detail);
        }
        return new BActivityRecord(this.getTimestamp(), (BObject)this, this.getStatus().toString(cx), this.getLocation(), this.getAuthority(), desc.toString());
    }

    @Override
    public Property getOutOfOrderStringProperty() {
        return details;
    }

    public Context getBase() {
        throw new IllegalStateException();
    }

    public BObject getFacet(String name) {
        throw new IllegalStateException();
    }

    public BFacets getFacets() {
        throw new IllegalStateException();
    }

    public String getLanguage() {
        throw new IllegalStateException();
    }

    public BUser getUser() {
        return null;
    }
}

