/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.filter;

import com.tridium.bql.filter.BStringFilter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.baja.nre.util.TextUtil;
import javax.baja.query.BExpression;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSecStringFilter
extends BStringFilter {
    public static final Type TYPE = Sys.loadType(BSecStringFilter.class);
    private static final char ONE_CHAR = '\u0000';
    protected static final char SUBSTITUTE = '\ufffd';

    public Type getType() {
        return TYPE;
    }

    public BSecStringFilter() {
    }

    public BSecStringFilter(String pattern, boolean exact, boolean include) {
        super(pattern, exact, include);
    }

    public void init(BObject o) {
    }

    public String getResolvedPattern() {
        if (this.getMatchCase()) {
            return this.getPattern();
        }
        return TextUtil.toLowerCase((String)this.getPattern());
    }

    public String[] getResolvedPatterns() {
        String resolvedPattern = this.getResolvedPattern();
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)" ||", (String)"||");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)"|| ", (String)"||");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)" &&", (String)"&&");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)"&& ", (String)"&&");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)" |!", (String)"|!(");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)"|! ", (String)"|!");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)" &!", (String)"&!");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)"&! ", (String)"&!");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)"||", (String)"\ufffd||");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)"&&", (String)"\ufffd&&");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)"|!", (String)"\ufffd|!");
        resolvedPattern = TextUtil.replace((String)resolvedPattern, (String)"&!", (String)"\ufffd&!");
        return TextUtil.split((String)resolvedPattern, (char)'\ufffd');
    }

    public String getPredicate(String columnName) {
        StringBuffer s = new StringBuffer(64);
        boolean inc = this.getInclude();
        if (!inc) {
            s.append("not (");
        }
        String[] patterns = this.getResolvedPatterns();
        for (int i = 0; i < patterns.length; ++i) {
            boolean miniInc = false;
            String content = patterns[i];
            if (i > 0) {
                String operator = content.substring(0, 2);
                content = content.substring(2);
                if (operator.equals("||")) {
                    s.append(" or ");
                } else if (operator.equals("&&")) {
                    s.append(" and ");
                } else if (operator.equals("!(")) {
                    s.append(" or not (");
                    miniInc = true;
                } else if (operator.equals("&!")) {
                    s.append(" and not (");
                    miniInc = true;
                }
            }
            s.append(this.getInnerPredicate(columnName, content));
            if (!miniInc) continue;
            s.append(')');
        }
        if (!inc) {
            s.append(')');
        }
        return s.toString();
    }

    public String getInnerPredicate(String columnName, String pattern) {
        StringBuffer s = new StringBuffer(64);
        s.append(columnName);
        if (!this.getMatchCase()) {
            s.append(".toString.toLowerCase");
        }
        s.append(this.getExact() ? " = " : " like ");
        s.append('\'').append(BSecStringFilter.escapeQuotes(pattern)).append('\'');
        return s.toString();
    }

    public BExpression getExpression(BExpression columnExpression) {
        if (!this.getMatchCase()) {
            columnExpression = Funcs.lower((BExpression)columnExpression);
        }
        ExpressionBuilder b = new ExpressionBuilder();
        String[] patterns = this.getResolvedPatterns();
        for (int i = 0; i < patterns.length; ++i) {
            String content = patterns[i];
            if (i > 0) {
                String operator = content.substring(0, 2);
                content = content.substring(2);
                if (operator.equals("||")) {
                    b.or(this.getInnerExpression(columnExpression.newExprCopy(), content));
                    continue;
                }
                if (operator.equals("&&")) {
                    b.and(this.getInnerExpression(columnExpression.newExprCopy(), content));
                    continue;
                }
                if (operator.equals("!(")) {
                    b.or(Predicates.not((BExpression)this.getInnerExpression(columnExpression.newExprCopy(), content)));
                    continue;
                }
                if (!operator.equals("&!")) continue;
                b.and(Predicates.not((BExpression)this.getInnerExpression(columnExpression.newExprCopy(), content)));
                continue;
            }
            b.or(this.getInnerExpression(columnExpression.newExprCopy(), content));
        }
        BExpression e = b.getExpression();
        if (!this.getInclude()) {
            e = Predicates.not((BExpression)e);
        }
        return e;
    }

    public BExpression getInnerExpression(BExpression columnExpression, String pattern) {
        BExpression e = this.getExact() ? Predicates.eq((BExpression)columnExpression, (BSimple)BString.make((String)pattern)) : Predicates.like((BExpression)columnExpression, (BString)BString.make((String)pattern));
        return e;
    }

    public boolean accept(BObject o) {
        String val = o.toString();
        if (!this.getMatchCase()) {
            val = val.toLowerCase();
        }
        boolean accepted = this.getExact() ? (this.getMatchCase() ? val.equals(this.getResolvedPattern()) : val.equalsIgnoreCase(this.getResolvedPattern())) : this.evaluate(val, this.getResolvedPattern());
        return this.getInclude() == accepted;
    }

    protected boolean evaluate(String left, String right) {
        String test = left.toString();
        Pattern p = new Pattern(right, this.getMatchCase());
        return p.isMatch(test);
    }

    private static String escapeQuotes(String s) {
        if (s.indexOf(39) == -1) {
            return s;
        }
        StringBuffer result = new StringBuffer(s.length() + 2);
        StringTokenizer tokens = new StringTokenizer(s, "'", true);
        while (tokens.hasMoreTokens()) {
            String t = tokens.nextToken();
            if (t.equals("'")) {
                result.append("\\'");
                continue;
            }
            result.append(t);
        }
        return result.toString();
    }

    public static class Pattern {
        private char[][] pattern;
        private boolean matchAll;
        private boolean matchCase;

        public Pattern(String patternString, boolean matchCase) {
            this.init(patternString.toCharArray(), matchCase);
        }

        private void init(char[] patternStr, boolean matchCase) {
            this.matchCase = matchCase;
            if (patternStr.length == 0) {
                this.pattern = new char[0][];
                return;
            }
            this.matchAll = true;
            for (int i = 0; i < patternStr.length; ++i) {
                if (patternStr[i] == '*' || patternStr[i] == '%') continue;
                this.matchAll = false;
                break;
            }
            if (this.matchAll) {
                return;
            }
            Vector<String> v = new Vector<String>();
            int i = 0;
            StringBuffer buf = new StringBuffer(16);
            while (true) {
                if (i == patternStr.length) {
                    if (buf.length() <= 0) break;
                    v.addElement(buf.toString());
                    break;
                }
                if (patternStr[i] == '\\') {
                    if (buf.length() == 0) {
                        buf.append(' ');
                    }
                    if (i < patternStr.length - 1) {
                        char next = patternStr[i + 1];
                        if (next == '%' || next == '*' || next == '_' || next == '\\') {
                            buf.append(next);
                        } else if (next == 'n') {
                            buf.append('\n');
                        } else if (next == 'r') {
                            buf.append('\r');
                        } else if (next == 't') {
                            buf.append('\t');
                        } else {
                            throw new IllegalArgumentException("Invalid escape sequence: \\" + next);
                        }
                        i += 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid escape sequence: \\");
                }
                if (patternStr[i] == '%' || patternStr[i] == '*' || patternStr[i] == '_') {
                    if (patternStr[i] == '_') {
                        if (buf.length() == 0) {
                            buf.append(' ');
                        }
                        buf.append('\u0000');
                        ++i;
                        continue;
                    }
                    if (buf.length() > 0) {
                        v.addElement(buf.toString());
                    }
                    v.addElement("*");
                    while (i < patternStr.length && (patternStr[i] == '%' || patternStr[i] == '*')) {
                        ++i;
                    }
                    buf.setLength(0);
                    continue;
                }
                if (buf.length() == 0) {
                    buf.append(' ');
                }
                buf.append(patternStr[i++]);
            }
            this.pattern = new char[v.size()][];
            for (int j = 0; j < v.size(); ++j) {
                this.pattern[j] = ((String)v.elementAt(j)).toCharArray();
            }
        }

        public boolean isMatch(String testStr) {
            if (this.matchAll) {
                return true;
            }
            if (!this.matchCase) {
                testStr = TextUtil.toLowerCase((String)testStr);
            }
            char[] test = testStr.toCharArray();
            int ti = 0;
            boolean lastStart = false;
            int len = test.length;
            boolean afterWildcard = false;
            if (len == 0) {
                return this.pattern.length == 0;
            }
            block0: for (int pi = 0; pi < this.pattern.length; ++pi) {
                if (this.pattern[pi][0] == '*') {
                    if (pi == this.pattern.length - 1) {
                        return true;
                    }
                    afterWildcard = true;
                    continue;
                }
                while (ti < len) {
                    int ei;
                    int start = ti;
                    for (ei = 1; ti < len && ei < this.pattern[pi].length && (this.pattern[pi][ei] == '\u0000' || this.pattern[pi][ei] == test[ti]); ++ti, ++ei) {
                    }
                    if (ei == this.pattern[pi].length) {
                        if (pi == this.pattern.length - 1) {
                            if (ti == len) {
                                return true;
                            }
                            if (afterWildcard) {
                                ti = len - (this.pattern[pi].length - 1);
                                continue;
                            }
                            return false;
                        }
                        afterWildcard = false;
                        continue block0;
                    }
                    if (ti == len) {
                        return false;
                    }
                    if (!afterWildcard) {
                        return false;
                    }
                    ti = start + 1;
                    if (ti != len) continue;
                    return false;
                }
            }
            return false;
        }
    }
}

