/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.filter;

import com.tridium.bql.filter.BAbsTimeFilter;
import com.tridium.bql.filter.BFilterEntry;
import com.tridium.bql.util.BDynamicTimeRangeType;
import com.tridium.orion.sql.BSqlField;
import com.tridiumx.entsec.filter.BDynamicRecentTimeRange;
import com.tridiumx.entsec.filter.BDynamicRecentTimeRangeType;
import javax.baja.naming.BOrd;
import javax.baja.query.BExpression;
import javax.baja.query.expression.BFunctionExpression;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Exprs;
import javax.baja.query.util.Funcs;
import javax.baja.query.util.Predicates;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.BTimeRange;

public class BSecRecentAbsTimeFilter
extends BAbsTimeFilter {
    public static final Property startTime = BSecRecentAbsTimeFilter.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property endTime = BSecRecentAbsTimeFilter.newProperty((int)0, (BValue)BAbsTime.NULL, null);
    public static final Property timeRangeType = BSecRecentAbsTimeFilter.newProperty((int)4, (BValue)BDynamicTimeRangeType.timeRange, null);
    public static final Property recentTimeRangeType = BSecRecentAbsTimeFilter.newProperty((int)0, (BValue)BDynamicRecentTimeRangeType.last12Hours, null);
    public static final Property dailyTimeRange = BSecRecentAbsTimeFilter.newProperty((int)0, (BValue)new BTimeRange(), null);
    public static final Property daysOfWeek = BSecRecentAbsTimeFilter.newProperty((int)0, (BValue)BDaysOfWeekBits.DEFAULT, null);
    public static final Property schedule = BSecRecentAbsTimeFilter.newProperty((int)0, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartOrdChooserFE"), (BFacets)BFacets.make((String)"targetType", (String)"schedule:BooleanSchedule")));
    public static final Property locked = BSecRecentAbsTimeFilter.newProperty((int)4, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BSecRecentAbsTimeFilter.class);
    private BBooleanSchedule cachedSchedule = null;

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime v) {
        this.set(startTime, (BValue)v, null);
    }

    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    public void setEndTime(BAbsTime v) {
        this.set(endTime, (BValue)v, null);
    }

    public BDynamicTimeRangeType getTimeRangeType() {
        return (BDynamicTimeRangeType)this.get(timeRangeType);
    }

    public void setTimeRangeType(BDynamicTimeRangeType v) {
        this.set(timeRangeType, (BValue)v, null);
    }

    public BDynamicRecentTimeRangeType getRecentTimeRangeType() {
        return (BDynamicRecentTimeRangeType)this.get(recentTimeRangeType);
    }

    public void setRecentTimeRangeType(BDynamicRecentTimeRangeType v) {
        this.set(recentTimeRangeType, (BValue)v, null);
    }

    public BTimeRange getDailyTimeRange() {
        return (BTimeRange)this.get(dailyTimeRange);
    }

    public void setDailyTimeRange(BTimeRange v) {
        this.set(dailyTimeRange, (BValue)v, null);
    }

    public BDaysOfWeekBits getDaysOfWeek() {
        return (BDaysOfWeekBits)this.get(daysOfWeek);
    }

    public void setDaysOfWeek(BDaysOfWeekBits v) {
        this.set(daysOfWeek, (BValue)v, null);
    }

    public BOrd getSchedule() {
        return (BOrd)this.get(schedule);
    }

    public void setSchedule(BOrd v) {
        this.set(schedule, (BValue)v, null);
    }

    public boolean getLocked() {
        return this.getBoolean(locked);
    }

    public void setLocked(boolean v) {
        this.setBoolean(locked, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void init(BObject o) {
        if (this.getParent() != null) {
            BFilterEntry entry = (BFilterEntry)this.getParent();
            if (this.getLocked()) {
                entry.setFlags((Slot)BFilterEntry.active, entry.getFlags((Slot)BFilterEntry.active) | 1);
            } else {
                entry.setFlags((Slot)BFilterEntry.active, entry.getFlags((Slot)BFilterEntry.active) & 0xFFFFFFFE);
            }
        }
        if (this.getRecentTimeRangeType() != BDynamicRecentTimeRangeType.timeRange) {
            BAbsTime time = BAbsTime.now();
            BDynamicRecentTimeRange range = BDynamicRecentTimeRange.make(this.getRecentTimeRangeType());
            this.setStartTime(range.getStartTime(time));
            this.setEndTime(range.getEndTime(time));
            this.setMaxEnabled(true);
            this.setMinEnabled(true);
        }
        this.initSchedule();
    }

    public void initSchedule() {
        if (this.getSchedule() != BOrd.DEFAULT) {
            this.cachedSchedule = null;
            try {
                this.cachedSchedule = (BBooleanSchedule)BOrd.make((String)("station:|" + this.getSchedule())).get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initFromDynamicTimeRange(BDynamicRecentTimeRange range) {
        this.setRecentTimeRangeType(range.getRangeType());
        if (this.getRecentTimeRangeType() == BDynamicRecentTimeRangeType.timeRange) {
            if (range.getFixedStartTime().equals((Object)BAbsTime.NULL)) {
                this.setStartTime(BAbsTime.make());
                this.setMinEnabled(false);
            } else {
                this.setStartTime(range.getFixedStartTime());
                this.setMinEnabled(true);
            }
            if (range.getFixedEndTime().equals((Object)BAbsTime.NULL)) {
                this.setEndTime(BAbsTime.make());
                this.setMaxEnabled(false);
            } else {
                this.setEndTime(range.getFixedEndTime());
                this.setMaxEnabled(true);
            }
        } else {
            this.init(null);
        }
    }

    public BDynamicRecentTimeRange getDynamicRecentTimeRange() {
        this.init(null);
        if (this.getRecentTimeRangeType() == BDynamicRecentTimeRangeType.timeRange) {
            if (this.getMinEnabled() && this.getMaxEnabled()) {
                return BDynamicRecentTimeRange.make(this.getStartTime(), this.getEndTime());
            }
            if (this.getMinEnabled()) {
                return BDynamicRecentTimeRange.make(this.getStartTime(), BAbsTime.DEFAULT);
            }
            if (this.getMaxEnabled()) {
                return BDynamicRecentTimeRange.make(BAbsTime.DEFAULT, this.getEndTime());
            }
            return BDynamicRecentTimeRange.DEFAULT;
        }
        return BDynamicRecentTimeRange.make(this.getRecentTimeRangeType());
    }

    public BExpression getExpression(BExpression columnExpression) {
        BExpression scheduleExpression;
        BExpression dailyTimeRangeExpression;
        boolean sqlHack;
        ExpressionBuilder b = new ExpressionBuilder();
        BExpression timeRangeExpression = this.getTimeRangeExpression(columnExpression);
        if (timeRangeExpression != null) {
            b.and(timeRangeExpression);
        }
        if (sqlHack = columnExpression.getType().equals(BSqlField.TYPE)) {
            this.initSchedule();
            return b.getExpression();
        }
        BExpression daysOfWeekExpression = this.getDaysOfWeekExpression(columnExpression);
        if (daysOfWeekExpression != null) {
            b.and(daysOfWeekExpression);
        }
        if ((dailyTimeRangeExpression = this.getDailyTimeRangeExpression(columnExpression)) != null) {
            b.and(dailyTimeRangeExpression);
        }
        if ((scheduleExpression = this.getScheduleExpression(columnExpression)) != null) {
            b.and(scheduleExpression);
        }
        return b.getExpression();
    }

    public boolean isAdvancedDefault() {
        return this.getDaysOfWeek().isEveryDay() && this.getDailyTimeRange().isAllDay() && this.getSchedule() == BOrd.DEFAULT;
    }

    public boolean advancedAccept(BAbsTime time) {
        if (!this.getDaysOfWeek().isEveryDay() && !this.getDaysOfWeek().includes(time)) {
            return false;
        }
        if (!this.getDailyTimeRange().isAllDay() && !this.getDailyTimeRange().includes(time)) {
            return false;
        }
        if (this.getSchedule() != BOrd.DEFAULT) {
            if (this.cachedSchedule != null) {
                return ((BBoolean)this.cachedSchedule.getOutput(time).getValueValue()).getBoolean();
            }
            return false;
        }
        return true;
    }

    public BExpression getTimeRangeExpression(BExpression columnExpression) {
        BAbsTime start = this.getStartTime();
        BAbsTime end = this.getEndTime();
        if (!(this.getMinEnabled() && !start.isNull() || this.getMaxEnabled() && !end.isNull())) {
            return null;
        }
        if (this.getMinEnabled() && !start.isNull() && (!this.getMaxEnabled() || end.isNull())) {
            return Predicates.ge((BExpression)columnExpression, (BSimple)start);
        }
        if (this.getMaxEnabled() && !end.isNull() && (!this.getMinEnabled() || start.isNull())) {
            return Predicates.le((BExpression)columnExpression, (BSimple)end);
        }
        return Predicates.and((BExpression)Predicates.ge((BExpression)columnExpression, (BSimple)start), (BExpression)Predicates.le((BExpression)((BExpression)columnExpression.newCopy()), (BSimple)end));
    }

    public BExpression getDaysOfWeekExpression(BExpression columnExpression) {
        BDaysOfWeekBits daysOfWeek = this.getDaysOfWeek();
        if (daysOfWeek.isEveryDay()) {
            return null;
        }
        BExpression[] params = new BExpression[]{columnExpression.newExprCopy(), Exprs.simple((BSimple)daysOfWeek)};
        BFunctionExpression function = Funcs.make((String)(TYPE.toString() + ".acceptDaysOfWeek"), (Type)BBoolean.TYPE, (BExpression[])params);
        return function;
    }

    public static BBoolean acceptDaysOfWeek(BObject target, BAbsTime time, BDaysOfWeekBits daysOfWeek) {
        return BBoolean.make((boolean)daysOfWeek.includes(time));
    }

    public BExpression getDailyTimeRangeExpression(BExpression columnExpression) {
        BTimeRange timeRange = this.getDailyTimeRange();
        if (timeRange.isAllDay()) {
            return null;
        }
        BExpression[] params = new BExpression[]{columnExpression.newExprCopy(), Exprs.simple((BSimple)timeRange.getStartTime()), Exprs.simple((BSimple)timeRange.getEndTime())};
        BFunctionExpression function = Funcs.make((String)(TYPE.toString() + ".acceptDailyTimeRange"), (Type)BBoolean.TYPE, (BExpression[])params);
        return function;
    }

    public static BBoolean acceptDailyTimeRange(BObject target, BAbsTime time, BTime startTime, BTime endTime) {
        BTimeRange timeRange = new BTimeRange(startTime, endTime);
        return BBoolean.make((boolean)timeRange.includes(time));
    }

    public BExpression getScheduleExpression(BExpression columnExpression) {
        BOrd schedule = this.getSchedule();
        if (schedule == BOrd.DEFAULT) {
            return null;
        }
        BExpression[] params = new BExpression[]{columnExpression.newExprCopy(), Exprs.simple((BSimple)schedule)};
        BFunctionExpression function = Funcs.make((String)(TYPE.toString() + ".acceptSchedule"), (Type)BBoolean.TYPE, (BExpression[])params);
        return function;
    }

    public static BBoolean acceptSchedule(BObject target, BAbsTime time, BOrd scheduleOrd) {
        try {
            BBooleanSchedule schedule = (BBooleanSchedule)BOrd.make((String)("station:|" + scheduleOrd)).get();
            return (BBoolean)schedule.getOutput(time).getValueValue();
        }
        catch (Exception e) {
            return BBoolean.FALSE;
        }
    }
}

