/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.filter;

import com.tridiumx.entsec.filter.BDynamicFutureTimeRangeType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public final class BDynamicFutureTimeRange
extends BSimple {
    public static final BDynamicFutureTimeRange DEFAULT = BDynamicFutureTimeRange.make(BAbsTime.NULL, BAbsTime.NULL);
    public static final BDynamicFutureTimeRange TODAY = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.today);
    public static final BDynamicFutureTimeRange LAST_24_HOURS = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.last24Hours);
    public static final BDynamicFutureTimeRange YESTERDAY = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.yesterday);
    public static final BDynamicFutureTimeRange WEEK_TO_DATE = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.weekToDate);
    public static final BDynamicFutureTimeRange LAST_WEEK = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.lastWeek);
    public static final BDynamicFutureTimeRange LAST_7_DAYS = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.last7Days);
    public static final BDynamicFutureTimeRange MONTH_TO_DATE = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.monthToDate);
    public static final BDynamicFutureTimeRange LAST_MONTH = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.lastMonth);
    public static final BDynamicFutureTimeRange YEAR_TO_DATE = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.yearToDate);
    public static final BDynamicFutureTimeRange LAST_YEAR = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.lastYear);
    public static final BDynamicFutureTimeRange THIS_WEEK = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.thisWeek);
    public static final BDynamicFutureTimeRange THIS_MONTH = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.thisMonth);
    public static final BDynamicFutureTimeRange THIS_YEAR = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.thisYear);
    public static final BDynamicFutureTimeRange REST_OF_DAY = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.restOfDay);
    public static final BDynamicFutureTimeRange TOMORROW = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.tomorrow);
    public static final BDynamicFutureTimeRange REST_OF_WEEK = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.restOfWeek);
    public static final BDynamicFutureTimeRange NEXT_WEEK = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.nextWeek);
    public static final BDynamicFutureTimeRange NEXT_7_DAYS = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.next7Days);
    public static final BDynamicFutureTimeRange REST_OF_MONTH = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.restOfMonth);
    public static final BDynamicFutureTimeRange NEXT_MONTH = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.nextMonth);
    public static final BDynamicFutureTimeRange REST_OF_YEAR = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.restOfYear);
    public static final BDynamicFutureTimeRange NEXT_YEAR = new BDynamicFutureTimeRange(BDynamicFutureTimeRangeType.nextYear);
    private static final HashMap byId = new HashMap();
    private static final BTime LAST_INSTANT;
    public static final Type TYPE;
    private BDynamicFutureTimeRangeType rangeType;
    private BAbsTime startTime;
    private BAbsTime endTime;

    private BDynamicFutureTimeRange() {
        this(BDynamicFutureTimeRangeType.today);
    }

    private BDynamicFutureTimeRange(BDynamicFutureTimeRangeType rangeType) {
        this.rangeType = rangeType;
        this.startTime = this.endTime = BAbsTime.NULL;
    }

    public static BDynamicFutureTimeRange make(BDynamicFutureTimeRangeType rangeType) {
        if (rangeType == BDynamicFutureTimeRangeType.today) {
            return TODAY;
        }
        if (rangeType == BDynamicFutureTimeRangeType.last24Hours) {
            return LAST_24_HOURS;
        }
        if (rangeType == BDynamicFutureTimeRangeType.yesterday) {
            return YESTERDAY;
        }
        if (rangeType == BDynamicFutureTimeRangeType.weekToDate) {
            return WEEK_TO_DATE;
        }
        if (rangeType == BDynamicFutureTimeRangeType.lastWeek) {
            return LAST_WEEK;
        }
        if (rangeType == BDynamicFutureTimeRangeType.last7Days) {
            return LAST_7_DAYS;
        }
        if (rangeType == BDynamicFutureTimeRangeType.monthToDate) {
            return MONTH_TO_DATE;
        }
        if (rangeType == BDynamicFutureTimeRangeType.lastMonth) {
            return LAST_MONTH;
        }
        if (rangeType == BDynamicFutureTimeRangeType.yearToDate) {
            return YEAR_TO_DATE;
        }
        if (rangeType == BDynamicFutureTimeRangeType.lastYear) {
            return LAST_YEAR;
        }
        if (rangeType == BDynamicFutureTimeRangeType.thisWeek) {
            return THIS_WEEK;
        }
        if (rangeType == BDynamicFutureTimeRangeType.thisMonth) {
            return THIS_MONTH;
        }
        if (rangeType == BDynamicFutureTimeRangeType.thisYear) {
            return THIS_YEAR;
        }
        if (rangeType == BDynamicFutureTimeRangeType.restOfDay) {
            return REST_OF_DAY;
        }
        if (rangeType == BDynamicFutureTimeRangeType.tomorrow) {
            return TOMORROW;
        }
        if (rangeType == BDynamicFutureTimeRangeType.restOfWeek) {
            return REST_OF_WEEK;
        }
        if (rangeType == BDynamicFutureTimeRangeType.nextWeek) {
            return NEXT_WEEK;
        }
        if (rangeType == BDynamicFutureTimeRangeType.next7Days) {
            return NEXT_7_DAYS;
        }
        if (rangeType == BDynamicFutureTimeRangeType.restOfMonth) {
            return REST_OF_MONTH;
        }
        if (rangeType == BDynamicFutureTimeRangeType.nextMonth) {
            return NEXT_MONTH;
        }
        if (rangeType == BDynamicFutureTimeRangeType.restOfYear) {
            return REST_OF_YEAR;
        }
        if (rangeType == BDynamicFutureTimeRangeType.nextYear) {
            return NEXT_YEAR;
        }
        if (rangeType == BDynamicFutureTimeRangeType.timeRange) {
            throw new IllegalArgumentException("Must provide time bounds with timeRange.");
        }
        throw new IllegalArgumentException();
    }

    public static BDynamicFutureTimeRange make(String periodId) {
        BDynamicFutureTimeRange result = null;
        String key = periodId.toLowerCase();
        Iterator keys = byId.keySet().iterator();
        result = (BDynamicFutureTimeRange)((Object)byId.get(key));
        if (result == null) {
            throw new IllegalArgumentException("Invalid period id: " + periodId);
        }
        return result;
    }

    public static BDynamicFutureTimeRange make(BAbsTime startTime, BAbsTime endTime) {
        BDynamicFutureTimeRange result = new BDynamicFutureTimeRange();
        result.rangeType = BDynamicFutureTimeRangeType.timeRange;
        if (!startTime.isNull() && !endTime.isNull() && startTime.isAfter(endTime)) {
            throw new IllegalArgumentException("Start time is after endTime time.");
        }
        result.startTime = startTime;
        result.endTime = endTime;
        return result;
    }

    public BDynamicFutureTimeRangeType getRangeType() {
        return this.rangeType;
    }

    public BAbsTime getFixedStartTime() {
        return this.startTime;
    }

    public BAbsTime getFixedEndTime() {
        return this.endTime;
    }

    public BAbsTime getStartTime(BAbsTime currentTime) {
        if (this.rangeType == BDynamicFutureTimeRangeType.timeRange) {
            return this.startTime;
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.today) {
            return BAbsTime.make((BAbsTime)currentTime, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.last24Hours) {
            return currentTime.subtract(BRelTime.DAY);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.yesterday) {
            return BAbsTime.make((BAbsTime)currentTime.prevDay(), (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.weekToDate || this.rangeType == BDynamicFutureTimeRangeType.thisWeek) {
            BAbsTime day = currentTime;
            while (day.getWeekday() != BWeekday.sunday) {
                day = day.prevDay();
            }
            return BAbsTime.make((BAbsTime)day, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.lastWeek) {
            BAbsTime day = currentTime;
            while (day.getWeekday() != BWeekday.sunday) {
                day = day.prevDay();
            }
            day = day.prevDay();
            while (day.getWeekday() != BWeekday.sunday) {
                day = day.prevDay();
            }
            return BAbsTime.make((BAbsTime)day, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.last7Days) {
            BAbsTime day = currentTime;
            for (int i = 0; i < 7; ++i) {
                day = day.prevDay();
            }
            return BAbsTime.make((BAbsTime)day, (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.monthToDate || this.rangeType == BDynamicFutureTimeRangeType.thisMonth) {
            return BAbsTime.make((int)currentTime.getYear(), (BMonth)currentTime.getMonth(), (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)currentTime.getTimeZone());
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.lastMonth) {
            BAbsTime lastMonth = currentTime.prevMonth();
            return BAbsTime.make((int)lastMonth.getYear(), (BMonth)lastMonth.getMonth(), (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)lastMonth.getTimeZone());
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.yearToDate || this.rangeType == BDynamicFutureTimeRangeType.thisYear) {
            return BAbsTime.make((int)currentTime.getYear(), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)currentTime.getTimeZone());
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.lastYear) {
            return BAbsTime.make((int)(currentTime.getYear() - 1), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)currentTime.getTimeZone());
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.restOfDay) {
            return currentTime;
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.tomorrow) {
            return BAbsTime.make((BAbsTime)currentTime.nextDay(), (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.restOfWeek) {
            return currentTime;
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.nextWeek) {
            return BAbsTime.make((BAbsTime)currentTime.next(BWeekday.sunday), (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.next7Days) {
            return BAbsTime.make((BAbsTime)currentTime.nextDay(), (BTime)BTime.MIDNIGHT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.restOfMonth) {
            return currentTime;
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.nextMonth) {
            BAbsTime nextMonth = currentTime.nextMonth();
            return BAbsTime.make((int)nextMonth.getYear(), (BMonth)nextMonth.getMonth(), (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)nextMonth.getTimeZone());
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.restOfYear) {
            return currentTime;
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.nextYear) {
            return BAbsTime.make((int)(currentTime.getYear() + 1), (BMonth)BMonth.january, (int)1, (int)0, (int)0, (int)0, (int)0, (BTimeZone)currentTime.getTimeZone());
        }
        throw new IllegalStateException("Unsupported range type: " + (Object)((Object)this.rangeType));
    }

    public BAbsTime getEndTime(BAbsTime currentTime) {
        if (this.rangeType == BDynamicFutureTimeRangeType.timeRange) {
            return this.endTime;
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.today || this.rangeType == BDynamicFutureTimeRangeType.restOfDay) {
            return BAbsTime.make((BAbsTime)currentTime, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.last24Hours) {
            return currentTime;
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.yesterday) {
            return BAbsTime.make((BAbsTime)currentTime.prevDay(), (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.weekToDate) {
            return currentTime;
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.lastWeek) {
            BAbsTime day = currentTime;
            while (day.getWeekday() != BWeekday.sunday) {
                day = day.prevDay();
            }
            day = day.prevDay();
            return BAbsTime.make((BAbsTime)day, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.last7Days) {
            BAbsTime day = currentTime;
            day = day.prevDay();
            return BAbsTime.make((BAbsTime)day, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.monthToDate) {
            return currentTime;
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.lastMonth) {
            BAbsTime lastMonth = currentTime.prevMonth();
            return BAbsTime.make((int)lastMonth.getYear(), (BMonth)lastMonth.getMonth(), (int)BAbsTime.getDaysInMonth((int)lastMonth.getYear(), (BMonth)lastMonth.getMonth()), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)lastMonth.getTimeZone());
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.yearToDate) {
            return currentTime;
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.lastYear) {
            return BAbsTime.make((int)(currentTime.getYear() - 1), (BMonth)BMonth.december, (int)BAbsTime.getDaysInMonth((int)(currentTime.getYear() - 1), (BMonth)BMonth.december), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)currentTime.getTimeZone());
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.thisWeek || this.rangeType == BDynamicFutureTimeRangeType.restOfWeek) {
            BAbsTime day = currentTime;
            day = day.nextDay();
            while (day.getWeekday() != BWeekday.saturday) {
                day = day.nextDay();
            }
            return BAbsTime.make((BAbsTime)day, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.thisMonth || this.rangeType == BDynamicFutureTimeRangeType.restOfMonth) {
            return BAbsTime.make((int)currentTime.getYear(), (BMonth)currentTime.getMonth(), (int)BAbsTime.getDaysInMonth((int)currentTime.getYear(), (BMonth)currentTime.getMonth()), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)currentTime.getTimeZone());
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.thisYear || this.rangeType == BDynamicFutureTimeRangeType.restOfYear) {
            return BAbsTime.make((int)currentTime.getYear(), (BMonth)BMonth.december, (int)BAbsTime.getDaysInMonth((int)currentTime.getYear(), (BMonth)BMonth.december), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)currentTime.getTimeZone());
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.tomorrow) {
            return BAbsTime.make((BAbsTime)currentTime.nextDay(), (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.nextWeek) {
            BAbsTime day = currentTime;
            day = day.next(day.getWeekday()).nextDay();
            while (day.getWeekday() != BWeekday.saturday) {
                day = day.nextDay();
            }
            return BAbsTime.make((BAbsTime)day, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.next7Days) {
            BAbsTime day = currentTime;
            day = day.next(day.getWeekday());
            return BAbsTime.make((BAbsTime)day, (BTime)LAST_INSTANT);
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.nextMonth) {
            BAbsTime day = currentTime;
            day = day.nextMonth();
            return BAbsTime.make((int)day.getYear(), (BMonth)day.getMonth(), (int)BAbsTime.getDaysInMonth((int)day.getYear(), (BMonth)day.getMonth()), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)day.getTimeZone());
        }
        if (this.rangeType == BDynamicFutureTimeRangeType.nextYear) {
            BAbsTime day = currentTime;
            day = day.nextYear();
            return BAbsTime.make((int)day.getYear(), (BMonth)BMonth.december, (int)BAbsTime.getDaysInMonth((int)day.getYear(), (BMonth)BMonth.december), (int)LAST_INSTANT.getHour(), (int)LAST_INSTANT.getMinute(), (int)LAST_INSTANT.getSecond(), (int)LAST_INSTANT.getMillisecond(), (BTimeZone)day.getTimeZone());
        }
        throw new IllegalStateException("Unsupported range type: " + (Object)((Object)this.rangeType));
    }

    public String toOrdParams() {
        BAbsTime end;
        if (this.rangeType != BDynamicFutureTimeRangeType.timeRange) {
            return "period=" + this.rangeType.getTag();
        }
        StringBuffer s = new StringBuffer(32);
        s.append("period=").append(this.rangeType.getTag());
        BAbsTime start = this.getFixedStartTime();
        if (start != null && !start.isNull()) {
            s.append(';').append("start=").append(start.encodeToString());
        }
        if ((end = this.getFixedEndTime()) != null && !end.isNull()) {
            s.append(';').append("end=").append(end.encodeToString());
        }
        return s.toString();
    }

    public int hashCode() {
        int hash = 23 + this.rangeType.hashCode();
        hash = hash * 37 + this.startTime.hashCode();
        return hash * 37 + this.endTime.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof BDynamicFutureTimeRange) {
            BDynamicFutureTimeRange other = (BDynamicFutureTimeRange)((Object)o);
            return this.rangeType == other.rangeType && this.startTime.equals((Object)other.startTime) && this.endTime.equals((Object)other.endTime);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        this.rangeType.encode(out);
        this.startTime.encode(out);
        this.endTime.encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        BDynamicFutureTimeRange result = new BDynamicFutureTimeRange();
        result.rangeType = (BDynamicFutureTimeRangeType)BDynamicFutureTimeRangeType.timeRange.decode(in);
        result.startTime = (BAbsTime)BAbsTime.DEFAULT.decode(in);
        result.endTime = (BAbsTime)BAbsTime.DEFAULT.decode(in);
        return result;
    }

    public String encodeToString() throws IOException {
        if (this.rangeType != BDynamicFutureTimeRangeType.timeRange) {
            return this.rangeType.encodeToString();
        }
        return this.rangeType.encodeToString() + ":startTime=" + this.startTime.encodeToString() + ";endTime=" + this.endTime.encodeToString();
    }

    public BObject decodeFromString(String s) throws IOException {
        int colon = s.indexOf(58);
        if (colon == -1) {
            return BDynamicFutureTimeRange.make(s);
        }
        int semi = s.indexOf(59);
        BDynamicFutureTimeRange result = new BDynamicFutureTimeRange();
        String typeString = s.substring(0, colon);
        if (!typeString.equals(BDynamicFutureTimeRangeType.timeRange.getTag())) {
            throw new IOException("Invalid string encoding: " + s);
        }
        result.rangeType = BDynamicFutureTimeRangeType.timeRange;
        String startParam = s.substring(colon + 1, semi);
        int eq = startParam.indexOf(61);
        if (eq == -1) {
            throw new IOException("Invalid string encoding: " + s);
        }
        if (!startParam.substring(0, eq).equals("startTime")) {
            throw new IOException("Invalid string encoding: " + s);
        }
        result.startTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(startParam.substring(eq + 1));
        String endParam = s.substring(semi + 1);
        eq = endParam.indexOf(61);
        if (eq == -1) {
            throw new IOException("Invalid string encoding: " + s);
        }
        if (!endParam.substring(0, eq).equals("endTime")) {
            throw new IOException("Invalid string encoding: " + s);
        }
        result.endTime = (BAbsTime)BAbsTime.DEFAULT.decodeFromString(endParam.substring(eq + 1));
        return result;
    }

    public Type getType() {
        return TYPE;
    }

    static {
        byId.put(BDynamicFutureTimeRangeType.today.getTag().toLowerCase(), TODAY);
        byId.put(BDynamicFutureTimeRangeType.last24Hours.getTag().toLowerCase(), LAST_24_HOURS);
        byId.put(BDynamicFutureTimeRangeType.yesterday.getTag().toLowerCase(), YESTERDAY);
        byId.put(BDynamicFutureTimeRangeType.weekToDate.getTag().toLowerCase(), WEEK_TO_DATE);
        byId.put(BDynamicFutureTimeRangeType.lastWeek.getTag().toLowerCase(), LAST_WEEK);
        byId.put(BDynamicFutureTimeRangeType.last7Days.getTag().toLowerCase(), LAST_7_DAYS);
        byId.put(BDynamicFutureTimeRangeType.monthToDate.getTag().toLowerCase(), MONTH_TO_DATE);
        byId.put(BDynamicFutureTimeRangeType.lastMonth.getTag().toLowerCase(), LAST_MONTH);
        byId.put(BDynamicFutureTimeRangeType.yearToDate.getTag().toLowerCase(), YEAR_TO_DATE);
        byId.put(BDynamicFutureTimeRangeType.lastYear.getTag().toLowerCase(), LAST_YEAR);
        byId.put(BDynamicFutureTimeRangeType.thisWeek.getTag().toLowerCase(), THIS_WEEK);
        byId.put(BDynamicFutureTimeRangeType.thisMonth.getTag().toLowerCase(), THIS_MONTH);
        byId.put(BDynamicFutureTimeRangeType.thisYear.getTag().toLowerCase(), THIS_YEAR);
        byId.put(BDynamicFutureTimeRangeType.restOfDay.getTag().toLowerCase(), REST_OF_DAY);
        byId.put(BDynamicFutureTimeRangeType.tomorrow.getTag().toLowerCase(), TOMORROW);
        byId.put(BDynamicFutureTimeRangeType.restOfWeek.getTag().toLowerCase(), REST_OF_WEEK);
        byId.put(BDynamicFutureTimeRangeType.restOfWeek.getTag().toLowerCase(), NEXT_WEEK);
        byId.put(BDynamicFutureTimeRangeType.restOfWeek.getTag().toLowerCase(), NEXT_7_DAYS);
        byId.put(BDynamicFutureTimeRangeType.restOfWeek.getTag().toLowerCase(), REST_OF_MONTH);
        byId.put(BDynamicFutureTimeRangeType.restOfWeek.getTag().toLowerCase(), NEXT_MONTH);
        byId.put(BDynamicFutureTimeRangeType.restOfWeek.getTag().toLowerCase(), REST_OF_YEAR);
        byId.put(BDynamicFutureTimeRangeType.restOfWeek.getTag().toLowerCase(), NEXT_YEAR);
        LAST_INSTANT = BTime.make((int)23, (int)59, (int)59, (int)999);
        TYPE = Sys.loadType(BDynamicFutureTimeRange.class);
    }
}

