/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.backup;

import com.tridiumx.accessDriver.BOffAlarmClass;
import com.tridiumx.entsec.backup.BLocalBackupJob;
import com.tridiumx.entsec.backup.BSystemBackupJob;
import javax.baja.alarm.AlarmSupport;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.alarm.BIAlarmSource;
import javax.baja.backup.BBackupService;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BSystemBackups
extends BComponent
implements BIAlarmSource {
    public static final Property systemBackupSchedule = BSystemBackups.newProperty((int)8, (BValue)new BStatusBoolean(false, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartScheduleLinkFE"));
    public static final Property localBackupSchedule = BSystemBackups.newProperty((int)8, (BValue)new BStatusBoolean(false, BStatus.nullStatus), (BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:SmartScheduleLinkFE"));
    public static final Property scheduledSystemBackupLimit = BSystemBackups.newProperty((int)8, (int)10, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Property scheduledLocalBackupLimit = BSystemBackups.newProperty((int)8, (int)10, (BFacets)BFacets.make((String)"min", (int)1));
    public static final Property alarmInfo = BSystemBackups.newProperty((int)8, (BValue)new BAlarmSourceInfo(), null);
    public static final Property restoreInfo = BSystemBackups.newProperty((int)71, (String)"", null);
    public static final Property systemBackupEventUsed = BSystemBackups.newProperty((int)5, (boolean)false, null);
    public static final Property localBackupEventUsed = BSystemBackups.newProperty((int)5, (boolean)false, null);
    public static final Action systemBackup = BSystemBackups.newAction((int)0, null);
    public static final Action localBackup = BSystemBackups.newAction((int)0, null);
    public static final Action restore = BSystemBackups.newAction((int)20, (BValue)BOrd.DEFAULT, null);
    public static final Action ackAlarm = BSystemBackups.newAction((int)4, (BValue)new BAlarmRecord(), null);
    public static final Type TYPE = Sys.loadType(BSystemBackups.class);
    public static final BIcon ICON = BIcon.std((String)"backup.png");
    public static final String FAILED = "Failed:";
    public static final String RESTORING = "Restoring";
    public static final String STARTING = "Starting";
    public static final String COMPLETE = "Complete";
    private AlarmSupport support;
    private boolean system = false;
    private boolean local = false;

    public BStatusBoolean getSystemBackupSchedule() {
        return (BStatusBoolean)this.get(systemBackupSchedule);
    }

    public void setSystemBackupSchedule(BStatusBoolean v) {
        this.set(systemBackupSchedule, (BValue)v, null);
    }

    public BStatusBoolean getLocalBackupSchedule() {
        return (BStatusBoolean)this.get(localBackupSchedule);
    }

    public void setLocalBackupSchedule(BStatusBoolean v) {
        this.set(localBackupSchedule, (BValue)v, null);
    }

    public int getScheduledSystemBackupLimit() {
        return this.getInt(scheduledSystemBackupLimit);
    }

    public void setScheduledSystemBackupLimit(int v) {
        this.setInt(scheduledSystemBackupLimit, v, null);
    }

    public int getScheduledLocalBackupLimit() {
        return this.getInt(scheduledLocalBackupLimit);
    }

    public void setScheduledLocalBackupLimit(int v) {
        this.setInt(scheduledLocalBackupLimit, v, null);
    }

    public BAlarmSourceInfo getAlarmInfo() {
        return (BAlarmSourceInfo)this.get(alarmInfo);
    }

    public void setAlarmInfo(BAlarmSourceInfo v) {
        this.set(alarmInfo, (BValue)v, null);
    }

    public String getRestoreInfo() {
        return this.getString(restoreInfo);
    }

    public void setRestoreInfo(String v) {
        this.setString(restoreInfo, v, null);
    }

    public boolean getSystemBackupEventUsed() {
        return this.getBoolean(systemBackupEventUsed);
    }

    public void setSystemBackupEventUsed(boolean v) {
        this.setBoolean(systemBackupEventUsed, v, null);
    }

    public boolean getLocalBackupEventUsed() {
        return this.getBoolean(localBackupEventUsed);
    }

    public void setLocalBackupEventUsed(boolean v) {
        this.setBoolean(localBackupEventUsed, v, null);
    }

    public void systemBackup() {
        this.invoke(systemBackup, null, null);
    }

    public void localBackup() {
        this.invoke(localBackup, null, null);
    }

    public void restore(BOrd event) {
        this.invoke(restore, (BValue)event, null);
    }

    public BBoolean ackAlarm(BAlarmRecord alarm) {
        return (BBoolean)this.invoke(ackAlarm, (BValue)alarm, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void started() {
        this.support = new AlarmSupport((BIAlarmSource)this, this.getAlarmInfo());
    }

    public void changed(Property p, Context cx) {
        boolean newLocal;
        if (p.equals(systemBackupSchedule)) {
            boolean newSystem = this.getSystemBackupSchedule().getValue();
            if (this.system != newSystem) {
                if (this.getSystemBackupEventUsed() && newSystem) {
                    return;
                }
                this.system = newSystem;
                this.setSystemBackupEventUsed(this.system);
                if (this.system) {
                    this.systemBackup();
                }
            }
        } else if (p.equals(localBackupSchedule) && this.local != (newLocal = this.getLocalBackupSchedule().getValue())) {
            if (this.getLocalBackupEventUsed() && newLocal) {
                return;
            }
            this.local = newLocal;
            this.setLocalBackupEventUsed(this.local);
            if (this.local) {
                this.localBackup();
            }
        }
    }

    public void doSystemBackup(Context cx) {
        BOrd ord = new BSystemBackupJob().submit(cx);
    }

    public void doLocalBackup(Context cx) {
        BOrd ord = new BLocalBackupJob().submit(cx);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (action.equals(restore)) {
            this.setRestoreInfo(STARTING);
            final Invocation invocation = new Invocation((BComponent)this, action, argument, cx);
            new Thread(){

                @Override
                public void run() {
                    invocation.run();
                }
            }.start();
        }
        return null;
    }

    public void doRestore(BOrd ord, Context cx) throws Exception {
        this.setRestoreInfo(RESTORING);
        try {
            BIFile file = (BIFile)ord.get();
            BBackupService service = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
            service.restoreFiles(file);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null) {
                message = e.toString();
            }
            this.setRestoreInfo(FAILED + message);
            throw e;
        }
        this.setRestoreInfo(COMPLETE);
    }

    public boolean generateAlert(String activityInfo, String jobLog) throws Exception {
        if (this.getAlarmInfo().getAlarmClass().equals(BOffAlarmClass.getAlarmClassName())) {
            return false;
        }
        BFacets facets = BFacets.make((String)"msgText", (BIDataValue)BString.make((String)activityInfo), (String)"jobLog", (BIDataValue)BString.make((String)jobLog));
        this.support.newAlert(facets);
        return true;
    }

    public BBoolean doAckAlarm(BAlarmRecord ackRequest) throws Exception {
        return BBoolean.make((boolean)this.support.ackAlarm(ackRequest));
    }
}

