/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.backup;

import com.tridium.backup.BBackupChannel;
import com.tridium.backup.BBackupRecord;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.smartTableHx.export.BExportFileWrapper;
import com.tridium.smartTableHx.export.ExportCommand;
import com.tridium.sys.station.BStationSaveJob;
import com.tridium.sys.station.Station;
import com.tridium.util.ThrowableUtil;
import com.tridium.util.TimeFormat;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.backup.BRemoteBackupChannel;
import com.tridiumx.entsec.backup.BSystemBackups;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.security.AccessController;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.backup.BBackupService;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.job.BJob;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.FileUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSystemBackupJob
extends BSimpleJob {
    public static final int LEVEL_NINE = 9;
    public static final Type TYPE = Sys.loadType(BSystemBackupJob.class);
    public static final boolean SCHEDULED = true;
    public static final boolean ENTIRE_SYSTEM = true;
    public static final boolean ARCHIVE = true;
    public static final boolean DOWNLOAD = true;
    private boolean scheduled = false;
    private boolean entireSystem = false;
    private boolean archive = false;
    private boolean download = false;
    private static boolean universalRun = false;
    public static final Logger LOG = Logger.getLogger("entsec");

    public Type getType() {
        return TYPE;
    }

    public BSystemBackupJob() {
        this(true);
    }

    public BSystemBackupJob(boolean entireSystem) {
        this(true, entireSystem, true, false);
    }

    public BSystemBackupJob(boolean scheduled, boolean entireSystem, boolean archive, boolean download) {
        this.scheduled = scheduled;
        this.entireSystem = entireSystem;
        this.archive = archive;
        this.download = download;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        boolean partial = false;
        File archiveFile = null;
        FilePath archiveFilePath = null;
        BExportFileWrapper wrapper = null;
        ZipOutputStream zipOutDownload = null;
        ZipOutputStream zipOutArchive = null;
        OutputStream out = null;
        InputStream in = null;
        Object outfile = null;
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        BSystemBackups systemBackups = null;
        try {
            BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
            systemBackups = service.getSystemBackups();
            if (!BEnterpriseSecurityService.isWorkstation() && this.archive) {
                throw new IllegalStateException("Must run System Backup on Workstation.");
            }
            if (universalRun) {
                throw new IllegalStateException("Only One Backup can run at a time...");
            }
            universalRun = true;
            String message = "Running Backup Job:";
            if (this.scheduled) {
                message = message + " scheduled,";
            }
            message = this.entireSystem ? message + " system," : message + " local,";
            if (this.archive) {
                message = message + " archive,";
            }
            if (this.download) {
                message = message + " download,";
            }
            this.log().message(message);
            this.progress(1);
            BAbsTime now = Clock.time();
            String sysName = SlotPath.escape((String)service.getSystemName(cx));
            if (sysName.length() == 0) {
                sysName = "entsec";
            }
            String archivePath = "~backups";
            if (this.scheduled) {
                archivePath = "~backups/scheduled";
            }
            String timestamp = TimeFormat.format((BAbsTime)now, (String)"YYMMDD_HHmm");
            String systemFileName = "backup_" + sysName + "_" + timestamp + ".zip";
            String partialSystemFileName = "backup_" + sysName + "_" + timestamp + "_partial.zip";
            String recordName = systemFileName;
            if (this.download && this.entireSystem && !this.archive) {
                wrapper = ExportCommand.makeExportFileWrapper((String)systemFileName);
                this.add(null, (BValue)wrapper);
                zipOutDownload = new ZipOutputStream(wrapper.getOutputStream());
                zipOutDownload.setMethod(8);
                zipOutDownload.setLevel(9);
            }
            if (this.entireSystem) {
                if (this.archive) {
                    archiveFilePath = new FilePath(archivePath + "/" + systemFileName);
                    FilePath fArchivePath = new FilePath(archivePath);
                    FilePath fArchiveFilePath = archiveFilePath;
                    AccessController.doPrivileged(() -> {
                        File f = BFileSystem.INSTANCE.pathToLocalFile(fArchivePath);
                        if (!f.exists()) {
                            f.mkdirs();
                        }
                        BFileSystem.INSTANCE.makeFile(fArchiveFilePath);
                        return null;
                    });
                    archiveFile = BFileSystem.INSTANCE.pathToLocalFile(archiveFilePath);
                    zipOutArchive = new ZipOutputStream(new FileOutputStream(archiveFile));
                    zipOutArchive.setMethod(8);
                    zipOutArchive.setLevel(9);
                }
                BNiagaraStation[] stations = service.getMonitorSysDefSecurity().getSecuritySubordinateStations();
                for (int i = 0; i < stations.length; ++i) {
                    if (!this.isAlive()) {
                        throw new InterruptedException("Job is canceled");
                    }
                    if (!stations[i].getEnabled()) {
                        this.log().message("Station is disabled, skipping Backup on subordinate Station:" + stations[i].getStationName());
                        continue;
                    }
                    this.log().start("Running Backup on subordinate Station:" + stations[i].getStationName());
                    this.progress((int)(10.0f + 20.0f * (float)i / (float)stations.length));
                    String interest = "" + TYPE + timestamp;
                    BFoxSession foxSession = RemoteUtil.getFoxSession(stations[i]);
                    try {
                        Object chan;
                        foxSession.engageNoRetry(interest);
                        if (foxSession.getConnection().session().isLegacyConnection()) {
                            chan = (BBackupChannel)foxSession.getConnection().getChannels().get("backup", BBackupChannel.TYPE);
                            in = chan.backup(true);
                        } else {
                            chan = (BRemoteBackupChannel)foxSession.getConnection().getChannels().get("remoteBackup", BRemoteBackupChannel.TYPE);
                            in = ((BRemoteBackupChannel)((Object)chan)).backup(true);
                        }
                        String stationName = foxSession.getStationName();
                        String fileName = "backup_" + stationName + "_" + timestamp + ".dist";
                        if (this.archive) {
                            zipOutArchive.putNextEntry(new ZipEntry(fileName));
                            FileUtil.pipe((InputStream)in, (OutputStream)zipOutArchive);
                            in.close();
                            zipOutArchive.closeEntry();
                        } else if (this.download && !this.archive) {
                            zipOutDownload.putNextEntry(new ZipEntry(fileName));
                            FileUtil.pipe((InputStream)in, (OutputStream)zipOutDownload);
                            in.close();
                            zipOutDownload.closeEntry();
                        }
                        this.log().success("Remote Backup complete.");
                        continue;
                    }
                    catch (InterruptedIOException | InterruptedException ie) {
                        throw ie;
                    }
                    catch (ConnectException ce) {
                        partial = true;
                        this.log().endFailed("Remote Backup cannot be completed because connection is down.");
                        LOG.log(Level.SEVERE, "Remote Backup cannot be completed because connection is down.", ce);
                        continue;
                    }
                    catch (Exception e) {
                        partial = true;
                        this.log().endFailed("Remote Backup cannot be completed, skipping this subordinate station.", (Throwable)e);
                        e.printStackTrace();
                        continue;
                    }
                    finally {
                        foxSession.disengage(interest);
                    }
                }
            }
            String stationName = Sys.getStation().getStationName();
            String fileName = "backup_" + stationName + "_" + timestamp + ".dist";
            if (!this.entireSystem) {
                recordName = fileName;
            }
            this.log().start("Running Backup on local station:" + stationName);
            this.progress(50);
            if (this.archive && this.entireSystem) {
                zipOutArchive.putNextEntry(new ZipEntry(fileName));
                out = zipOutArchive;
            } else if (this.archive && !this.entireSystem) {
                archiveFilePath = new FilePath(archivePath + "/" + fileName);
                FilePath fArchivePath = new FilePath(archivePath);
                FilePath fArchiveFilePath = archiveFilePath;
                AccessController.doPrivileged(() -> {
                    File f = BFileSystem.INSTANCE.pathToLocalFile(fArchivePath);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    BFileSystem.INSTANCE.makeFile(fArchiveFilePath);
                    return null;
                });
                archiveFile = BFileSystem.INSTANCE.pathToLocalFile(archiveFilePath);
                out = new BufferedOutputStream(new FileOutputStream(archiveFile));
            } else if (this.download && this.entireSystem) {
                zipOutDownload.putNextEntry(new ZipEntry(fileName));
                out = zipOutDownload;
            } else if (this.download && !this.entireSystem) {
                wrapper = ExportCommand.makeExportFileWrapper((String)fileName);
                this.add(null, (BValue)wrapper);
                out = wrapper.getOutputStream();
            }
            BStationSaveJob job = new BStationSaveJob();
            Station.saveSync((BJob)job);
            BBackupService backupService = (BBackupService)Sys.getService((Type)BBackupService.TYPE);
            backupService.zip(null, out, false);
            if (!this.archive && this.download && this.entireSystem) {
                zipOutDownload.closeEntry();
                zipOutDownload.finish();
                zipOutDownload.close();
                if (out != null) {
                    out.flush();
                    out.close();
                }
            } else if (!this.archive && this.download && !this.entireSystem) {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            } else if (this.archive && this.entireSystem) {
                zipOutArchive.closeEntry();
                zipOutArchive.finish();
                if (out != null) {
                    out.flush();
                    out.close();
                }
            } else if (this.archive && !this.entireSystem && out != null) {
                out.flush();
                out.close();
            }
            if (this.archive && this.download) {
                inputStream = new FileInputStream(archiveFile);
                String copyFileName = systemFileName;
                if (!this.entireSystem) {
                    copyFileName = fileName;
                }
                wrapper = ExportCommand.makeExportFileWrapper((String)copyFileName);
                outputStream = wrapper.getOutputStream();
                FileUtil.pipe((InputStream)inputStream, (OutputStream)outputStream);
                this.add(null, (BValue)wrapper);
                wrapper.closeOutput();
                inputStream.close();
                outputStream.close();
            }
            if (partial) {
                if (wrapper != null) {
                    wrapper.setFileName(partialSystemFileName);
                }
                if (this.archive) {
                    String localArchivePath = archivePath;
                    AccessController.doPrivileged(() -> {
                        BFileSystem.INSTANCE.move(new FilePath(localArchivePath + "/" + systemFileName), new FilePath(localArchivePath + "/" + partialSystemFileName));
                        return null;
                    });
                }
                if (this.scheduled && systemBackups != null) {
                    systemBackups.generateAlert("Partial scheduled backup:" + partialSystemFileName, this.log().encode());
                }
            }
            this.log().success("Local Backup complete.");
            this.setProgress(95);
            if (this.scheduled) {
                File file;
                int i;
                this.log().start("Running cleanup...");
                int systemLimit = systemBackups.getScheduledSystemBackupLimit();
                int localLimit = systemBackups.getScheduledLocalBackupLimit();
                String fArchivePath = archivePath;
                File scheduled = AccessController.doPrivileged(() -> BFileSystem.INSTANCE.pathToLocalFile(new FilePath(fArchivePath)));
                Array a = new Array((Object[])scheduled.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathName) {
                        return pathName.getName().endsWith(".zip");
                    }
                }));
                if (a.size() > systemLimit) {
                    a = a.sort((Comparator)new LastModifiedComparitor());
                    for (i = systemLimit; i < a.size(); ++i) {
                        file = (File)a.get(i);
                        AccessController.doPrivileged(() -> {
                            FileUtil.delete((File)file);
                            return null;
                        });
                    }
                }
                if ((a = new Array((Object[])scheduled.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathName) {
                        return !pathName.getName().endsWith(".zip");
                    }
                }))).size() > localLimit) {
                    a = a.sort((Comparator)new LastModifiedComparitor());
                    for (i = localLimit; i < a.size(); ++i) {
                        file = (File)a.get(i);
                        AccessController.doPrivileged(() -> {
                            FileUtil.delete((File)file);
                            return null;
                        });
                    }
                }
                this.log().success("Cleanup Complete.");
                this.progress(97);
            }
            BBackupRecord rec = new BBackupRecord();
            rec.setTimestamp(now);
            rec.setHost(Sys.getHostName());
            if (this.download && this.archive) {
                rec.setPath("archive/hx:" + recordName);
            } else if (this.download) {
                rec.setPath("hx:" + recordName);
            } else if (this.archive) {
                rec.setPath("archive:" + recordName);
            }
            if (this.scheduled) {
                rec.setUser("scheduled");
            } else if (cx.getUser() != null) {
                rec.setUser(cx.getUser().toString());
            }
            rec.append((BBackupService)Sys.getService((Type)BBackupService.TYPE));
            this.progress(100);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (systemBackups != null) {
                systemBackups.generateAlert("Backup could not be completed: " + ThrowableUtil.dumpToString((Throwable)e), this.log().encode());
            }
            throw e;
        }
        finally {
            universalRun = false;
            if (zipOutDownload != null) {
                zipOutDownload.close();
            }
            if (zipOutArchive != null) {
                zipOutArchive.close();
            }
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    public static class LastModifiedComparitor
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 1L;

        public int compare(Object o1, Object o2) {
            return Long.valueOf(((File)o2).lastModified()).compareTo(((File)o1).lastModified());
        }
    }
}

