/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.app;

import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.app.BIEntsecApp;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public abstract class EntsecAppUtil {
    public static void installApps() {
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        BOrdList ordList = BOrdList.DEFAULT;
        TypeInfo[] entsecAppTypes = Sys.getRegistry().getConcreteTypes(BIEntsecApp.TYPE.getTypeInfo());
        for (int i = 0; i < entsecAppTypes.length; ++i) {
            BIEntsecApp entsecApp = (BIEntsecApp)entsecAppTypes[i].getTypeSpec().getInstance();
            if (!entsecApp.installApp()) continue;
            try {
                Sys.getService((Type)entsecApp.getType());
            }
            catch (ServiceNotFoundException e) {
                service.getParent().asComponent().add(null, (BValue)entsecApp);
                service.newlyInstalledApps = BOrdList.add((BOrdList)service.newlyInstalledApps, (BOrd)BOrd.make((String)("service:" + entsecApp.getType())));
            }
            ordList = BOrdList.add((BOrdList)ordList, (BOrd)BOrd.make((String)("service:" + entsecApp.getType())));
        }
    }

    public static boolean isEntsecAppNew(BTypeSpec typeSpec) {
        BOrd ord = BOrd.make((String)("service:" + typeSpec));
        BEnterpriseSecurityService service = (BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE);
        if (service.newlyInstalledApps.equals((Object)BOrdList.DEFAULT)) {
            return false;
        }
        BOrd[] ords = service.newlyInstalledApps.toArray();
        for (int i = 0; i < ords.length; ++i) {
            if (!ords[i].equals((Object)ord)) continue;
            return true;
        }
        return false;
    }
}

