/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache.data;

import com.tridiumx.entsec.access.orion.BValidationBits;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.util.dbCache.data.AbstractCacheData;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.util.BUuid;

public class WiegandFormatCacheData
extends AbstractCacheData {
    private String wiegandFormatName = "";
    private String facilityCode = "";
    private int bitLength = 0;
    private int credentialStart = 0;
    private int credentialLength = 1;
    private int facilityStart = 0;
    private int facilityLength = 0;
    private int parityBits = 0;
    private String format = "";
    private String parity = "";
    private int validationBits = 0;

    private WiegandFormatCacheData() {
        this.init();
    }

    private WiegandFormatCacheData(BWiegandFormat rec) {
        this.setData(rec);
    }

    public static WiegandFormatCacheData make() {
        return new WiegandFormatCacheData();
    }

    public static WiegandFormatCacheData make(BWiegandFormat rec) {
        return new WiegandFormatCacheData(rec);
    }

    private void init() {
        BValue value = null;
        value = BWiegandFormat.wiegandFormatName.getDefaultValue();
        if (value instanceof BString) {
            this.setWiegandFormatName(((BString)value).getString());
        }
        if ((value = BWiegandFormat.facilityCode.getDefaultValue()) instanceof BString) {
            this.setFacilityCode(((BString)value).getString());
        }
        if ((value = BWiegandFormat.bitLength.getDefaultValue()) instanceof BInteger) {
            this.setBitLength(((BInteger)value).getInt());
        }
        if ((value = BWiegandFormat.credentialStart.getDefaultValue()) instanceof BInteger) {
            this.setCredentialStart(((BInteger)value).getInt());
        }
        if ((value = BWiegandFormat.credentialLength.getDefaultValue()) instanceof BInteger) {
            this.setCredentialLength(((BInteger)value).getInt());
        }
        if ((value = BWiegandFormat.facilityStart.getDefaultValue()) instanceof BInteger) {
            this.setFacilityStart(((BInteger)value).getInt());
        }
        if ((value = BWiegandFormat.facilityLength.getDefaultValue()) instanceof BInteger) {
            this.setFacilityLength(((BInteger)value).getInt());
        }
        if ((value = BWiegandFormat.parityBits.getDefaultValue()) instanceof BInteger) {
            this.setParityBits(((BInteger)value).getInt());
        }
        if ((value = BWiegandFormat.format.getDefaultValue()) instanceof BString) {
            this.setFormat(((BString)value).getString());
        }
        if ((value = BWiegandFormat.parity.getDefaultValue()) instanceof BString) {
            this.setParity(((BString)value).getString());
        }
        if ((value = BWiegandFormat.validationBits.getDefaultValue()) instanceof BValidationBits) {
            this.setValidationBits((BValidationBits)value);
        }
    }

    public void setData(BWiegandFormat rec) {
        this.setWiegandFormatName(rec.getWiegandFormatName());
        this.setFacilityCode(rec.getFacilityCode());
        this.setBitLength(rec.getBitLength());
        this.setCredentialStart(rec.getCredentialStart());
        this.setCredentialLength(rec.getCredentialLength());
        this.setFacilityStart(rec.getFacilityStart());
        this.setFacilityLength(rec.getFacilityLength());
        this.setParityBits(rec.getParityBits());
        this.setFormat(rec.getFormat());
        this.setParity(rec.getParity());
        this.setValidationBits(rec.getValidationBits());
    }

    public String getWiegandFormatName() {
        return this.wiegandFormatName;
    }

    public void setWiegandFormatName(String value) {
        this.wiegandFormatName = value;
    }

    public String getFacilityCode() {
        return this.facilityCode;
    }

    public void setFacilityCode(String value) {
        this.facilityCode = value;
    }

    public int getBitLength() {
        return this.bitLength;
    }

    public void setBitLength(int value) {
        this.bitLength = value;
    }

    public int getCredentialStart() {
        return this.credentialStart;
    }

    public void setCredentialStart(int value) {
        this.credentialStart = value;
    }

    public int getCredentialLength() {
        return this.credentialLength;
    }

    public void setCredentialLength(int value) {
        this.credentialLength = value;
    }

    public int getFacilityStart() {
        return this.facilityStart;
    }

    public void setFacilityStart(int value) {
        this.facilityStart = value;
    }

    public int getFacilityLength() {
        return this.facilityLength;
    }

    public void setFacilityLength(int value) {
        this.facilityLength = value;
    }

    public int getParityBits() {
        return this.parityBits;
    }

    public void setParityBits(int value) {
        this.parityBits = value;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String value) {
        this.format = value;
    }

    public String getParity() {
        return this.parity;
    }

    public void setParity(String value) {
        this.parity = value;
    }

    public BValidationBits getValidationBits() {
        return BValidationBits.make(this.validationBits);
    }

    public void setValidationBits(BValidationBits value) {
        this.validationBits = value.getOrdinal();
    }

    public BWiegandFormat getWiegandFormat(BUuid wiegandFormatUuid) {
        BWiegandFormat wiegandFormat = new BWiegandFormat();
        wiegandFormat.setWiegandFormatId(wiegandFormatUuid);
        wiegandFormat.setWiegandFormatName(this.wiegandFormatName);
        wiegandFormat.setFacilityCode(this.facilityCode);
        wiegandFormat.setBitLength(this.bitLength);
        wiegandFormat.setCredentialStart(this.credentialStart);
        wiegandFormat.setCredentialLength(this.credentialLength);
        wiegandFormat.setFacilityStart(this.facilityStart);
        wiegandFormat.setFacilityLength(this.facilityLength);
        wiegandFormat.setParityBits(this.parityBits);
        wiegandFormat.setFormat(this.format);
        wiegandFormat.setParity(this.parity);
        wiegandFormat.setValidationBits(this.getValidationBits());
        wiegandFormat.clearAllModified();
        return wiegandFormat;
    }

    @Override
    public boolean isEmpty() {
        return this.getWiegandFormatName() == null || this.getWiegandFormatName().length() == 0;
    }
}

