/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache.data;

import com.tridium.orion.OrionSession;
import com.tridium.orion.priv.model.BDynamicOrionObject;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BSupervisorZoneJoin;
import com.tridiumx.entsec.access.util.dbCache.AccessZoneCache;
import com.tridiumx.entsec.access.util.dbCache.data.AbstractCacheData;
import com.tridiumx.entsec.access.util.dbCache.data.BPersonData;
import com.tridiumx.entsec.access.util.dbCache.data.PersonAccessRightCacheData;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.util.BUuid;

public class PersonCacheData
extends AbstractCacheData {
    private static final Map.Entry[] EMPTY_MAP_ENTRY_ARRAY = new Map.Entry[0];
    private static final BUuid[] EMPTY_BUUID_ARRAY = new BUuid[0];
    private static ReentrantReadWriteLock accessRightRWLock = new ReentrantReadWriteLock();
    private static ReentrantReadWriteLock personZoneRWLock = new ReentrantReadWriteLock();
    private static ReentrantReadWriteLock supervisorZoneRWLock = new ReentrantReadWriteLock();
    private String displayString = "";
    private String pinNumber = null;
    private boolean supervisor = false;
    private boolean traceCard = false;
    private Map accessRightsMap = new HashMap();
    private Map personZonesMap = new HashMap();
    private Map supervisorZonesMap = new HashMap();
    private boolean pinKnown;

    public PersonCacheData() {
    }

    public PersonCacheData(BPerson rec) {
        this.setPersonData(rec);
    }

    public PersonCacheData(BDynamicOrionObject rec, OrionSession session) {
        this.setPersonData(rec, session);
    }

    public PersonCacheData(BPersonAccJoin personAccJoin) {
        this.insertAccessRight(personAccJoin);
    }

    public PersonCacheData(BPerson rec, BPersonAccJoin personAccJoin) {
        this.setPersonData(rec);
        this.insertAccessRight(personAccJoin);
    }

    public PersonCacheData(BPersonZoneJoin zoneJoin) {
        this.insertPersonZone(zoneJoin);
    }

    public PersonCacheData(BPerson rec, BPersonZoneJoin zoneJoin) {
        this.setPersonData(rec);
        this.insertPersonZone(zoneJoin);
    }

    public PersonCacheData(BSupervisorZoneJoin zoneJoin) {
        this.insertSupervisorZone(zoneJoin);
    }

    public PersonCacheData(BPerson rec, BSupervisorZoneJoin zoneJoin) {
        this.setPersonData(rec);
        this.insertSupervisorZone(zoneJoin);
    }

    public void setPersonData(BPerson rec) {
        this.setDisplayString(rec.toDisplayString(null));
        BPassword pin = rec.getPinNumber();
        if (pin != null && !pin.isDefault()) {
            this.setPinNumber(pin);
        }
        this.setSupervisor(rec.getSupervisor());
        this.setTraceCard(rec.getTraceCard());
    }

    public void setPersonData(BDynamicOrionObject rec, OrionSession session) {
        this.setDisplayString(rec.toDisplayString(null));
        this.setPinNumber(BPassword.make((String)rec.get(session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.pinNumber)).toString()));
        this.setSupervisor(rec.get(session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.supervisor)).toString().equals("true"));
        this.setTraceCard(rec.get(session.getOrionDatabase().getColumnName(BPerson.ORION_TYPE, BPerson.traceCard)).toString().equals("true"));
    }

    public void insertAccessRight(BPersonAccJoin personAccJoin) {
        if (personAccJoin != null && !personAccJoin.isNull()) {
            PersonCacheData.getWriteLock(accessRightRWLock);
            try {
                PersonAccessRightCacheData data = (PersonAccessRightCacheData)this.accessRightsMap.get((BUuid)personAccJoin.getAccessRight().getId());
                if (data == null) {
                    data = new PersonAccessRightCacheData(personAccJoin);
                } else {
                    data.setData(personAccJoin);
                }
                this.addAccessRightEntry((BUuid)personAccJoin.getAccessRight().getId(), data);
            }
            finally {
                PersonCacheData.releaseWriteLock(accessRightRWLock);
            }
        }
    }

    private void addAccessRightEntry(BUuid key, PersonAccessRightCacheData data) {
        PersonCacheData.getWriteLock(accessRightRWLock);
        try {
            if (!data.isEmpty()) {
                this.accessRightsMap.put(key, data);
            } else {
                this.deleteAccessRight(key);
            }
        }
        finally {
            PersonCacheData.releaseWriteLock(accessRightRWLock);
        }
    }

    public void deleteAccessRight(BUuid accessRightUuid) {
        PersonCacheData.getWriteLock(accessRightRWLock);
        try {
            this.accessRightsMap.remove(accessRightUuid);
        }
        finally {
            PersonCacheData.releaseWriteLock(accessRightRWLock);
        }
    }

    public void insertPersonZone(BPersonZoneJoin zoneJoin) {
        if (zoneJoin != null && !zoneJoin.isNull()) {
            PersonCacheData.getWriteLock(personZoneRWLock);
            try {
                PersonZoneCacheData data = (PersonZoneCacheData)this.personZonesMap.get((BUuid)zoneJoin.getAccessZone().getId());
                if (data == null) {
                    data = new PersonZoneCacheData(zoneJoin);
                    if (!data.isEmpty()) {
                        AccessZoneCache.incrementAccessZonePersonCount((BUuid)zoneJoin.getAccessZone().getId());
                        this.incrementAccessZoneSupervisorCount((BUuid)zoneJoin.getAccessZone().getId());
                    }
                } else {
                    data.setData(zoneJoin);
                }
                this.addPersonZoneEntry((BUuid)zoneJoin.getAccessZone().getId(), data);
            }
            finally {
                PersonCacheData.releaseWriteLock(personZoneRWLock);
            }
        }
    }

    private void addPersonZoneEntry(BUuid key, PersonZoneCacheData data) {
        PersonCacheData.getWriteLock(personZoneRWLock);
        try {
            if (!data.isEmpty()) {
                this.personZonesMap.put(key, data);
            } else {
                this.deletePersonZone(key);
            }
        }
        finally {
            PersonCacheData.releaseWriteLock(personZoneRWLock);
        }
    }

    public void deletePersonZone(BUuid accessZoneUuid) {
        PersonCacheData.getWriteLock(personZoneRWLock);
        try {
            if (this.personZonesMap.remove(accessZoneUuid) != null) {
                AccessZoneCache.decrementAccessZonePersonCount(accessZoneUuid);
                this.decrementAccessZoneSupervisorCount(accessZoneUuid);
            }
        }
        finally {
            PersonCacheData.releaseWriteLock(personZoneRWLock);
        }
    }

    public void insertSupervisorZone(BSupervisorZoneJoin zoneJoin) {
        if (zoneJoin != null && !zoneJoin.isNull()) {
            PersonCacheData.getWriteLock(supervisorZoneRWLock);
            try {
                SupervisorZoneCacheData data = (SupervisorZoneCacheData)this.supervisorZonesMap.get((BUuid)zoneJoin.getAccessZone().getId());
                if (data == null) {
                    data = new SupervisorZoneCacheData(zoneJoin);
                    if (!data.isEmpty()) {
                        this.incrementSupervisorsInZone((BUuid)zoneJoin.getAccessZone().getId());
                    }
                } else {
                    data.setData(zoneJoin);
                }
                this.addSupervisorZoneEntry((BUuid)zoneJoin.getAccessZone().getId(), data);
            }
            finally {
                PersonCacheData.releaseWriteLock(supervisorZoneRWLock);
            }
        }
    }

    private void addSupervisorZoneEntry(BUuid key, SupervisorZoneCacheData data) {
        PersonCacheData.getWriteLock(supervisorZoneRWLock);
        try {
            if (!data.isEmpty()) {
                this.supervisorZonesMap.put(key, data);
            } else {
                this.deleteSupervisorZone(key);
            }
        }
        finally {
            PersonCacheData.releaseWriteLock(supervisorZoneRWLock);
        }
    }

    public void deleteSupervisorZone(BUuid accessZoneUuid) {
        PersonCacheData.getWriteLock(supervisorZoneRWLock);
        try {
            if (this.supervisorZonesMap.remove(accessZoneUuid) != null) {
                this.decrementSupervisorsInZone(accessZoneUuid);
            }
        }
        finally {
            PersonCacheData.releaseWriteLock(supervisorZoneRWLock);
        }
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public void setDisplayString(String value) {
        this.displayString = value != null && value.length() > 0 ? value : "";
    }

    public BPassword getPinNumber() {
        if (this.pinNumber == null) {
            return BPassword.DEFAULT;
        }
        return BPassword.make((String)this.pinNumber);
    }

    public String getPinNumberAsText() {
        return this.pinNumber == null ? "" : this.pinNumber;
    }

    public void setPinNumber(BPassword value) {
        this.pinNumber = value != null && !value.isNull() ? AccessController.doPrivileged(() -> ((BPassword)value).getValue()) : null;
    }

    public boolean getSupervisor() {
        return this.supervisor;
    }

    public void setSupervisor(boolean value) {
        this.supervisor = value;
    }

    public boolean getTraceCard() {
        return this.traceCard;
    }

    public void setTraceCard(boolean value) {
        this.traceCard = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry[] getAccessRightJoins(BAbsTime time, boolean filterValidDate) {
        PersonCacheData.getReadLock(accessRightRWLock);
        try {
            if (this.accessRightsMap.isEmpty()) {
                Map.Entry[] entryArray = EMPTY_MAP_ENTRY_ARRAY;
                return entryArray;
            }
            Array arr = new Array(Map.Entry.class);
            Set set = this.accessRightsMap.entrySet();
            for (Map.Entry me : set) {
                PersonAccessRightCacheData data;
                BUuid accessRightUuid = (BUuid)me.getKey();
                if (accessRightUuid == null || accessRightUuid.equals((Object)BUuid.DEFAULT) || filterValidDate && !PersonCacheData.isValidDate(data = (PersonAccessRightCacheData)me.getValue(), time)) continue;
                arr.add(me);
            }
            Map.Entry[] entryArray = (Map.Entry[])arr.trim();
            return entryArray;
        }
        finally {
            PersonCacheData.releaseReadLock(accessRightRWLock);
        }
    }

    public boolean containsAccessRight(BUuid key) {
        PersonCacheData.getReadLock(accessRightRWLock);
        try {
            boolean bl = this.accessRightsMap.containsKey(key);
            return bl;
        }
        finally {
            PersonCacheData.releaseReadLock(accessRightRWLock);
        }
    }

    public int getAccessRightsSize() {
        PersonCacheData.getReadLock(accessRightRWLock);
        try {
            int n = this.accessRightsMap.size();
            return n;
        }
        finally {
            PersonCacheData.releaseReadLock(accessRightRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BUuid[] getPersonZoneUuids() {
        PersonCacheData.getReadLock(personZoneRWLock);
        try {
            if (this.personZonesMap.isEmpty()) {
                BUuid[] bUuidArray = EMPTY_BUUID_ARRAY;
                return bUuidArray;
            }
            Array arr = new Array(BUuid.class);
            Set set = this.personZonesMap.entrySet();
            for (Map.Entry me : set) {
                BUuid accessZoneUuid = (BUuid)me.getKey();
                if (accessZoneUuid == null || accessZoneUuid.equals((Object)BUuid.DEFAULT)) continue;
                arr.add((Object)accessZoneUuid);
            }
            BUuid[] bUuidArray = (BUuid[])arr.trim();
            return bUuidArray;
        }
        finally {
            PersonCacheData.releaseReadLock(personZoneRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getPersonZoneLastModified(BUuid accessZoneUuid) {
        PersonCacheData.getReadLock(personZoneRWLock);
        try {
            PersonZoneCacheData data = (PersonZoneCacheData)this.personZonesMap.get(accessZoneUuid);
            if (data == null) {
                BAbsTime bAbsTime = null;
                return bAbsTime;
            }
            BAbsTime bAbsTime = data.getLastModified();
            return bAbsTime;
        }
        finally {
            PersonCacheData.releaseReadLock(personZoneRWLock);
        }
    }

    public boolean containsPersonZone(BUuid key) {
        PersonCacheData.getReadLock(personZoneRWLock);
        try {
            boolean bl = this.personZonesMap.containsKey(key);
            return bl;
        }
        finally {
            PersonCacheData.releaseReadLock(personZoneRWLock);
        }
    }

    public int getPersonZonesSize() {
        PersonCacheData.getReadLock(personZoneRWLock);
        try {
            int n = this.personZonesMap.size();
            return n;
        }
        finally {
            PersonCacheData.releaseReadLock(personZoneRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BUuid[] getSupervisorZoneUuids() {
        PersonCacheData.getReadLock(supervisorZoneRWLock);
        try {
            if (this.supervisorZonesMap.isEmpty()) {
                BUuid[] bUuidArray = EMPTY_BUUID_ARRAY;
                return bUuidArray;
            }
            Array arr = new Array(BUuid.class);
            Set set = this.supervisorZonesMap.entrySet();
            for (Map.Entry me : set) {
                BUuid accessZoneUuid = (BUuid)me.getKey();
                if (accessZoneUuid == null || accessZoneUuid.equals((Object)BUuid.DEFAULT)) continue;
                arr.add((Object)accessZoneUuid);
            }
            BUuid[] bUuidArray = (BUuid[])arr.trim();
            return bUuidArray;
        }
        finally {
            PersonCacheData.releaseReadLock(supervisorZoneRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAbsTime getSupervisorZoneLastModified(BUuid accessZoneUuid) {
        PersonCacheData.getReadLock(supervisorZoneRWLock);
        try {
            SupervisorZoneCacheData data = (SupervisorZoneCacheData)this.supervisorZonesMap.get(accessZoneUuid);
            if (data == null) {
                BAbsTime bAbsTime = null;
                return bAbsTime;
            }
            BAbsTime bAbsTime = data.getLastModified();
            return bAbsTime;
        }
        finally {
            PersonCacheData.releaseReadLock(supervisorZoneRWLock);
        }
    }

    public boolean containsSupervisorZone(BUuid key) {
        PersonCacheData.getReadLock(supervisorZoneRWLock);
        try {
            boolean bl = this.supervisorZonesMap.containsKey(key);
            return bl;
        }
        finally {
            PersonCacheData.releaseReadLock(supervisorZoneRWLock);
        }
    }

    public int getSupervisorZonesSize() {
        PersonCacheData.getReadLock(supervisorZoneRWLock);
        try {
            int n = this.supervisorZonesMap.size();
            return n;
        }
        finally {
            PersonCacheData.releaseReadLock(supervisorZoneRWLock);
        }
    }

    private void incrementAccessZoneSupervisorCount(BUuid accessZoneUuid) {
        PersonCacheData.getReadLock(supervisorZoneRWLock);
        try {
            SupervisorZoneCacheData data = (SupervisorZoneCacheData)this.supervisorZonesMap.get(accessZoneUuid);
            if (data != null) {
                AccessZoneCache.incrementAccessZoneSupervisorCount(accessZoneUuid);
            }
        }
        finally {
            PersonCacheData.releaseReadLock(supervisorZoneRWLock);
        }
    }

    private void decrementAccessZoneSupervisorCount(BUuid accessZoneUuid) {
        PersonCacheData.getReadLock(supervisorZoneRWLock);
        try {
            SupervisorZoneCacheData data = (SupervisorZoneCacheData)this.supervisorZonesMap.get(accessZoneUuid);
            if (data != null) {
                AccessZoneCache.decrementAccessZoneSupervisorCount(accessZoneUuid);
            }
        }
        finally {
            PersonCacheData.releaseReadLock(supervisorZoneRWLock);
        }
    }

    private void incrementSupervisorsInZone(BUuid accessZoneUuid) {
        PersonCacheData.getReadLock(personZoneRWLock);
        try {
            PersonZoneCacheData data = (PersonZoneCacheData)this.personZonesMap.get(accessZoneUuid);
            if (data != null) {
                AccessZoneCache.incrementAccessZoneSupervisorCount(accessZoneUuid);
            }
        }
        finally {
            PersonCacheData.releaseReadLock(personZoneRWLock);
        }
    }

    private void decrementSupervisorsInZone(BUuid accessZoneUuid) {
        PersonCacheData.getReadLock(personZoneRWLock);
        try {
            PersonZoneCacheData data = (PersonZoneCacheData)this.personZonesMap.get(accessZoneUuid);
            if (data != null) {
                AccessZoneCache.decrementAccessZoneSupervisorCount(accessZoneUuid);
            }
        }
        finally {
            PersonCacheData.releaseReadLock(personZoneRWLock);
        }
    }

    public BPersonData getPerson(BUuid uuid) {
        return new BPersonData(uuid, this);
    }

    @Override
    public boolean isEmpty() {
        return this.displayString == null || this.displayString.length() == 0;
    }

    private static boolean isValidDate(PersonAccessRightCacheData data, BAbsTime time) {
        BAbsTime startDate = data.getStartDate();
        BAbsTime endDate = data.getEndDate();
        if (startDate.equals((Object)BAbsTime.DEFAULT) && endDate.equals((Object)BAbsTime.DEFAULT)) {
            return true;
        }
        return !startDate.equals((Object)BAbsTime.DEFAULT) && !endDate.equals((Object)BAbsTime.DEFAULT) ? !startDate.isAfter(time) && !endDate.isBefore(time) : (!startDate.equals((Object)BAbsTime.DEFAULT) ? !startDate.isAfter(time) : !endDate.equals((Object)BAbsTime.DEFAULT) && !endDate.isBefore(time));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMap() {
        BUuid[] uuids;
        Object data;
        int i;
        PersonCacheData.getReadLock(accessRightRWLock);
        try {
            Map.Entry[] mapEntries = this.getAccessRightJoins(BAbsTime.DEFAULT, false);
            if (mapEntries.length == 0) {
                System.out.println("    <No Access Rights>");
            } else {
                if (mapEntries.length == 1) {
                    System.out.println("    Access Right:");
                } else {
                    System.out.println("    Access Rights:");
                }
                for (i = 0; i < mapEntries.length; ++i) {
                    data = (PersonAccessRightCacheData)mapEntries[i].getValue();
                    if (data != null) {
                        System.out.println("      " + mapEntries[i].getKey().toString() + " Start Date: " + ((PersonAccessRightCacheData)data).getStartDate() + " End Date: " + ((PersonAccessRightCacheData)data).getEndDate() + " Assigned Threat Level: " + ((PersonAccessRightCacheData)data).getAssignedThreatLevel());
                        continue;
                    }
                    System.out.println("      " + mapEntries[i].getKey().toString());
                }
            }
        }
        finally {
            PersonCacheData.releaseReadLock(accessRightRWLock);
        }
        PersonCacheData.getReadLock(personZoneRWLock);
        try {
            uuids = this.getPersonZoneUuids();
            if (uuids.length == 0) {
                System.out.println("    <No Person Zones>");
            } else {
                if (uuids.length == 1) {
                    System.out.println("    Person Zone:");
                } else {
                    System.out.println("    Person Zones:");
                }
                for (i = 0; i < uuids.length; ++i) {
                    data = (PersonZoneCacheData)this.personZonesMap.get(uuids[i]);
                    if (data != null) {
                        System.out.println("      " + uuids[i].toString() + " Last Modified: " + ((PersonZoneCacheData)data).getLastModified());
                        continue;
                    }
                    System.out.println("      " + uuids[i].toString());
                }
            }
        }
        finally {
            PersonCacheData.releaseReadLock(personZoneRWLock);
        }
        PersonCacheData.getReadLock(supervisorZoneRWLock);
        try {
            uuids = this.getSupervisorZoneUuids();
            if (uuids.length == 0) {
                System.out.println("    <No Supervisor Zones>");
            } else {
                if (uuids.length == 1) {
                    System.out.println("    Supervisor Zone:");
                } else {
                    System.out.println("    Supervisor Zones:");
                }
                for (i = 0; i < uuids.length; ++i) {
                    data = (SupervisorZoneCacheData)this.supervisorZonesMap.get(uuids[i]);
                    if (data != null) {
                        System.out.println("      " + uuids[i].toString() + " Last Modified: " + ((SupervisorZoneCacheData)data).getLastModified());
                        continue;
                    }
                    System.out.println("      " + uuids[i].toString());
                }
            }
        }
        finally {
            PersonCacheData.releaseReadLock(supervisorZoneRWLock);
        }
    }

    public boolean isPinKnown() {
        return this.pinKnown;
    }

    public void setPinKnown(boolean pinKnown) {
        this.pinKnown = pinKnown;
    }

    private class SupervisorZoneCacheData {
        private BAbsTime lastModified = BAbsTime.NULL;

        private SupervisorZoneCacheData(BSupervisorZoneJoin zoneJoin) {
            this.setData(zoneJoin);
        }

        private void setData(BSupervisorZoneJoin zoneJoin) {
            this.setLastModified(zoneJoin.getLastModified());
        }

        private BAbsTime getLastModified() {
            return this.lastModified;
        }

        private void setLastModified(BAbsTime value) {
            this.lastModified = value != null && !value.isNull() && !value.equals((Object)BAbsTime.NULL) ? value : BAbsTime.NULL;
        }

        private boolean isEmpty() {
            return false;
        }
    }

    private class PersonZoneCacheData {
        private BAbsTime lastModified = BAbsTime.NULL;

        private PersonZoneCacheData(BPersonZoneJoin zoneJoin) {
            this.setData(zoneJoin);
        }

        private void setData(BPersonZoneJoin zoneJoin) {
            this.setLastModified(zoneJoin.getLastModified());
        }

        private BAbsTime getLastModified() {
            return this.lastModified;
        }

        private void setLastModified(BAbsTime value) {
            this.lastModified = value != null && !value.isNull() && !value.equals((Object)BAbsTime.NULL) ? value : BAbsTime.NULL;
        }

        private boolean isEmpty() {
            return false;
        }
    }
}

