/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.BadgeCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.WiegandFormatCacheData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.util.BUuid;

public abstract class WiegandFormatCache
extends AbstractCache {
    private static final BWiegandFormat[] EMPTY_WIEGAND_FORMAT_ARRAY = new BWiegandFormat[0];
    private static final WiegandFormatCacheData[] EMPTY_WIEGAND_FORMAT_DATA_ARRAY = new WiegandFormatCacheData[0];
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map wiegandFormatsMap = new HashMap();

    public static void initWiegandFormats(DbCache dbCache, OrionSession session) {
        WiegandFormatCache.getWriteLock(rwLock);
        try {
            wiegandFormatsMap.clear();
        }
        finally {
            WiegandFormatCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BWiegandFormat.ORION_TYPE);
            while (cursor.next()) {
                BWiegandFormat rec = (BWiegandFormat)cursor.get();
                WiegandFormatCache.insertWiegandFormat(dbCache, rec, session);
            }
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertWiegandFormat(DbCache dbCache, BWiegandFormat rec, OrionSession session) {
        boolean rebuildBadges = false;
        if (!dbCache.isRunningOnSupervisor()) {
            WiegandFormatCache.getWriteLock(rwLock);
            try {
                WiegandFormatCacheData data = WiegandFormatCache.getCacheData(rec.getWiegandFormatId());
                if (data == null) {
                    data = WiegandFormatCacheData.make(rec);
                } else {
                    if (!data.getValidationBits().equals((Object)rec.getValidationBits())) {
                        rebuildBadges = true;
                    }
                    data.setData(rec);
                }
                WiegandFormatCache.addMapEntry(rec.getWiegandFormatId(), data);
            }
            finally {
                WiegandFormatCache.releaseWriteLock(rwLock);
            }
            if (rebuildBadges) {
                BadgeCache.initBadges(dbCache, session);
            }
        }
    }

    public static void updateWiegandFormat(DbCache dbCache, BWiegandFormat rec, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            WiegandFormatCache.insertWiegandFormat(dbCache, rec, session);
        }
    }

    public static void deleteWiegandFormat(DbCache dbCache, BWiegandFormat rec, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            WiegandFormatCache.removeWiegandFormat(rec.getWiegandFormatId());
        }
    }

    private static void removeWiegandFormat(BUuid key) {
        WiegandFormatCache.getWriteLock(rwLock);
        try {
            wiegandFormatsMap.remove(key);
        }
        finally {
            WiegandFormatCache.releaseWriteLock(rwLock);
        }
    }

    public static WiegandFormatCacheData getCacheData(BUuid wiegandFormatUuid) {
        if (wiegandFormatUuid == null) {
            return null;
        }
        WiegandFormatCache.getReadLock(rwLock);
        try {
            WiegandFormatCacheData wiegandFormatCacheData = (WiegandFormatCacheData)wiegandFormatsMap.get(wiegandFormatUuid);
            return wiegandFormatCacheData;
        }
        finally {
            WiegandFormatCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BWiegandFormat[] getWiegandFormats() {
        WiegandFormatCache.getReadLock(rwLock);
        try {
            Set set = wiegandFormatsMap.entrySet();
            if (set.isEmpty()) {
                BWiegandFormat[] bWiegandFormatArray = EMPTY_WIEGAND_FORMAT_ARRAY;
                return bWiegandFormatArray;
            }
            Array arr = new Array(BWiegandFormat.class);
            for (Map.Entry me : set) {
                BWiegandFormat wiegandFormat;
                WiegandFormatCacheData data = (WiegandFormatCacheData)me.getValue();
                if (data == null || (wiegandFormat = data.getWiegandFormat((BUuid)me.getKey())) == null) continue;
                arr.add((Object)wiegandFormat);
            }
            BWiegandFormat[] bWiegandFormatArray = (BWiegandFormat[])arr.trim();
            return bWiegandFormatArray;
        }
        finally {
            WiegandFormatCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WiegandFormatCacheData[] getWiegandFormatDataArr() {
        WiegandFormatCache.getReadLock(rwLock);
        try {
            Set set = wiegandFormatsMap.entrySet();
            if (set.isEmpty()) {
                WiegandFormatCacheData[] wiegandFormatCacheDataArray = EMPTY_WIEGAND_FORMAT_DATA_ARRAY;
                return wiegandFormatCacheDataArray;
            }
            Array arr = new Array(WiegandFormatCacheData.class);
            for (Map.Entry me : set) {
                WiegandFormatCacheData data = (WiegandFormatCacheData)me.getValue();
                if (data == null) continue;
                arr.add((Object)data);
            }
            WiegandFormatCacheData[] wiegandFormatCacheDataArray = (WiegandFormatCacheData[])arr.trim();
            return wiegandFormatCacheDataArray;
        }
        finally {
            WiegandFormatCache.releaseReadLock(rwLock);
        }
    }

    public static BWiegandFormat getWiegandFormat(BUuid wiegandFormatUuid) {
        WiegandFormatCacheData cacheData = WiegandFormatCache.getCacheData(wiegandFormatUuid);
        if (cacheData == null) {
            return null;
        }
        return cacheData.getWiegandFormat(wiegandFormatUuid);
    }

    private static void addMapEntry(BUuid key, WiegandFormatCacheData data) {
        WiegandFormatCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                wiegandFormatsMap.put(key, data);
            } else {
                WiegandFormatCache.removeWiegandFormat(key);
            }
        }
        finally {
            WiegandFormatCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        WiegandFormatCache.getReadLock(rwLock);
        try {
            int n = wiegandFormatsMap.size();
            return n;
        }
        finally {
            WiegandFormatCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        WiegandFormatCache.getReadLock(rwLock);
        try {
            System.out.println("Wiegand Format Cache: " + wiegandFormatsMap.size() + " Record(s)");
            Set set = wiegandFormatsMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry me : set) {
                BUuid key = (BUuid)me.getKey();
                System.out.println("  Wiegand Format Uuid: " + key.toString());
                WiegandFormatCacheData data = (WiegandFormatCacheData)me.getValue();
                System.out.println("    Wiegand Format Name: " + data.getWiegandFormatName());
            }
            System.out.println("");
        }
        finally {
            WiegandFormatCache.releaseReadLock(rwLock);
        }
    }
}

