/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.BThreatLevelGroupRecData;
import com.tridiumx.entsec.access.util.dbCache.data.ThreatLevelGroupRecCacheData;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.util.BUuid;

public abstract class ThreatLevelGroupRecCache
extends AbstractCache {
    private static final BThreatLevelGroupRecData[] EMPTY_THREAT_LEVEL_DATA_ARRAY = new BThreatLevelGroupRecData[0];
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map threatLevelGroupsMap = new HashMap();

    public static void initThreatLevelGroupRecs(DbCache dbCache, OrionSession session) {
        ThreatLevelGroupRecCache.getWriteLock(rwLock);
        try {
            threatLevelGroupsMap.clear();
        }
        finally {
            ThreatLevelGroupRecCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BThreatLevelGroupRec.ORION_TYPE);
            while (cursor.next()) {
                BThreatLevelGroupRec rec = (BThreatLevelGroupRec)cursor.get();
                ThreatLevelGroupRecCache.insertThreatLevelGroupRec(dbCache, rec);
            }
            cursor.close();
        }
    }

    public static void initThreatLevelGroupRecs(DbCache dbCache, BThreatLevelGroupRec[] threatLevelGroups) {
        ThreatLevelGroupRecCache.getWriteLock(rwLock);
        try {
            threatLevelGroupsMap.clear();
        }
        finally {
            ThreatLevelGroupRecCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            for (int i = 0; i < threatLevelGroups.length; ++i) {
                ThreatLevelGroupRecCache.insertThreatLevelGroupRec(dbCache, threatLevelGroups[i]);
            }
        }
    }

    public static void insertThreatLevelGroupRec(DbCache dbCache, BThreatLevelGroupRec rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            ThreatLevelGroupRecCache.getWriteLock(rwLock);
            try {
                ThreatLevelGroupRecCacheData data = ThreatLevelGroupRecCache.getCacheData(rec.getUuid());
                if (data == null) {
                    data = new ThreatLevelGroupRecCacheData(rec);
                } else {
                    data.setData(rec);
                }
                ThreatLevelGroupRecCache.addMapEntry(rec.getUuid(), data);
            }
            finally {
                ThreatLevelGroupRecCache.releaseWriteLock(rwLock);
            }
        }
    }

    public static void updateThreatLevelGroupRec(DbCache dbCache, BThreatLevelGroupRec rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            ThreatLevelGroupRecCache.insertThreatLevelGroupRec(dbCache, rec);
        }
    }

    public static void deleteThreatLevelGroupRec(DbCache dbCache, OrionSession session, BThreatLevelGroupRec threatLevelGroup) {
        if (!dbCache.isRunningOnSupervisor()) {
            ThreatLevelGroupRecCache.removeThreatLevelGroupRec(dbCache, session, threatLevelGroup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeThreatLevelGroupRec(DbCache dbCache, OrionSession session, BThreatLevelGroupRec threatLevelGroup) {
        boolean objectExists = false;
        ThreatLevelGroupRecCache.getWriteLock(rwLock);
        try {
            objectExists = threatLevelGroupsMap.remove(threatLevelGroup.getUuid()) != null;
        }
        finally {
            ThreatLevelGroupRecCache.releaseWriteLock(rwLock);
        }
        if (objectExists) {
            dbCache.removeThreatLevelGroupRecs(threatLevelGroup);
        }
    }

    public static BThreatLevelGroupRecData getThreatLevelGroupRecData(BUuid threatLevelGroupUuid) {
        ThreatLevelGroupRecCache.getReadLock(rwLock);
        try {
            ThreatLevelGroupRecCacheData cacheData = ThreatLevelGroupRecCache.getCacheData(threatLevelGroupUuid);
            if (cacheData == null) {
                BThreatLevelGroupRecData bThreatLevelGroupRecData = null;
                return bThreatLevelGroupRecData;
            }
            BThreatLevelGroupRecData bThreatLevelGroupRecData = new BThreatLevelGroupRecData(threatLevelGroupUuid, cacheData);
            return bThreatLevelGroupRecData;
        }
        finally {
            ThreatLevelGroupRecCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BThreatLevelGroupRecData[] getThreatLevelGroupRecDataArr() {
        ThreatLevelGroupRecCache.getReadLock(rwLock);
        try {
            Set set = threatLevelGroupsMap.entrySet();
            if (set.isEmpty()) {
                BThreatLevelGroupRecData[] bThreatLevelGroupRecDataArray = EMPTY_THREAT_LEVEL_DATA_ARRAY;
                return bThreatLevelGroupRecDataArray;
            }
            Array arr = new Array(BThreatLevelGroupRecData.class);
            for (Map.Entry me : set) {
                ThreatLevelGroupRecCacheData data;
                BUuid key = (BUuid)me.getKey();
                BThreatLevelGroupRecData threatLevelGroupData = new BThreatLevelGroupRecData(key, data = (ThreatLevelGroupRecCacheData)me.getValue());
                if (threatLevelGroupData == null) continue;
                arr.add((Object)threatLevelGroupData);
            }
            BThreatLevelGroupRecData[] bThreatLevelGroupRecDataArray = (BThreatLevelGroupRecData[])arr.trim();
            return bThreatLevelGroupRecDataArray;
        }
        finally {
            ThreatLevelGroupRecCache.releaseReadLock(rwLock);
        }
    }

    private static ThreatLevelGroupRecCacheData getCacheData(BUuid key) {
        if (key == null) {
            return null;
        }
        ThreatLevelGroupRecCache.getReadLock(rwLock);
        try {
            ThreatLevelGroupRecCacheData threatLevelGroupRecCacheData = (ThreatLevelGroupRecCacheData)threatLevelGroupsMap.get(key);
            return threatLevelGroupRecCacheData;
        }
        finally {
            ThreatLevelGroupRecCache.releaseReadLock(rwLock);
        }
    }

    private static void addMapEntry(BUuid key, ThreatLevelGroupRecCacheData data) {
        ThreatLevelGroupRecCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                threatLevelGroupsMap.put(key, data);
            } else {
                threatLevelGroupsMap.remove(key);
            }
        }
        finally {
            ThreatLevelGroupRecCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        ThreatLevelGroupRecCache.getReadLock(rwLock);
        try {
            int n = threatLevelGroupsMap.size();
            return n;
        }
        finally {
            ThreatLevelGroupRecCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        ThreatLevelGroupRecCache.getReadLock(rwLock);
        try {
            System.out.println("Threat Level Cache: " + ThreatLevelGroupRecCache.getSize() + " Record(s)");
            Set set = threatLevelGroupsMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry me : set) {
                BUuid key = (BUuid)me.getKey();
                System.out.println("  Threat Level: " + key.toString());
                ThreatLevelGroupRecCacheData data = (ThreatLevelGroupRecCacheData)me.getValue();
                int activeLevel = data.getActiveLevel();
                System.out.println("    Display Name: " + data.getDisplayString());
                System.out.println("    ActiveLevel: " + activeLevel);
            }
            System.out.println("");
        }
        finally {
            ThreatLevelGroupRecCache.releaseReadLock(rwLock);
        }
    }
}

