/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.ScheduleRecCacheData;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.orionTools.MappingSupport;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.util.BUuid;

public abstract class ScheduleRecCache
extends AbstractCache {
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map scheduleRecsMap = new HashMap();

    public static void initScheduleRecs(DbCache dbCache, OrionSession session) {
        ScheduleRecCache.getWriteLock(rwLock);
        try {
            scheduleRecsMap.clear();
        }
        finally {
            ScheduleRecCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BScheduleRec.ORION_TYPE);
            while (cursor.next()) {
                BScheduleRec rec = (BScheduleRec)cursor.get();
                ScheduleRecCache.insertScheduleRec(dbCache, rec);
            }
            cursor.close();
        }
    }

    public static void insertScheduleRec(DbCache dbCache, BScheduleRec rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            ScheduleRecCache.insertScheduleRec(rec.getUuid(), rec.getScheduleDisplayPath());
        }
    }

    private static void insertScheduleRec(BUuid scheduleRecUuid, String scheduleDisplayPath) {
        ScheduleRecCache.getWriteLock(rwLock);
        try {
            ScheduleRecCacheData data = ScheduleRecCache.getCacheData(scheduleRecUuid);
            if (data == null) {
                data = new ScheduleRecCacheData(scheduleDisplayPath);
            } else {
                data.setScheduleDisplayPath(scheduleDisplayPath);
            }
            ScheduleRecCache.addMapEntry(scheduleRecUuid, data);
        }
        finally {
            ScheduleRecCache.releaseWriteLock(rwLock);
        }
    }

    public static void updateScheduleRec(DbCache dbCache, BScheduleRec rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            ScheduleRecCache.insertScheduleRec(dbCache, rec);
        }
    }

    public static void deleteScheduleRec(DbCache dbCache, BScheduleRec rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            ScheduleRecCache.removeScheduleRec(rec.getUuid());
        }
    }

    private static void removeScheduleRec(BUuid key) {
        ScheduleRecCache.getWriteLock(rwLock);
        try {
            scheduleRecsMap.remove(key);
        }
        finally {
            ScheduleRecCache.releaseWriteLock(rwLock);
        }
    }

    public static BBooleanSchedule getSchedule(DbCache dbCache, BUuid scheduleRecUuid) {
        if (scheduleRecUuid == null) {
            return null;
        }
        ScheduleRecCacheData data = ScheduleRecCache.getCacheData(scheduleRecUuid);
        if (data == null) {
            return null;
        }
        String scheduleDisplayPath = data.getScheduleDisplayPath();
        if (scheduleDisplayPath != null && scheduleDisplayPath.length() > 0) {
            BOrd scheduleOrd = BOrd.make((BOrd)MappingSupport.STATION_ORD, (BOrd)BOrd.make((String)MappingSupport.displayPathToSlotOrd(scheduleDisplayPath)));
            return (BBooleanSchedule)scheduleOrd.get();
        }
        return null;
    }

    private static ScheduleRecCacheData getCacheData(BUuid scheduleRecUuid) {
        if (scheduleRecUuid == null) {
            return null;
        }
        ScheduleRecCache.getReadLock(rwLock);
        try {
            ScheduleRecCacheData scheduleRecCacheData = (ScheduleRecCacheData)scheduleRecsMap.get(scheduleRecUuid);
            return scheduleRecCacheData;
        }
        finally {
            ScheduleRecCache.releaseReadLock(rwLock);
        }
    }

    private static void addMapEntry(BUuid key, ScheduleRecCacheData data) {
        ScheduleRecCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                scheduleRecsMap.put(key, data);
            } else {
                ScheduleRecCache.removeScheduleRec(key);
            }
        }
        finally {
            ScheduleRecCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        ScheduleRecCache.getReadLock(rwLock);
        try {
            int n = scheduleRecsMap.size();
            return n;
        }
        finally {
            ScheduleRecCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        ScheduleRecCache.getReadLock(rwLock);
        try {
            System.out.println("Schedule Record Cache: " + scheduleRecsMap.size() + " Record(s)");
            Set set = scheduleRecsMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry me : set) {
                BUuid key = (BUuid)me.getKey();
                System.out.println("  Schedule: " + key.toString());
                ScheduleRecCacheData data = (ScheduleRecCacheData)me.getValue();
                String value = data.getScheduleDisplayPath();
                System.out.println("    Display Path: " + value);
            }
            System.out.println("");
        }
        finally {
            ScheduleRecCache.releaseReadLock(rwLock);
        }
    }
}

