/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BNiagaraIntegrationID;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.NiagaraIntegrationIdCacheData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.util.BUuid;

public abstract class NiagaraIntegrationIdCache
extends AbstractCache {
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map niagaraIntegrationIdsMap = new HashMap();

    public static void initNiagaraIntegrationIds(DbCache dbCache, OrionSession session) {
        NiagaraIntegrationIdCache.getWriteLock(rwLock);
        try {
            niagaraIntegrationIdsMap.clear();
        }
        finally {
            NiagaraIntegrationIdCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BNiagaraIntegrationID.ORION_TYPE);
            while (cursor.next()) {
                BNiagaraIntegrationID rec = (BNiagaraIntegrationID)cursor.get();
                NiagaraIntegrationIdCache.insertNiagaraIntegrationId(dbCache, rec);
            }
            cursor.close();
        }
    }

    public static void insertNiagaraIntegrationId(DbCache dbCache, BNiagaraIntegrationID rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            NiagaraIntegrationIdCache.insertNiagaraIntegrationId(rec.getIntegrationUuid(), rec.getIntegrationId());
        }
    }

    private static void insertNiagaraIntegrationId(BUuid niagaraIntegrationUuid, int integrationId) {
        NiagaraIntegrationIdCache.getWriteLock(rwLock);
        try {
            NiagaraIntegrationIdCacheData data = NiagaraIntegrationIdCache.getCacheData(niagaraIntegrationUuid);
            if (data == null) {
                data = new NiagaraIntegrationIdCacheData(integrationId);
            } else {
                data.setNiagaraIntegrationId(integrationId);
            }
            NiagaraIntegrationIdCache.addMapEntry(niagaraIntegrationUuid, data);
        }
        finally {
            NiagaraIntegrationIdCache.releaseWriteLock(rwLock);
        }
    }

    public static void updateNiagaraIntegrationId(DbCache dbCache, BNiagaraIntegrationID rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            NiagaraIntegrationIdCache.insertNiagaraIntegrationId(dbCache, rec);
        }
    }

    public static void deleteNiagaraIntegrationId(DbCache dbCache, BNiagaraIntegrationID rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            NiagaraIntegrationIdCache.removeNiagaraIntegrationId(rec.getIntegrationUuid());
        }
    }

    private static void removeNiagaraIntegrationId(BUuid key) {
        NiagaraIntegrationIdCache.getWriteLock(rwLock);
        try {
            niagaraIntegrationIdsMap.remove(key);
        }
        finally {
            NiagaraIntegrationIdCache.releaseWriteLock(rwLock);
        }
    }

    public static int getIntegrationId(DbCache dbCache, BUuid integrationUuid) {
        if (integrationUuid == null) {
            return 0;
        }
        NiagaraIntegrationIdCacheData cacheData = NiagaraIntegrationIdCache.getCacheData(integrationUuid);
        if (cacheData == null) {
            return 0;
        }
        return cacheData.getNiagaraIntegrationId();
    }

    private static NiagaraIntegrationIdCacheData getCacheData(BUuid integrationUuid) {
        if (integrationUuid == null) {
            return null;
        }
        NiagaraIntegrationIdCache.getReadLock(rwLock);
        try {
            NiagaraIntegrationIdCacheData niagaraIntegrationIdCacheData = (NiagaraIntegrationIdCacheData)niagaraIntegrationIdsMap.get(integrationUuid);
            return niagaraIntegrationIdCacheData;
        }
        finally {
            NiagaraIntegrationIdCache.releaseReadLock(rwLock);
        }
    }

    private static void addMapEntry(BUuid key, NiagaraIntegrationIdCacheData data) {
        NiagaraIntegrationIdCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                niagaraIntegrationIdsMap.put(key, data);
            } else {
                NiagaraIntegrationIdCache.removeNiagaraIntegrationId(key);
            }
        }
        finally {
            NiagaraIntegrationIdCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        NiagaraIntegrationIdCache.getReadLock(rwLock);
        try {
            int n = niagaraIntegrationIdsMap.size();
            return n;
        }
        finally {
            NiagaraIntegrationIdCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        NiagaraIntegrationIdCache.getReadLock(rwLock);
        try {
            System.out.println("Niagara Integration ID Cache: " + niagaraIntegrationIdsMap.size() + " Record(s)");
            Set set = niagaraIntegrationIdsMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry me : set) {
                BUuid key = (BUuid)me.getKey();
                System.out.println("  Integration Uuid: " + key.toString());
                NiagaraIntegrationIdCacheData data = (NiagaraIntegrationIdCacheData)me.getValue();
                int value = data.getNiagaraIntegrationId();
                System.out.println("    Integration ID: " + value);
            }
            System.out.println("");
        }
        finally {
            NiagaraIntegrationIdCache.releaseReadLock(rwLock);
        }
    }
}

