/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.access.orion.BAccFloorJoin;
import com.tridiumx.entsec.access.orion.BAccFloorRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.BAccessRightData;
import com.tridiumx.entsec.access.util.dbCache.data.FloorCacheData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.util.BUuid;

public abstract class FloorCache
extends AbstractCache {
    private static final BAccessRightData[] EMPTY_ACCESS_RIGHT_DATA_ARRAY = new BAccessRightData[0];
    private static final BUuid[] EMPTY_BUUID_ARRAY = new BUuid[0];
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map floorsMap = new HashMap();

    public static void initFloors(DbCache dbCache, OrionSession session) {
        FloorCache.getWriteLock(rwLock);
        try {
            floorsMap.clear();
        }
        finally {
            FloorCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BAccFloorRec.ORION_TYPE);
            while (cursor.next()) {
                BAccFloorRec floor = (BAccFloorRec)cursor.get();
                FloorCache.insertFloor(dbCache, floor);
            }
            cursor.close();
        }
        FloorCache.initAccessRights(dbCache, session);
    }

    public static void initAccessRights(DbCache dbCache, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BAccFloorJoin.ORION_TYPE);
            while (cursor.next()) {
                BAccFloorJoin ar = (BAccFloorJoin)((Object)cursor.get());
                FloorCache.insertAccessRight(dbCache, ar);
            }
            cursor.close();
        }
    }

    public static void insertFloor(DbCache dbCache, BAccFloorRec floor) {
        if (!dbCache.isRunningOnSupervisor()) {
            FloorCache.getWriteLock(rwLock);
            try {
                FloorCacheData data = FloorCache.getCacheData(floor.getUuid());
                if (data == null) {
                    data = new FloorCacheData(floor);
                } else {
                    data.setFloorData(floor);
                }
                FloorCache.addMapEntry(floor.getUuid(), data);
            }
            finally {
                FloorCache.releaseWriteLock(rwLock);
            }
        }
    }

    public static void updateFloor(DbCache dbCache, BAccFloorRec floor) {
        if (!dbCache.isRunningOnSupervisor()) {
            FloorCache.insertFloor(dbCache, floor);
        }
    }

    public static void deleteFloor(DbCache dbCache, BAccFloorRec floor) {
        if (!dbCache.isRunningOnSupervisor()) {
            FloorCache.removeFloor(floor.getUuid());
        }
    }

    private static void removeFloor(BUuid key) {
        FloorCache.getWriteLock(rwLock);
        try {
            floorsMap.remove(key);
        }
        finally {
            FloorCache.releaseWriteLock(rwLock);
        }
    }

    public static void insertAccessRight(DbCache dbCache, BAccFloorJoin floorAccJoin) {
        if (!dbCache.isRunningOnSupervisor()) {
            FloorCache.insertAccessRight((BUuid)floorAccJoin.getFloor().getId(), floorAccJoin);
        }
    }

    private static void insertAccessRight(BUuid floorUuid, BAccFloorJoin floorAccJoin) {
        FloorCache.getWriteLock(rwLock);
        try {
            FloorCacheData data = FloorCache.getCacheData(floorUuid);
            if (data == null) {
                data = new FloorCacheData(floorAccJoin);
            } else {
                data.insertAccessRight(floorAccJoin);
            }
            FloorCache.addMapEntry(floorUuid, data);
        }
        finally {
            FloorCache.releaseWriteLock(rwLock);
        }
    }

    public static void deleteAccessRight(DbCache dbCache, BAccFloorJoin ar) {
        if (!dbCache.isRunningOnSupervisor()) {
            FloorCache.removeAccessRight((BUuid)ar.getFloor().getId(), (BUuid)ar.getAccessRight().getId());
        }
    }

    public static void removeFloorRecsAccessRight(DbCache dbCache, OrionSession session, BAccessRight accessRight) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BAccFloorJoin.ORION_TYPE, new PropertyValue(BAccFloorJoin.accessRight, (BValue)BRef.make((BIOrionObject)accessRight)));
            while (cursor.next()) {
                BAccFloorJoin rec = (BAccFloorJoin)((Object)cursor.get());
                FloorCache.removeAccessRight((BUuid)rec.getFloor().getId(), accessRight.getAccessRightId());
            }
            cursor.close();
        }
    }

    private static void removeAccessRight(BUuid floorUuid, BUuid accessRightUuid) {
        FloorCache.getWriteLock(rwLock);
        try {
            FloorCacheData data = FloorCache.getCacheData(floorUuid);
            if (data != null) {
                data.deleteAccessRight(accessRightUuid);
                FloorCache.addMapEntry(floorUuid, data);
            }
        }
        finally {
            FloorCache.releaseWriteLock(rwLock);
        }
    }

    public static BAccFloorRec getFloor(DbCache dbCache, BUuid floorUuid) {
        FloorCacheData data = FloorCache.getCacheData(floorUuid);
        if (data == null) {
            return null;
        }
        return data.getFloor(floorUuid);
    }

    public static BUuid[] getAccessRightUuids(DbCache dbCache, BUuid floorUuid) {
        FloorCacheData data = FloorCache.getCacheData(floorUuid);
        if (data == null) {
            return EMPTY_BUUID_ARRAY;
        }
        return data.getAccessRightUuids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BVector getFloorsVector(DbCache dbCache, Array elevatorAccessRightUuids, String elevatorSlotPath) {
        Array arr = new Array(FloorCacheData.class);
        FloorCache.getReadLock(rwLock);
        try {
            Set set = floorsMap.entrySet();
            if (set.isEmpty()) {
                BVector bVector = null;
                return bVector;
            }
            block4: for (Map.Entry me : set) {
                FloorCacheData data = (FloorCacheData)me.getValue();
                if (!data.getFloorDisplayPath().startsWith(elevatorSlotPath)) continue;
                for (int i = 0; i < elevatorAccessRightUuids.size(); ++i) {
                    BUuid elevatorAccessRight = (BUuid)elevatorAccessRightUuids.get(i);
                    if (!data.containsAccessRight(elevatorAccessRight)) continue;
                    arr.add((Object)data);
                    continue block4;
                }
            }
        }
        finally {
            FloorCache.releaseReadLock(rwLock);
        }
        if (arr.isEmpty()) {
            return null;
        }
        BVector v = new BVector();
        FloorCacheData[] floorsData = (FloorCacheData[])arr.trim();
        for (int i = 0; i < floorsData.length; ++i) {
            v.add(null, (BValue)BString.make((String)floorsData[i].getFloorDisplayPath()));
        }
        return v;
    }

    public static BAccessRightData[] getAccessRights(DbCache dbCache, BUuid floorUuid) {
        BUuid[] accessRightUuids = FloorCache.getAccessRightUuids(dbCache, floorUuid);
        if (accessRightUuids.length == 0) {
            return EMPTY_ACCESS_RIGHT_DATA_ARRAY;
        }
        Array arr = new Array(BAccessRightData.class);
        for (int i = 0; i < accessRightUuids.length; ++i) {
            BAccessRightData accessRightData = dbCache.getAccessRightData(accessRightUuids[i]);
            if (accessRightData == null) continue;
            arr.add((Object)accessRightData);
        }
        return (BAccessRightData[])arr.trim();
    }

    public static boolean containsAccessRight(BUuid floorUuid, BUuid accessRightUuid) {
        FloorCacheData data = FloorCache.getCacheData(floorUuid);
        if (data == null) {
            return false;
        }
        return data.containsAccessRight(accessRightUuid);
    }

    public static FloorCacheData getCacheData(BUuid floorUuid) {
        if (floorUuid == null) {
            return null;
        }
        FloorCache.getReadLock(rwLock);
        try {
            FloorCacheData floorCacheData = (FloorCacheData)floorsMap.get(floorUuid);
            return floorCacheData;
        }
        finally {
            FloorCache.releaseReadLock(rwLock);
        }
    }

    private static void addMapEntry(BUuid key, FloorCacheData data) {
        FloorCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                floorsMap.put(key, data);
            } else {
                FloorCache.removeFloor(key);
            }
        }
        finally {
            FloorCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        FloorCache.getReadLock(rwLock);
        try {
            int n = floorsMap.size();
            return n;
        }
        finally {
            FloorCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        FloorCache.getReadLock(rwLock);
        try {
            System.out.println("Floor: " + floorsMap.size() + " Record(s)");
            Set set = floorsMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry me : set) {
                BUuid floorUuid = (BUuid)me.getKey();
                System.out.println("  Floor: " + floorUuid.toString());
                FloorCacheData data = (FloorCacheData)me.getValue();
                System.out.println("    Display Path: " + data.getFloorDisplayPath());
                data.printMap();
            }
            System.out.println("");
        }
        finally {
            FloorCache.releaseReadLock(rwLock);
        }
    }
}

