/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BCacheStatusEnum;
import com.tridiumx.entsec.access.orion.BAccFloorJoin;
import com.tridiumx.entsec.access.orion.BAccFloorRec;
import com.tridiumx.entsec.access.orion.BAccReaderJoin;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BEntryReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BExitReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BNiagaraIntegrationID;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BSupervisorZoneJoin;
import com.tridiumx.entsec.access.orion.BThreatLevelBadgeJoin;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.util.dbCache.AccessRightCache;
import com.tridiumx.entsec.access.util.dbCache.AccessZoneCache;
import com.tridiumx.entsec.access.util.dbCache.BadgeCache;
import com.tridiumx.entsec.access.util.dbCache.FloorCache;
import com.tridiumx.entsec.access.util.dbCache.NiagaraIntegrationIdCache;
import com.tridiumx.entsec.access.util.dbCache.PersonCache;
import com.tridiumx.entsec.access.util.dbCache.ReaderCache;
import com.tridiumx.entsec.access.util.dbCache.ScheduleRecCache;
import com.tridiumx.entsec.access.util.dbCache.ThreatLevelBadgeJoinCache;
import com.tridiumx.entsec.access.util.dbCache.ThreatLevelGroupRecCache;
import com.tridiumx.entsec.access.util.dbCache.WiegandFormatCache;
import com.tridiumx.entsec.access.util.dbCache.data.AccessRightCacheData;
import com.tridiumx.entsec.access.util.dbCache.data.BAccessRightData;
import com.tridiumx.entsec.access.util.dbCache.data.BPersonData;
import com.tridiumx.entsec.access.util.dbCache.data.BThreatLevelBadgeJoinData;
import com.tridiumx.entsec.access.util.dbCache.data.BThreatLevelGroupRecData;
import com.tridiumx.entsec.access.util.dbCache.data.BadgeCacheData;
import com.tridiumx.entsec.access.util.dbCache.data.ReaderCacheData;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import java.util.logging.Logger;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BString;
import javax.baja.sys.BVector;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class DbCache {
    private static final String SERVER_HOST_MODEL = "Workstation";
    private static final BAccessRightData[] EMPTY_ACCESS_RIGHT_DATA_ARRAY = new BAccessRightData[0];
    private boolean runningOnSupervisor = false;

    public void init(OrionSession session) {
        this.runningOnSupervisor = BEnterpriseSecurityService.isWorkstation();
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        if (!this.runningOnSupervisor) {
            service.setCacheStatus(BCacheStatusEnum.initializing);
        }
        try {
            Logger.getLogger("entsec").info("initializing validation cache...");
            this.initScheduleRecs(session);
            this.initNiagaraIntegrationIds(session);
            this.initThreatLevelGroupRecs(session);
            this.initThreatLevelBadgeJoins(session);
            this.initAccessRights(session);
            this.initAccessZones(session);
            this.initPersons(session);
            this.initReaderRecs(session);
            this.initFloorRecs(session);
            this.initWiegandFormats(session);
            this.initBadges(session);
            Logger.getLogger("entsec").info("done initializing validation cache: " + this.getStatus());
            if (!this.runningOnSupervisor) {
                service.setCacheStatus(BCacheStatusEnum.active);
            }
        }
        catch (Exception e) {
            if (!this.runningOnSupervisor) {
                service.setCacheStatus(BCacheStatusEnum.fault);
            }
            e.printStackTrace();
        }
    }

    public void removeAccessRights(OrionSession session, BAccessRight accessRight) {
        this.removePersonsAccessRight(session, accessRight);
        this.removeReaderRecsAccessRight(session, accessRight);
        this.removeFloorRecsAccessRight(session, accessRight);
    }

    public void removeThreatLevelGroupRecs(BThreatLevelGroupRec threatLevelGroup) {
    }

    public void removeThreatLevelBadgeJoins(BThreatLevelBadgeJoin threatLevelBadgeJoin) {
    }

    public void removeAccessZones(OrionSession session, BAccessZoneRec accessZone) {
        this.removePersonsAccessZone(session, accessZone);
        this.removeReaderRecsAccessZone(session, accessZone);
    }

    public void resetAccessZoneOccupancy(OrionSession session, BAccessZoneRec accessZone) {
        this.resetAccessZoneOccupancy(accessZone.getUuid());
    }

    public void initThreatLevelGroupRecs(OrionSession session) {
        ThreatLevelGroupRecCache.initThreatLevelGroupRecs(this, session);
    }

    public void insertThreatLevelGroupRec(BThreatLevelGroupRec rec) {
        ThreatLevelGroupRecCache.insertThreatLevelGroupRec(this, rec);
    }

    public void updateThreatLevelGroupRec(BThreatLevelGroupRec rec) {
        ThreatLevelGroupRecCache.updateThreatLevelGroupRec(this, rec);
    }

    public void deleteThreatLevelGroupRec(OrionSession session, BThreatLevelGroupRec rec) {
        ThreatLevelGroupRecCache.deleteThreatLevelGroupRec(this, session, rec);
    }

    public BThreatLevelGroupRecData getThreatLevelGroupRecData(BUuid threatLevelGroupUuid) {
        return ThreatLevelGroupRecCache.getThreatLevelGroupRecData(threatLevelGroupUuid);
    }

    public void initThreatLevelBadgeJoins(OrionSession session) {
        ThreatLevelBadgeJoinCache.initThreatLevelBadgeJoins(this, session);
    }

    public void insertThreatLevelBadgeJoin(BThreatLevelBadgeJoin rec) {
        ThreatLevelBadgeJoinCache.insertThreatLevelBadgeJoin(this, rec);
    }

    public void updateThreatLevelBadgeJoin(BThreatLevelBadgeJoin rec) {
        ThreatLevelBadgeJoinCache.updateThreatLevelBadgeJoin(this, rec);
    }

    public void deleteThreatLevelBadgeJoin(BThreatLevelBadgeJoin rec) {
        ThreatLevelBadgeJoinCache.deleteThreatLevelBadgeJoin(this, rec);
    }

    public BThreatLevelBadgeJoinData getThreatLevelBadgeJoinData(BString badgeId) {
        return ThreatLevelBadgeJoinCache.getThreatLevelBadgeJoinData(badgeId);
    }

    public void initAccessRights(OrionSession session) {
        AccessRightCache.initAccessRights(this, session);
    }

    public void insertAccessRight(BAccessRight rec) {
        AccessRightCache.insertAccessRight(this, rec);
    }

    public void updateAccessRight(BAccessRight rec) {
        AccessRightCache.updateAccessRight(this, rec);
    }

    public void deleteAccessRight(OrionSession session, BAccessRight rec) {
        AccessRightCache.deleteAccessRight(this, session, rec);
    }

    public BAccessRightData getAccessRightData(BUuid accessRightUuid) {
        return AccessRightCache.getAccessRightData(accessRightUuid);
    }

    public BAccessRightData[] getPersonReaderAccessRights(BUuid personUuid, BUuid readerUuid, BAbsTime time, boolean filterValidDate) {
        BAccessRightData[] accessRightDatas = PersonCache.getAccessRights(this, personUuid, time, filterValidDate);
        if (accessRightDatas == null || accessRightDatas.length == 0) {
            return EMPTY_ACCESS_RIGHT_DATA_ARRAY;
        }
        ReaderCacheData readerCacheData = ReaderCache.getCacheData(readerUuid);
        if (readerCacheData == null) {
            return EMPTY_ACCESS_RIGHT_DATA_ARRAY;
        }
        Array arr = new Array(BAccessRightData.class);
        for (int i = 0; i < accessRightDatas.length; ++i) {
            BUuid accessRightUuid = accessRightDatas[i].getAccessRightUuid();
            if (!readerCacheData.containsAccessRight(accessRightUuid)) continue;
            arr.add((Object)accessRightDatas[i]);
        }
        return (BAccessRightData[])arr.trim();
    }

    public void initAccessZones(OrionSession session) {
        AccessZoneCache.initAccessZones(this, session);
    }

    public void insertAccessZone(BAccessZoneRec rec) {
        AccessZoneCache.insertAccessZone(this, rec);
    }

    public void updateAccessZone(BAccessZoneRec rec) {
        AccessZoneCache.updateAccessZone(this, rec);
    }

    public void deleteAccessZone(OrionSession session, BAccessZoneRec rec) {
        AccessZoneCache.deleteAccessZone(this, session, rec);
    }

    public BAccessZoneRec[] getAccessZones() {
        return AccessZoneCache.getAccessZones();
    }

    public BAccessZoneRec getAccessZone(BUuid accessZoneUuid) {
        return AccessZoneCache.getAccessZone(accessZoneUuid);
    }

    public void initReaderRecs(OrionSession session) {
        ReaderCache.initReaders(this, session);
    }

    public void insertReaderRec(BAccReaderRec rec) {
        ReaderCache.insertReader(this, rec);
    }

    public void updateReaderRec(BAccReaderRec rec) {
        ReaderCache.updateReader(this, rec);
    }

    public void deleteReaderRec(BAccReaderRec rec) {
        ReaderCache.deleteReader(this, rec);
    }

    public BAccReaderRec getReaderRec(BUuid readerUuid) {
        return ReaderCache.getReader(this, readerUuid);
    }

    public void insertReaderAccessRight(BAccReaderJoin rec) {
        ReaderCache.insertAccessRight(this, rec);
    }

    public void deleteReaderAccessRight(BAccReaderJoin rec) {
        ReaderCache.deleteAccessRight(this, rec);
    }

    public void removeReaderRecsAccessRight(OrionSession session, BAccessRight accessRight) {
        ReaderCache.removeReaderRecsAccessRight(this, session, accessRight);
    }

    public BAccessRightData[] getReaderAccessRights(BUuid readerUuid) {
        return ReaderCache.getAccessRights(this, readerUuid);
    }

    public void insertEntryZone(BEntryReaderZoneJoin rec) {
        ReaderCache.insertEntryZone(this, rec);
    }

    public void deleteEntryZone(BEntryReaderZoneJoin rec) {
        ReaderCache.deleteEntryZone(this, rec);
    }

    public BAccessZoneRec[] getEntryZones(BUuid readerUuid) {
        return ReaderCache.getEntryZones(this, readerUuid);
    }

    public void insertExitZone(BExitReaderZoneJoin rec) {
        ReaderCache.insertExitZone(this, rec);
    }

    public void deleteExitZone(BExitReaderZoneJoin rec) {
        ReaderCache.deleteExitZone(this, rec);
    }

    public void removeReaderRecsAccessZone(OrionSession session, BAccessZoneRec accessZone) {
        ReaderCache.removeReaderRecsAccessZone(this, session, accessZone);
    }

    public BAccessZoneRec[] getExitZones(BUuid readerUuid) {
        return ReaderCache.getExitZones(this, readerUuid);
    }

    public void initFloorRecs(OrionSession session) {
        FloorCache.initFloors(this, session);
    }

    public void insertFloorRec(BAccFloorRec rec) {
        FloorCache.insertFloor(this, rec);
    }

    public void updateFloorRec(BAccFloorRec rec) {
        FloorCache.updateFloor(this, rec);
    }

    public void deleteFloorRec(BAccFloorRec rec) {
        FloorCache.deleteFloor(this, rec);
    }

    public void insertFloorAccessRight(BAccFloorJoin ar) {
        FloorCache.insertAccessRight(this, ar);
    }

    public void deleteFloorAccessRight(BAccFloorJoin ar) {
        FloorCache.deleteAccessRight(this, ar);
    }

    public void removeFloorRecsAccessRight(OrionSession session, BAccessRight accessRight) {
        FloorCache.removeFloorRecsAccessRight(this, session, accessRight);
    }

    public BAccessRightData[] getFloorAccessRights(BUuid floorUuid) {
        return FloorCache.getAccessRights(this, floorUuid);
    }

    public BVector getFloorsVector(Array elevatorAccessRightUuids, String elevatorSlotPath) {
        return FloorCache.getFloorsVector(this, elevatorAccessRightUuids, elevatorSlotPath);
    }

    public BAccFloorRec getFloorRec(BUuid floorUuid) {
        return FloorCache.getFloor(this, floorUuid);
    }

    public void initPersons(OrionSession session) {
        PersonCache.initPersons(this, session);
    }

    public void initPerson(BUuid personUuid, OrionSession session) {
        BPerson person = PersonCache.initPerson(this, personUuid, session);
        if (person != null) {
            BadgeCache.initBadges(this, person, session);
        }
    }

    public void insertPerson(BPerson person) {
        PersonCache.insertPerson(this, person);
    }

    public void updatePerson(BPerson person) {
        PersonCache.updatePerson(this, person);
    }

    public void updatePerson(BPerson person, boolean pinKnown) {
        PersonCache.updatePerson(this, person, pinKnown);
    }

    public void deletePerson(BPerson person) {
        PersonCache.deletePerson(this, person);
    }

    public void insertPersonAccessRight(BPersonAccJoin rec) {
        PersonCache.insertAccessRight(this, rec);
    }

    public void updatePersonAccessRight(BPersonAccJoin rec) {
        PersonCache.updateAccessRight(this, rec);
    }

    public void deletePersonAccessRight(BPersonAccJoin rec) {
        PersonCache.deleteAccessRight(this, rec);
    }

    public void removePersonsAccessRight(OrionSession session, BAccessRight accessRight) {
        PersonCache.removePersonsAccessRight(this, session, accessRight);
    }

    public BAccessRightData[] getPersonAccessRights(BUuid personUuid, BAbsTime time, boolean filterValidDate) {
        return PersonCache.getAccessRights(this, personUuid, time, filterValidDate);
    }

    public void resetAccessZoneOccupancy(BUuid accessZoneUuid) {
        PersonCache.resetAccessZoneOccupancy(accessZoneUuid);
    }

    public void insertPersonZone(BPersonZoneJoin rec) {
        PersonCache.insertPersonZone(this, rec);
    }

    public void updatePersonZone(BPersonZoneJoin rec) {
        PersonCache.updatePersonZone(this, rec);
    }

    public void deletePersonZone(BPersonZoneJoin rec) {
        PersonCache.deletePersonZone(this, rec);
    }

    public void removePersonsAccessZone(OrionSession session, BAccessZoneRec accessZone) {
        PersonCache.removePersonsAccessZone(this, session, accessZone);
    }

    public BAccessZoneRec[] getPersonZones(BUuid personUuid) {
        return PersonCache.getPersonZones(this, personUuid);
    }

    public BPersonZoneJoin getPersonZoneJoin(DbCache dbCache, BUuid personUuid, BUuid accessZoneUuid) {
        return PersonCache.getPersonZoneJoin(this, personUuid, accessZoneUuid);
    }

    public int getAccessZonePersonCount(BUuid accessZoneUuid) {
        return AccessZoneCache.getAccessZonePersonCount(accessZoneUuid);
    }

    public BPersonZoneJoin[] getOccupiedPersons(BUuid accessZoneUuid) {
        return PersonCache.getOccupiedPersons(accessZoneUuid);
    }

    public void insertSupervisorZone(BSupervisorZoneJoin rec) {
        PersonCache.insertSupervisorZone(this, rec);
    }

    public void updateSupervisorZone(BSupervisorZoneJoin rec) {
        PersonCache.updateSupervisorZone(this, rec);
    }

    public void deleteSupervisorZone(BSupervisorZoneJoin rec) {
        PersonCache.deleteSupervisorZone(this, rec);
    }

    public BAccessZoneRec[] getSupervisorZones(BUuid personUuid) {
        return PersonCache.getSupervisorZones(this, personUuid);
    }

    public BSupervisorZoneJoin getSupervisorZoneJoin(DbCache dbCache, BUuid supervisorUuid, BUuid accessZoneUuid) {
        return PersonCache.getSupervisorZoneJoin(this, supervisorUuid, accessZoneUuid);
    }

    public int getAccessZoneSupervisorCount(BUuid accessZoneUuid) {
        return AccessZoneCache.getAccessZoneSupervisorCount(accessZoneUuid);
    }

    public BPersonZoneJoin[] getOccupiedSupervisors(BUuid accessZoneUuid) {
        return PersonCache.getOccupiedSupervisors(accessZoneUuid);
    }

    public void initBadges(OrionSession session) {
        BadgeCache.initBadges(this, session);
    }

    public void insertBadge(BBadge rec) {
        BadgeCache.insertBadge(this, rec);
    }

    public void updateBadge(BBadge rec) {
        BadgeCache.updateBadge(this, rec);
    }

    public void deleteBadge(BBadge rec) {
        BadgeCache.deleteBadge(this, rec);
    }

    public BBadge getBadge(String badgeId) {
        return BadgeCache.getBadge(this, badgeId);
    }

    public BPersonData getBadgeOwner(String badgeId) {
        BBadge badge = BadgeCache.getBadge(this, badgeId);
        return this.getBadgeOwner(badge);
    }

    public BPersonData getBadgeOwner(BBadge badge, OrionSession session, boolean refreshPersonForPin) {
        return PersonCache.getPerson(this, (BUuid)badge.getOwner().getId(), session, refreshPersonForPin);
    }

    public BPersonData getBadgeOwner(BBadge badge) {
        return PersonCache.getPerson(this, (BUuid)badge.getOwner().getId());
    }

    public BBadge[] getBadges() {
        return BadgeCache.getBadges();
    }

    public BadgeCacheData[] getBadgeDataArr() {
        return BadgeCache.getBadgeDataArr();
    }

    public BBadge[] getBadgesFromCredential(String credential) {
        return BadgeCache.getBadgesFromCredential(this, credential);
    }

    public void initWiegandFormats(OrionSession session) {
        WiegandFormatCache.initWiegandFormats(this, session);
    }

    public void insertWiegandFormat(BWiegandFormat rec, OrionSession session) {
        WiegandFormatCache.insertWiegandFormat(this, rec, session);
    }

    public void updateWiegandFormat(BWiegandFormat rec, OrionSession session) {
        WiegandFormatCache.updateWiegandFormat(this, rec, session);
    }

    public void deleteWiegandFormat(BWiegandFormat rec, OrionSession session) {
        WiegandFormatCache.deleteWiegandFormat(this, rec, session);
    }

    public BWiegandFormat[] getWiegandFormats() {
        return WiegandFormatCache.getWiegandFormats();
    }

    public BWiegandFormat getWiegandFormat(BUuid wiegandFormatUuid) {
        return WiegandFormatCache.getWiegandFormat(wiegandFormatUuid);
    }

    public void initScheduleRecs(OrionSession session) {
        ScheduleRecCache.initScheduleRecs(this, session);
    }

    public void insertScheduleRec(BScheduleRec rec) {
        ScheduleRecCache.insertScheduleRec(this, rec);
    }

    public void updateScheduleRec(BScheduleRec rec) {
        ScheduleRecCache.updateScheduleRec(this, rec);
    }

    public void deleteScheduleRec(BScheduleRec rec) {
        ScheduleRecCache.deleteScheduleRec(this, rec);
    }

    public BBooleanSchedule getSchedule(BUuid scheduleRecId) {
        return ScheduleRecCache.getSchedule(this, scheduleRecId);
    }

    public BUuid getScheduleRecUuid(BUuid accessRightUuid) {
        if (accessRightUuid == null) {
            return null;
        }
        BAccessRightData accessRightdata = this.getAccessRightData(accessRightUuid);
        if (accessRightdata == null) {
            return null;
        }
        AccessRightCacheData data = accessRightdata.getAccessRightCacheData();
        return data.getScheduleRecUuid();
    }

    public BBooleanSchedule getScheduleForAccessRight(BUuid accessRightId) {
        return this.getSchedule(this.getScheduleRecUuid(accessRightId));
    }

    public void initNiagaraIntegrationIds(OrionSession session) {
        NiagaraIntegrationIdCache.initNiagaraIntegrationIds(this, session);
    }

    public void insertNiagaraIntegrationId(BNiagaraIntegrationID rec) {
        NiagaraIntegrationIdCache.insertNiagaraIntegrationId(this, rec);
    }

    public void updateNiagaraIntegrationId(BNiagaraIntegrationID rec) {
        NiagaraIntegrationIdCache.updateNiagaraIntegrationId(this, rec);
    }

    public void deleteNiagaraIntegrationId(BNiagaraIntegrationID rec) {
        NiagaraIntegrationIdCache.deleteNiagaraIntegrationId(this, rec);
    }

    public int getIntegrationId(BUuid integrationUuid) {
        return NiagaraIntegrationIdCache.getIntegrationId(this, integrationUuid);
    }

    public BUuid getNiagaraIntegrationUuid(BUuid accessRightUuid) {
        if (accessRightUuid == null) {
            return null;
        }
        BAccessRightData accessRightdata = this.getAccessRightData(accessRightUuid);
        if (accessRightdata == null) {
            return null;
        }
        AccessRightCacheData data = accessRightdata.getAccessRightCacheData();
        return data.getNiagaraIntegrationUuid();
    }

    public int getIntegrationIdForAccessRight(BUuid accessRightUuid) {
        BUuid niagaraIntegrationUuid = this.getNiagaraIntegrationUuid(accessRightUuid);
        return NiagaraIntegrationIdCache.getIntegrationId(this, niagaraIntegrationUuid);
    }

    public String getStatus() {
        if (this.runningOnSupervisor) {
            return "Data not cached on Supervisor";
        }
        return "persons " + PersonCache.getSize() + ", readers " + ReaderCache.getSize() + ", floors " + FloorCache.getSize() + ", threatLevelGroups " + ThreatLevelGroupRecCache.getSize() + ", accessRights " + AccessRightCache.getSize() + ", accessZones " + AccessZoneCache.getSize() + ", badges " + BadgeCache.getSize() + ", wiegandFormats " + WiegandFormatCache.getSize() + ", scheduleRecs " + ScheduleRecCache.getSize() + ", niagaraIntegrationIds " + NiagaraIntegrationIdCache.getSize();
    }

    public void printMaps() {
        if (this.runningOnSupervisor) {
            return;
        }
        ThreatLevelGroupRecCache.printMap();
        ThreatLevelBadgeJoinCache.printMap();
        AccessRightCache.printMap();
        AccessZoneCache.printMap();
        PersonCache.printMap();
        ReaderCache.printMap();
        FloorCache.printMap();
        BadgeCache.printMap();
        WiegandFormatCache.printMap();
        NiagaraIntegrationIdCache.printMap();
        ScheduleRecCache.printMap();
    }

    public boolean isRunningOnSupervisor() {
        return this.runningOnSupervisor;
    }

    public void setMaxBadgeCacheSize(int size) {
        BadgeCache.setMaxCacheSize(size);
        PersonCache.setMaxCacheSize(size);
    }
}

