/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.PropertyValue;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BValidationBits;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.ThreatLevelBadgeJoinCache;
import com.tridiumx.entsec.access.util.dbCache.data.BThreatLevelBadgeJoinData;
import com.tridiumx.entsec.access.util.dbCache.data.BadgeCacheData;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.util.BUuid;

public abstract class BadgeCache
extends AbstractCache {
    private static final BBadge[] EMPTY_BADGE_ARRAY = new BBadge[0];
    private static final BadgeCacheData[] EMPTY_BADGE_DATA_ARRAY = new BadgeCacheData[0];
    public static final String CREDENTIAL_ONLY_HEADER = "Z";
    public static final String FACILITY_CODE_HEADER = "Y";
    private static final int MAP_INITIAL_CAPACITY = 16;
    private static final float MAP_LOAD_FACTOR = 0.75f;
    private static final boolean MAP_ACCESS_ORDER = true;
    private static int max_cache_size = -1;
    private static ReentrantReadWriteLock badgesRWLock = new ReentrantReadWriteLock();
    private static ReentrantReadWriteLock credentialsRWLock = new ReentrantReadWriteLock();
    private static Map badgesMap = new LinkedBadgeMap(16, 0.75f, true);
    private static Map badgeCredentialsMap = new HashMap();
    private static Map badgeIDMap = new HashMap();

    public static void initBadges(DbCache dbCache, OrionSession session) {
        BadgeCache.getWriteLock(badgesRWLock);
        try {
            badgesMap.clear();
        }
        finally {
            BadgeCache.releaseWriteLock(badgesRWLock);
        }
        BadgeCache.getWriteLock(credentialsRWLock);
        try {
            badgeCredentialsMap.clear();
        }
        finally {
            BadgeCache.releaseWriteLock(credentialsRWLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BBadge.ORION_TYPE);
            while (cursor.next()) {
                BBadge rec = (BBadge)cursor.get();
                BadgeCache.insertBadge(dbCache, rec);
            }
            cursor.close();
        }
    }

    public static void initBadges(DbCache dbCache, BPerson owner, OrionSession session) {
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.select(BBadge.ORION_TYPE, new PropertyValue(BBadge.owner, (BValue)BRef.make((BIOrionObject)owner)));
            while (cursor.next()) {
                BBadge rec = (BBadge)cursor.get();
                BadgeCache.insertBadge(dbCache, rec);
            }
            cursor.close();
        }
    }

    public static void insertBadge(DbCache dbCache, BBadge rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            BadgeCache.insertBadge(rec.getBadgeId(), rec, dbCache.getWiegandFormat((BUuid)rec.getWiegandFormat().getId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertBadge(String id, BBadge rec, BWiegandFormat wiegandFormat) {
        String badgeId = id;
        if (badgeId == null || badgeId.length() == 0) {
            return;
        }
        if (wiegandFormat == null) {
            return;
        }
        if (wiegandFormat.getValidationBits().equals((Object)BValidationBits.credentialOnly)) {
            badgeId = CREDENTIAL_ONLY_HEADER + rec.getCredential();
        } else if (wiegandFormat.getValidationBits().equals((Object)BValidationBits.credentialAndFacilityCode)) {
            badgeId = CREDENTIAL_ONLY_HEADER + rec.getCredential() + FACILITY_CODE_HEADER + rec.getFacilityCode();
        }
        BadgeCache.getWriteLock(badgesRWLock);
        try {
            BadgeCacheData data = BadgeCache.getCacheData(badgeId);
            if (data == null) {
                data = BadgeCacheData.make(rec);
            } else {
                data.setData(rec);
            }
            BadgeCache.addMapEntry(badgeId, data);
            if (badgeId.startsWith(CREDENTIAL_ONLY_HEADER)) {
                badgeIDMap.put(rec.getBadgeId(), badgeId);
            }
        }
        finally {
            BadgeCache.releaseWriteLock(badgesRWLock);
        }
    }

    public static void updateBadge(DbCache dbCache, BBadge rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            BadgeCache.insertBadge(dbCache, rec);
        }
    }

    public static void deleteBadge(DbCache dbCache, BBadge rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            BadgeCache.removeBadge(rec.getBadgeId(), rec.getCredential());
            BThreatLevelBadgeJoinData data = ThreatLevelBadgeJoinCache.getThreatLevelBadgeJoinData(BString.make((String)rec.getBadgeId()));
            if (data != null) {
                ThreatLevelBadgeJoinCache.deleteThreatLevelBadgeJoin(dbCache, BString.make((String)rec.getBadgeId()));
            }
        }
    }

    private static void removeBadge(String key, String credential) {
        BadgeCache.getWriteLock(badgesRWLock);
        try {
            if (badgesMap.get(key) != null) {
                badgesMap.remove(key);
            } else {
                String badgeIDKey = (String)badgeIDMap.get(key);
                badgesMap.remove(badgeIDKey);
            }
            badgesMap.remove(key);
            BadgeCache.removeBadgeCredential(key, credential);
        }
        finally {
            BadgeCache.releaseWriteLock(badgesRWLock);
        }
    }

    private static void insertBadgeCredential(String badgeId, String credential) {
        BadgeCache.getWriteLock(credentialsRWLock);
        try {
            Vector<String> vector = BadgeCache.getBadgeCredential(credential);
            if (vector == null) {
                vector = new Vector<String>();
            } else if (BadgeCache.badgeCredentialBadgeIdExists(vector, badgeId)) {
                return;
            }
            vector.add(badgeId);
            badgeCredentialsMap.put(credential, vector);
        }
        finally {
            BadgeCache.releaseWriteLock(credentialsRWLock);
        }
    }

    private static void removeBadgeCredential(String badgeId, String credential) {
        BadgeCache.getWriteLock(credentialsRWLock);
        try {
            Vector vector = BadgeCache.getBadgeCredential(credential);
            if (vector != null && vector.size() > 1) {
                BadgeCache.removeBadgeCredential(vector, badgeId);
            } else {
                badgeCredentialsMap.remove(credential);
            }
        }
        finally {
            BadgeCache.releaseWriteLock(credentialsRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeBadgeCredential(Vector vector, String badgeId) {
        BadgeCache.getWriteLock(credentialsRWLock);
        try {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                if (!value.equals(badgeId)) continue;
                iterator.remove();
                break;
            }
        }
        finally {
            BadgeCache.releaseWriteLock(credentialsRWLock);
        }
    }

    private static Vector getBadgeCredential(String key) {
        BadgeCache.getReadLock(credentialsRWLock);
        try {
            Vector vector = (Vector)badgeCredentialsMap.get(key);
            return vector;
        }
        finally {
            BadgeCache.releaseReadLock(credentialsRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BBadge[] getBadgesFromCredential(DbCache dbCache, String credential) {
        BadgeCache.getReadLock(credentialsRWLock);
        try {
            Vector vector = BadgeCache.getBadgeCredential(credential);
            if (vector == null || vector.isEmpty()) {
                BBadge[] bBadgeArray = EMPTY_BADGE_ARRAY;
                return bBadgeArray;
            }
            Array arr = new Array(BBadge.class);
            Enumeration e = vector.elements();
            while (e.hasMoreElements()) {
                BBadge badge = BadgeCache.getBadge(dbCache, (String)e.nextElement());
                if (badge == null) continue;
                arr.add((Object)badge);
            }
            BBadge[] bBadgeArray = (BBadge[])arr.trim();
            return bBadgeArray;
        }
        finally {
            BadgeCache.releaseReadLock(credentialsRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean badgeCredentialBadgeIdExists(Vector vector, String badgeId) {
        BadgeCache.getReadLock(credentialsRWLock);
        try {
            if (vector != null && !vector.isEmpty()) {
                Enumeration e = vector.elements();
                while (e.hasMoreElements()) {
                    String value = (String)e.nextElement();
                    if (!value.equals(badgeId)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            BadgeCache.releaseReadLock(credentialsRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BBadge[] getBadges() {
        BadgeCache.getReadLock(badgesRWLock);
        try {
            Set set = badgesMap.entrySet();
            if (set == null || set.isEmpty()) {
                BBadge[] bBadgeArray = EMPTY_BADGE_ARRAY;
                return bBadgeArray;
            }
            Array arr = new Array(BBadge.class);
            for (Map.Entry me : set) {
                BBadge badge;
                BadgeCacheData data = (BadgeCacheData)me.getValue();
                if (data == null || (badge = data.getBadge()) == null) continue;
                arr.add((Object)badge);
            }
            BBadge[] bBadgeArray = (BBadge[])arr.trim();
            return bBadgeArray;
        }
        finally {
            BadgeCache.releaseReadLock(badgesRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BadgeCacheData[] getBadgeDataArr() {
        BadgeCache.getReadLock(badgesRWLock);
        try {
            Set set = badgesMap.entrySet();
            if (set == null || set.isEmpty()) {
                BadgeCacheData[] badgeCacheDataArray = EMPTY_BADGE_DATA_ARRAY;
                return badgeCacheDataArray;
            }
            Array arr = new Array(BadgeCacheData.class);
            for (Map.Entry me : set) {
                BadgeCacheData data = (BadgeCacheData)me.getValue();
                if (data == null) continue;
                arr.add((Object)data);
            }
            BadgeCacheData[] badgeCacheDataArray = (BadgeCacheData[])arr.trim();
            return badgeCacheDataArray;
        }
        finally {
            BadgeCache.releaseReadLock(badgesRWLock);
        }
    }

    public static BBadge getBadge(DbCache dbCache, String badgeId) {
        BadgeCacheData cacheData = BadgeCache.getCacheData(badgeId);
        if (cacheData == null) {
            return null;
        }
        return cacheData.getBadge();
    }

    private static BadgeCacheData getCacheData(String badgeId) {
        if (badgeId == null || badgeId.length() == 0) {
            return null;
        }
        BadgeCache.getReadLock(badgesRWLock);
        try {
            BadgeCacheData badgeCacheData = (BadgeCacheData)badgesMap.get(badgeId);
            return badgeCacheData;
        }
        finally {
            BadgeCache.releaseReadLock(badgesRWLock);
        }
    }

    private static void addMapEntry(String key, BadgeCacheData data) {
        if (data == null) {
            return;
        }
        BadgeCache.getWriteLock(badgesRWLock);
        try {
            if (!data.isEmpty()) {
                badgesMap.put(key, data);
                BadgeCache.insertBadgeCredential(key, data.getCredential());
            } else {
                BadgeCache.removeBadge(key, data.getCredential());
            }
        }
        finally {
            BadgeCache.releaseWriteLock(badgesRWLock);
        }
    }

    public static int getSize() {
        BadgeCache.getReadLock(badgesRWLock);
        try {
            int n = badgesMap.size();
            return n;
        }
        finally {
            BadgeCache.releaseReadLock(badgesRWLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        String key;
        Set set;
        BadgeCache.getReadLock(badgesRWLock);
        try {
            System.out.println("Badge Cache: " + badgesMap.size() + " Record(s). Max cache size: " + max_cache_size);
            set = badgesMap.entrySet();
            if (set == null || set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry me : set) {
                key = (String)me.getKey();
                System.out.println("  Badge ID: " + key);
                BadgeCacheData data = (BadgeCacheData)me.getValue();
                BBadge badge = data.getBadge();
                System.out.println("    Db Badge Id: " + badge.getBadgeId());
                System.out.println("    Credential: " + badge.getCredential());
                if (badge.getOwner().getId() instanceof BUuid) {
                    System.out.println("    Owner: " + ((BUuid)badge.getOwner().getId()).toString());
                    continue;
                }
                System.out.println("    Owner: <empty>");
            }
            System.out.println("");
        }
        finally {
            BadgeCache.releaseReadLock(badgesRWLock);
        }
        BadgeCache.getReadLock(credentialsRWLock);
        try {
            System.out.println("Badge Cache (Credentials): " + badgeCredentialsMap.size() + " Record(s)");
            set = badgeCredentialsMap.entrySet();
            if (set == null || set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry me : set) {
                key = (String)me.getKey();
                System.out.println("  Credential: " + key);
                Vector vector = (Vector)me.getValue();
                for (String data : vector) {
                    System.out.println("    Badge ID: " + data);
                }
            }
            System.out.println("");
        }
        finally {
            BadgeCache.releaseReadLock(credentialsRWLock);
        }
    }

    public static int getMaxCacheSize() {
        return max_cache_size;
    }

    public static void setMaxCacheSize(int size) {
        max_cache_size = size;
    }

    private static class LinkedBadgeMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 1L;

        protected LinkedBadgeMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeEldestEntry(Map.Entry eldest) {
            AbstractCache.getWriteLock(badgesRWLock);
            try {
                if (max_cache_size != -1 && this.size() > max_cache_size) {
                    BadgeCacheData data = (BadgeCacheData)eldest.getValue();
                    BadgeCache.removeBadgeCredential((String)eldest.getKey(), data.getCredential());
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                AbstractCache.releaseWriteLock(badgesRWLock);
            }
        }
    }
}

