/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util.dbCache;

import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.util.dbCache.AbstractCache;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.access.util.dbCache.data.AccessRightCacheData;
import com.tridiumx.entsec.access.util.dbCache.data.BAccessRightData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.baja.nre.util.Array;
import javax.baja.util.BUuid;

public abstract class AccessRightCache
extends AbstractCache {
    private static final BAccessRightData[] EMPTY_ACCESS_RIGHT_DATA_ARRAY = new BAccessRightData[0];
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static Map accessRightsMap = new HashMap();

    public static void initAccessRights(DbCache dbCache, OrionSession session) {
        AccessRightCache.getWriteLock(rwLock);
        try {
            accessRightsMap.clear();
        }
        finally {
            AccessRightCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            OrionCursor cursor = session.scan(BAccessRight.ORION_TYPE);
            while (cursor.next()) {
                BAccessRight rec = (BAccessRight)cursor.get();
                AccessRightCache.insertAccessRight(dbCache, rec);
            }
            cursor.close();
        }
    }

    public static void initAccessRights(DbCache dbCache, BAccessRight[] accessRights) {
        AccessRightCache.getWriteLock(rwLock);
        try {
            accessRightsMap.clear();
        }
        finally {
            AccessRightCache.releaseWriteLock(rwLock);
        }
        if (!dbCache.isRunningOnSupervisor()) {
            for (int i = 0; i < accessRights.length; ++i) {
                AccessRightCache.insertAccessRight(dbCache, accessRights[i]);
            }
        }
    }

    public static void insertAccessRight(DbCache dbCache, BAccessRight rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            AccessRightCache.getWriteLock(rwLock);
            try {
                AccessRightCacheData data = AccessRightCache.getCacheData(rec.getAccessRightId());
                if (data == null) {
                    data = new AccessRightCacheData(rec);
                } else {
                    data.setData(rec);
                }
                AccessRightCache.addMapEntry(rec.getAccessRightId(), data);
            }
            finally {
                AccessRightCache.releaseWriteLock(rwLock);
            }
        }
    }

    public static void updateAccessRight(DbCache dbCache, BAccessRight rec) {
        if (!dbCache.isRunningOnSupervisor()) {
            AccessRightCache.insertAccessRight(dbCache, rec);
        }
    }

    public static void deleteAccessRight(DbCache dbCache, OrionSession session, BAccessRight accessRight) {
        if (!dbCache.isRunningOnSupervisor()) {
            AccessRightCache.removeAccessRight(dbCache, session, accessRight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeAccessRight(DbCache dbCache, OrionSession session, BAccessRight accessRight) {
        boolean objectExists = false;
        AccessRightCache.getWriteLock(rwLock);
        try {
            objectExists = accessRightsMap.remove(accessRight.getAccessRightId()) != null;
        }
        finally {
            AccessRightCache.releaseWriteLock(rwLock);
        }
        if (objectExists) {
            dbCache.removeAccessRights(session, accessRight);
        }
    }

    public static BAccessRightData getAccessRightData(BUuid accessRightUuid) {
        AccessRightCache.getReadLock(rwLock);
        try {
            AccessRightCacheData cacheData = AccessRightCache.getCacheData(accessRightUuid);
            if (cacheData == null) {
                BAccessRightData bAccessRightData = null;
                return bAccessRightData;
            }
            BAccessRightData bAccessRightData = new BAccessRightData(accessRightUuid, cacheData);
            return bAccessRightData;
        }
        finally {
            AccessRightCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BAccessRightData[] getAccessRightDataArr() {
        AccessRightCache.getReadLock(rwLock);
        try {
            Set set = accessRightsMap.entrySet();
            if (set.isEmpty()) {
                BAccessRightData[] bAccessRightDataArray = EMPTY_ACCESS_RIGHT_DATA_ARRAY;
                return bAccessRightDataArray;
            }
            Array arr = new Array(BAccessRightData.class);
            for (Map.Entry me : set) {
                AccessRightCacheData data;
                BUuid key = (BUuid)me.getKey();
                BAccessRightData accessRightData = new BAccessRightData(key, data = (AccessRightCacheData)me.getValue());
                if (accessRightData == null) continue;
                arr.add((Object)accessRightData);
            }
            BAccessRightData[] bAccessRightDataArray = (BAccessRightData[])arr.trim();
            return bAccessRightDataArray;
        }
        finally {
            AccessRightCache.releaseReadLock(rwLock);
        }
    }

    private static AccessRightCacheData getCacheData(BUuid key) {
        if (key == null) {
            return null;
        }
        AccessRightCache.getReadLock(rwLock);
        try {
            AccessRightCacheData accessRightCacheData = (AccessRightCacheData)accessRightsMap.get(key);
            return accessRightCacheData;
        }
        finally {
            AccessRightCache.releaseReadLock(rwLock);
        }
    }

    private static void addMapEntry(BUuid key, AccessRightCacheData data) {
        AccessRightCache.getWriteLock(rwLock);
        try {
            if (!data.isEmpty()) {
                accessRightsMap.put(key, data);
            } else {
                accessRightsMap.remove(key);
            }
        }
        finally {
            AccessRightCache.releaseWriteLock(rwLock);
        }
    }

    public static int getSize() {
        AccessRightCache.getReadLock(rwLock);
        try {
            int n = accessRightsMap.size();
            return n;
        }
        finally {
            AccessRightCache.releaseReadLock(rwLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printMap() {
        AccessRightCache.getReadLock(rwLock);
        try {
            System.out.println("Access Right Cache: " + AccessRightCache.getSize() + " Record(s)");
            Set set = accessRightsMap.entrySet();
            if (set.isEmpty()) {
                System.out.println("  <empty>\n");
                return;
            }
            for (Map.Entry me : set) {
                BUuid key = (BUuid)me.getKey();
                System.out.println("  Access Right: " + key.toString());
                AccessRightCacheData data = (AccessRightCacheData)me.getValue();
                BUuid scheduleRecUuid = data.getScheduleRecUuid();
                BUuid niagaraIntegrationUuid = data.getNiagaraIntegrationUuid();
                BUuid threatLevelGroupUuid = data.getThreatLevelGroupRecUuid();
                System.out.println("    Schedule: " + scheduleRecUuid.toString());
                System.out.println("    Integration ID: " + niagaraIntegrationUuid.toString());
                System.out.println("    Threat Level Group: " + threatLevelGroupUuid.toString());
                System.out.println("    Threat Level Operation: " + (Object)((Object)data.getThreatLevelOperation()));
                System.out.println("    Assigned Threat Level: " + data.getAssignedThreatLevel());
            }
            System.out.println("");
        }
        finally {
            AccessRightCache.releaseReadLock(rwLock);
        }
    }
}

