/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.util;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionTypeId;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridiumx.accessDriver.enums.BEnforcementEnum;
import com.tridiumx.accessDriver.enums.BOccupancyEnum;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessValidationInfo;
import com.tridiumx.entsec.access.BAccessZone;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.orion.BSupervisorZoneJoin;
import com.tridiumx.entsec.access.util.AccessZonesValidationUtil;
import com.tridiumx.entsec.access.util.ValidationUtil;
import com.tridiumx.entsec.access.util.dbCache.DbCache;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;

public abstract class AccessZonesUpdateUtil {
    public static void update(BAccessValidationInfo info, OrionSession session, BAccessControlService service, DbCache dbCache) {
        BAccessZoneRec[] entryZoneRecs = info.getEntryZoneRecs();
        for (int i = 0; i < entryZoneRecs.length; ++i) {
            BAccessZoneRec rec = entryZoneRecs[i];
            BAccessZone zone = null;
            if (info.entryZones != null) {
                zone = (BAccessZone)info.entryZones.get(rec.getUuid());
            }
            if (zone != null) {
                AccessZonesUpdateUtil.updateEntry(zone, rec, info, session, service, dbCache);
                continue;
            }
            AccessZonesUpdateUtil.remoteUpdateEntry(rec, info, session, dbCache);
        }
        BAccessZoneRec[] exitZoneRecs = info.getExitZoneRecs();
        for (int i = 0; i < exitZoneRecs.length; ++i) {
            BAccessZoneRec rec = exitZoneRecs[i];
            BAccessZone zone = null;
            if (info.exitZones != null) {
                zone = (BAccessZone)info.exitZones.get(rec.getUuid());
            }
            if (zone != null) {
                AccessZonesUpdateUtil.updateExit(zone, rec, info, session, service, dbCache);
                continue;
            }
            AccessZonesUpdateUtil.remoteUpdateExit(rec, info, session, dbCache);
        }
    }

    private static void remoteUpdateEntry(BAccessZoneRec rec, BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        block2: {
            try {
                RemoteUtil.invokeRemote(rec.getStationName(), rec.getMappedOrd(), BAccessZone.remoteUpdateEntry, (BValue)info);
            }
            catch (Exception e) {
                if (rec.getFallbackEnforcement() == BEnforcementEnum.off) break block2;
                info.getRecord().setActivity(BBadgeActivity.connectionProblem);
                StringBuffer b = new StringBuffer();
                b.append(BAccessControlService.lex.getText("error.connectFailure", new Object[]{rec.getStationName(), rec.getZoneName()}));
                b.append(": ");
                b.append(BAccessControlService.lex.getText("accessZoneNotUpdated"));
                info.getRecord().setDetails(b.toString());
                ValidationUtil.record(info, session, dbCache);
            }
        }
    }

    private static void remoteUpdateExit(BAccessZoneRec rec, BAccessValidationInfo info, OrionSession session, DbCache dbCache) {
        block2: {
            try {
                RemoteUtil.invokeRemote(rec.getStationName(), rec.getMappedOrd(), BAccessZone.remoteUpdateExit, (BValue)info);
            }
            catch (Exception e) {
                if (rec.getFallbackEnforcement() == BEnforcementEnum.off) break block2;
                info.getRecord().setActivity(BBadgeActivity.connectionProblem);
                StringBuffer b = new StringBuffer();
                b.append(BAccessControlService.lex.getText("error.connectFailure", new Object[]{rec.getStationName(), rec.getZoneName()}));
                b.append(": ");
                b.append(BAccessControlService.lex.getText("accessZoneNotUpdated"));
                info.getRecord().setDetails(b.toString());
                ValidationUtil.record(info, session, dbCache);
            }
        }
    }

    public static void updateEntry(BAccessZone accessZone, BAccessZoneRec rec, BAccessValidationInfo info, OrionSession session, BAccessControlService service, DbCache dbCache) {
        BSupervisorZoneJoin supervisor = null;
        if (accessZone.getOccupancyCriteria() == BOccupancyEnum.supervisors) {
            supervisor = new BSupervisorZoneJoin();
            supervisor.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)info.getPersonData().getPersonUuid()));
            supervisor.setAccessZone(BRef.make((BIOrionObject)rec));
        }
        BPersonZoneJoin inside = AccessZonesValidationUtil.getPersonZoneJoin(info, session, dbCache, rec);
        int newPeople = 0;
        if (inside != null) {
            inside.setLastModified(BAbsTime.now());
            dbCache.updatePersonZone(inside);
            service.updatePersonZoneJoin(inside);
            if (accessZone.getOccupancyCriteria() == BOccupancyEnum.supervisors && !AccessZonesValidationUtil.supervisorExists(info, session, dbCache, supervisor)) {
                return;
            }
        } else {
            BPersonZoneJoin newInside = new BPersonZoneJoin();
            newInside.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)info.getPersonData().getPersonUuid()));
            newInside.setAccessZone(BRef.make((BIOrionObject)rec));
            dbCache.insertPersonZone(newInside);
            service.insertPersonZoneJoin(newInside);
            if (accessZone.getOccupancyCriteria() == BOccupancyEnum.supervisors && !AccessZonesValidationUtil.supervisorExists(info, session, dbCache, supervisor)) {
                return;
            }
            ++newPeople;
            Clock.Ticket ticket = (Clock.Ticket)accessZone.cleanupTickets.get(info.getDoorHandle());
            if (ticket != null) {
                ticket.cancel();
                ticket = null;
            }
            for (int j = accessZone.pending.size() - 1; j >= 0; --j) {
                BAccessZone.PendingOccupancy p = (BAccessZone.PendingOccupancy)accessZone.pending.get(j);
                if (!p.doorHandle.equals(info.getDoorHandle())) continue;
                if (!info.getPersonData().getPersonUuid().equals((Object)p.personId)) {
                    newInside = new BPersonZoneJoin();
                    newInside.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)p.personId));
                    newInside.setAccessZone(BRef.make((BIOrionObject)rec));
                    if (p.entry) {
                        dbCache.insertPersonZone(newInside);
                        service.insertPersonZoneJoin(newInside);
                        ++newPeople;
                    } else {
                        dbCache.deletePersonZone(newInside);
                        service.deletePersonZoneJoin(newInside);
                        --newPeople;
                    }
                }
                accessZone.pending.remove(j);
            }
        }
        double total = accessZone.getFallback().getNumeric();
        accessZone.getFallback().setValue(total += (double)newPeople);
    }

    public static void updateExit(BAccessZone accessZone, BAccessZoneRec rec, BAccessValidationInfo info, OrionSession session, BAccessControlService service, DbCache dbCache) {
        BPersonZoneJoin inside;
        if (accessZone.getOccupancyCriteria() == BOccupancyEnum.supervisors) {
            BSupervisorZoneJoin supervisor = new BSupervisorZoneJoin();
            supervisor.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)info.getPersonData().getPersonUuid()));
            supervisor.setAccessZone(BRef.make((BIOrionObject)rec));
            boolean isSupervisor = AccessZonesValidationUtil.supervisorExists(info, session, dbCache, supervisor);
            if (!isSupervisor) {
                BPersonZoneJoin inside2 = AccessZonesValidationUtil.getPersonZoneJoin(info, session, dbCache, rec);
                if (inside2 != null) {
                    dbCache.deletePersonZone(inside2);
                    service.deletePersonZoneJoin(inside2);
                }
                return;
            }
        }
        if ((inside = AccessZonesValidationUtil.getPersonZoneJoin(info, session, dbCache, rec)) != null) {
            Clock.Ticket ticket;
            dbCache.deletePersonZone(inside);
            service.deletePersonZoneJoin(inside);
            int newPeople = 1;
            for (int j = accessZone.pending.size() - 1; j >= 0; --j) {
                BAccessZone.PendingOccupancy p = (BAccessZone.PendingOccupancy)accessZone.pending.get(j);
                if (!p.doorHandle.equals(info.getDoorHandle())) continue;
                if (!info.getPersonData().getPersonUuid().equals((Object)p.personId)) {
                    BPersonZoneJoin newInside = new BPersonZoneJoin();
                    newInside.setPerson(BRef.make((BOrionTypeId)BPerson.ORION_TYPE.getOrionTypeId(), (BSimple)p.personId));
                    newInside.setAccessZone(BRef.make((BIOrionObject)rec));
                    if (p.entry) {
                        dbCache.insertPersonZone(newInside);
                        service.insertPersonZoneJoin(newInside);
                        --newPeople;
                    } else {
                        dbCache.deletePersonZone(newInside);
                        service.deletePersonZoneJoin(newInside);
                        ++newPeople;
                    }
                }
                accessZone.pending.remove(j);
            }
            double total = accessZone.getFallback().getNumeric();
            accessZone.getFallback().setValue(total -= (double)newPeople);
            if (Double.compare(total, 0.0) == 0 && (ticket = (Clock.Ticket)accessZone.cleanupTickets.get(info.getDoorHandle())) != null) {
                ticket.cancel();
                ticket = null;
            }
        }
    }
}

