/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.ui.schedule;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridiumx.entsec.access.schedule.BScheduleAddInfo;
import com.tridiumx.entsec.access.ui.schedule.BDistributedScheduleManager;
import com.tridiumx.entsec.access.ui.schedule.BDistributedScheduleMgrTable;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BStringSchedule;
import javax.baja.schedule.BTriggerSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTreePane;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.nav.tree.BNavTree;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeController;
import javax.baja.workbench.nav.tree.NavTreeNode;

public class DistributedScheduleModel
extends MgrModel {
    public MgrColumn nameCol;
    public MgrColumn.Path pathCol;
    BDistributedScheduleManager manager;
    static final UiLexicon lex = new UiLexicon(BDistributedScheduleManager.class);

    public DistributedScheduleModel(BDistributedScheduleManager manager) {
        super((BAbstractManager)manager);
        this.manager = manager;
    }

    public MgrTypeInfo[] getNewTypes() {
        return new MgrTypeInfo[]{MgrTypeInfo.make((Type)BBooleanSchedule.TYPE), MgrTypeInfo.make((Type)BNumericSchedule.TYPE), MgrTypeInfo.make((Type)BEnumSchedule.TYPE), MgrTypeInfo.make((Type)BStringSchedule.TYPE), MgrTypeInfo.make((Type)BCalendarSchedule.TYPE), MgrTypeInfo.make((Type)BTriggerSchedule.TYPE)};
    }

    protected String makeTableTitle() {
        return this.manager.getTableTitle();
    }

    public int getSubscribeDepth() {
        return 1;
    }

    public Type[] getIncludeTypes() {
        return new Type[]{BBooleanSchedule.TYPE, BNumericSchedule.TYPE, BEnumSchedule.TYPE, BStringSchedule.TYPE, BCalendarSchedule.TYPE, BTriggerSchedule.TYPE};
    }

    public boolean accept(BComponent c) {
        Type[] validTypes = this.getIncludeTypes();
        for (int i = 0; i < validTypes.length; ++i) {
            if (c.getType() != validTypes[i]) continue;
            return true;
        }
        return false;
    }

    public void load(BComponent target) {
        super.load(target);
    }

    public BMgrTable makeTable() {
        return new BDistributedScheduleMgrTable(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandArtifact addInstances(MgrEditRow[] rows, Context cx) throws Exception {
        BFoxSession foxSession = null;
        try {
            BOrd parentOrd = this.promptForAddScheduleLocation();
            if (parentOrd == null) {
                CommandArtifact commandArtifact = null;
                return commandArtifact;
            }
            BComponent container = (BComponent)parentOrd.resolve(this.manager.getCurrentValue()).get();
            BNiagaraStation station = (BNiagaraStation)this.manager.getDeviceExt().getParent();
            foxSession = RemoteUtil.getFoxSession(station);
            if (foxSession == null) {
                CommandArtifact commandArtifact = null;
                return commandArtifact;
            }
            BNiagaraWbShell shell = (BNiagaraWbShell)this.manager.getWbShell();
            if (shell != null && shell.isAppletOrWebStart()) {
                foxSession.getConnection().setCheckBrandCompatibility(false);
            }
            foxSession.getConnection().engageNoRetry((BFoxClientConnection.Interest)this.manager);
            String[] names = new String[rows.length];
            String[] learnPaths = new String[rows.length];
            for (int i = 0; i < rows.length; ++i) {
                names[i] = SlotPath.escape((String)rows[i].getName());
                learnPaths[i] = this.manager.getLearnPath(rows[i].getDiscovery());
            }
            this.addInstances(this.manager, names, learnPaths, container);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (foxSession != null && foxSession.getConnection().isEngaged((BFoxClientConnection.Interest)this.manager)) {
                foxSession.getConnection().disengage((BFoxClientConnection.Interest)this.manager);
            }
        }
        return null;
    }

    private void addInstances(BDistributedScheduleManager manager, String[] names, String[] learnPaths, BComponent container) {
        try {
            BDistributedScheduleMgrTable table = (BDistributedScheduleMgrTable)manager.getModel().getTable();
            table.clearScheduleContainerMap();
            BScheduleAddInfo addInfo = new BScheduleAddInfo();
            BVector namesVector = new BVector();
            for (int i = 0; i < names.length; ++i) {
                namesVector.add("n" + i, (BValue)BString.make((String)names[i]));
            }
            addInfo.setNames(namesVector);
            BVector valuesVector = new BVector();
            for (int i = 0; i < learnPaths.length; ++i) {
                valuesVector.add("v" + i, (BValue)BString.make((String)learnPaths[i]));
            }
            addInfo.setValues(valuesVector);
            addInfo.setContainer(container.getSlotPathOrd());
            Action action = manager.getDeviceExt().getAction("submitDistributedAdd");
            if (action != null) {
                manager.getLearn().setJob((BOrd)manager.getDeviceExt().invoke(action, (BValue)addInfo));
            }
            manager.getController().updateCommands();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected MgrColumn[] makeColumns() {
        MgrColumn[] mgrColumnArray = new MgrColumn[3];
        mgrColumnArray[0] = this.nameCol = new MgrColumn.Name();
        this.pathCol = new LocalPath(4);
        mgrColumnArray[1] = this.pathCol;
        mgrColumnArray[2] = new MgrColumn.Type(5);
        return mgrColumnArray;
    }

    private BOrd promptForAddScheduleLocation() {
        BOrd lastOrd;
        BNavTree tree = null;
        BComponent base = null;
        BOrd baseOrd = this.manager.getLocalScheduleBase();
        if (baseOrd == null || baseOrd.isNull()) {
            baseOrd = BOrd.make((String)"station:|slot:/");
        }
        if ((lastOrd = this.manager.getLastScheduleFolder()) == null || lastOrd.isNull()) {
            lastOrd = BOrd.make((String)"station:|slot:/");
        }
        try {
            base = (BComponent)baseOrd.resolve(this.manager.getCurrentValue()).get();
            if (base == null) {
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (base == null && (base = (BComponent)(baseOrd = BOrd.make((String)"station:|slot:/")).resolve(this.manager.getCurrentValue()).get()) == null) {
            return null;
        }
        if (base instanceof BComponent) {
            tree = new BNavTree((BINavNode)BOrd.make((String)base.getAbsoluteOrd().toString()).get());
            ((DefaultNavTreeModel)tree.getModel()).setRootVisible(true);
        } else {
            tree = new BNavTree();
        }
        try {
            tree.setReadonly(true);
            tree.setController((TreeController)new NavController());
            if (base != null && baseOrd != null && !baseOrd.isNull() && baseOrd.toString().length() > 0) {
                tree.expandToOrd((BObject)base, lastOrd);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)new BTreePane((BTree)tree), BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        pane.setMinWidth(300.0);
        pane.setMinHeight(200.0);
        BGridPane grid = new BGridPane(1);
        grid.add(null, (BValue)new BLabel(lex.get("scheduling.selectContainer")));
        BEdgePane edgePane1 = new BEdgePane();
        edgePane1.setCenter((BWidget)grid);
        BEdgePane edgePane = new BEdgePane();
        edgePane.setTop((BWidget)edgePane1);
        edgePane.setCenter((BWidget)pane);
        String title = this.manager.getController().add.getLabel();
        int r = BDialog.open((BWidget)this.manager, (String)title, (Object)edgePane, (int)3);
        if (r == 2) {
            return null;
        }
        BOrd parentOrd = null;
        try {
            parentOrd = ((NavTreeNode)tree.getSelection().getNode()).getNavNode().getNavOrd();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (parentOrd == null || parentOrd.isNull()) {
            return null;
        }
        this.manager.setLastScheduleFolder(parentOrd);
        return parentOrd;
    }

    private class NavController
    extends NavTreeController {
        private NavController() {
        }

        public void nodeDoubleClicked(BMouseEvent event, TreeNode node) {
        }
    }

    public static class LocalPath
    extends MgrColumn.Path {
        public LocalPath(int flags) {
            super(flags);
        }

        public String getDisplayName() {
            return lex.getText("scheduling.supervisorId");
        }

        public BValue load(MgrEditRow row) {
            BValue value = (BValue)this.get(row.getTarget());
            if (value != null) {
                return value.newCopy();
            }
            return null;
        }
    }
}

