/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.ui.schedule;

import com.tridiumx.entsec.access.schedule.BScheduleExportInfo;
import com.tridiumx.entsec.access.schedule.util.MatchUtil;
import com.tridiumx.entsec.access.ui.schedule.BDistributedScheduleManager;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrController;

public class DistributedScheduleController
extends MgrController {
    BDistributedScheduleManager manager;
    final UiLexicon lex = new UiLexicon(BDistributedScheduleManager.class);
    public final MgrController.MgrCommand exportCommand;

    public DistributedScheduleController(BDistributedScheduleManager mgr) {
        super((BAbstractManager)mgr);
        this.manager = mgr;
        this.exportCommand = new ExportCommand((BWidget)mgr);
        this.exportCommand.setFlags(15);
    }

    public CommandArtifact doDiscover(Context cx) throws Exception {
        super.doDiscover(cx);
        Action action = this.manager.getDeviceExt().getAction("submitDistributedDiscover");
        if (action != null) {
            this.manager.getLearn().setJob((BOrd)this.manager.getDeviceExt().invoke(action, (BValue)MatchUtil.getDiscoveryQuery(this.manager.getModel().getIncludeTypes())));
        }
        this.updateCommands();
        return null;
    }

    public void updateCommands() {
        BMgrTable table;
        BJob job;
        if (this.manager.getLearn() != null && (job = this.manager.getLearn().getJob()) != null && job.getJobState() != null && job.getJobState().isRunning()) {
            this.discover.setEnabled(false);
            this.add.setEnabled(false);
            this.match.setEnabled(false);
            this.exportCommand.setEnabled(false);
            return;
        }
        super.updateCommands();
        BLearnTable learnTable = this.getLearnTable();
        if (learnTable != null && !learnTable.getSelection().isEmpty()) {
            this.add.setEnabled(!this.manager.learnSelectionsAlreadyImported());
        }
        if ((table = this.getTable()) == null || table.getSelection().isEmpty()) {
            this.exportCommand.setEnabled(false);
        } else {
            this.exportCommand.setEnabled(true);
        }
    }

    public void cellDoubleClicked(BMgrTable table, BMouseEvent event, int row, int col) {
        if (this.allSelectionsContainExt()) {
            super.cellDoubleClicked(table, event, row, col);
        }
    }

    public void cellDoubleClicked(BLearnTable learnTable, BMouseEvent event, int row, int col) {
        if (!this.manager.learnSelectionsAlreadyImported()) {
            super.cellDoubleClicked(learnTable, event, row, col);
        }
    }

    private boolean allSelectionsContainExt() {
        boolean enabled = true;
        BComponent[] selComponents = this.getSelectedComponents();
        for (int i = 0; i < selComponents.length; ++i) {
            if (BScheduleDeviceExt.getExt((BAbstractSchedule)((BAbstractSchedule)selComponents[i])) != null) continue;
            enabled = false;
            break;
        }
        return enabled;
    }

    protected MgrController.IMgrCommand[] makeCommands() {
        return new MgrController.IMgrCommand[]{this.learnMode, this.discover, this.add, this.match, this.exportCommand};
    }

    public CommandArtifact doAdd(Context cx) throws Exception {
        return super.doAdd(cx);
    }

    public CommandArtifact doMatch(Object discovery, BComponent database, Context cx) throws Exception {
        this.manager.matchSchedule(discovery, database, cx);
        return null;
    }

    private void exportSchedules(BDistributedScheduleManager manager, BScheduleExportInfo exportInfo) {
        try {
            Action action = manager.getDeviceExt().getAction("submitDistributedExport");
            if (action != null) {
                manager.getLearn().setJob((BOrd)manager.getDeviceExt().invoke(action, (BValue)exportInfo));
            }
            this.updateCommands();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ExportCommand
    extends MgrController.MgrCommand {
        public ExportCommand(BWidget owner) {
            super(owner, Lexicon.make((String)"schedule"), "driver.command.export");
        }

        public CommandArtifact doInvoke() {
            BComponent[] sel = DistributedScheduleController.this.getTable().getSelectedComponents();
            BScheduleExportInfo exportInfo = new BScheduleExportInfo();
            BVector supervisorIdsVector = new BVector();
            for (int i = 0; i < sel.length; ++i) {
                supervisorIdsVector.add("s" + i, (BValue)BString.make((String)sel[i].getSlotPathOrd().toString()));
            }
            exportInfo.setSupervisorIds(supervisorIdsVector);
            DistributedScheduleController.this.exportSchedules(DistributedScheduleController.this.manager, exportInfo);
            return null;
        }
    }
}

