/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.ui.schedule;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridium.orion.OrionSession;
import com.tridium.workbench.shell.BNiagaraWbShell;
import com.tridiumx.entsec.access.schedule.BDistributedScheduleOptions;
import com.tridiumx.entsec.access.schedule.nd.BDistributedScheduleAddJob;
import com.tridiumx.entsec.access.schedule.nd.BDistributedScheduleExportJob;
import com.tridiumx.entsec.access.schedule.nd.BDistributedScheduleLearnResult;
import com.tridiumx.entsec.access.schedule.util.MatchUtil;
import com.tridiumx.entsec.access.ui.schedule.BDistributedScheduleMgrTable;
import com.tridiumx.entsec.access.ui.schedule.DistributedScheduleController;
import com.tridiumx.entsec.access.ui.schedule.DistributedScheduleModel;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.gx.BImage;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class BDistributedScheduleManager
extends BAbstractManager
implements BFoxClientConnection.Interest {
    public static final Property localScheduleBase = BDistributedScheduleManager.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Property lastScheduleFolder = BDistributedScheduleManager.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BDistributedScheduleManager.class);
    private static BImage iconImg = BImage.make((BIcon)BIcon.std((String)"schedule.png"));
    final UiLexicon lex = new UiLexicon(BDistributedScheduleManager.class);
    final String lexType = UiLexicon.bajaui().getText("type");
    public BDistributedScheduleOptions options;
    String lexDiscoveryObjects = "";
    String lexDatabaseObjects = "";

    public BOrd getLocalScheduleBase() {
        return (BOrd)this.get(localScheduleBase);
    }

    public void setLocalScheduleBase(BOrd v) {
        this.set(localScheduleBase, (BValue)v, null);
    }

    public BOrd getLastScheduleFolder() {
        return (BOrd)this.get(lastScheduleFolder);
    }

    public void setLastScheduleFolder(BOrd v) {
        this.set(lastScheduleFolder, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void stopped() throws Exception {
        super.stopped();
        this.unregisterForAllComponentEvents();
        if (this.options != null) {
            this.options.setLastScheduleContainer(this.getLastScheduleFolder());
            this.options.save();
        }
    }

    public void doLoadValue(BObject value, Context cx) {
        this.init(value, cx);
        BStation station = MatchUtil.getConfigStation((BComponent)this.getDeviceExt());
        this.setTableTitle(station.getStationName());
        super.doLoadValue(value, cx);
        MatchUtil.createActions(this.getDeviceExt());
    }

    public void init(BObject value, Context cx) {
        this.initOptions();
        this.setLastScheduleFolder(this.options.getLastScheduleContainer());
    }

    public void initOptions() {
        this.options = this.getDefaultOptions();
    }

    private BDistributedScheduleOptions getDefaultOptions() {
        return BDistributedScheduleOptions.getDefault();
    }

    public void setTableTitle(String title) {
        this.lexDatabaseObjects = title;
    }

    public void setLearnTableTitle(String title) {
        this.lexDiscoveryObjects = title;
    }

    public String getTableTitle() {
        return this.lexDatabaseObjects;
    }

    public String getLearnTableTitle() {
        return this.lexDiscoveryObjects;
    }

    public BNiagaraScheduleDeviceExt getDeviceExt() {
        return (BNiagaraScheduleDeviceExt)this.getCurrentValue();
    }

    protected MgrController makeController() {
        return new DistributedScheduleController(this);
    }

    protected MgrModel makeModel() {
        return new DistributedScheduleModel(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrState makeState() {
        return new State();
    }

    private BDistributedScheduleLearnResult lr(Object o) {
        return (BDistributedScheduleLearnResult)((Object)o);
    }

    private DistributedScheduleModel model() {
        return (DistributedScheduleModel)this.getModel();
    }

    public boolean learnSelectionsAlreadyImported() {
        BLearnTable learnTable = this.getController().getLearnTable();
        if (learnTable != null) {
            int[] learnSel = this.getController().getLearnSelectedRows();
            for (int i = 0; i < learnSel.length; ++i) {
                String lrSupervisorId = this.getLearnSupervisorId(learnTable.getObjectAt(learnSel[i]));
                if (lrSupervisorId == null || lrSupervisorId.length() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public String getLearnName(Object discovery) {
        return this.lr(discovery).getName();
    }

    public String getLearnPath(Object discovery) {
        return this.lr(discovery).getPath();
    }

    public String getLearnSupervisorId(Object discovery) {
        return this.lr(discovery).getSupervisorId();
    }

    public Type getLearnType(Object discovery) {
        return Sys.getRegistry().getType(this.lr(discovery).getTypeStr()).getTypeSpec().getResolvedType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void matchSchedule(Object discovery, BComponent database, Context cx) throws Exception {
        block19: {
            BFoxSession foxSession = null;
            OrionSession remoteOrionSession = null;
            try {
                BNiagaraStation station = (BNiagaraStation)this.getDeviceExt().getParent();
                foxSession = RemoteUtil.getFoxSession(station);
                if (foxSession == null) {
                    return;
                }
                BNiagaraWbShell shell = (BNiagaraWbShell)this.getWbShell();
                if (shell != null && shell.isAppletOrWebStart()) {
                    foxSession.getConnection().setCheckBrandCompatibility(false);
                }
                foxSession.getConnection().engageNoRetry((BFoxClientConnection.Interest)this);
                BComponent remoteSchedule = RemoteUtil.getRemoteComponent(foxSession, this.getLearnPath(discovery));
                if (remoteSchedule == null) {
                    return;
                }
                remoteSchedule.lease();
                String scheduleName = this.promptForMatchName(foxSession, remoteSchedule, database, cx);
                if (scheduleName == null) break block19;
                BNiagaraNetwork remoteNiagaraNetwork = (BNiagaraNetwork)foxSession.getService(BNiagaraNetwork.TYPE);
                if (remoteNiagaraNetwork == null) {
                    BDialog.error((BWidget)this, (Object)"Failed to find remote network");
                    return;
                }
                BNiagaraStation remoteStation = RemoteUtil.findStation((BComponent)remoteNiagaraNetwork, MatchUtil.getConfigStation((BComponent)this.getDeviceExt()).getStationName());
                if (remoteStation == null) {
                    BDialog.error((BWidget)this, (Object)("Failed to find remote station '" + MatchUtil.getConfigStation((BComponent)this.getDeviceExt()).getStationName() + "'"));
                    return;
                }
                remoteStation.lease();
                BNiagaraScheduleDeviceExt remoteScheduleDeviceExt = remoteStation.getSchedules();
                remoteScheduleDeviceExt.lease();
                try {
                    remoteOrionSession = MatchUtil.getRemoteOrionSession(foxSession, cx);
                    if (this.lr(discovery).isMatchable(foxSession, database, remoteOrionSession, remoteSchedule, cx)) {
                        MatchUtil.matchSchedule(foxSession, remoteScheduleDeviceExt, remoteSchedule, database, SlotPath.escape((String)scheduleName), remoteOrionSession, cx);
                        this.getController().doDiscover(cx);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String errorMessage = null;
                    errorMessage = e.getMessage() != null ? e.getMessage() : e.toString();
                    BDialog.error((BWidget)this, (Object)errorMessage);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (remoteOrionSession != null) {
                    remoteOrionSession.close();
                    remoteOrionSession = null;
                }
                if (foxSession != null && foxSession.getConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                    foxSession.getConnection().disengage((BFoxClientConnection.Interest)this);
                }
            }
        }
    }

    private String promptForMatchName(BFoxSession foxSession, BComponent remoteSchedule, BComponent database, Context cx) throws Exception {
        String currentName = null;
        currentName = BScheduleDeviceExt.getExt((BAbstractSchedule)((BAbstractSchedule)remoteSchedule)) != null ? remoteSchedule.getDisplayName(cx) : database.getDisplayName(cx);
        BTextField schedNameField = new BTextField(currentName, 48);
        BTextField supervisorField = new BTextField(database.getSlotPathOrd().toString(), 64);
        supervisorField.setEditable(false);
        BGridPane grid = new BGridPane(2);
        grid.add(null, (BValue)new BLabel(this.lex.getText("scheduling.name")));
        grid.add(null, (BValue)schedNameField);
        grid.add(null, (BValue)new BLabel(this.lex.getText("scheduling.supervisorId")));
        grid.add(null, (BValue)supervisorField);
        String title = this.getController().match.getLabel();
        int r = BDialog.open((BWidget)this, (String)title, (Object)grid, (int)3);
        if (r == 2) {
            return null;
        }
        return schedNameField.getText();
    }

    private class TypeCol
    extends MgrColumn {
        public TypeCol() {
            super(BDistributedScheduleManager.this.lexType, 4);
        }

        public Object get(Object row) {
            return Sys.getRegistry().getType(BDistributedScheduleManager.this.lr(row).getTypeStr()).getTypeName();
        }
    }

    public class State
    extends MgrState {
        Object[] roots;
        BJob jobToRemember;

        State() {
        }

        protected void restoreForOrd(BAbstractManager manager) {
            super.restoreForOrd(manager);
            if (this.roots != null) {
                manager.getLearn().updateRoots(this.roots);
            }
            if (this.jobToRemember != null && this.jobToRemember.isMounted()) {
                manager.getLearn().setJob(this.jobToRemember);
            }
        }

        protected void saveForOrd(BAbstractManager manager) {
            super.saveForOrd(manager);
            this.roots = manager.getLearn().getRoots();
            this.jobToRemember = manager.getLearn().getJob();
        }

        public BJob getJob() {
            return this.jobToRemember;
        }
    }

    private class SupervisorIdCol
    extends MgrColumn {
        public SupervisorIdCol(String header) {
            super(header, 1);
        }

        public Object get(Object row) {
            return BDistributedScheduleManager.this.getLearnSupervisorId(row);
        }
    }

    private class PathCol
    extends MgrColumn {
        public PathCol(String header) {
            this(header, 1);
        }

        public PathCol(String header, int flags) {
            super(header, 4);
        }

        public Object get(Object row) {
            return BDistributedScheduleManager.this.getLearnPath(row);
        }
    }

    private class Learn
    extends MgrLearn {
        BDistributedScheduleManager manager;

        public Learn(BDistributedScheduleManager manager) {
            super((BAbstractManager)BDistributedScheduleManager.this);
            BNiagaraScheduleDeviceExt schedDeviceExt = BDistributedScheduleManager.this.getDeviceExt();
            BDistributedScheduleManager.this.setLearnTableTitle(schedDeviceExt.getParent().getDisplayName(null));
            this.manager = manager;
        }

        public BImage getIcon(Object d) {
            return iconImg;
        }

        public String makeTableTitle() {
            return BDistributedScheduleManager.this.getLearnTableTitle();
        }

        public boolean isExisting(Object dis, BComponent db) {
            return db.getSlotPathOrd().toString().equals(BDistributedScheduleManager.this.getLearnSupervisorId(dis));
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return Sys.getRegistry().getType(BDistributedScheduleManager.this.lr(dis).getTypeStr()).is(db.getType());
        }

        public void jobComplete(BJob job) {
            if (job.getType().is(BDistributedScheduleAddJob.TYPE)) {
                try {
                    BDistributedScheduleMgrTable table = (BDistributedScheduleMgrTable)this.getManager().getModel().getTable();
                    table.reload();
                    BDistributedScheduleManager.this.getController().doDiscover(this.getManager().getCurrentContext());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            if (job.getType().is(BDistributedScheduleExportJob.TYPE)) {
                try {
                    BDistributedScheduleManager.this.getController().doDiscover(this.getManager().getCurrentContext());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            job.lease(Integer.MAX_VALUE);
            this.updateRoots(job.getChildren(BDistributedScheduleLearnResult.class));
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Name(), new PathCol(BDistributedScheduleManager.this.lex.getText("scheduling.path"), 4), new SupervisorIdCol(BDistributedScheduleManager.this.lex.getText("scheduling.supervisorId")), new TypeCol()};
        }

        public void toRow(Object d, MgrEditRow row) throws Exception {
            row.setCell(((BDistributedScheduleManager)BDistributedScheduleManager.this).model().nameCol, (BValue)BString.make((String)((BComponent)d).getName()));
        }

        public MgrTypeInfo[] toTypes(Object d) {
            return new MgrTypeInfo[]{MgrTypeInfo.make((TypeInfo)Sys.getRegistry().getType(BDistributedScheduleManager.this.lr(d).getTypeStr()))};
        }
    }
}

