/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.ui.px;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.kitpx.BBoundLabel;
import com.tridium.kitpx.BBoundLabelBinding;
import com.tridium.kitpx.enums.BStatusEffect;
import com.tridium.nrio.BNrioDevice;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.videoDriver.camera.BIRemoteVideoCamera;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.ui.BVideoPlayer;
import com.tridium.videoDriver.ui.camera.BVideoCameraWidget;
import com.tridium.videoDriver.ui.camera.BVideoPanTiltJoystick;
import com.tridium.videoDriver.ui.camera.BVideoPtzBinding;
import com.tridium.videoDriver.ui.camera.BVideoPtzCtrlPanel;
import com.tridium.videoDriver.ui.camera.BVideoZoomSlider;
import com.tridium.videoDriver.ui.holdDownButton.px.BHoldDownPxBinding;
import com.tridium.videoDriver.ui.holdDownButton.px.BHoldDownPxButton;
import com.tridium.videoDriver.ui.multistream.BVideoMultistreamPane;
import com.tridium.videoDriver.ui.playback.BLiveVideo;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.ui.videoStream.BVideoMultistreamBinding;
import com.tridium.videoDriver.ui.videoStream.BVideoStreamBinding;
import com.tridium.workbench.shell.BNiagaraWbApplet;
import com.tridium.workbench.shell.BNiagaraWbWebStartShell;
import com.tridiumx.accessDriver.BAccessDoor;
import com.tridiumx.accessDriver.BAccessNetwork;
import com.tridiumx.accessDriver.BAccessSdi;
import com.tridiumx.accessDriver.BIAccessDevice;
import javax.baja.agent.AgentList;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.converters.BIBooleanToSimple;
import javax.baja.converters.BIStatusToSimple;
import javax.baja.converters.BObjectToString;
import javax.baja.driver.BDevice;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.Mark;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.ui.BLabel;
import javax.baja.ui.BLayout;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbViewBinding;

abstract class AccessMenuBuilder {
    AccessMenuBuilder() {
    }

    static BMenu getNewMenu(BPxEditorPane editor, BTransferWidget trans) {
        BMenu menu = new BMenu();
        BLabel label = new BLabel();
        label.setLayout(BLayout.make((String)"0,0,100,20"));
        String name = Lexicon.make((String)"entsec").getText("blankLabel");
        menu.add(null, (Command)new NewWidget(editor, trans, name, (BWidget)label));
        BFoxSession foxSession = null;
        BWidgetShell shell = editor.getShell();
        foxSession = shell instanceof BNiagaraWbWebStartShell ? ((BNiagaraWbWebStartShell)shell).getFoxSession() : ((BNiagaraWbApplet)shell).getFoxSession();
        BComponent root = BOrd.make((String)"station:|slot:/").get((BObject)foxSession).asComponent();
        try {
            BAccessNetwork network = (BAccessNetwork)foxSession.getService(BAccessNetwork.TYPE);
            network.lease();
            BIAccessDevice[] modules = (BIAccessDevice[])network.getChildren(BIAccessDevice.class);
            for (int i = 0; i < modules.length; ++i) {
                menu.add(null, (BValue)new BSubMenuItem((BIMenu)AccessMenuBuilder.getModuleMenu(editor, trans, modules[i])));
            }
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        menu.add(null, (BValue)new BSubMenuItem((BIMenu)AccessMenuBuilder.getCameraMenu(editor, trans, root)));
        menu.add(null, (BValue)new BSubMenuItem((BIMenu)AccessMenuBuilder.getVideoWidgetsMenu(editor, trans)));
        return menu;
    }

    private static BMenu getModuleMenu(BPxEditorPane editor, BTransferWidget trans, BIAccessDevice module) {
        ((BDevice)module).lease();
        String moduleName = TextUtil.toFriendly((String)((BDevice)module).getDisplayName(null));
        BMenu menu = new BMenu(moduleName);
        BLabel label = new BLabel(moduleName);
        label.setLayout(BLayout.make((String)"0,0,100,20"));
        menu.add(null, (Command)new NewWidget(editor, trans, moduleName, (BWidget)label));
        BAccessDoor[] doors = (BAccessDoor[])module.getPoints().getChildren(BAccessDoor.class);
        for (int i = 0; i < doors.length; ++i) {
            doors[i].lease();
            String doorName = doors[i].getDisplayName(null);
            String doorOrd = "station:|slot:/Drivers/AccessNetwork/" + ((BDevice)module).getName() + "/points/" + doors[i].getName();
            BAccessSdi sensor = doors[i].getSensor();
            BBoundLabel bound = new BBoundLabel();
            bound.setLayout(BLayout.make((String)"0,0,100,20"));
            BBoundLabelBinding door = new BBoundLabelBinding();
            door.setOrd(BOrd.make((String)doorOrd));
            bound.add(null, (BValue)door);
            if (sensor != null) {
                BBoundLabelBinding image = new BBoundLabelBinding();
                image.setPopupEnabled(false);
                image.setStatusEffect(BStatusEffect.none);
                image.setOrd(BOrd.make((String)(doorOrd + "/" + sensor.getName() + "/out")));
                bound.add(null, (BValue)image);
                BIBooleanToSimple conv = new BIBooleanToSimple();
                conv.setTrueValue((BSimple)BImage.make((BOrd)BOrd.make((String)"module://entsec/rc/access/doorOpen.png")));
                conv.setFalseValue((BSimple)BImage.make((BOrd)BOrd.make((String)"module://entsec/rc/access/doorClosed.png")));
                image.add("image", (BValue)conv);
                BIStatusToSimple conv2 = new BIStatusToSimple();
                conv2.setUnackedAlarm((BSimple)BBoolean.TRUE);
                image.add("blink", (BValue)conv2);
            }
            menu.add(null, (Command)new NewWidget(editor, trans, doorName, (BWidget)bound));
        }
        String mname = ((BDevice)module).getName();
        AccessMenuBuilder.loadIOItems(editor, trans, ((BNrioDevice)module).getUsedDiArray(), "di", mname, menu);
        AccessMenuBuilder.loadIOItems(editor, trans, ((BNrioDevice)module).getUsedSdiArray(), "sdi", mname, menu);
        AccessMenuBuilder.loadIOItems(editor, trans, ((BNrioDevice)module).getUsedRelayArray(), "ro", mname, menu);
        return menu;
    }

    private static void loadIOItems(BPxEditorPane editor, BTransferWidget trans, BOrd[] ords, String ioBaseName, String moduleName, BMenu menu) {
        for (int i = 0; i < ords.length; ++i) {
            String displayName = ioBaseName + (i + 1);
            String ioOrd = ords[i] == null ? "station:|slot:/Drivers/AccessNetwork/" + moduleName + "/points/" + displayName : ords[i].toString();
            BBoundLabel bound = new BBoundLabel();
            bound.setLayout(BLayout.make((String)"0,0,100,20"));
            BBoundLabelBinding binding = new BBoundLabelBinding();
            binding.setStatusEffect(BStatusEffect.none);
            binding.setOrd(BOrd.make((String)ioOrd));
            bound.add(null, (BValue)binding);
            BObjectToString conv = new BObjectToString();
            binding.add("text", (BValue)conv);
            menu.add(null, (Command)new NewWidget(editor, trans, displayName, (BWidget)bound));
        }
    }

    private static BMenu getVideoWidgetsMenu(BPxEditorPane editor, BTransferWidget trans) {
        Lexicon lex = Lexicon.make((String)"entsec");
        BMenu videoMenu = new BMenu(lex.getText("graphicsEditor.videoPxWidgetMenu.label"));
        BVideoPlayer videoPlayer = new BVideoPlayer();
        videoPlayer.add("binding", (BValue)new BVideoStreamBinding());
        BVideoPtzCtrlPanel videoPtzCtrlPanel = new BVideoPtzCtrlPanel();
        videoPtzCtrlPanel.add("panTiltZoomBinding", (BValue)new BVideoPtzBinding());
        BVideoPanTiltJoystick videoPanTiltJoystick = new BVideoPanTiltJoystick();
        videoPanTiltJoystick.add("panTiltBinding", (BValue)new BVideoPtzBinding());
        BVideoZoomSlider zoomSlider = new BVideoZoomSlider();
        zoomSlider.add("zoomBinding", (BValue)new BVideoPtzBinding());
        BVideoCameraWidget cameraWidget = new BVideoCameraWidget();
        cameraWidget.add("cameraBinding", (BValue)new BVideoPtzBinding());
        BHoldDownPxButton mouseDownBtn = new BHoldDownPxButton();
        mouseDownBtn.add("binding", (BValue)new BHoldDownPxBinding());
        BVideoMultistreamPane multiStreamPane = new BVideoMultistreamPane();
        multiStreamPane.add("binding", (BValue)new BVideoMultistreamBinding());
        videoMenu.add(null, (Command)new NewWidget(editor, trans, lex.getText("graphicsEditor.videoPxWidgetMenu.liveVideoPlayer"), (BWidget)videoPlayer));
        videoMenu.add(null, (Command)new NewWidget(editor, trans, lex.getText("graphicsEditor.videoPxWidgetMenu.controlPanel"), (BWidget)videoPtzCtrlPanel));
        videoMenu.add(null, (Command)new NewWidget(editor, trans, lex.getText("graphicsEditor.videoPxWidgetMenu.panTiltJoystick"), (BWidget)videoPanTiltJoystick));
        videoMenu.add(null, (Command)new NewWidget(editor, trans, lex.getText("graphicsEditor.videoPxWidgetMenu.zoomSlider"), (BWidget)zoomSlider));
        videoMenu.add(null, (Command)new NewWidget(editor, trans, lex.getText("graphicsEditor.videoPxWidgetMenu.cameraWidget"), (BWidget)cameraWidget));
        videoMenu.add(null, (Command)new NewWidget(editor, trans, lex.getText("graphicsEditor.videoPxWidgetMenu.mouseDownBtn"), (BWidget)mouseDownBtn));
        videoMenu.add(null, (Command)new NewWidget(editor, trans, lex.getText("graphicsEditor.videoPxWidgetMenu.videoMultistreamPane"), (BWidget)multiStreamPane));
        return videoMenu;
    }

    private static BMenu getCameraMenu(BPxEditorPane editor, BTransferWidget trans, BComponent root) {
        root.lease(10);
        Lexicon lex = Lexicon.make((String)"entsec");
        BMenu menu = new BMenu(lex.getText("graphicsEditor.cameraMenu.label"));
        BITable cameras = (BITable)BOrd.make((String)"bql: select slotPath, displayName from videoDriver:IVideoCamera").get((BObject)root);
        TableCursor cursor = cameras.cursor();
        Column slotPath = cameras.getColumns().get("slotPath");
        Column displayName = cameras.getColumns().get("displayName");
        while (cursor.next()) {
            BWbViewBinding viewBinding;
            BOrd ord = BOrd.make((String)cursor.cell(slotPath).toString());
            BIVideoCamera camera = (BIVideoCamera)ord.get((BObject)root);
            String cameraName = cursor.cell(displayName).toString();
            if (AccessMenuBuilder.supportsLiveView(camera)) {
                viewBinding = new BWbViewBinding();
                viewBinding.setOrd(ord);
                BLiveVideo liveVideo = new BLiveVideo();
                liveVideo.add("binding", (BValue)viewBinding);
                if (camera instanceof BIRemoteVideoCamera) {
                    menu.add(null, (Command)new NewWidget(editor, trans, cameraName + " (Live View) [Remote Camera]", (BWidget)liveVideo));
                } else {
                    menu.add(null, (Command)new NewWidget(editor, trans, cameraName + " (Live View)", (BWidget)liveVideo));
                }
            }
            if (!AccessMenuBuilder.supportsPlaybackView(camera)) continue;
            viewBinding = new BWbViewBinding();
            viewBinding.setOrd(ord);
            BVideoPlayback videoPlayback = new BVideoPlayback();
            videoPlayback.add("binding", (BValue)viewBinding);
            if (camera instanceof BIRemoteVideoCamera) {
                menu.add(null, (Command)new NewWidget(editor, trans, cameraName + " (Playback View) [Remote Camera]", (BWidget)videoPlayback));
                continue;
            }
            menu.add(null, (Command)new NewWidget(editor, trans, cameraName + " (Playback View)", (BWidget)videoPlayback));
        }
        return menu;
    }

    private static boolean supportsLiveView(BIVideoCamera camera) {
        if (camera == null) {
            return false;
        }
        AgentList agents = camera.asObject().getAgents();
        for (int i = 0; i < agents.size(); ++i) {
            if (!agents.get(i).getAgentType().is(BLiveVideo.TYPE)) continue;
            return true;
        }
        return false;
    }

    private static boolean supportsPlaybackView(BIVideoCamera camera) {
        if (camera == null) {
            return false;
        }
        AgentList agents = camera.asObject().getAgents();
        for (int i = 0; i < agents.size(); ++i) {
            if (!agents.get(i).getAgentType().is(BVideoPlayback.TYPE)) continue;
            return true;
        }
        return false;
    }

    static class NewWidget
    extends Command {
        BPxEditorPane editor;
        BTransferWidget trans;
        String name;
        BWidget widget;

        public NewWidget(BPxEditorPane editor, BTransferWidget trans, String name, BWidget widget) {
            super((BWidget)editor, name, BImage.make((BIcon)widget.getIcon()), null, null);
            this.editor = editor;
            this.trans = trans;
            this.name = name;
            this.widget = widget;
        }

        public CommandArtifact doInvoke() throws Exception {
            return this.trans.insertTransferData(new TransferContext(null, 16, TransferEnvelope.make((Mark)new Mark((BObject[])new BWidget[]{this.widget}, new String[]{""}))));
        }
    }
}

