/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BRef;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionException;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.aes.BRdbSecuritySettings;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.schema.AXToN48PinConverter;
import com.tridiumx.entsec.access.schema.AutoConnect;
import com.tridiumx.entsec.access.schema.InvalidPinConverter;
import com.tridiumx.entsec.access.schema.N46ToN48PinConverter;
import com.tridiumx.entsec.access.schema.PinConverter;
import com.tridiumx.entsec.access.schema.exception.InvalidPinException;
import com.tridiumx.entsec.access.schema.exception.RetainInvalidPinException;
import com.tridiumx.entsec.intrusion.orion.BIntrusionPin;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class Upgrade_1_14_to_1_15
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BAccessControlService.VERSION_1_14;
    private static final BSchemaVersion TO_VERSION = BAccessControlService.VERSION_1_15;
    private static final int BATCH_UPDATE_SIZE_LIMIT = 200;
    protected Logger log = Logger.getLogger("entsec-wb.Upgrade_1_14_to_1_15");

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public void upgrade(BLocalOrionDatabase db, BIOrionApp biOrionApp, OrionSession session) throws Exception {
        try {
            BAccessControlService.LOG.log(Level.INFO, "Upgrading from 1_14 to 1_15.....");
            this.updatePinEncryptionFromHmacSha1ToHmacSha256(BPerson.ORION_TYPE, BPerson.pinNumber, db, session);
            this.updatePinEncryptionFromHmacSha1ToHmacSha256(BIntrusionPin.ORION_TYPE, BIntrusionPin.pinNumber, db, session);
        }
        catch (Exception e) {
            e.printStackTrace();
            BAccessControlService.LOG.log(Level.SEVERE, "Upgrade_1_14_to_1_15 Schema Upgrade either not needed or failed", e);
            throw e;
        }
    }

    private void updatePinEncryptionFromHmacSha1ToHmacSha256(OrionType orionType, Property pinNumber, BLocalOrionDatabase db, OrionSession session) throws Exception {
        String tableName = db.getTableName(orionType);
        try (AutoConnect connect = new AutoConnect(session);
             ResultSet incorrectPinsCountResultSet = connect.getConnection().createStatement().executeQuery("SELECT count(1) FROM " + tableName);){
            int noOfRecordsToBeUpdated = 0;
            if (incorrectPinsCountResultSet.next()) {
                noOfRecordsToBeUpdated = incorrectPinsCountResultSet.getInt(1);
            }
            BAccessControlService.LOG.log(Level.INFO, "No of PINs in " + orionType.getTypeName() + " to be updated::: " + noOfRecordsToBeUpdated);
            if (noOfRecordsToBeUpdated == 0) {
                return;
            }
            StringBuffer incorrectPinsQueryProjection = new StringBuffer();
            Property[] keys = orionType.getKey();
            for (int i = 0; i < keys.length; ++i) {
                incorrectPinsQueryProjection.append(keys[i].getName());
                incorrectPinsQueryProjection.append(", ");
            }
            incorrectPinsQueryProjection.append(pinNumber.getName());
            BAccessControlService.LOG.fine("SELECT " + incorrectPinsQueryProjection + " FROM " + tableName);
            Property fnlPinNumberProp = pinNumber;
            StringBuffer updateQuery = new StringBuffer();
            updateQuery.append("            UPDATE ").append(tableName);
            updateQuery.append("               SET ").append(fnlPinNumberProp.getName()).append(" = ? ");
            updateQuery.append("             WHERE ");
            for (int i = 0; i < keys.length; ++i) {
                if (i > 0) {
                    updateQuery.append("       AND ");
                }
                updateQuery.append(keys[i].getName()).append(" = ? ");
            }
            BAccessControlService.LOG.fine(updateQuery.toString());
            try (ResultSet incorrectPinsResultSet = connect.getConnection().createStatement().executeQuery("SELECT " + incorrectPinsQueryProjection + " FROM " + tableName);
                 PreparedStatement updatePinsPrepStmt = connect.getConnection().prepareStatement(updateQuery.toString());){
                BRdbSecuritySettings rdbmsSettings = ((BEnterpriseSecurityService)Sys.getService((Type)BEnterpriseSecurityService.TYPE)).getOrionDatabase().getRdbms().getRdbSecuritySettings();
                AesSysKeyEncoder hmacSha1Encoder = rdbmsSettings.getHmacSha1Encoder();
                AesSysKeyEncoder hmadSha256Encoder = rdbmsSettings.getEncoder();
                PinConverter pinConverter = null;
                int rowCount = 0;
                while (incorrectPinsResultSet.next()) {
                    String currentPinInDB = incorrectPinsResultSet.getString(pinNumber.getName());
                    int prepareIndex = 1;
                    String convertedPin = null;
                    try {
                        if (pinConverter == null && (pinConverter = this.getPINConverter(currentPinInDB, hmacSha1Encoder, hmadSha256Encoder)).isNullifyInvalidPins()) {
                            this.log.info("All the INVALID PINS shall be cleared off.");
                        }
                        convertedPin = pinConverter.convert(hmadSha256Encoder, currentPinInDB);
                    }
                    catch (InvalidPinException e) {
                        try {
                            if (null == pinConverter) {
                                pinConverter = new InvalidPinConverter();
                            }
                            convertedPin = pinConverter.convert(hmadSha256Encoder, currentPinInDB);
                        }
                        catch (RetainInvalidPinException re) {
                            ++rowCount;
                            continue;
                        }
                    }
                    catch (RetainInvalidPinException e) {
                        ++rowCount;
                        continue;
                    }
                    updatePinsPrepStmt.setString(prepareIndex++, convertedPin);
                    for (int i = 0; i < keys.length; ++i) {
                        Type type = keys[i].getType();
                        if (type.equals(BRef.TYPE)) {
                            BRef ref = (BRef)keys[i].getDefaultValue();
                            OrionType refType = (OrionType)ref.getTargetTypeSpec().getResolvedType();
                            type = refType.getKey()[0].getType();
                        }
                        if (type.equals(BUuid.TYPE)) {
                            updatePinsPrepStmt.setBytes(prepareIndex, incorrectPinsResultSet.getBytes(keys[i].getName()));
                            continue;
                        }
                        if (type.equals(BString.TYPE)) {
                            updatePinsPrepStmt.setString(prepareIndex, incorrectPinsResultSet.getString(keys[i].getName()));
                            continue;
                        }
                        if (type.equals(BInteger.TYPE)) {
                            updatePinsPrepStmt.setInt(prepareIndex, incorrectPinsResultSet.getInt(keys[i].getName()));
                            continue;
                        }
                        throw new Exception("Key Type has no Translator available:" + type + " for " + orionType);
                    }
                    updatePinsPrepStmt.addBatch();
                    if (++rowCount % 200 != 0 && rowCount != noOfRecordsToBeUpdated) continue;
                    updatePinsPrepStmt.executeBatch();
                    BAccessControlService.LOG.log(Level.INFO, "Updated " + rowCount + " " + orionType.getTypeName() + " records of " + noOfRecordsToBeUpdated);
                }
                if (rowCount != noOfRecordsToBeUpdated) {
                    throw new OrionException("Unexpected row count during update: " + rowCount);
                }
                connect.commit();
                BAccessControlService.LOG.log(Level.INFO, "Successfully updated " + noOfRecordsToBeUpdated + " for " + orionType.getTypeName());
                if (pinConverter != null && !pinConverter.isNullifyInvalidPins()) {
                    this.log.severe("Upgarde had left the invalid pins as is in the system. Please clear invalid pins by choosing the workflow System Setup -> Miscellaneous -> Server Maintenance -> Click on \"Get Invalid Pins\" button.");
                }
            }
        }
    }

    private PinConverter getPINConverter(String currentPinInDB, AesSysKeyEncoder hmacSha1Encoder, AesSysKeyEncoder hmacSha256Encoder) throws Exception {
        if (currentPinInDB == null) {
            return new AXToN48PinConverter();
        }
        String[] split = currentPinInDB.split(":");
        if (split.length == 3) {
            return new N46ToN48PinConverter(hmacSha1Encoder);
        }
        if (split.length == 2) {
            try {
                if (hmacSha256Encoder.decrypt(currentPinInDB) != null) {
                    return new AXToN48PinConverter();
                }
                return new N46ToN48PinConverter(hmacSha1Encoder);
            }
            catch (Exception e) {
                try {
                    if (hmacSha1Encoder.decrypt(currentPinInDB) != null) {
                        return new N46ToN48PinConverter(hmacSha1Encoder);
                    }
                    throw new InvalidPinException();
                }
                catch (Exception e1) {
                    throw new InvalidPinException();
                }
            }
        }
        throw new InvalidPinException();
    }
}

