/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schema;

import com.tridium.orion.BIOrionApp;
import com.tridium.orion.BLocalOrionDatabase;
import com.tridium.orion.BSchemaVersion;
import com.tridium.orion.ISchemaUpgrader;
import com.tridium.orion.OrionSession;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BLdapServerPersonEntry;
import com.tridiumx.entsec.orionTools.SchemaUpgradeSupport;
import java.util.logging.Level;
import javax.baja.rdb.ddl.DdlCommand;

public class Upgrade_1_13_to_1_14
implements ISchemaUpgrader {
    private static final BSchemaVersion FROM_VERSION = BAccessControlService.VERSION_1_13;
    private static final BSchemaVersion TO_VERSION = BAccessControlService.VERSION_1_14;

    public BSchemaVersion getFromVersion() {
        return FROM_VERSION;
    }

    public BSchemaVersion getToVersion() {
        return TO_VERSION;
    }

    public void upgrade(BLocalOrionDatabase db, BIOrionApp biOrionApp, OrionSession session) throws Exception {
        try {
            this.createLdapServerPersonEntryTable(db, session);
        }
        catch (Exception e) {
            e.printStackTrace();
            BAccessControlService.LOG.log(Level.SEVERE, "Upgrade_1_13_to_1_14 Schema Upgrade either not needed or failed", e);
        }
    }

    private void createLdapServerPersonEntryTable(BLocalOrionDatabase db, OrionSession session) {
        DdlCommand[] ddl = SchemaUpgradeSupport.createTable(BLdapServerPersonEntry.ORION_TYPE, db);
        for (int i = 0; i < ddl.length; ++i) {
            session.invokeDdl(ddl[i]);
        }
    }

    static {
        SchemaUpgradeSupport.skipConvertTimestampToLong(BLdapServerPersonEntry.ORION_TYPE, BLdapServerPersonEntry.lastModified);
    }
}

