/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schedule.util;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridium.orion.OrionSession;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.sys.transfer.TransferStrategy;
import com.tridium.util.ObjectUtil;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.schedule.actions.BSubmitDistributedAddAction;
import com.tridiumx.entsec.access.schedule.actions.BSubmitDistributedDiscoverAction;
import com.tridiumx.entsec.access.schedule.actions.BSubmitDistributedExportAction;
import com.tridiumx.entsec.orionTools.BMappedExt;
import com.tridiumx.entsec.orionTools.MergeSupport;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.driver.schedule.BScheduleImportExt;
import javax.baja.naming.SlotPath;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public abstract class MatchUtil {
    public static void matchSchedule(BFoxSession foxSession, BNiagaraScheduleDeviceExt remoteScheduleDeviceExt, BComponent remoteSchedule, BComponent database, String scheduleName, OrionSession remoteOrionSession, Context cx) throws Exception {
        BScheduleImportExt importExt = BScheduleDeviceExt.getExt((BAbstractSchedule)((BAbstractSchedule)remoteSchedule));
        if (importExt != null) {
            BUuid uuid;
            importExt.setSupervisorId(database.getSlotPathOrd().toString());
            BComponent parent = (BComponent)remoteSchedule.getParent();
            if (!scheduleName.equals(remoteSchedule.getName())) {
                parent.rename(remoteSchedule.getPropertyInParent(), scheduleName, cx);
            }
            if (remoteOrionSession != null && !(uuid = MatchUtil.getUuid(database)).equivalent((Object)BUuid.DEFAULT)) {
                remoteSchedule.lease(1);
                MergeSupport.changeUuidForComponent(uuid, remoteSchedule, remoteOrionSession);
            }
        } else {
            if (remoteScheduleDeviceExt.get(scheduleName = MatchUtil.getUniqueName((BComponent)remoteScheduleDeviceExt, scheduleName)) != null) {
                throw new IllegalArgumentException("Name '" + scheduleName + "' already exists");
            }
            Mark mark = new Mark((BObject)remoteSchedule, scheduleName);
            TransferResult result = TransferStrategy.make((int)32, (Mark)mark, (BObject)remoteScheduleDeviceExt, null, (Context)cx).transfer();
            String[] newNames = result.getInsertNames();
            for (int i = 0; i < newNames.length; ++i) {
                Property p = remoteScheduleDeviceExt.getProperty(newNames[i]);
                remoteScheduleDeviceExt.setFlags((Slot)p, remoteScheduleDeviceExt.getFlags((Slot)p) | 1);
            }
            BAbstractSchedule movedSchedule = (BAbstractSchedule)remoteScheduleDeviceExt.get(scheduleName);
            if (movedSchedule != null) {
                BUuid uuid;
                movedSchedule.lease(10);
                importExt = remoteScheduleDeviceExt.makeImportExt();
                importExt.setSupervisorId(database.getSlotPathOrd().toString());
                movedSchedule.add("ext", (BValue)importExt);
                BScheduleImportExt impExt = BScheduleDeviceExt.getExt((BAbstractSchedule)movedSchedule);
                if (impExt != null) {
                    impExt.invoke(BScheduleImportExt.execute, null);
                }
                if (remoteOrionSession != null && !(uuid = MatchUtil.getUuid(database)).equivalent((Object)BUuid.DEFAULT)) {
                    MergeSupport.changeUuidForComponent(uuid, (BComponent)movedSchedule, remoteOrionSession);
                }
            }
        }
    }

    public static void createActions(BNiagaraScheduleDeviceExt schedDeviceExt) {
        int actionFlags = 7;
        if (schedDeviceExt != null) {
            if (schedDeviceExt.get(SlotPath.escape((String)"submitDistributedDiscover")) == null) {
                schedDeviceExt.add(SlotPath.escape((String)"submitDistributedDiscover"), (BValue)new BSubmitDistributedDiscoverAction(), actionFlags);
            }
            if (schedDeviceExt.get(SlotPath.escape((String)"submitDistributedAdd")) == null) {
                schedDeviceExt.add(SlotPath.escape((String)"submitDistributedAdd"), (BValue)new BSubmitDistributedAddAction(), actionFlags);
            }
            if (schedDeviceExt.get(SlotPath.escape((String)"submitDistributedExport")) == null) {
                schedDeviceExt.add(SlotPath.escape((String)"submitDistributedExport"), (BValue)new BSubmitDistributedExportAction(), actionFlags);
            }
        }
    }

    public static BString getDiscoveryQuery(Type[] validTypes) {
        StringBuffer whereClause = new StringBuffer();
        whereClause.append("where ((parent.type != schedule:AbstractSchedule) and (");
        for (int i = 0; i < validTypes.length; ++i) {
            if (i > 0) {
                whereClause.append(" or ");
            }
            whereClause.append("type = " + validTypes[i].getTypeInfo().getModuleName() + ":" + validTypes[i].getTypeInfo().getTypeName());
        }
        whereClause.append("))");
        return BString.make((String)("station:|slot:/|bql: select name, slotPathOrd, type, ext.supervisorId from schedule:AbstractSchedule " + whereClause.toString()));
    }

    public static BUuid getUuid(BComponent component) {
        Type type = component.getType();
        AgentInfo info = Sys.getRegistry().getAgents(type.getTypeInfo()).filter(AgentFilter.is((Type)BMappedExt.TYPE)).getDefault();
        Type mappedExtType = info.getAgentType().getTypeSpec().getResolvedType();
        BMappedExt ext = (BMappedExt)component.getMixIn(mappedExtType);
        ext.lease();
        return ext.getUuid();
    }

    public static OrionSession getRemoteOrionSession(BFoxSession foxSession, Context cx) {
        BAccessControlService remoteService = (BAccessControlService)foxSession.getService(BAccessControlService.TYPE);
        remoteService.lease();
        return remoteService.createSession(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BStation getConfigStation(BComponent pObject) {
        BStation object = null;
        BComplex parent = null;
        try {
            if (pObject == null) {
                BStation bStation = null;
                return bStation;
            }
            if (pObject instanceof BStation) {
                BStation bStation = object = (BStation)pObject;
                return bStation;
            }
            for (parent = pObject.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof BStation)) continue;
                object = (BStation)parent;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            parent = null;
        }
        return object;
    }

    private static String getUniqueName(BComponent parent, String name) {
        return ObjectUtil.generateUniqueName((String)name, (ObjectUtil.NameContainer)new ScheduleNameContainer(parent));
    }

    private static class ScheduleNameContainer
    implements ObjectUtil.NameContainer {
        BComponent parent;

        ScheduleNameContainer(BComponent parent) {
            this.parent = parent;
        }

        public boolean contains(String name) {
            return this.parent.get(name) != null;
        }
    }
}

