/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schedule.nd;

import com.tridium.collection.BEmptyTable;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridiumx.entsec.access.schedule.nd.BDistributedScheduleLearnResult;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameMap;

public class BDistributedScheduleLearnJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BDistributedScheduleLearnJob.class);
    private boolean canceled = false;
    private String query;
    private BNiagaraScheduleDeviceExt scheduleDeviceExt;

    public Type getType() {
        return TYPE;
    }

    public BDistributedScheduleLearnJob() {
    }

    public BDistributedScheduleLearnJob(BNiagaraScheduleDeviceExt scheduleDeviceExt, String query) {
        this.scheduleDeviceExt = scheduleDeviceExt;
        this.query = query;
    }

    public void doCancel(Context cx) {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        this.canceled = false;
        this.progress(25);
        BFoxSession foxSession = null;
        String interest = "DistributedScheduleLearn" + System.identityHashCode((Object)this);
        try {
            BNiagaraStation station = (BNiagaraStation)this.scheduleDeviceExt.getParent();
            foxSession = RemoteUtil.getFoxSession(station);
            if (foxSession == null) {
                throw new IllegalArgumentException("Failed to get fox session");
            }
            foxSession.engageNoRetry(interest);
            BITable table = this.getRemoteSchedules(foxSession, this.query);
            if (this.canceled) {
                this.canceled();
                return;
            }
            BNameMap nameMap = null;
            this.progress(75);
            if (!(table instanceof BEmptyTable)) {
                ColumnList l = table.getColumns();
                Column name = l.get(0);
                Column path = l.get(1);
                Column typ = l.get(2);
                Column supervisorId = l.get(3);
                TableCursor c = table.cursor();
                while (c.next()) {
                    BDistributedScheduleLearnResult lr = new BDistributedScheduleLearnResult();
                    lr.setPath(c.cell(path).toString());
                    lr.setSupervisorId(c.cell(supervisorId).toString());
                    lr.setTypeStr(c.cell(typ).toString());
                    String stringName = c.cell(name).toString();
                    if (this.get(stringName) != null) {
                        if (nameMap == null) {
                            nameMap = BNameMap.DEFAULT;
                        }
                        Property p = this.add(stringName + "?", (BValue)lr);
                        nameMap = BNameMap.make((BNameMap)nameMap, (String)p.getName(), (String)SlotPath.unescape((String)stringName));
                        continue;
                    }
                    this.add(stringName, (BValue)lr);
                }
                if (nameMap != null) {
                    this.add("displayNames", (BValue)nameMap);
                }
            }
            this.progress(100);
        }
        finally {
            if (foxSession != null && foxSession.isEngaged(interest)) {
                foxSession.disengage(interest);
            }
        }
    }

    private BITable getRemoteSchedules(BFoxSession foxSession, String query) {
        BOrd queryOrd = BOrd.make((String)query);
        return (BITable)queryOrd.resolve((BObject)foxSession).get();
    }
}

