/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.schedule.nd;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.schedule.BNiagaraScheduleDeviceExt;
import com.tridium.nd.schedule.BNiagaraScheduleExport;
import com.tridium.nd.schedule.BNiagaraScheduleImportExt;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.schedule.BScheduleExportInfo;
import com.tridiumx.entsec.access.schedule.util.MatchUtil;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import java.util.logging.Level;
import javax.baja.driver.schedule.BScheduleImportExt;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class BDistributedScheduleExportJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BDistributedScheduleExportJob.class);
    private boolean canceled = false;
    private BString[] supervisorIds = null;
    private BNiagaraScheduleDeviceExt scheduleDeviceExt;

    public Type getType() {
        return TYPE;
    }

    public BDistributedScheduleExportJob() {
    }

    public BDistributedScheduleExportJob(BNiagaraScheduleDeviceExt scheduleDeviceExt, BScheduleExportInfo exportInfo) {
        this.scheduleDeviceExt = scheduleDeviceExt;
        if (exportInfo.getSupervisorIds() != null) {
            this.supervisorIds = (BString[])exportInfo.getSupervisorIds().getChildren(BString.class);
        }
    }

    public void doCancel(Context cx) {
        this.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        this.canceled = false;
        BFoxSession foxSession = null;
        String interest = "DistributedScheduleExport" + System.identityHashCode((Object)this);
        try {
            BUuid remoteUuid;
            BComponent[] schedules = this.getSchedules(this.scheduleDeviceExt, this.supervisorIds, cx);
            if (schedules.length != this.supervisorIds.length) {
                throw new IllegalArgumentException("schedules.length != supervisorIds.length");
            }
            BNiagaraStation station = (BNiagaraStation)this.scheduleDeviceExt.getParent();
            foxSession = RemoteUtil.getFoxSession(station);
            if (foxSession == null) {
                throw new IllegalArgumentException("Failed to get fox session");
            }
            foxSession.engageNoRetry(interest);
            BNiagaraNetwork remoteNiagaraNetwork = (BNiagaraNetwork)foxSession.getService(BNiagaraNetwork.TYPE);
            if (remoteNiagaraNetwork == null) {
                throw new IllegalArgumentException("Failed to find remote network");
            }
            String stationName = Sys.getStation().getStationName();
            BNiagaraStation remoteStation = RemoteUtil.findStation((BComponent)remoteNiagaraNetwork, stationName);
            if (remoteStation == null) {
                throw new IllegalArgumentException("Failed to find remote station '" + stationName + "'");
            }
            remoteStation.lease();
            BNiagaraScheduleDeviceExt remoteScheduleDeviceExt = remoteStation.getSchedules();
            remoteScheduleDeviceExt.lease();
            Array importNames = new Array(String.class);
            Array remoteSchedules = new Array(BComponent.class);
            for (int i = 0; i < schedules.length; ++i) {
                this.progress((i + 1) * 80 / schedules.length);
                if (this.canceled) {
                    this.canceled();
                    break;
                }
                boolean found = false;
                BUuid uuid = MatchUtil.getUuid(schedules[i]);
                if (BEnterpriseSecurityService.LOG.isLoggable(Level.FINE)) {
                    this.log().message("Looking for matched schedule: " + schedules[i].getSlotPath() + " with uuid: " + uuid);
                }
                BAbstractSchedule[] remoteChildren = (BAbstractSchedule[])remoteScheduleDeviceExt.getChildren(BAbstractSchedule.class);
                for (int j = 0; j < remoteChildren.length; ++j) {
                    remoteChildren[j].lease(1);
                    remoteUuid = MatchUtil.getUuid((BComponent)remoteChildren[j]);
                    if (!remoteUuid.equals((Object)uuid)) continue;
                    if (BEnterpriseSecurityService.LOG.isLoggable(Level.FINE)) {
                        this.log().message("Schedule found: " + remoteChildren[j].getSlotPath() + " with uuid: " + remoteUuid);
                    }
                    found = true;
                    BNiagaraScheduleImportExt ext = (BNiagaraScheduleImportExt)remoteChildren[j].get("ext");
                    if (ext == null) break;
                    ext.lease();
                    ext.execute();
                    break;
                }
                if (found) continue;
                if (BEnterpriseSecurityService.LOG.isLoggable(Level.FINE)) {
                    this.log().message("Schedule is new:" + schedules[i].getSlotPath() + " with uuid: " + uuid);
                }
                importNames.add((Object)schedules[i].getName());
                BAbstractSchedule newSchedule = (BAbstractSchedule)schedules[i].getType().getTypeSpec().getInstance();
                MappingSupport.addMappedExt((BComponent)newSchedule, uuid);
                remoteSchedules.add((Object)newSchedule);
                BScheduleImportExt ext = remoteScheduleDeviceExt.makeImportExt();
                ext.setSupervisorId(schedules[i].getSlotPathOrd().toString());
                newSchedule.add("ext", (BValue)ext);
                String exportName = schedules[i].getName() + "Export";
                if (this.scheduleDeviceExt.get(exportName) != null) continue;
                BNiagaraScheduleExport exportSchedule = new BNiagaraScheduleExport();
                exportSchedule.setSupervisorId(schedules[i].getSlotPathOrd().toString());
                this.scheduleDeviceExt.add(exportName, (BValue)exportSchedule);
            }
            if (remoteSchedules.size() > 0) {
                Mark mark = new Mark((BObject[])((BComponent[])remoteSchedules.trim()), (String[])importNames.trim());
                for (int i = 0; i < importNames.size(); ++i) {
                    if (remoteScheduleDeviceExt.get((String)importNames.get(i)) != null) {
                        throw new Exception("Cannot Export Schedule, Name is Already in Use");
                    }
                    Property p = remoteScheduleDeviceExt.add(importNames.get(i) + "?", (BValue)remoteSchedules.get(i), 1);
                    if (!BEnterpriseSecurityService.LOG.isLoggable(Level.FINE)) continue;
                    remoteScheduleDeviceExt.getComponentSpace().sync();
                    BAbstractSchedule[] children = (BAbstractSchedule[])remoteScheduleDeviceExt.getChildren(BAbstractSchedule.class);
                    if (children.length <= 0) continue;
                    BAbstractSchedule newlyAdded = children[children.length - 1];
                    newlyAdded.lease();
                    remoteUuid = MatchUtil.getUuid((BComponent)newlyAdded);
                    this.log().message("New Names: " + newlyAdded.getName() + " with uuid: " + remoteUuid);
                }
            }
            this.progress(100);
        }
        finally {
            if (foxSession != null && foxSession.isEngaged(interest)) {
                foxSession.disengage(interest);
            }
        }
    }

    private BComponent[] getSchedules(BNiagaraScheduleDeviceExt scheduleDeviceExt, BString[] supervisorIds, Context cx) {
        BOrd[] remoteOrds = new BOrd[supervisorIds.length];
        for (int i = 0; i < supervisorIds.length; ++i) {
            String scheduleOrd = supervisorIds[i].getString();
            remoteOrds[i] = scheduleOrd.indexOf("station:|") == -1 ? BOrd.make((String)("station:|" + scheduleOrd)) : BOrd.make((String)scheduleOrd);
        }
        BatchResolve resolvedOrds = this.getResolvedOrds(remoteOrds, (BObject)scheduleDeviceExt);
        if (resolvedOrds == null) {
            return new BAbstractSchedule[0];
        }
        return resolvedOrds.getTargetComponents();
    }

    private BatchResolve getResolvedOrds(BOrd[] ords, BObject base) {
        BatchResolve batchResolveOrds = new BatchResolve(ords);
        if (batchResolveOrds != null) {
            batchResolveOrds.resolve(base);
        }
        return batchResolveOrds;
    }
}

