/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.replicate;

import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BOrionScheme;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.priv.fox.BFoxOrionDatabase;
import com.tridium.orion.priv.fox.BFoxOrionSpace;
import com.tridium.orion.priv.util.CountingUtil;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.PropertyValue;
import com.tridium.orion.sql.SqlColumns;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.AccessControlServiceUpgrade;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccFloorJoin;
import com.tridiumx.entsec.access.orion.BAccFloorRec;
import com.tridiumx.entsec.access.orion.BAccReaderJoin;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BKeypadFormat;
import com.tridiumx.entsec.access.orion.BNiagaraIntegrationID;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BThreatLevelBadgeJoin;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.access.schema.Upgrade_1_8_to_1_9;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.replicate.BDeletion;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.orionTools.replicate.Replicator;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsec.threat.BThreatLevelSetup;
import com.tridiumx.entsec.threat.BThreatLevelStationJoin;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.alarm.BAlarmService;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.expression.BListExpression;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Version;

public class EntsecReplicator
extends Replicator {
    private static final OrionType TYPE_W = BWiegandFormat.ORION_TYPE;
    private static final OrionType TYPE_K = BKeypadFormat.ORION_TYPE;
    private static final OrionType TYPE_T = BTenant.ORION_TYPE;
    private static final OrionType TYPE_S = BScheduleRec.ORION_TYPE;
    private static final OrionType TYPE_PL = BNiagaraIntegrationID.ORION_TYPE;
    private static final OrionType TYPE_R = BAccReaderRec.ORION_TYPE;
    private static final OrionType TYPE_F = BAccFloorRec.ORION_TYPE;
    private static final OrionType TYPE_A = BAccessRight.ORION_TYPE;
    private static final OrionType TYPE_P = BPerson.ORION_TYPE;
    private static final OrionType TYPE_AR = BAccReaderJoin.ORION_TYPE;
    private static final OrionType TYPE_AF = BAccFloorJoin.ORION_TYPE;
    private static final OrionType TYPE_PA = BPersonAccJoin.ORION_TYPE;
    private static final OrionType TYPE_B = BBadge.ORION_TYPE;
    private static final OrionType TYPE_TL = BThreatLevelGroupRec.ORION_TYPE;
    private static final OrionType TYPE_TLS = BThreatLevelStationJoin.ORION_TYPE;
    private static final OrionType TYPE_TLB = BThreatLevelBadgeJoin.ORION_TYPE;
    private static final String W = BAppTable.getTableName(TYPE_W);
    private static final String K = BAppTable.getTableName(TYPE_K);
    private static final String T = BAppTable.getTableName(TYPE_T);
    private static final String S = BAppTable.getTableName(TYPE_S);
    private static final String PL = BAppTable.getTableName(TYPE_PL);
    private static final String R = BAppTable.getTableName(TYPE_R);
    private static final String F = BAppTable.getTableName(TYPE_F);
    private static final String A = BAppTable.getTableName(TYPE_A);
    private static final String P = BAppTable.getTableName(TYPE_P);
    private static final String AR = BAppTable.getTableName(TYPE_AR);
    private static final String AF = BAppTable.getTableName(TYPE_AF);
    private static final String PA = BAppTable.getTableName(TYPE_PA);
    private static final String B = BAppTable.getTableName(TYPE_B);
    private static final String TL = BAppTable.getTableName(TYPE_TL);
    private static final String TLS = BAppTable.getTableName(TYPE_TLS);
    private static final String TLB = BAppTable.getTableName(TYPE_TLB);
    private static final String LAST_MODIFIED = BReplicableObject.lastModified.getName();
    private static final String R_STATION_NAME = "r." + BAccReaderRec.stationName.getName();
    private static final String R_UUID = "r." + BAccReaderRec.uuid.getName();
    private static final String F_STATION_NAME = "f." + BAccFloorRec.stationName.getName();
    private static final String F_UUID = "f." + BAccFloorRec.uuid.getName();
    private static final String AR_READER = "ar." + BAccReaderJoin.reader.getName();
    private static final String AF_FLOOR = "af." + BAccFloorJoin.floor.getName();
    private static final String AF_ACCESS_RIGHT = "af." + BAccFloorJoin.accessRight.getName();
    private static final String AR_ACCESS_RIGHT = "ar." + BAccReaderJoin.accessRight.getName();
    private static final String A_ACCESS_RIGHTID = "a." + BAccessRight.accessRightId.getName();
    private static final String PA_ACCESS_RIGHT = "pa." + BPersonAccJoin.accessRight.getName();
    private static final String PA_PERSON = "pa." + BPersonAccJoin.person.getName();
    private static final String P_PERSON_ID = "p." + BPerson.personId.getName();
    private static final String B_OWNER = "b." + BBadge.owner.getName();
    private static final String S_UUID = "s." + BScheduleRec.uuid.getName();
    private static final String A_SCHED = "a." + BAccessRight.schedule.getName();
    private static final String PL_UUID = "pl." + BNiagaraIntegrationID.integrationUuid.getName();
    private static final String A_PERSON_LOCATION = "a." + BAccessRight.niagaraIntegrationID.getName();
    private static final String T_UUID = "t." + BTenant.tenantId.getName();
    private static final String A_TENANT = "a." + BAccessRight.tenant.getName();
    private static final String B_TENANT = "b." + BBadge.tenant.getName();
    private static final String P_TENANT = "p." + BPerson.tenant.getName();
    private static final String PL_TENANT = "pl." + BNiagaraIntegrationID.tenant.getName();
    private static final String B_BADGE_ID = "b." + BBadge.badgeId.getName();
    private static final String TL_UUID = "tl." + BThreatLevelGroupRec.uuid.getName();
    private static final String TL_TENANT = "tl." + BThreatLevelGroupRec.tenant.getName();
    private static final String A_TL = "a." + BAccessRight.threatLevelGroup.getName();
    private static final String TLS_TL = "tls." + BThreatLevelStationJoin.threatLevelGroup.getName();
    private static final String TLS_STATION_NAME = "tls." + BThreatLevelStationJoin.stationName.getName();
    private static final String TLB_TL = "tlb." + BThreatLevelBadgeJoin.threatLevelGroup.getName();
    private static final String TLB_B = "tlb." + BThreatLevelBadgeJoin.badge.getName();
    private static final String SQL_W = "select * from " + W + " where " + LAST_MODIFIED + " between ? and ?";
    private static final String SQL_K = "select * from " + K + " where " + LAST_MODIFIED + " between ? and ?";
    private static final String SQL_A_T = "select distinct t.* from " + T + " t inner join " + A + " a  on " + T_UUID + " = " + A_TENANT + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (t." + LAST_MODIFIED + " between ? and ? or  ar." + LAST_MODIFIED + " between ? and ? or  a." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ?";
    private static final String SQL_B_T = "select distinct t.* from " + T + " t inner join " + B + " b  on " + T_UUID + " = " + B_TENANT + " inner join " + P + " p  on " + B_OWNER + " = " + P_PERSON_ID + " inner join " + PA + " pa on " + P_PERSON_ID + " = " + PA_PERSON + " inner join " + A + " a  on " + PA_ACCESS_RIGHT + " = " + A_ACCESS_RIGHTID + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (t." + LAST_MODIFIED + " between ? and ? or  ar." + LAST_MODIFIED + " between ? and ? or  pa." + LAST_MODIFIED + " between ? and ? or  b." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ?";
    private static final String SQL_P_T = "select distinct t.* from " + T + " t inner join " + P + " p  on " + T_UUID + " = " + P_TENANT + " inner join " + PA + " pa on " + P_PERSON_ID + " = " + PA_PERSON + " inner join " + A + " a  on " + PA_ACCESS_RIGHT + " = " + A_ACCESS_RIGHTID + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (t." + LAST_MODIFIED + " between ? and ? or  ar." + LAST_MODIFIED + " between ? and ? or  pa." + LAST_MODIFIED + " between ? and ? or  p." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ?";
    private static final String SQL_PL_T = "select distinct t.* from " + T + " t inner join " + PL + " pl on " + T_UUID + " = " + PL_TENANT + " inner join " + A + " a  on " + PL_UUID + " = " + A_PERSON_LOCATION + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (t." + LAST_MODIFIED + " between ? and ? or  pl." + LAST_MODIFIED + " between ? and ? or  ar." + LAST_MODIFIED + " between ? and ? or  a." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ?";
    private static final String SQL_S = "select distinct s.* from " + S + " s inner join " + A + " a  on " + S_UUID + " = " + A_SCHED + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (s." + LAST_MODIFIED + " between ? and ? or  ar." + LAST_MODIFIED + " between ? and ? or  a." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ?";
    private static final String SQL_PL = "select distinct pl.* from " + PL + " pl inner join " + A + " a  on " + PL_UUID + " = " + A_PERSON_LOCATION + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (pl." + LAST_MODIFIED + " between ? and ? or  ar." + LAST_MODIFIED + " between ? and ? or  a." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ?";
    private static final String SQL_TL = "select distinct tl.* from " + TL + " tl inner join " + A + " a  on " + TL_UUID + " = " + A_TL + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (tl." + LAST_MODIFIED + " between ? and ? or  ar." + LAST_MODIFIED + " between ? and ? or  a." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ? order by tl.path";
    private static final String SQL_TL_STATION = "select distinct tl.* from " + TL + " tl inner join " + TLS + " tls  on " + TLS_TL + " = " + TL_UUID + " where (tl." + LAST_MODIFIED + " between ? and ? or  tls." + LAST_MODIFIED + " between ? and ?) and " + TLS_STATION_NAME + " = ? order by tl.path";
    private static final String SQL_TLS = "select distinct tls.* from " + TLS + " tls where (tls." + LAST_MODIFIED + " between ? and ?) and " + TLS_STATION_NAME + " = ?";
    private static final String SQL_R = "select * from " + R + " where " + LAST_MODIFIED + " between ? and ?";
    private static final String SQL_F = "select * from " + F + " where " + LAST_MODIFIED + " between ? and ?";
    private static final String SQL_AR = "select distinct ar.* from " + AR + " ar inner join " + R + " r on " + AR_READER + " = " + R_UUID + " where (ar." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ?";
    private static final String SQL_AF = "select distinct af.* from   " + AF + " af inner join " + F + " f on   " + AF_FLOOR + " = " + F_UUID + " inner join " + A + " a on   " + AF_ACCESS_RIGHT + " = " + A_ACCESS_RIGHTID + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (ar." + LAST_MODIFIED + " between ? and ? or  af." + LAST_MODIFIED + " between ? and ?) and " + F_STATION_NAME + " = ? and " + F_STATION_NAME + " = " + R_STATION_NAME;
    private static final String SQL_A = "select distinct a.* from " + A + " a inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (ar." + LAST_MODIFIED + " between ? and ? or  a." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ?";
    private static final String SQL_PA = "select distinct pa.* from " + PA + " pa inner join " + A + " a  on " + PA_ACCESS_RIGHT + " = " + A_ACCESS_RIGHTID + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (ar." + LAST_MODIFIED + " between ? and ? or  pa." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ?";
    private static final String SQL_P = "select distinct p.* from " + P + " p inner join " + PA + " pa on " + P_PERSON_ID + " = " + PA_PERSON + " inner join " + A + " a  on " + PA_ACCESS_RIGHT + " = " + A_ACCESS_RIGHTID + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where (ar." + LAST_MODIFIED + " between ? and ? or  pa." + LAST_MODIFIED + " between ? and ? or  p." + LAST_MODIFIED + " between ? and ?) and " + R_STATION_NAME + " = ?";
    private static final String SQL_B = "select distinct b.* from " + B + " b inner join " + P + " p  on " + B_OWNER + " = " + P_PERSON_ID + " inner join " + PA + " pa on " + P_PERSON_ID + " = " + PA_PERSON + " inner join " + A + " a  on " + PA_ACCESS_RIGHT + " = " + A_ACCESS_RIGHTID + " inner join " + AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + R + " r  on " + AR_READER + " = " + R_UUID + " where ((ar." + LAST_MODIFIED + " between ? and ? ) or (pa." + LAST_MODIFIED + " between ? and ? ) or (b." + LAST_MODIFIED + " between ? and ? ) ) and " + R_STATION_NAME + " = ?";
    private static final String SQL_BUMP_BADGE = "update " + B + " set " + LAST_MODIFIED + " = ? where " + BBadge.badgeId.getName() + " = ?";
    private static final OrionType TYPE_Z = BAccessZoneRec.ORION_TYPE;
    private static final String Z = BAppTable.getTableName(TYPE_Z);
    private static final String Z_STATION_NAME = "z." + BAccessZoneRec.stationName.getName();
    private static final String Z_UUID = "z." + BAccessZoneRec.uuid.getName();
    private static final String SQL_PULL_Z = "select * from " + Z + " z where " + LAST_MODIFIED + " between ? and ?  and " + Z_STATION_NAME + " = ?";
    private static OrionType[] CLEAN_TYPES = new OrionType[]{TYPE_W, TYPE_K, TYPE_T, TYPE_S, TYPE_PL, TYPE_R, TYPE_F, TYPE_A, TYPE_P, TYPE_AR, TYPE_AF, TYPE_PA, TYPE_B, TYPE_Z};
    private static final BOrd APP_ORD = BOrd.make((String)"service:entsec:AccessControlService");

    public int compareTo(Object o) {
        return -1;
    }

    @Override
    protected BAbstractOrionApp getSupervisorOrionApp() {
        return (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
    }

    public OrionSession openSupervisorSession(String name) {
        return EntsecReplicator.makeOrionSession(this.getSupervisorOrionApp(), name);
    }

    @Override
    protected void beforeReplicate(BAbsTime begin) throws Exception {
        OrionCursor supCursor = this.getSupervisorSession().select(BDeletion.ORION_TYPE, SQL_D, new BSimple[]{TYPE_B.getTypeSpec(), BAbsTime.DEFAULT});
        this.repStartTime = begin;
        while (supCursor.next()) {
            BDeletion del = (BDeletion)((Object)supCursor.get());
            BBadge badge = (BBadge)EntsecReplicator.createRecordFromDeletion(del, TYPE_B);
            this.getSupervisorSession().update(SQL_BUMP_BADGE, new BSimple[]{begin, BString.make((String)badge.getBadgeId())});
        }
    }

    @Override
    protected BOrd getJaceOrionAppOrd() {
        return APP_ORD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReplicate(OrionSession jaceSession, BAbsTime timestamp, String stationName, boolean replicateFromJace, BSafeSimpleJob job, BFacets facets) throws Exception {
        OrionSession superSession = null;
        try {
            BExpression exp;
            superSession = this.openSupervisorSession(stationName);
            BFoxOrionDatabase db = (BFoxOrionDatabase)jaceSession.getOrionDatabase();
            BEnterpriseSecurityService remoteService = (BEnterpriseSecurityService)((BFoxOrionSpace)db.getOrionSpace()).getFoxSession().getService(BEnterpriseSecurityService.TYPE);
            remoteService.lease();
            BAccessControlService remoteAccessService = (BAccessControlService)((BFoxOrionSpace)db.getOrionSpace()).getFoxSession().getService(BAccessControlService.TYPE);
            remoteAccessService.lease();
            Version remoteVersion = new Version(remoteAccessService.getSoftwareVersion());
            if (remoteVersion.compareTo(AccessControlServiceUpgrade.SECURITY_2_3_17) > 0) {
                BAlarmService localAlarmService = (BAlarmService)Sys.getService((Type)BAlarmService.TYPE);
                BAlarmService remoteAlarmService = (BAlarmService)((BFoxOrionSpace)db.getOrionSpace()).getFoxSession().getService(BAlarmService.TYPE);
                remoteAlarmService.lease();
                if (remoteAlarmService.getCoalesceAlarms() != localAlarmService.getCoalesceAlarms()) {
                    remoteAlarmService.setCoalesceAlarms(localAlarmService.getCoalesceAlarms());
                }
            }
            this.clearVersionSafe();
            if (remoteVersion.compareTo(AccessControlServiceUpgrade.SECURITY_2_2_1) < 0) {
                this.addVersionSafeType(BAccessRight.ORION_TYPE);
                this.addVersionSafeType(BPersonAccJoin.ORION_TYPE);
            }
            if (remoteVersion.compareTo(AccessControlServiceUpgrade.SECURITY_2_2_8_9) < 0 && CountingUtil.getCount((OrionType)BWiegandFormat.ORION_TYPE, (BExpression)(exp = Predicates.gt((BExpression)new BSqlField(BWiegandFormat.ORION_TYPE, BWiegandFormat.bitLength), (BSimple)BInteger.make((int)128))), (OrionSession)this.getSupervisorSession()) > 0 && CountingUtil.getCount((OrionType)BWiegandFormat.ORION_TYPE, (BExpression)exp.newExprCopy(), (OrionSession)jaceSession) == 0) {
                try {
                    this.logTrace("attempting to add 256 bit Wiegand Format support to Sec 2.2.7 subordinate...");
                    Upgrade_1_8_to_1_9.upgradeWiegandFormatWidth(jaceSession.getOrionDatabase(), jaceSession);
                    this.logTrace("256 bit wiegand format support now added to Sec 2.2.7 subordinate!");
                }
                catch (Exception e) {
                    throw new Exception("Backwards support for 256 bit Wiegand Format supported cannot be obtained, please uprade all subordinates or remove 129+ bit Wiegand Format.", e);
                }
            }
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            if (replicateFromJace) {
                this.pullDelete(jaceSession, timestamp, TYPE_R, superSession);
                this.pullPersist(jaceSession, timestamp, TYPE_R, SQL_R, superSession);
                this.pullDelete(jaceSession, timestamp, TYPE_F, superSession);
                this.pullPersist(jaceSession, timestamp, TYPE_F, SQL_F, superSession);
            }
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushDelete(jaceSession, timestamp, TYPE_W, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_K, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_T, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_PL, superSession);
            this.pushPersist(jaceSession, timestamp, TYPE_W, SQL_W, superSession);
            this.pushPersist(jaceSession, timestamp, TYPE_K, SQL_K, superSession);
            HashMap threatMap = this.getThreats(jaceSession, timestamp, stationName, facets, superSession);
            this.replicateTenants(jaceSession, timestamp, stationName, threatMap, superSession);
            this.pushPersistPerJace(jaceSession, timestamp, 3, stationName, TYPE_PL, SQL_PL, false, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_S, superSession);
            this.pushPersistPerJace(jaceSession, timestamp, 3, stationName, TYPE_S, SQL_S, true, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushDelete(jaceSession, timestamp, TYPE_AR, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_AF, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_PA, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_B, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_A, superSession);
            this.pushDelete(jaceSession, timestamp, TYPE_P, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            boolean threatReplication = false;
            if (remoteVersion.compareTo(AccessControlServiceUpgrade.SECURITY_2_2_1) >= 0) {
                threatReplication = true;
                this.pushDelete(jaceSession, timestamp, TYPE_TL, superSession);
                this.pushDelete(jaceSession, timestamp, TYPE_TLS, superSession);
                if (threatMap != null && threatMap.size() > 0) {
                    this.logTrace("Threat Level Replication required");
                    Array a = new Array(threatMap.values().toArray());
                    a = a.sort((Comparator)new BThreatLevelGroupRec.PathCompare());
                    this.pushPersistPerJaceNoBatch(jaceSession, a, stationName, TYPE_TL, superSession);
                    this.pushPersistPerJace(jaceSession, timestamp, 1, stationName, TYPE_TLS, SQL_TLS, false, superSession);
                } else {
                    this.logTrace("Threat Level Replication not required");
                }
                BThreatLevelSetup localService = (BThreatLevelSetup)Sys.getService((Type)BThreatLevelSetup.TYPE);
                BEnumRange range = localService.getThreatLevelRange();
                remoteService.getThreatLevelSetup().lease();
                remoteService.getThreatLevelSetup().setThreatLevelRange(range);
            }
            this.pushPersistPerJace(jaceSession, timestamp, 2, stationName, TYPE_A, SQL_A, false, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushPersistPerJace(jaceSession, timestamp, 3, stationName, TYPE_P, SQL_P, false, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushPersistPerJace(jaceSession, timestamp, 1, stationName, TYPE_AR, SQL_AR, false, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushPersistPerJace(jaceSession, timestamp, 2, stationName, TYPE_AF, SQL_AF, false, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushPersistPerJace(jaceSession, timestamp, 2, stationName, TYPE_PA, SQL_PA, false, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            this.pushPersistPerJace(jaceSession, timestamp, 3, stationName, TYPE_B, SQL_B, false, superSession);
            if (!timestamp.equals((Object)BAbsTime.NULL) && job != null) {
                job.checkCancel(null);
            }
            if (threatReplication) {
                this.pushDelete(jaceSession, timestamp, TYPE_TLB, superSession);
                this.pushThreatLevelBadges(jaceSession, threatMap, superSession);
            }
            this.replicateAccessZones(jaceSession, timestamp, stationName, replicateFromJace, superSession);
        }
        finally {
            if (superSession != null) {
                superSession.close();
                superSession = null;
            }
        }
    }

    protected void pushThreatLevelBadges(OrionSession jaceSession, HashMap threatMap, OrionSession superSession) {
        if (threatMap == null || threatMap.size() == 0) {
            return;
        }
        BSqlQuery query = BSqlQuery.make((OrionType)BThreatLevelBadgeJoin.ORION_TYPE);
        ExpressionBuilder b = new ExpressionBuilder();
        BListExpression listExpression = new BListExpression();
        Array a = new Array(BSimple.class);
        for (BThreatLevelGroupRec rec : threatMap.values()) {
            a.add((Object)rec.getUuid());
        }
        b.and(Predicates.in((BExpression)SqlColumns.make((OrionType)BThreatLevelBadgeJoin.ORION_TYPE, (Property)BThreatLevelBadgeJoin.threatLevelGroup).getColumnExpression().newExprCopy(), (BSimple[])((BSimple[])a.trim())));
        query.where(b);
        OrionCursor c = superSession.select((BQuery)query);
        while (c.next()) {
            BOrionObject o = (BOrionObject)c.get();
            jaceSession.persist((BIOrionObject)((BOrionObject)o.newCopy()));
        }
    }

    @Override
    protected void doCleanSupervisorDeletionTable(BAbsTime timestamp) throws Exception {
        EntsecReplicator.cleanDeletionTable(this.getSupervisorSession(), timestamp);
    }

    @Override
    protected void doCleanJaceDeletionTable(OrionSession jaceSession, BAbsTime timestamp) throws Exception {
        EntsecReplicator.cleanDeletionTable(jaceSession, timestamp);
    }

    private void replicateAccessZones(OrionSession jaceSession, BAbsTime timestamp, String stationName, boolean replicateFromJace, OrionSession superSession) throws Exception {
        if (replicateFromJace) {
            this.pullDeleteAccessZones(jaceSession, timestamp, superSession);
            this.pullPersistAccessZones(jaceSession, timestamp, stationName, superSession);
        }
    }

    private void pullPersistAccessZones(OrionSession jaceSession, BAbsTime timestamp, String stationName, OrionSession superSession) throws Exception {
        this.logTrace("pullPersistAccessZones begin");
        OrionCursor jaceCursor = jaceSession.select(TYPE_Z, SQL_PULL_Z, new BSimple[]{timestamp, this.repStartTime, BString.make((String)stationName)});
        while (jaceCursor.next()) {
            BReplicableObject obj = (BReplicableObject)((Object)jaceCursor.get());
            BReplicableObject newObj = (BReplicableObject)obj.getOrionType().getInstance();
            newObj.copyFrom((BIOrionObject)obj);
            superSession.persist((BIOrionObject)newObj);
        }
        this.logTrace("pullPersistAccessZones end");
    }

    private void pullDeleteAccessZones(OrionSession jaceSession, BAbsTime timestamp, OrionSession superSession) throws Exception {
        this.logTrace("pullDeleteAccessZones begin");
        OrionCursor jaceCursor = jaceSession.select(BDeletion.ORION_TYPE, SQL_D, new BSimple[]{TYPE_Z.getTypeSpec(), timestamp});
        while (jaceCursor.next()) {
            BDeletion del = (BDeletion)((Object)jaceCursor.get());
            BReplicableObject newObj = EntsecReplicator.createRecordFromDeletion(del, TYPE_Z);
            superSession.insert((BIOrionObject)new BDeletion(TYPE_Z.getTypeSpec(), BOrionScheme.encodeKeysToString((BIOrionObject)newObj)));
            superSession.delete((BIOrionObject)newObj);
        }
        this.logTrace("pullDeleteAccessZones end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateTenants(OrionSession jaceSession, BAbsTime timestamp, String stationName, HashMap threatMap, OrionSession superSession) {
        HashMap tenantsMap = new HashMap();
        try {
            OrionCursor cursor = this.getCursor(timestamp, 3, stationName, TYPE_T, SQL_A_T, superSession);
            this.addTenants(tenantsMap, cursor);
            cursor.close();
            cursor = this.getCursor(timestamp, 4, stationName, TYPE_T, SQL_B_T, superSession);
            this.addTenants(tenantsMap, cursor);
            cursor.close();
            cursor = this.getCursor(timestamp, 4, stationName, TYPE_T, SQL_P_T, superSession);
            this.addTenants(tenantsMap, cursor);
            cursor.close();
            cursor = this.getCursor(timestamp, 4, stationName, TYPE_T, SQL_PL_T, superSession);
            this.addTenants(tenantsMap, cursor);
            cursor.close();
            if (threatMap != null && threatMap.size() > 0) {
                this.addTenants(tenantsMap, threatMap, superSession);
            }
            this.pushPersistPerJace(jaceSession, tenantsMap, stationName, TYPE_T, superSession);
        }
        finally {
            tenantsMap.clear();
            tenantsMap = null;
        }
    }

    private void addTenants(HashMap map, OrionCursor cursor) {
        while (cursor.next()) {
            BIOrionObject rec = (BIOrionObject)cursor.get();
            BTenant obj = (BTenant)EntsecReplicator.cloneRecord(rec, TYPE_T);
            map.put(obj.getTenantId(), obj);
        }
    }

    private void addTenants(HashMap tenantMap, HashMap threatMap, OrionSession superSession) {
        Collection collection = threatMap.values();
        for (BThreatLevelGroupRec rec : collection) {
            if (!rec.getTenant().isBound() || tenantMap.get(rec.getTenant().getId()) != null) continue;
            BTenant tenant = (BTenant)rec.getTenant().getTarget(superSession);
            BTenant obj = (BTenant)EntsecReplicator.cloneRecord((BIOrionObject)tenant, TYPE_T);
            tenantMap.put(obj.getTenantId(), obj);
        }
    }

    private HashMap getThreats(OrionSession jaceSession, BAbsTime timestamp, String stationName, BFacets facets, OrionSession superSession) {
        if (facets.getb("noThreatRequired", false)) {
            return null;
        }
        BAccessControlService remoteAccessService = (BAccessControlService)((BFoxOrionSpace)jaceSession.getOrionDatabase().getOrionSpace()).getFoxSession().getService(BAccessControlService.TYPE);
        remoteAccessService.lease();
        Version remoteVersion = new Version(remoteAccessService.getSoftwareVersion());
        if (remoteVersion.compareTo(AccessControlServiceUpgrade.SECURITY_2_2_1) >= 0) {
            HashMap threatMap = new HashMap();
            OrionCursor cursor = this.getCursorForThreat(timestamp, 3, stationName, TYPE_TL, SQL_TL, superSession);
            this.addThreatLevels(threatMap, cursor, superSession);
            cursor.close();
            cursor = this.getCursorForThreat(timestamp, 2, stationName, TYPE_TL, SQL_TL_STATION, superSession);
            this.addThreatLevels(threatMap, cursor, superSession);
            cursor.close();
            if (threatMap.size() > 0) {
                return threatMap;
            }
        }
        return null;
    }

    private void addThreatLevels(HashMap map, OrionCursor cursor, OrionSession superSession) {
        while (cursor.next()) {
            BIOrionObject rec = (BIOrionObject)cursor.get();
            BThreatLevelGroupRec obj = (BThreatLevelGroupRec)EntsecReplicator.cloneRecord(rec, TYPE_TL);
            String[] parentPaths = obj.getParentPaths();
            for (int i = 0; i < parentPaths.length; ++i) {
                if (map.get(parentPaths[i]) != null) continue;
                BThreatLevelGroupRec parentRec = (BThreatLevelGroupRec)superSession.read(BThreatLevelGroupRec.ORION_TYPE, new PropertyValue(BThreatLevelGroupRec.path, (BValue)BString.make((String)parentPaths[i])));
                BThreatLevelGroupRec parentRecCopy = (BThreatLevelGroupRec)EntsecReplicator.cloneRecord((BIOrionObject)parentRec, TYPE_TL);
                if (map.get(parentPaths[i]) != null) continue;
                map.put(parentPaths[i], parentRecCopy);
            }
            if (map.get(obj.toDisplayString(null)) != null) continue;
            map.put(obj.toDisplayString(null), obj);
        }
    }
}

