/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BIsNull;
import com.tridium.orion.sql.BSqlField;
import com.tridium.orion.sql.BSqlQuery;
import com.tridium.orion.sql.SqlColumns;
import com.tridium.query.BOrderByCol;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.orionTools.BITenantObject;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.MergeSupport;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import javax.baja.query.BExpression;
import javax.baja.query.BOrderByColumn;
import javax.baja.query.BOrdering;
import javax.baja.query.BProjectionColumn;
import javax.baja.query.BQuery;
import javax.baja.query.util.ExpressionBuilder;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

public class BNiagaraIntegrationID
extends BReplicableObject
implements BITenantObject {
    public static final Property integrationUuid = BNiagaraIntegrationID.newProperty((int)5, (BValue)BUuid.DEFAULT, (BFacets)BFacets.make((String)"key", (boolean)true));
    public static final Property integrationName = BNiagaraIntegrationID.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"displayId", (boolean)true)), (BFacets)BFacets.make((String)"allowNull", (boolean)false)), (BFacets)BFacets.make((String)"indexed", (boolean)true)));
    public static final Property integrationId = BNiagaraIntegrationID.newProperty((int)8, (int)1, null);
    public static final Property tenant = BNiagaraIntegrationID.newProperty((int)8, (BValue)BRef.make((BTypeSpec)BTenant.TYPE.getTypeSpec()), (BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)0), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Property iDescription = BNiagaraIntegrationID.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)128), (BFacets)BFacets.make((String)"multiLine", (boolean)true)));
    public static final Type TYPE = Sys.loadType(BNiagaraIntegrationID.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final BIcon ICON = BIcon.make((String)"module://entsec/rc/access/compass.png");

    public BUuid getIntegrationUuid() {
        return (BUuid)this.get(integrationUuid);
    }

    public void setIntegrationUuid(BUuid v) {
        this.set(integrationUuid, (BValue)v, null);
    }

    public String getIntegrationName() {
        return this.getString(integrationName);
    }

    public void setIntegrationName(String v) {
        this.setString(integrationName, v, null);
    }

    public int getIntegrationId() {
        return this.getInt(integrationId);
    }

    public void setIntegrationId(int v) {
        this.setInt(integrationId, v, null);
    }

    @Override
    public BRef getTenant() {
        return (BRef)this.get(tenant);
    }

    public void setTenant(BRef v) {
        this.set(tenant, (BValue)v, null);
    }

    public BTenant resolveTenant(OrionSession session) {
        return (BTenant)this.getTenant().getTarget(session);
    }

    public String getIDescription() {
        return this.getString(iDescription);
    }

    public void setIDescription(String v) {
        this.setString(iDescription, v, null);
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public BIcon getIcon() {
        return ICON;
    }

    public static int getFreeId(OrionSession session) {
        BNiagaraIntegrationID[] niagaraIntegrations = BNiagaraIntegrationID.getOrderedNiagaraIntegrationIDs(session);
        int maybeFree = 1;
        int lastId = 0;
        for (int i = 0; i < niagaraIntegrations.length; ++i) {
            if (niagaraIntegrations[i].getIntegrationId() != maybeFree && niagaraIntegrations[i].getIntegrationId() != lastId) {
                return maybeFree;
            }
            maybeFree = niagaraIntegrations[i].getIntegrationId() + 1;
            lastId = niagaraIntegrations[i].getIntegrationId();
        }
        return maybeFree;
    }

    public static BNiagaraIntegrationID[] getOrderedNiagaraIntegrationIDs(OrionSession session) {
        BSqlQuery query = BSqlQuery.make((OrionType)ORION_TYPE);
        BProjectionColumn projectionColumn = SqlColumns.make((OrionType)ORION_TYPE, (Property)integrationId);
        BOrderByCol ordBy = new BOrderByCol(projectionColumn.getColumnExpression().newExprCopy());
        query.orderBy(BOrdering.make((BOrderByColumn)ordBy));
        return (BNiagaraIntegrationID[])session.select((BQuery)query).toArray();
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        MergeSupport.setReferencesToNull((BIOrionObject)this, session);
        return super.beforeDelete(session);
    }

    public String toDisplayString(Context cx) {
        StringBuffer b = new StringBuffer();
        b.append(this.getIntegrationName());
        b.append(" [" + this.getIntegrationId() + "]");
        return b.toString();
    }

    public void checkIndex(OrionSession session) throws Exception {
        BSqlQuery q = BSqlQuery.make((OrionType)ORION_TYPE);
        BSqlField tenantField = new BSqlField(ORION_TYPE, tenant);
        BSqlField nameField = new BSqlField(ORION_TYPE, integrationName);
        BSqlField uuidField = new BSqlField(ORION_TYPE, integrationUuid);
        ExpressionBuilder b = new ExpressionBuilder();
        if (this.getTenant().isBound()) {
            b.and(Predicates.eq((BExpression)tenantField, (BSimple)this.getTenant().getId()));
        } else {
            b.and((BExpression)new BIsNull((BExpression)tenantField));
        }
        b.and(Predicates.eq((BExpression)nameField, (BSimple)BString.make((String)this.getIntegrationName())));
        b.and(Predicates.ne((BExpression)uuidField, (BSimple)this.getIntegrationUuid()));
        q.where(b.getExpression());
        OrionCursor c = session.select((BQuery)q);
        if (c.next()) {
            String tenantName = "None";
            if (this.getTenant().isBound()) {
                tenantName = this.resolveTenant(session).toDisplayString(null);
            }
            String message = BAccessControlService.lex.getText("niagaraIntegerationIDIndexViolation", new Object[]{tenantName, this.getIntegrationName()});
            throw new IllegalStateException(message);
        }
    }

    @Override
    public void afterInsert(OrionSession session) {
        super.afterInsert(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertNiagaraIntegrationId(this);
    }

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updateNiagaraIntegrationId(this);
    }

    @Override
    public void afterDelete(OrionSession session) {
        super.afterDelete(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().deleteNiagaraIntegrationId(this);
    }

    @Override
    public Property getTenantProperty() {
        return tenant;
    }
}

