/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.orion;

import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccFloorJoin;
import com.tridiumx.entsec.access.orion.BAccFloorRec;
import com.tridiumx.entsec.access.orion.BAccReaderJoin;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BNiagaraIntegrationID;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.isom.ICompatibleWithIsom;
import com.tridiumx.entsec.orionTools.BITenantObject;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.orionTools.BTenant;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.orionTools.replicate.Replicator;
import com.tridiumx.entsec.threat.BThreatLevelEntry;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsec.threat.BThreatLevelOperationEnum;
import java.util.Map;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import org.json.simple.JSONObject;

public class BAccessRight
extends BReplicableObject
implements BITenantObject,
ICompatibleWithIsom {
    public static final Property accessRightId = BAccessRight.newProperty((int)1, (BValue)BUuid.DEFAULT, (BFacets)BFacets.make((String)"key", (boolean)true));
    public static final Property accessRightName = BAccessRight.newProperty((int)8, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)64), (BFacets)BFacets.make((String)"displayId", (boolean)true)), (BFacets)BFacets.make((String)"unique", (boolean)true)), (BFacets)BFacets.make((String)"allowNull", (boolean)false)));
    public static final Property schedule = BAccessRight.newProperty((int)8, (BValue)BRef.make((BTypeSpec)BScheduleRec.TYPE.getTypeSpec()), (BFacets)BFacets.make((BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)0), (BFacets)BFacets.make((String)"allowNull", (boolean)true)), (BFacets)BFacets.make((String)ALLOW_UI_NULL, (boolean)false)));
    public static final Property niagaraIntegrationID = BAccessRight.newProperty((int)8, (BValue)BRef.make((BTypeSpec)BNiagaraIntegrationID.TYPE.getTypeSpec()), (BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)0), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Property tenant = BAccessRight.newProperty((int)8, (BValue)BRef.make((BTypeSpec)BTenant.TYPE.getTypeSpec()), (BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)0), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Property acDescription = BAccessRight.newProperty((int)0, (String)"", (BFacets)BFacets.make((BFacets)BFacets.make((String)"width", (int)128), (BFacets)BFacets.make((String)"multiLine", (boolean)true)));
    public static final Property threatLevelGroup = BAccessRight.newProperty((int)8, (BValue)BRef.make((BTypeSpec)BThreatLevelGroupRec.TYPE.getTypeSpec()), (BFacets)BFacets.make((BFacets)BFacets.make((String)"onDelete", (int)0), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Property threatLevelOperation = BAccessRight.newProperty((int)0, (BValue)BThreatLevelOperationEnum.normal, null);
    public static final Property defaultAssignedThreatLevel = BAccessRight.newProperty((int)0, (BValue)BThreatLevelEntry.make(-1), (BFacets)BFacets.make((BFacets)BFacets.make((String)"fieldEditor", (String)"entsec:ActiveThreatLevelRangeFE"), (BFacets)BFacets.make((String)"allowNull", (boolean)true)));
    public static final Type TYPE = Sys.loadType(BAccessRight.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;
    public static final BIcon ICON = BIcon.make((String)"module://entsec/rc/access/accessRight.png");
    private BAccessRight reliableInstance;

    public BUuid getAccessRightId() {
        return (BUuid)this.get(accessRightId);
    }

    public void setAccessRightId(BUuid v) {
        this.set(accessRightId, (BValue)v, null);
    }

    public String getAccessRightName() {
        return this.getString(accessRightName);
    }

    public void setAccessRightName(String v) {
        this.setString(accessRightName, v, null);
    }

    public BRef getSchedule() {
        return (BRef)this.get(schedule);
    }

    public void setSchedule(BRef v) {
        this.set(schedule, (BValue)v, null);
    }

    public BScheduleRec resolveSchedule(OrionSession session) {
        return (BScheduleRec)this.getSchedule().getTarget(session);
    }

    public BRef getNiagaraIntegrationID() {
        return (BRef)this.get(niagaraIntegrationID);
    }

    public void setNiagaraIntegrationID(BRef v) {
        this.set(niagaraIntegrationID, (BValue)v, null);
    }

    public BNiagaraIntegrationID resolveNiagaraIntegrationID(OrionSession session) {
        return (BNiagaraIntegrationID)this.getNiagaraIntegrationID().getTarget(session);
    }

    @Override
    public BRef getTenant() {
        return (BRef)this.get(tenant);
    }

    public void setTenant(BRef v) {
        this.set(tenant, (BValue)v, null);
    }

    public BTenant resolveTenant(OrionSession session) {
        return (BTenant)this.getTenant().getTarget(session);
    }

    public String getAcDescription() {
        return this.getString(acDescription);
    }

    public void setAcDescription(String v) {
        this.setString(acDescription, v, null);
    }

    public BRef getThreatLevelGroup() {
        return (BRef)this.get(threatLevelGroup);
    }

    public void setThreatLevelGroup(BRef v) {
        this.set(threatLevelGroup, (BValue)v, null);
    }

    public BThreatLevelGroupRec resolveThreatLevelGroup(OrionSession session) {
        return (BThreatLevelGroupRec)this.getThreatLevelGroup().getTarget(session);
    }

    public BThreatLevelOperationEnum getThreatLevelOperation() {
        return (BThreatLevelOperationEnum)this.get(threatLevelOperation);
    }

    public void setThreatLevelOperation(BThreatLevelOperationEnum v) {
        this.set(threatLevelOperation, (BValue)v, null);
    }

    public BThreatLevelEntry getDefaultAssignedThreatLevel() {
        return (BThreatLevelEntry)this.get(defaultAssignedThreatLevel);
    }

    public void setDefaultAssignedThreatLevel(BThreatLevelEntry v) {
        this.set(defaultAssignedThreatLevel, (BValue)v, null);
    }

    public ReadersCursor getReaders(OrionSession session) {
        return new ReadersCursor(session.linkedScan((BIOrionObject)this, BAccReaderJoin.ORION_TYPE, BAccReaderRec.ORION_TYPE));
    }

    public PersonnelCursor getPersonnel(OrionSession session) {
        return new PersonnelCursor(session.linkedScan((BIOrionObject)this, BPersonAccJoin.ORION_TYPE, BPerson.ORION_TYPE));
    }

    public FloorsCursor getFloors(OrionSession session) {
        return new FloorsCursor(session.linkedScan((BIOrionObject)this, BAccFloorJoin.ORION_TYPE, BAccFloorRec.ORION_TYPE));
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    public BIcon getIcon() {
        return ICON;
    }

    @Override
    public void afterInsert(OrionSession session) {
        super.afterInsert(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().insertAccessRight(this);
        if (this.getThreatLevelGroup().isBound()) {
            BEnterpriseSecurityService.threatReplicationRequired();
        }
    }

    @Override
    public boolean beforeUpdate(OrionSession session) {
        if (session.getFacets().getb(Replicator.REPLICATING, false)) {
            BAccessRight databaseInstance = (BAccessRight)session.read((BIOrionObject)this.newCopy());
            if (databaseInstance == null) {
                return false;
            }
            this.reliableInstance = databaseInstance;
        } else if (this.isModified(threatLevelGroup)) {
            BEnterpriseSecurityService.threatReplicationRequired();
        }
        return super.beforeUpdate(session);
    }

    @Override
    public void afterUpdate(OrionSession session) {
        super.afterUpdate(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        service.getDbCache().updateAccessRight(this);
        if (session.getFacets().getb(Replicator.REPLICATING, false) && this.reliableInstance != null && this.reliableInstance.getThreatLevelGroup().isBound() && (this.getThreatLevelGroup().getId() == null || !this.reliableInstance.getThreatLevelGroup().getId().equals((Object)this.getThreatLevelGroup().getId()))) {
            BThreatLevelGroupRec rec = (BThreatLevelGroupRec)this.reliableInstance.getThreatLevelGroup().getTarget(session);
            try {
                rec.deleteIfNoLongerValidOnSubordinate(session);
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public boolean beforeDelete(OrionSession session) {
        super.beforeDelete(session);
        BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        BAccessRight databaseInstance = (BAccessRight)session.read((BIOrionObject)this.newCopy());
        if (databaseInstance == null) {
            return false;
        }
        this.reliableInstance = databaseInstance;
        service.getDbCache().deleteAccessRight(session, this.reliableInstance);
        return true;
    }

    @Override
    public void afterDelete(OrionSession session) {
        if (session.getFacets().getb(Replicator.REPLICATING, false)) {
            if (!this.reliableInstance.getThreatLevelGroup().isBound()) {
                return;
            }
            BThreatLevelGroupRec rec = (BThreatLevelGroupRec)this.reliableInstance.getThreatLevelGroup().getTarget(session);
            if (rec == null) {
                return;
            }
            try {
                rec.deleteIfNoLongerValidOnSubordinate(session);
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.reliableInstance.getThreatLevelGroup().isBound()) {
            BEnterpriseSecurityService.threatReplicationRequired();
        }
        super.afterDelete(session);
    }

    @Override
    public Property getTenantProperty() {
        return tenant;
    }

    @Override
    public void fromJson(JSONObject jsonObject) throws Exception {
    }

    @Override
    public JSONObject getJSON(OrionSession orionSession) throws Exception {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"id", (Object)this.getAccessRightId().encodeToString());
        jsonObject.put((Object)"name", (Object)this.getAccessRightName());
        return jsonObject;
    }

    @Override
    public BOrionObject[] getRefObject(OrionSession orionSession, Type refObj) {
        return null;
    }

    @Override
    public boolean hasAdditionalInfo() {
        return false;
    }

    @Override
    public BOrionObject getAdditionalInfoOrionObjects(OrionSession orionSession) {
        return null;
    }

    @Override
    public BOrionObject getAdditionalInfoOrionObjectsFromJson(JSONObject jsonObject) {
        return null;
    }

    @Override
    public BOrionObject[] associateObject(BOrionObject[] orionObject) {
        return null;
    }

    @Override
    public Map removeReferenceObject() {
        return null;
    }

    @Override
    public void addReferenceObject(Map ref) {
    }

    public static class FloorsCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private FloorsCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BAccFloorRec getAccFloorRec() {
            return (BAccFloorRec)this.cursor.get();
        }
    }

    public static class PersonnelCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private PersonnelCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BPerson getPerson() {
            return (BPerson)this.cursor.get();
        }
    }

    public static class ReadersCursor
    implements OrionCursor {
        private final OrionCursor cursor;

        private ReadersCursor(OrionCursor cursor) {
            this.cursor = cursor;
        }

        public Context getContext() {
            return this.cursor.getContext();
        }

        public OrionType getOrionType() {
            return this.cursor.getOrionType();
        }

        public BIOrionObject[] toArray() {
            return this.cursor.toArray();
        }

        public boolean next() {
            return this.cursor.next();
        }

        public boolean nextComponent() {
            return this.cursor.nextComponent();
        }

        public boolean next(Class cls) {
            return this.cursor.next(cls);
        }

        public BObject get() {
            return (BObject)this.cursor.get();
        }

        public OrionSession getSession() {
            return this.cursor.getSession();
        }

        public void close() {
            this.cursor.close();
        }

        public BAccReaderRec getAccReaderRec() {
            return (BAccReaderRec)this.cursor.get();
        }
    }
}

