/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.history;

import com.tridiumx.accessDriver.enums.activity.BLDAPActivityEnum;
import com.tridiumx.entsec.orionTools.history.BSecHistoryRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.naming.BOrd;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLDAPAuditRecord
extends BSecHistoryRecord {
    private static final long serialVersionUID = 1L;
    public static final Property ldapServerOrd = BLDAPAuditRecord.newProperty((int)0, (BValue)BOrd.DEFAULT, null);
    public static final Property activity = BLDAPAuditRecord.newProperty((int)0, (BValue)BLDAPActivityEnum.DEFAULT, null);
    public static final Property owner = BLDAPAuditRecord.newProperty((int)0, (String)"", null);
    public static final Property activityId = BLDAPAuditRecord.newProperty((int)0, (int)0, null);
    public static final Property status = BLDAPAuditRecord.newProperty((int)0, (String)"", null);
    public static final Property details = BLDAPAuditRecord.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BLDAPAuditRecord.class);

    public BOrd getLdapServerOrd() {
        return (BOrd)this.get(ldapServerOrd);
    }

    public void setLdapServerOrd(BOrd v) {
        this.set(ldapServerOrd, (BValue)v, null);
    }

    public BLDAPActivityEnum getActivity() {
        return (BLDAPActivityEnum)this.get(activity);
    }

    public void setActivity(BLDAPActivityEnum v) {
        this.set(activity, (BValue)v, null);
    }

    public String getOwner() {
        return this.getString(owner);
    }

    public void setOwner(String v) {
        this.setString(owner, v, null);
    }

    public int getActivityId() {
        return this.getInt(activityId);
    }

    public void setActivityId(int v) {
        this.setInt(activityId, v, null);
    }

    public String getStatus() {
        return this.getString(status);
    }

    public void setStatus(String v) {
        this.setString(status, v, null);
    }

    public String getDetails() {
        return this.getString(details);
    }

    public void setDetails(String v) {
        this.setString(details, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doWrite(DataOutput dataOutput) throws IOException {
        this.getTimestamp().encode(dataOutput);
        dataOutput.writeUTF(this.getLdapServerOrd().encodeToString());
        dataOutput.writeUTF(this.getActivity().encodeToString());
        dataOutput.writeUTF(this.getOwner());
        dataOutput.writeInt(this.getActivityId());
        dataOutput.writeUTF(this.getStatus());
        dataOutput.writeUTF(this.getDetails());
    }

    @Override
    protected void doRead(DataInput in, Context cx) throws IOException {
        this.setTimestamp((BAbsTime)BAbsTime.DEFAULT.decode(in));
        this.setLdapServerOrd((BOrd)BOrd.DEFAULT.decodeFromString(in.readUTF()));
        this.setActivity((BLDAPActivityEnum)BLDAPActivityEnum.DEFAULT.decodeFromString(in.readUTF()));
        this.setOwner(in.readUTF());
        this.setActivityId(in.readInt());
        this.setStatus(in.readUTF());
        this.setDetails(in.readUTF());
    }

    public static String successText() {
        return TYPE.getModule().getLexicon().get("ldap.audit.success.status");
    }

    public static String failureText() {
        return TYPE.getModule().getLexicon().get("ldap.audit.failure.status");
    }
}

