/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.history;

import com.tridium.orion.OrionType;
import com.tridiumx.accessDriver.enums.activity.BTimeAttendEnum;
import com.tridiumx.entsec.orionTools.history.BOrionHistoryRecord;
import com.tridiumx.entsec.securityUtil.BActivityRecord;
import com.tridiumx.entsec.securityUtil.BISecurityActivity;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.agent.AgentList;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

public class BAttendanceOrionRec
extends BOrionHistoryRecord
implements BISecurityActivity {
    private static final long serialVersionUID = 1L;
    public static final Property timestamp = BAttendanceOrionRec.newProperty((int)4, (BValue)BAbsTime.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"showSeconds", (boolean)true)));
    public static final Property activityTimestamp = BAttendanceOrionRec.newProperty((int)8, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"indexed", (boolean)true), (BFacets)BFacets.make((String)"showSeconds", (boolean)true)));
    public static final Property activity = BAttendanceOrionRec.newProperty((int)8, (BValue)BTimeAttendEnum.none, null);
    public static final Property owner = BAttendanceOrionRec.newProperty((int)8, (String)"", (BFacets)BFacets.make((String)"width", (int)128));
    public static final Property manualEntry = BAttendanceOrionRec.newProperty((int)8, (boolean)false, null);
    public static final Property hidden = BAttendanceOrionRec.newProperty((int)4, (boolean)false, null);
    public static final Property supervisorManualEntry = BAttendanceOrionRec.newProperty((int)4, (boolean)false, null);
    public static final Property personId = BAttendanceOrionRec.newProperty((int)4, (BValue)BUuid.NULL, null);
    public static final Type TYPE = Sys.loadType(BAttendanceOrionRec.class);
    public static final OrionType ORION_TYPE = (OrionType)TYPE;

    @Override
    public BAbsTime getTimestamp() {
        return (BAbsTime)this.get(timestamp);
    }

    @Override
    public void setTimestamp(BAbsTime v) {
        this.set(timestamp, (BValue)v, null);
    }

    public BAbsTime getActivityTimestamp() {
        return (BAbsTime)this.get(activityTimestamp);
    }

    public void setActivityTimestamp(BAbsTime v) {
        this.set(activityTimestamp, (BValue)v, null);
    }

    public BTimeAttendEnum getActivity() {
        return (BTimeAttendEnum)this.get(activity);
    }

    public void setActivity(BTimeAttendEnum v) {
        this.set(activity, (BValue)v, null);
    }

    public String getOwner() {
        return this.getString(owner);
    }

    public void setOwner(String v) {
        this.setString(owner, v, null);
    }

    public boolean getManualEntry() {
        return this.getBoolean(manualEntry);
    }

    public void setManualEntry(boolean v) {
        this.setBoolean(manualEntry, v, null);
    }

    public boolean getHidden() {
        return this.getBoolean(hidden);
    }

    public void setHidden(boolean v) {
        this.setBoolean(hidden, v, null);
    }

    public boolean getSupervisorManualEntry() {
        return this.getBoolean(supervisorManualEntry);
    }

    public void setSupervisorManualEntry(boolean v) {
        this.setBoolean(supervisorManualEntry, v, null);
    }

    public BUuid getPersonId() {
        return (BUuid)this.get(personId);
    }

    public void setPersonId(BUuid v) {
        this.set(personId, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return this.getTypeFromSpace(TYPE);
    }

    @Override
    public Property timestampProperty() {
        return activityTimestamp;
    }

    @Override
    protected void doRead(DataInput in) throws IOException {
        this.setActivityTimestamp((BAbsTime)BAbsTime.DEFAULT.decode(in));
        try {
            this.setActivity((BTimeAttendEnum)BTimeAttendEnum.none.decodeFromString(in.readUTF()));
        }
        catch (Exception e) {
            this.setActivity(BTimeAttendEnum.none);
        }
        this.setOwner(in.readUTF());
        this.setManualEntry(in.readBoolean());
        this.setHidden(in.readBoolean());
        try {
            this.setPersonId((BUuid)BUuid.NULL.decode(in));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void doWrite(DataOutput out) throws IOException {
        this.getActivityTimestamp().encode(out);
        out.writeUTF(this.getActivity().encodeToString());
        out.writeUTF(this.getOwner());
        out.writeBoolean(this.getManualEntry());
        out.writeBoolean(this.getHidden());
        this.getPersonId().encode(out);
    }

    @Override
    public BActivityRecord convertToActivity(Context cx) {
        if (this.getHidden()) {
            return null;
        }
        return new BActivityRecord(this.getActivityTimestamp(), (BObject)this, this.getActivity().toString(cx), "", this.getOwner(), this.getManualEntry() ? manualEntry.getDefaultDisplayName(cx) : "");
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("entsec:AttendanceOrionColumnsProvider");
        return list;
    }

    public String toDisplayString(Context cx) {
        return this.getOwner() + ", " + this.getActivity().getDisplayTag(cx) + ", " + this.getActivityTimestamp();
    }
}

