/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access.dyntable;

import com.tridium.orion.BOrionTypeId;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessZone;
import com.tridiumx.entsec.access.dyntable.BAcTable;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BAccessZones
extends BAcTable {
    public static final Property rowType = BAccessZones.newProperty((int)1, (BValue)BOrionTypeId.make((BTypeSpec)BAccessZoneRec.TYPE.getTypeSpec()), null);
    public static final Type TYPE = Sys.loadType(BAccessZones.class);
    private static final String ACCESS_CONTROL_FEATURE = "accessControl";
    private static final String ACCESSS_ZONES_ATTR = "accessZone.limit";
    private static final String VENDOR = "tridium";

    public BOrionTypeId getRowType() {
        return (BOrionTypeId)this.get(rowType);
    }

    public void setRowType(BOrionTypeId v) {
        this.set(rowType, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return BAccessZone.ICON;
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        super.checkAdd(name, value, flags, facets, context);
        if (!this.isRunning()) {
            return;
        }
        if (value instanceof BAccessZone) {
            BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            String limit = service.getAccessZoneLimit();
            if (limit.equals("none")) {
                return;
            }
            int limitNum = Integer.parseInt(limit);
            Integer accessZoneCount = (Integer)service.fw(503, ACCESSS_ZONES_ATTR, null, null, null);
            if (accessZoneCount >= limitNum) {
                String message = "Exceeded limit of " + limitNum + " Access Zones";
                if (context == Context.decoding) {
                    BAccessControlService.LOG.warning(message);
                } else {
                    throw new RuntimeException(message);
                }
            }
        }
    }
}

