/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.entsec.access;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionSession;
import com.tridium.orion.sql.BSqlField;
import com.tridiumx.accessDriver.BActivityAlertExt;
import com.tridiumx.accessDriver.BSecAlarmSourceInfo;
import com.tridiumx.accessDriver.enums.BEnforcementEnum;
import com.tridiumx.accessDriver.enums.BOccupancyEnum;
import com.tridiumx.accessDriver.enums.activity.BActivity;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BAccessValidationInfo;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BPersonZoneJoin;
import com.tridiumx.entsec.access.util.AccessZonesUpdateUtil;
import com.tridiumx.entsec.access.util.AccessZonesValidationUtil;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.securityUtil.BIAsyncStationStarted;
import java.util.HashMap;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.control.BNumericWritable;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;
import javax.baja.query.BExpression;
import javax.baja.query.util.Predicates;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;
import javax.baja.util.BUuid;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

public class BAccessZone
extends BNumericWritable
implements BIAsyncStationStarted {
    public static final Property proxyExt = BAccessZone.newProperty((int)4, (BValue)new BNullProxyExt(), null);
    public static final Property facets = BAccessZone.newProperty((int)4, (BValue)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"precision", (BIDataValue)BInteger.make((int)0)), null);
    public static final Property in1 = BAccessZone.newProperty((int)5, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in2 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in3 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in4 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in5 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in6 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in7 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in8 = BAccessZone.newProperty((int)5, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in9 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in10 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in11 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in12 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in13 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in14 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in15 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property in16 = BAccessZone.newProperty((int)6, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property fallback = BAccessZone.newProperty((int)4, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property overrideExpiration = BAccessZone.newProperty((int)261, (BValue)BAbsTime.NULL, null);
    public static final Property faultCause = BAccessZone.newProperty((int)71, (String)"", null);
    public static final Property occupied = BAccessZone.newProperty((int)1, (BValue)new BStatusBoolean(), null);
    public static final Property lockDown = BAccessZone.newProperty((int)0, (boolean)false, null);
    public static final Property occupancyCriteria = BAccessZone.newProperty((int)0, (BValue)BOccupancyEnum.any, null);
    public static final Property passbackMode = BAccessZone.newProperty((int)0, (BValue)BEnforcementEnum.hard, null);
    public static final Property aboveHighThresholdEnforcement = BAccessZone.newProperty((int)0, (BValue)BEnforcementEnum.off, null);
    public static final Property atHighThresholdEnforcement = BAccessZone.newProperty((int)0, (BValue)BDynamicEnum.make((BEnum)BEnforcementEnum.off), (BFacets)BFacets.make((String)"range", (BIDataValue)BEnforcementEnum.softRange));
    public static final Property belowLowThresholdEnforcement = BAccessZone.newProperty((int)0, (BValue)BDynamicEnum.make((BEnum)BEnforcementEnum.off), (BFacets)BFacets.make((String)"range", (BIDataValue)BEnforcementEnum.hardRange));
    public static final Property atLowThresholdEnforcement = BAccessZone.newProperty((int)0, (BValue)BDynamicEnum.make((BEnum)BEnforcementEnum.off), (BFacets)BFacets.make((String)"range", (BIDataValue)BEnforcementEnum.softRange));
    public static final Property supervisorRequiredEnforcement = BAccessZone.newProperty((int)0, (BValue)BEnforcementEnum.off, null);
    public static final Property highestEnforcement = BAccessZone.newProperty((int)5, (BValue)BEnforcementEnum.off, null);
    public static final Property pendingTime = BAccessZone.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)15), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)10), (String)"max", (BIDataValue)BRelTime.makeMinutes((int)1)));
    public static final Property passbackTimeout = BAccessZone.newProperty((int)0, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0), (String)"max", (BIDataValue)BRelTime.makeHours((int)24)));
    public static final Property resetOccupancyEnabled = BAccessZone.newProperty((int)0, (boolean)false, null);
    public static final Property resetOccupancyTime = BAccessZone.newProperty((int)0, (BValue)BTime.DEFAULT, (BFacets)BFacets.make((String)"showSeconds", (boolean)false));
    public static final Property highThreshold = BAccessZone.newProperty((int)0, (int)100, null);
    public static final Property lowThreshold = BAccessZone.newProperty((int)0, (int)-1, null);
    public static final Property antiPassbackViolationAlert = BAccessZone.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BBadgeActivity.antiPassbackViolation, BAccessZone.initAlarmSourceInfo()), null);
    public static final Property accessZoneDisabledAlert = BAccessZone.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BBadgeActivity.accessZoneDisabled, BAccessZone.initAlarmSourceInfo()), null);
    public static final Property occupancyViolationAlert = BAccessZone.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BBadgeActivity.occupancyViolation, BAccessZone.initAlarmSourceInfo()), null);
    public static final Property supervisorRequiredAlert = BAccessZone.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BBadgeActivity.supervisorRequired, BAccessZone.initAlarmSourceInfo()), null);
    public static final Property grantedButAntiPassbackViolationAlert = BAccessZone.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BBadgeActivity.grantedButAntiPassbackViolation, BAccessZone.initAlarmSourceInfo()), null);
    public static final Property grantedButOccupancyViolationAlert = BAccessZone.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BBadgeActivity.grantedButOccupancyViolation, BAccessZone.initAlarmSourceInfo()), null);
    public static final Property grantedButAccessZoneDisabledAlert = BAccessZone.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BBadgeActivity.grantedButAccessZoneDisabled, BAccessZone.initAlarmSourceInfo()), null);
    public static final Property grantedButSupervisorRequiredAlert = BAccessZone.newProperty((int)0, (BValue)new BActivityAlertExt((BActivity)BBadgeActivity.grantedButSupervisorRequired, BAccessZone.initAlarmSourceInfo()), null);
    public static final Property groupStatus = BAccessZone.newProperty((int)1028, (BValue)BStatus.DEFAULT, null);
    public static final Action recount = BAccessZone.newAction((int)0, null);
    public static final Action resetOccupancy = BAccessZone.newAction((int)4, null);
    public static final Action cleanup = BAccessZone.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action remoteValidationEntry = BAccessZone.newAction((int)4, (BValue)new BAccessValidationInfo(), null);
    public static final Action remoteValidationExit = BAccessZone.newAction((int)4, (BValue)new BAccessValidationInfo(), null);
    public static final Action remoteUpdateEntry = BAccessZone.newAction((int)4, (BValue)new BAccessValidationInfo(), null);
    public static final Action remoteUpdateExit = BAccessZone.newAction((int)4, (BValue)new BAccessValidationInfo(), null);
    public static final Action remoteConfirmMaybePending = BAccessZone.newAction((int)4, null);
    public static final Action remoteClearMaybePending = BAccessZone.newAction((int)4, null);
    public static final Action remoteMakeAlarm = BAccessZone.newAction((int)4, (BValue)new BAccessValidationInfo(), null);
    public static final Action persistGrouping = BAccessZone.newAction((int)20, null);
    public static final Type TYPE = Sys.loadType(BAccessZone.class);
    public static final BIcon ICON = BIcon.make((String)"module://entsec/rc/access/accessZone.png");
    private BAccessControlService service = null;
    private Array remoteStationsCache = new Array(String.class);
    private static final String engageKey = "BHxAccessZoneGroupingFE";
    public String generateAlarmOnCleanUpFor2ManRule = null;
    public Clock.Ticket resetTicket = null;
    public HashMap cleanupTickets = new HashMap();
    public Array pending = new Array(PendingOccupancy.class);
    public Array maybePending = new Array(PendingOccupancy.class);

    public BAbstractProxyExt getProxyExt() {
        return (BAbstractProxyExt)this.get(proxyExt);
    }

    public void setProxyExt(BAbstractProxyExt v) {
        this.set(proxyExt, (BValue)v, null);
    }

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatusNumeric getIn1() {
        return (BStatusNumeric)this.get(in1);
    }

    public void setIn1(BStatusNumeric v) {
        this.set(in1, (BValue)v, null);
    }

    public BStatusNumeric getIn2() {
        return (BStatusNumeric)this.get(in2);
    }

    public void setIn2(BStatusNumeric v) {
        this.set(in2, (BValue)v, null);
    }

    public BStatusNumeric getIn3() {
        return (BStatusNumeric)this.get(in3);
    }

    public void setIn3(BStatusNumeric v) {
        this.set(in3, (BValue)v, null);
    }

    public BStatusNumeric getIn4() {
        return (BStatusNumeric)this.get(in4);
    }

    public void setIn4(BStatusNumeric v) {
        this.set(in4, (BValue)v, null);
    }

    public BStatusNumeric getIn5() {
        return (BStatusNumeric)this.get(in5);
    }

    public void setIn5(BStatusNumeric v) {
        this.set(in5, (BValue)v, null);
    }

    public BStatusNumeric getIn6() {
        return (BStatusNumeric)this.get(in6);
    }

    public void setIn6(BStatusNumeric v) {
        this.set(in6, (BValue)v, null);
    }

    public BStatusNumeric getIn7() {
        return (BStatusNumeric)this.get(in7);
    }

    public void setIn7(BStatusNumeric v) {
        this.set(in7, (BValue)v, null);
    }

    public BStatusNumeric getIn8() {
        return (BStatusNumeric)this.get(in8);
    }

    public void setIn8(BStatusNumeric v) {
        this.set(in8, (BValue)v, null);
    }

    public BStatusNumeric getIn9() {
        return (BStatusNumeric)this.get(in9);
    }

    public void setIn9(BStatusNumeric v) {
        this.set(in9, (BValue)v, null);
    }

    public BStatusNumeric getIn10() {
        return (BStatusNumeric)this.get(in10);
    }

    public void setIn10(BStatusNumeric v) {
        this.set(in10, (BValue)v, null);
    }

    public BStatusNumeric getIn11() {
        return (BStatusNumeric)this.get(in11);
    }

    public void setIn11(BStatusNumeric v) {
        this.set(in11, (BValue)v, null);
    }

    public BStatusNumeric getIn12() {
        return (BStatusNumeric)this.get(in12);
    }

    public void setIn12(BStatusNumeric v) {
        this.set(in12, (BValue)v, null);
    }

    public BStatusNumeric getIn13() {
        return (BStatusNumeric)this.get(in13);
    }

    public void setIn13(BStatusNumeric v) {
        this.set(in13, (BValue)v, null);
    }

    public BStatusNumeric getIn14() {
        return (BStatusNumeric)this.get(in14);
    }

    public void setIn14(BStatusNumeric v) {
        this.set(in14, (BValue)v, null);
    }

    public BStatusNumeric getIn15() {
        return (BStatusNumeric)this.get(in15);
    }

    public void setIn15(BStatusNumeric v) {
        this.set(in15, (BValue)v, null);
    }

    public BStatusNumeric getIn16() {
        return (BStatusNumeric)this.get(in16);
    }

    public void setIn16(BStatusNumeric v) {
        this.set(in16, (BValue)v, null);
    }

    public BStatusNumeric getFallback() {
        return (BStatusNumeric)this.get(fallback);
    }

    public void setFallback(BStatusNumeric v) {
        this.set(fallback, (BValue)v, null);
    }

    public BAbsTime getOverrideExpiration() {
        return (BAbsTime)this.get(overrideExpiration);
    }

    public void setOverrideExpiration(BAbsTime v) {
        this.set(overrideExpiration, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BStatusBoolean getOccupied() {
        return (BStatusBoolean)this.get(occupied);
    }

    public void setOccupied(BStatusBoolean v) {
        this.set(occupied, (BValue)v, null);
    }

    public boolean getLockDown() {
        return this.getBoolean(lockDown);
    }

    public void setLockDown(boolean v) {
        this.setBoolean(lockDown, v, null);
    }

    public BOccupancyEnum getOccupancyCriteria() {
        return (BOccupancyEnum)this.get(occupancyCriteria);
    }

    public void setOccupancyCriteria(BOccupancyEnum v) {
        this.set(occupancyCriteria, (BValue)v, null);
    }

    public BEnforcementEnum getPassbackMode() {
        return (BEnforcementEnum)this.get(passbackMode);
    }

    public void setPassbackMode(BEnforcementEnum v) {
        this.set(passbackMode, (BValue)v, null);
    }

    public BEnforcementEnum getAboveHighThresholdEnforcement() {
        return (BEnforcementEnum)this.get(aboveHighThresholdEnforcement);
    }

    public void setAboveHighThresholdEnforcement(BEnforcementEnum v) {
        this.set(aboveHighThresholdEnforcement, (BValue)v, null);
    }

    public BDynamicEnum getAtHighThresholdEnforcement() {
        return (BDynamicEnum)this.get(atHighThresholdEnforcement);
    }

    public void setAtHighThresholdEnforcement(BDynamicEnum v) {
        this.set(atHighThresholdEnforcement, (BValue)v, null);
    }

    public BDynamicEnum getBelowLowThresholdEnforcement() {
        return (BDynamicEnum)this.get(belowLowThresholdEnforcement);
    }

    public void setBelowLowThresholdEnforcement(BDynamicEnum v) {
        this.set(belowLowThresholdEnforcement, (BValue)v, null);
    }

    public BDynamicEnum getAtLowThresholdEnforcement() {
        return (BDynamicEnum)this.get(atLowThresholdEnforcement);
    }

    public void setAtLowThresholdEnforcement(BDynamicEnum v) {
        this.set(atLowThresholdEnforcement, (BValue)v, null);
    }

    public BEnforcementEnum getSupervisorRequiredEnforcement() {
        return (BEnforcementEnum)this.get(supervisorRequiredEnforcement);
    }

    public void setSupervisorRequiredEnforcement(BEnforcementEnum v) {
        this.set(supervisorRequiredEnforcement, (BValue)v, null);
    }

    public BEnforcementEnum getHighestEnforcement() {
        return (BEnforcementEnum)this.get(highestEnforcement);
    }

    public void setHighestEnforcement(BEnforcementEnum v) {
        this.set(highestEnforcement, (BValue)v, null);
    }

    public BRelTime getPendingTime() {
        return (BRelTime)this.get(pendingTime);
    }

    public void setPendingTime(BRelTime v) {
        this.set(pendingTime, (BValue)v, null);
    }

    public BRelTime getPassbackTimeout() {
        return (BRelTime)this.get(passbackTimeout);
    }

    public void setPassbackTimeout(BRelTime v) {
        this.set(passbackTimeout, (BValue)v, null);
    }

    public boolean getResetOccupancyEnabled() {
        return this.getBoolean(resetOccupancyEnabled);
    }

    public void setResetOccupancyEnabled(boolean v) {
        this.setBoolean(resetOccupancyEnabled, v, null);
    }

    public BTime getResetOccupancyTime() {
        return (BTime)this.get(resetOccupancyTime);
    }

    public void setResetOccupancyTime(BTime v) {
        this.set(resetOccupancyTime, (BValue)v, null);
    }

    public int getHighThreshold() {
        return this.getInt(highThreshold);
    }

    public void setHighThreshold(int v) {
        this.setInt(highThreshold, v, null);
    }

    public int getLowThreshold() {
        return this.getInt(lowThreshold);
    }

    public void setLowThreshold(int v) {
        this.setInt(lowThreshold, v, null);
    }

    public BActivityAlertExt getAntiPassbackViolationAlert() {
        return (BActivityAlertExt)this.get(antiPassbackViolationAlert);
    }

    public void setAntiPassbackViolationAlert(BActivityAlertExt v) {
        this.set(antiPassbackViolationAlert, (BValue)v, null);
    }

    public BActivityAlertExt getAccessZoneDisabledAlert() {
        return (BActivityAlertExt)this.get(accessZoneDisabledAlert);
    }

    public void setAccessZoneDisabledAlert(BActivityAlertExt v) {
        this.set(accessZoneDisabledAlert, (BValue)v, null);
    }

    public BActivityAlertExt getOccupancyViolationAlert() {
        return (BActivityAlertExt)this.get(occupancyViolationAlert);
    }

    public void setOccupancyViolationAlert(BActivityAlertExt v) {
        this.set(occupancyViolationAlert, (BValue)v, null);
    }

    public BActivityAlertExt getSupervisorRequiredAlert() {
        return (BActivityAlertExt)this.get(supervisorRequiredAlert);
    }

    public void setSupervisorRequiredAlert(BActivityAlertExt v) {
        this.set(supervisorRequiredAlert, (BValue)v, null);
    }

    public BActivityAlertExt getGrantedButAntiPassbackViolationAlert() {
        return (BActivityAlertExt)this.get(grantedButAntiPassbackViolationAlert);
    }

    public void setGrantedButAntiPassbackViolationAlert(BActivityAlertExt v) {
        this.set(grantedButAntiPassbackViolationAlert, (BValue)v, null);
    }

    public BActivityAlertExt getGrantedButOccupancyViolationAlert() {
        return (BActivityAlertExt)this.get(grantedButOccupancyViolationAlert);
    }

    public void setGrantedButOccupancyViolationAlert(BActivityAlertExt v) {
        this.set(grantedButOccupancyViolationAlert, (BValue)v, null);
    }

    public BActivityAlertExt getGrantedButAccessZoneDisabledAlert() {
        return (BActivityAlertExt)this.get(grantedButAccessZoneDisabledAlert);
    }

    public void setGrantedButAccessZoneDisabledAlert(BActivityAlertExt v) {
        this.set(grantedButAccessZoneDisabledAlert, (BValue)v, null);
    }

    public BActivityAlertExt getGrantedButSupervisorRequiredAlert() {
        return (BActivityAlertExt)this.get(grantedButSupervisorRequiredAlert);
    }

    public void setGrantedButSupervisorRequiredAlert(BActivityAlertExt v) {
        this.set(grantedButSupervisorRequiredAlert, (BValue)v, null);
    }

    public BStatus getGroupStatus() {
        return (BStatus)this.get(groupStatus);
    }

    public void setGroupStatus(BStatus v) {
        this.set(groupStatus, (BValue)v, null);
    }

    public void recount() {
        this.invoke(recount, null, null);
    }

    public void resetOccupancy() {
        this.invoke(resetOccupancy, null, null);
    }

    public void cleanup(BString event) {
        this.invoke(cleanup, (BValue)event, null);
    }

    public BAccessValidationInfo remoteValidationEntry(BAccessValidationInfo event) {
        return (BAccessValidationInfo)this.invoke(remoteValidationEntry, (BValue)event, null);
    }

    public BAccessValidationInfo remoteValidationExit(BAccessValidationInfo event) {
        return (BAccessValidationInfo)this.invoke(remoteValidationExit, (BValue)event, null);
    }

    public void remoteUpdateEntry(BAccessValidationInfo event) {
        this.invoke(remoteUpdateEntry, (BValue)event, null);
    }

    public void remoteUpdateExit(BAccessValidationInfo event) {
        this.invoke(remoteUpdateExit, (BValue)event, null);
    }

    public void remoteConfirmMaybePending() {
        this.invoke(remoteConfirmMaybePending, null, null);
    }

    public void remoteClearMaybePending() {
        this.invoke(remoteClearMaybePending, null, null);
    }

    public void remoteMakeAlarm(BAccessValidationInfo event) {
        this.invoke(remoteMakeAlarm, (BValue)event, null);
    }

    public void persistGrouping() {
        this.invoke(persistGrouping, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BAccessZone() {
        if (this.getFallback().isNull()) {
            this.getFallback().setValue(0.0);
        }
    }

    public final void started() throws Exception {
        this.fwStarted();
        this.scheduleReset();
        if (Sys.isStationStarted()) {
            this.stationStarted();
        }
        BNiagaraStation[] stations = this.getGrouping();
        for (int i = 0; i < stations.length; ++i) {
            this.remoteStationsCache.add((Object)stations[i].getName());
        }
    }

    public void stationStarted() throws Exception {
        BEnterpriseSecurityService.postAsyncStationStarted(this);
    }

    @Override
    public void asyncStationStarted() {
        try {
            this.doRecount();
        }
        catch (Exception e) {
            BAccessControlService.LOG.log(Level.SEVERE, "Cannot count for AccessZone: " + this.getDisplayName(null), e);
        }
        this.persistGrouping();
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot == out) {
            return BAccessControlService.lex.getText("AccessZone.out");
        }
        return super.getDisplayName(slot, cx);
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(occupancyCriteria) || p.equals(lockDown)) {
            this.doRecount();
        } else if (p.equals(resetOccupancyTime) || p.equals(resetOccupancyEnabled)) {
            this.scheduleReset();
        } else if (p.equals(out)) {
            if (this.getOut().getValue() > 0.0) {
                this.getOccupied().setValue(true);
            } else {
                this.getOccupied().setValue(false);
            }
        } else if (p.equals(passbackMode) || p.equals(aboveHighThresholdEnforcement) || p.equals(atHighThresholdEnforcement) || p.equals(belowLowThresholdEnforcement) || p.equals(atLowThresholdEnforcement) || p.equals(supervisorRequiredEnforcement)) {
            BEnforcementEnum enforcement = this.calculateHighestEnforcement();
            if (this.getHighestEnforcement() != enforcement) {
                this.setHighestEnforcement(enforcement);
            }
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        if (Sys.getStation().isRunning()) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        BAccessZone.this.checkPurgeGrouping();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
        }
    }

    public void checkPurgeGrouping() throws Exception {
        Thread.sleep(500L);
        if (!this.isRunning()) {
            BUuid uuid = MappingSupport.getMappedUuid((BComponent)this);
            BAccessZoneRec rec = new BAccessZoneRec();
            rec.init(BAccessZoneRec.uuid, (BValue)uuid);
            this.purgeGrouping(rec);
        }
    }

    public void scheduleReset() {
        if (this.resetTicket != null) {
            this.resetTicket.cancel();
            this.resetTicket = null;
        }
        if (this.getResetOccupancyEnabled()) {
            BAbsTime schedule = BAbsTime.make((BAbsTime)BAbsTime.now(), (BTime)this.getResetOccupancyTime());
            if (schedule.isBefore(BAbsTime.now())) {
                schedule = schedule.nextDay();
            }
            this.resetTicket = Clock.schedule((BComponent)this, (BAbsTime)schedule, (Action)resetOccupancy, null);
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (!this.isRunning()) {
            return null;
        }
        if (action == execute) {
            return super.post(action, arg, cx);
        }
        if (this.getService().getAccessControlWorker().isRunning()) {
            this.getService().getAccessControlWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return null;
    }

    public void doPersistGrouping() throws Exception {
        BNiagaraStation[] stations = this.getGrouping();
        for (int i = 0; i < stations.length; ++i) {
            this.persistGrouping(stations[i]);
        }
    }

    public void purgeGrouping(BAccessZoneRec rec) throws Exception {
        String[] stations = (String[])this.remoteStationsCache.trim();
        for (int i = 0; i < stations.length; ++i) {
            BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
            BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stations[i]);
            if (station == null) continue;
            BAccessZone.purgeGroupingFromDelete(station, rec);
        }
        this.remoteStationsCache.clear();
    }

    public BNiagaraStation[] getGrouping() {
        Array a = new Array(BNiagaraStation.class);
        BLink[] links = this.getLinks((Slot)groupStatus);
        for (int i = 0; i < links.length; ++i) {
            try {
                BComponent sourceComponent = links[i].getSourceComponent();
                if (!(sourceComponent instanceof BNiagaraStation)) continue;
                a.add((Object)sourceComponent);
                continue;
            }
            catch (UnresolvedException e) {
                e.printStackTrace();
            }
        }
        return (BNiagaraStation[])a.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistGrouping(BNiagaraStation station) throws Exception {
        OrionSession session = null;
        OrionSession localSession = null;
        BFoxSession foxSession = null;
        try {
            localSession = this.getService().createSession(null);
            BAccessZoneRec rec = (BAccessZoneRec)localSession.mappedRead((BObject)this);
            foxSession = RemoteUtil.getFoxSession(station);
            foxSession.engageNoRetry(engageKey);
            BAccessControlService service = (BAccessControlService)foxSession.getService(BAccessControlService.TYPE);
            service.lease();
            session = service.createSession(null);
            session.persist((BIOrionObject)rec);
            if (!this.remoteStationsCache.contains((Object)station.getName())) {
                this.remoteStationsCache.add((Object)station.getName());
            }
        }
        catch (Exception e) {
            BAccessControlService.LOG.log(Level.SEVERE, "Access Zone Grouping can not be automatically updated on " + station.getName(), e);
        }
        finally {
            if (localSession != null) {
                localSession.close();
                localSession = null;
            }
            if (session != null) {
                session.close();
                session = null;
            }
            if (foxSession != null) {
                foxSession.disengage(engageKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeGrouping(BNiagaraStation station, BAccessZoneRec rec) throws Exception {
        OrionSession session = null;
        OrionSession localSession = null;
        BFoxSession foxSession = null;
        try {
            localSession = this.getService().createSession(null);
            if (rec == null) {
                rec = (BAccessZoneRec)localSession.mappedRead((BObject)this);
            }
            foxSession = RemoteUtil.getFoxSession(station);
            foxSession.engageNoRetry(engageKey);
            BAccessControlService service = (BAccessControlService)foxSession.getService(BAccessControlService.TYPE);
            service.lease();
            session = service.createSession(null);
            session.delete((BIOrionObject)rec);
            if (this.remoteStationsCache.contains((Object)station.getName())) {
                this.remoteStationsCache.remove((Object)station.getName());
            }
        }
        catch (Exception e) {
            BAccessControlService.LOG.log(Level.SEVERE, "Access Zone Grouping can not be automatically removed on " + station.getName(), e);
        }
        finally {
            if (localSession != null) {
                localSession.close();
                localSession = null;
            }
            if (session != null) {
                session.close();
                session = null;
            }
            if (foxSession != null) {
                foxSession.disengage(engageKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void purgeGroupingFromDelete(BNiagaraStation station, BAccessZoneRec rec) throws Exception {
        if (station == null) {
            return;
        }
        OrionSession session = null;
        OrionSession localSession = null;
        BFoxSession foxSession = null;
        try {
            BAccessControlService localService = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
            localSession = localService.createSession(null);
            foxSession = RemoteUtil.getFoxSession(station);
            foxSession.engageNoRetry(engageKey);
            BAccessControlService service = (BAccessControlService)foxSession.getService(BAccessControlService.TYPE);
            service.lease();
            session = service.createSession(null);
            session.delete((BIOrionObject)rec);
        }
        catch (Exception e) {
            BAccessControlService.LOG.log(Level.SEVERE, "Access Zone Grouping can not be automatically removed on " + station.getName(), e);
        }
        finally {
            if (localSession != null) {
                localSession.close();
                localSession = null;
            }
            if (session != null) {
                session.close();
                session = null;
            }
            if (foxSession != null) {
                foxSession.disengage(engageKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doResetOccupancy() {
        BAccessControlService.LOG.fine("Resetting for AccessZone: " + this.getDisplayName(null));
        OrionSession session = null;
        try {
            session = this.getService().createSession(null);
            BAccessZoneRec rec = (BAccessZoneRec)session.mappedRead((BObject)this);
            BSqlField recField = new BSqlField(BPersonZoneJoin.ORION_TYPE, BPersonZoneJoin.accessZone);
            session.delete(BPersonZoneJoin.ORION_TYPE, Predicates.eq((BExpression)recField, (BSimple)BRef.make((BIOrionObject)rec)));
            this.service.getDbCache().resetAccessZoneOccupancy(session, rec);
            this.getFallback().setValue(0.0);
            this.scheduleReset();
            this.generateAlarmOnCleanUpFor2ManRule = null;
            if (this.cleanupTickets.size() > 0) {
                Object[] tickets = this.cleanupTickets.values().toArray();
                for (int i = 0; i < tickets.length; ++i) {
                    Clock.Ticket ticket = (Clock.Ticket)tickets[i];
                    if (ticket == null) continue;
                    ticket.cancel();
                    ticket = null;
                }
                this.cleanupTickets.clear();
            }
            this.pending.clear();
            this.maybePending.clear();
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRecount() {
        BAccessControlService.LOG.fine("Recounting for AccessZone: " + this.getDisplayName(null));
        OrionSession session = null;
        try {
            BAccessZoneRec rec;
            session = this.getService().createSession(null);
            if (this.getOccupancyCriteria() == BOccupancyEnum.any) {
                rec = (BAccessZoneRec)session.mappedRead((BObject)this);
                if (rec == null) {
                    this.getFallback().setStatus(BStatus.ok);
                    this.getFallback().setValue(0.0);
                    return;
                }
                int total = rec.getOccupiedCount(session);
                this.getFallback().setStatus(BStatus.ok);
                this.getFallback().setValue((double)total);
            } else {
                rec = (BAccessZoneRec)session.mappedRead((BObject)this);
                if (rec == null) {
                    this.getFallback().setStatus(BStatus.ok);
                    this.getFallback().setValue(0.0);
                    return;
                }
                int total = rec.getOccupiedSupervisorCount(session);
                this.getFallback().setStatus(BStatus.ok);
                this.getFallback().setValue((double)total);
            }
            this.doExecute();
        }
        catch (Exception e) {
            this.getFallback().setStatus(BStatus.fault);
            BAccessControlService.LOG.log(Level.SEVERE, "Recounting for AccessZone failed: " + this.getDisplayName(null), e);
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCleanup(BString dH) {
        OrionSession session = null;
        try {
            String doorHandle = dH.toString();
            Clock.Ticket ticket = (Clock.Ticket)this.cleanupTickets.get(doorHandle);
            if (ticket != null) {
                ticket.cancel();
                ticket = null;
            }
            this.cleanupTickets.remove(doorHandle);
            if (this.generateAlarmOnCleanUpFor2ManRule != null && this.generateAlarmOnCleanUpFor2ManRule.equals(doorHandle)) {
                BAccessZoneRec rec;
                int supers;
                String activityInfo = BAccessControlService.lex.getText("belowLowThreshold", new Object[]{"" + this.getFallback().valueToString((Context)this.getFacets())});
                this.makeAlarm(BBadgeActivity.occupancyViolation, "", "", activityInfo, null);
                BEnforcementEnum supervisorEnum = this.getSupervisorRequiredEnforcement();
                if (!supervisorEnum.equals((Object)BEnforcementEnum.off) && (supers = (rec = (BAccessZoneRec)(session = this.getService().createSession(null)).mappedRead((BObject)this)).getOccupiedSupervisorCount(session)) == 0) {
                    this.makeAlarm(BBadgeActivity.grantedButSupervisorRequired, "", "", "", null);
                }
            }
            for (int i = 0; i < this.pending.size(); ++i) {
                PendingOccupancy p = (PendingOccupancy)this.pending.get(i);
                if (!p.doorHandle.equals(doorHandle)) continue;
                this.pending.remove(i);
            }
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void doRemoteConfirmMaybePending() {
        this.confirmMaybePending();
    }

    public void doRemoteClearMaybePending() {
        this.clearMaybePending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAccessValidationInfo doRemoteValidationEntry(BAccessValidationInfo info) {
        OrionSession session = null;
        try {
            session = this.getService().createSession(null);
            boolean validated = AccessZonesValidationUtil.validateAccessZoneEntry(this, (BAccessZoneRec)session.mappedRead((BObject)this), info, session, this.service.getDbCache());
            info.getRecord().setGranted(validated);
            BAccessValidationInfo bAccessValidationInfo = info;
            return bAccessValidationInfo;
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BAccessValidationInfo doRemoteValidationExit(BAccessValidationInfo info) {
        OrionSession session = null;
        try {
            session = this.getService().createSession(null);
            boolean validated = AccessZonesValidationUtil.validateAccessZoneExit(this, (BAccessZoneRec)session.mappedRead((BObject)this), info, session, this.service.getDbCache());
            info.getRecord().setGranted(validated);
            BAccessValidationInfo bAccessValidationInfo = info;
            return bAccessValidationInfo;
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void doRemoteUpdateEntry(BAccessValidationInfo info) {
        OrionSession session = null;
        try {
            session = this.getService().createSession(null);
            AccessZonesUpdateUtil.updateEntry(this, (BAccessZoneRec)session.mappedRead((BObject)this), info, session, this.service, this.service.getDbCache());
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void doRemoteUpdateExit(BAccessValidationInfo info) {
        OrionSession session = null;
        try {
            session = this.getService().createSession(null);
            AccessZonesUpdateUtil.updateExit(this, (BAccessZoneRec)session.mappedRead((BObject)this), info, session, this.service, this.service.getDbCache());
        }
        finally {
            if (session != null) {
                session.close();
                session = null;
            }
        }
    }

    public void doRemoteMakeAlarm(BAccessValidationInfo info) {
        this.makeAlarm(info.getRecord().getActivity(), info.getRecord().getOwner(), info.getRecord().getBadge(), info.getRecord().getDetails(), info.getPersonData().getPersonUuid());
    }

    public void makeAlarm(BBadgeActivity activity, String owner, String badge, String activityInfo, BUuid personId) {
        try {
            BActivityAlertExt[] alerts = (BActivityAlertExt[])this.getChildren(BActivityAlertExt.class);
            for (int i = 0; i < alerts.length; ++i) {
                if (!alerts[i].getActivityType().equals((Object)activity)) continue;
                alerts[i].generateAlert(badge, owner, activityInfo, personId);
            }
        }
        catch (Exception alarmEx) {
            alarmEx.printStackTrace();
        }
    }

    public boolean enableLogging(BBadgeActivity activity) {
        try {
            BActivityAlertExt[] alerts = (BActivityAlertExt[])this.getChildren(BActivityAlertExt.class);
            for (int i = 0; i < alerts.length; ++i) {
                if (!alerts[i].getActivityType().equals((Object)activity)) continue;
                return alerts[i].getEnableLogging();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public Pending tryToAddToPending(PendingOccupancy newPending) {
        boolean alreadyPending = false;
        boolean hasSupervisor = false;
        int count = 1;
        PendingOccupancy[] p = (PendingOccupancy[])this.pending.trim();
        for (int i = 0; i < p.length; ++i) {
            if (newPending.pendingId.equals(p[i].pendingId)) {
                alreadyPending = true;
                --count;
            }
            if (newPending.doorHandle.equals(p[i].doorHandle)) {
                ++count;
            }
            if (!newPending.supervisor) continue;
            hasSupervisor = true;
        }
        this.maybePending.add((Object)newPending);
        return new Pending(count, alreadyPending, hasSupervisor);
    }

    public void confirmMaybePending() {
        for (int i = 0; i < this.maybePending.size(); ++i) {
            PendingOccupancy p = (PendingOccupancy)this.maybePending.get(i);
            this.pending.add((Object)p);
            Clock.Ticket ticket = (Clock.Ticket)this.cleanupTickets.get(p.doorHandle);
            if (ticket != null) {
                ticket.cancel();
                ticket = null;
            }
            this.cleanupTickets.put(p.doorHandle, Clock.schedule((BComponent)this, (BRelTime)this.getPendingTime(), (Action)cleanup, (BValue)BString.make((String)p.doorHandle)));
        }
        this.maybePending.clear();
    }

    public boolean hasSupervisorPending(String doorHandle, boolean entry) {
        PendingOccupancy[] p = (PendingOccupancy[])this.pending.trim();
        for (int i = 0; i < p.length; ++i) {
            if (!doorHandle.equals(p[i].doorHandle) || !p[i].supervisor || entry != p[i].entry) continue;
            return true;
        }
        return false;
    }

    public void clearMaybePending() {
        this.maybePending.clear();
    }

    public BEnforcementEnum calculateHighestEnforcement() {
        BEnforcementEnum highest = BEnforcementEnum.off;
        Array tags = new Array(String.class);
        tags.add((Object)this.getPassbackMode().getTag());
        tags.add((Object)this.getAboveHighThresholdEnforcement().getTag());
        tags.add((Object)this.getAtHighThresholdEnforcement().getTag());
        tags.add((Object)this.getBelowLowThresholdEnforcement().getTag());
        tags.add((Object)this.getAtLowThresholdEnforcement().getTag());
        tags.add((Object)this.getSupervisorRequiredEnforcement().getTag());
        for (int i = 0; i < tags.size(); ++i) {
            if (tags.get(i).toString().equals(BEnforcementEnum.soft.getTag())) {
                highest = BEnforcementEnum.soft;
                continue;
            }
            if (!tags.get(i).toString().equals(BEnforcementEnum.hard.getTag())) continue;
            return BEnforcementEnum.hard;
        }
        return highest;
    }

    static BSecAlarmSourceInfo initAlarmSourceInfo() {
        BSecAlarmSourceInfo asi = new BSecAlarmSourceInfo();
        asi.setFlags((Slot)BAlarmSourceInfo.toFaultText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toOffnormalText, 4);
        asi.setFlags((Slot)BAlarmSourceInfo.toNormalText, 4);
        asi.setSourceName(BFormat.make((String)"%parent.parent.displayName%"));
        return asi;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public final BAccessControlService getService() {
        if (this.service != null) {
            return this.service;
        }
        if (!this.isRunning()) {
            throw new NotRunningException();
        }
        throw new IllegalStateException("Exceeded license limit");
    }

    private void fwStarted() {
        if (this.service != null) {
            return;
        }
        BAccessControlService s = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        Object licenseFault = s.fw(501, "accessZone.limit", null, null, null);
        if (licenseFault != null) {
            this.getOut().setStatus(BStatus.fault);
            this.setFlags((Slot)faultCause, this.getFlags((Slot)faultCause) & 0xFFFFFFFB);
            this.setFaultCause("Over license limit");
            return;
        }
        this.setFlags((Slot)faultCause, this.getFlags((Slot)faultCause) | 4);
        this.service = s;
    }

    public static class PendingOccupancy {
        public BUuid personId;
        public String pendingId;
        public String doorHandle;
        public BAbsTime timestamp;
        public boolean entry;
        public boolean supervisor;

        public PendingOccupancy() {
        }

        public PendingOccupancy(BUuid personId, String doorHandle, boolean entry, boolean supervisor) {
            this.pendingId = doorHandle + personId.toString();
            this.doorHandle = doorHandle;
            this.personId = personId;
            this.timestamp = BAbsTime.now();
            this.entry = entry;
            this.supervisor = supervisor;
        }
    }

    public static class Pending {
        public int count;
        public boolean alreadyPending;
        public boolean hasSupervisor;

        public Pending(int count, boolean alreadyPending, boolean hasSupervisor) {
            this.count = count;
            this.alreadyPending = alreadyPending;
            this.hasSupervisor = hasSupervisor;
        }
    }
}

